/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.accounting.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import com.merge.api.resources.accounting.types.PaymentAccount;
import com.merge.api.resources.accounting.types.PaymentAccountingPeriod;
import com.merge.api.resources.accounting.types.PaymentAppliedToLinesItem;
import com.merge.api.resources.accounting.types.PaymentCompany;
import com.merge.api.resources.accounting.types.PaymentContact;
import com.merge.api.resources.accounting.types.PaymentCurrency;
import com.merge.api.resources.accounting.types.PaymentTrackingCategoriesItem;
import com.merge.api.resources.accounting.types.PaymentType;
import com.merge.api.resources.accounting.types.RemoteData;
import com.merge.api.resources.accounting.types.RemoteField;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class Payment {
    private final Optional<String> id;
    private final Optional<String> remoteId;
    private final Optional<OffsetDateTime> createdAt;
    private final Optional<OffsetDateTime> modifiedAt;
    private final Optional<OffsetDateTime> transactionDate;
    private final Optional<PaymentContact> contact;
    private final Optional<PaymentAccount> account;
    private final Optional<PaymentCurrency> currency;
    private final Optional<String> exchangeRate;
    private final Optional<PaymentCompany> company;
    private final Optional<Double> totalAmount;
    private final Optional<PaymentType> type;
    private final Optional<List<Optional<PaymentTrackingCategoriesItem>>> trackingCategories;
    private final Optional<PaymentAccountingPeriod> accountingPeriod;
    private final Optional<List<PaymentAppliedToLinesItem>> appliedToLines;
    private final Optional<OffsetDateTime> remoteUpdatedAt;
    private final Optional<Boolean> remoteWasDeleted;
    private final Optional<Map<String, JsonNode>> fieldMappings;
    private final Optional<List<RemoteData>> remoteData;
    private final Optional<List<RemoteField>> remoteFields;
    private final Map<String, Object> additionalProperties;

    private Payment(Optional<String> id, Optional<String> remoteId, Optional<OffsetDateTime> createdAt, Optional<OffsetDateTime> modifiedAt, Optional<OffsetDateTime> transactionDate, Optional<PaymentContact> contact, Optional<PaymentAccount> account, Optional<PaymentCurrency> currency, Optional<String> exchangeRate, Optional<PaymentCompany> company, Optional<Double> totalAmount, Optional<PaymentType> type, Optional<List<Optional<PaymentTrackingCategoriesItem>>> trackingCategories, Optional<PaymentAccountingPeriod> accountingPeriod, Optional<List<PaymentAppliedToLinesItem>> appliedToLines, Optional<OffsetDateTime> remoteUpdatedAt, Optional<Boolean> remoteWasDeleted, Optional<Map<String, JsonNode>> fieldMappings, Optional<List<RemoteData>> remoteData, Optional<List<RemoteField>> remoteFields, Map<String, Object> additionalProperties) {
        this.id = id;
        this.remoteId = remoteId;
        this.createdAt = createdAt;
        this.modifiedAt = modifiedAt;
        this.transactionDate = transactionDate;
        this.contact = contact;
        this.account = account;
        this.currency = currency;
        this.exchangeRate = exchangeRate;
        this.company = company;
        this.totalAmount = totalAmount;
        this.type = type;
        this.trackingCategories = trackingCategories;
        this.accountingPeriod = accountingPeriod;
        this.appliedToLines = appliedToLines;
        this.remoteUpdatedAt = remoteUpdatedAt;
        this.remoteWasDeleted = remoteWasDeleted;
        this.fieldMappings = fieldMappings;
        this.remoteData = remoteData;
        this.remoteFields = remoteFields;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="remote_id")
    public Optional<String> getRemoteId() {
        return this.remoteId;
    }

    @JsonProperty(value="created_at")
    public Optional<OffsetDateTime> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="modified_at")
    public Optional<OffsetDateTime> getModifiedAt() {
        return this.modifiedAt;
    }

    @JsonProperty(value="transaction_date")
    public Optional<OffsetDateTime> getTransactionDate() {
        return this.transactionDate;
    }

    @JsonProperty(value="contact")
    public Optional<PaymentContact> getContact() {
        return this.contact;
    }

    @JsonProperty(value="account")
    public Optional<PaymentAccount> getAccount() {
        return this.account;
    }

    @JsonProperty(value="currency")
    public Optional<PaymentCurrency> getCurrency() {
        return this.currency;
    }

    @JsonProperty(value="exchange_rate")
    public Optional<String> getExchangeRate() {
        return this.exchangeRate;
    }

    @JsonProperty(value="company")
    public Optional<PaymentCompany> getCompany() {
        return this.company;
    }

    @JsonProperty(value="total_amount")
    public Optional<Double> getTotalAmount() {
        return this.totalAmount;
    }

    @JsonProperty(value="type")
    public Optional<PaymentType> getType() {
        return this.type;
    }

    @JsonProperty(value="tracking_categories")
    public Optional<List<Optional<PaymentTrackingCategoriesItem>>> getTrackingCategories() {
        return this.trackingCategories;
    }

    @JsonProperty(value="accounting_period")
    public Optional<PaymentAccountingPeriod> getAccountingPeriod() {
        return this.accountingPeriod;
    }

    @JsonProperty(value="applied_to_lines")
    public Optional<List<PaymentAppliedToLinesItem>> getAppliedToLines() {
        return this.appliedToLines;
    }

    @JsonProperty(value="remote_updated_at")
    public Optional<OffsetDateTime> getRemoteUpdatedAt() {
        return this.remoteUpdatedAt;
    }

    @JsonProperty(value="remote_was_deleted")
    public Optional<Boolean> getRemoteWasDeleted() {
        return this.remoteWasDeleted;
    }

    @JsonProperty(value="field_mappings")
    public Optional<Map<String, JsonNode>> getFieldMappings() {
        return this.fieldMappings;
    }

    @JsonProperty(value="remote_data")
    public Optional<List<RemoteData>> getRemoteData() {
        return this.remoteData;
    }

    @JsonProperty(value="remote_fields")
    public Optional<List<RemoteField>> getRemoteFields() {
        return this.remoteFields;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Payment && this.equalTo((Payment)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Payment other) {
        return this.id.equals(other.id) && this.remoteId.equals(other.remoteId) && this.createdAt.equals(other.createdAt) && this.modifiedAt.equals(other.modifiedAt) && this.transactionDate.equals(other.transactionDate) && this.contact.equals(other.contact) && this.account.equals(other.account) && this.currency.equals(other.currency) && this.exchangeRate.equals(other.exchangeRate) && this.company.equals(other.company) && this.totalAmount.equals(other.totalAmount) && this.type.equals(other.type) && this.trackingCategories.equals(other.trackingCategories) && this.accountingPeriod.equals(other.accountingPeriod) && this.appliedToLines.equals(other.appliedToLines) && this.remoteUpdatedAt.equals(other.remoteUpdatedAt) && this.remoteWasDeleted.equals(other.remoteWasDeleted) && this.fieldMappings.equals(other.fieldMappings) && this.remoteData.equals(other.remoteData) && this.remoteFields.equals(other.remoteFields);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.remoteId, this.createdAt, this.modifiedAt, this.transactionDate, this.contact, this.account, this.currency, this.exchangeRate, this.company, this.totalAmount, this.type, this.trackingCategories, this.accountingPeriod, this.appliedToLines, this.remoteUpdatedAt, this.remoteWasDeleted, this.fieldMappings, this.remoteData, this.remoteFields);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> id = Optional.empty();
        private Optional<String> remoteId = Optional.empty();
        private Optional<OffsetDateTime> createdAt = Optional.empty();
        private Optional<OffsetDateTime> modifiedAt = Optional.empty();
        private Optional<OffsetDateTime> transactionDate = Optional.empty();
        private Optional<PaymentContact> contact = Optional.empty();
        private Optional<PaymentAccount> account = Optional.empty();
        private Optional<PaymentCurrency> currency = Optional.empty();
        private Optional<String> exchangeRate = Optional.empty();
        private Optional<PaymentCompany> company = Optional.empty();
        private Optional<Double> totalAmount = Optional.empty();
        private Optional<PaymentType> type = Optional.empty();
        private Optional<List<Optional<PaymentTrackingCategoriesItem>>> trackingCategories = Optional.empty();
        private Optional<PaymentAccountingPeriod> accountingPeriod = Optional.empty();
        private Optional<List<PaymentAppliedToLinesItem>> appliedToLines = Optional.empty();
        private Optional<OffsetDateTime> remoteUpdatedAt = Optional.empty();
        private Optional<Boolean> remoteWasDeleted = Optional.empty();
        private Optional<Map<String, JsonNode>> fieldMappings = Optional.empty();
        private Optional<List<RemoteData>> remoteData = Optional.empty();
        private Optional<List<RemoteField>> remoteFields = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(Payment other) {
            this.id(other.getId());
            this.remoteId(other.getRemoteId());
            this.createdAt(other.getCreatedAt());
            this.modifiedAt(other.getModifiedAt());
            this.transactionDate(other.getTransactionDate());
            this.contact(other.getContact());
            this.account(other.getAccount());
            this.currency(other.getCurrency());
            this.exchangeRate(other.getExchangeRate());
            this.company(other.getCompany());
            this.totalAmount(other.getTotalAmount());
            this.type(other.getType());
            this.trackingCategories(other.getTrackingCategories());
            this.accountingPeriod(other.getAccountingPeriod());
            this.appliedToLines(other.getAppliedToLines());
            this.remoteUpdatedAt(other.getRemoteUpdatedAt());
            this.remoteWasDeleted(other.getRemoteWasDeleted());
            this.fieldMappings(other.getFieldMappings());
            this.remoteData(other.getRemoteData());
            this.remoteFields(other.getRemoteFields());
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.of(id);
            return this;
        }

        @JsonSetter(value="remote_id", nulls=Nulls.SKIP)
        public Builder remoteId(Optional<String> remoteId) {
            this.remoteId = remoteId;
            return this;
        }

        public Builder remoteId(String remoteId) {
            this.remoteId = Optional.of(remoteId);
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<OffsetDateTime> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(OffsetDateTime createdAt) {
            this.createdAt = Optional.of(createdAt);
            return this;
        }

        @JsonSetter(value="modified_at", nulls=Nulls.SKIP)
        public Builder modifiedAt(Optional<OffsetDateTime> modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public Builder modifiedAt(OffsetDateTime modifiedAt) {
            this.modifiedAt = Optional.of(modifiedAt);
            return this;
        }

        @JsonSetter(value="transaction_date", nulls=Nulls.SKIP)
        public Builder transactionDate(Optional<OffsetDateTime> transactionDate) {
            this.transactionDate = transactionDate;
            return this;
        }

        public Builder transactionDate(OffsetDateTime transactionDate) {
            this.transactionDate = Optional.of(transactionDate);
            return this;
        }

        @JsonSetter(value="contact", nulls=Nulls.SKIP)
        public Builder contact(Optional<PaymentContact> contact) {
            this.contact = contact;
            return this;
        }

        public Builder contact(PaymentContact contact) {
            this.contact = Optional.of(contact);
            return this;
        }

        @JsonSetter(value="account", nulls=Nulls.SKIP)
        public Builder account(Optional<PaymentAccount> account) {
            this.account = account;
            return this;
        }

        public Builder account(PaymentAccount account) {
            this.account = Optional.of(account);
            return this;
        }

        @JsonSetter(value="currency", nulls=Nulls.SKIP)
        public Builder currency(Optional<PaymentCurrency> currency) {
            this.currency = currency;
            return this;
        }

        public Builder currency(PaymentCurrency currency) {
            this.currency = Optional.of(currency);
            return this;
        }

        @JsonSetter(value="exchange_rate", nulls=Nulls.SKIP)
        public Builder exchangeRate(Optional<String> exchangeRate) {
            this.exchangeRate = exchangeRate;
            return this;
        }

        public Builder exchangeRate(String exchangeRate) {
            this.exchangeRate = Optional.of(exchangeRate);
            return this;
        }

        @JsonSetter(value="company", nulls=Nulls.SKIP)
        public Builder company(Optional<PaymentCompany> company) {
            this.company = company;
            return this;
        }

        public Builder company(PaymentCompany company) {
            this.company = Optional.of(company);
            return this;
        }

        @JsonSetter(value="total_amount", nulls=Nulls.SKIP)
        public Builder totalAmount(Optional<Double> totalAmount) {
            this.totalAmount = totalAmount;
            return this;
        }

        public Builder totalAmount(Double totalAmount) {
            this.totalAmount = Optional.of(totalAmount);
            return this;
        }

        @JsonSetter(value="type", nulls=Nulls.SKIP)
        public Builder type(Optional<PaymentType> type) {
            this.type = type;
            return this;
        }

        public Builder type(PaymentType type) {
            this.type = Optional.of(type);
            return this;
        }

        @JsonSetter(value="tracking_categories", nulls=Nulls.SKIP)
        public Builder trackingCategories(Optional<List<Optional<PaymentTrackingCategoriesItem>>> trackingCategories) {
            this.trackingCategories = trackingCategories;
            return this;
        }

        public Builder trackingCategories(List<Optional<PaymentTrackingCategoriesItem>> trackingCategories) {
            this.trackingCategories = Optional.of(trackingCategories);
            return this;
        }

        @JsonSetter(value="accounting_period", nulls=Nulls.SKIP)
        public Builder accountingPeriod(Optional<PaymentAccountingPeriod> accountingPeriod) {
            this.accountingPeriod = accountingPeriod;
            return this;
        }

        public Builder accountingPeriod(PaymentAccountingPeriod accountingPeriod) {
            this.accountingPeriod = Optional.of(accountingPeriod);
            return this;
        }

        @JsonSetter(value="applied_to_lines", nulls=Nulls.SKIP)
        public Builder appliedToLines(Optional<List<PaymentAppliedToLinesItem>> appliedToLines) {
            this.appliedToLines = appliedToLines;
            return this;
        }

        public Builder appliedToLines(List<PaymentAppliedToLinesItem> appliedToLines) {
            this.appliedToLines = Optional.of(appliedToLines);
            return this;
        }

        @JsonSetter(value="remote_updated_at", nulls=Nulls.SKIP)
        public Builder remoteUpdatedAt(Optional<OffsetDateTime> remoteUpdatedAt) {
            this.remoteUpdatedAt = remoteUpdatedAt;
            return this;
        }

        public Builder remoteUpdatedAt(OffsetDateTime remoteUpdatedAt) {
            this.remoteUpdatedAt = Optional.of(remoteUpdatedAt);
            return this;
        }

        @JsonSetter(value="remote_was_deleted", nulls=Nulls.SKIP)
        public Builder remoteWasDeleted(Optional<Boolean> remoteWasDeleted) {
            this.remoteWasDeleted = remoteWasDeleted;
            return this;
        }

        public Builder remoteWasDeleted(Boolean remoteWasDeleted) {
            this.remoteWasDeleted = Optional.of(remoteWasDeleted);
            return this;
        }

        @JsonSetter(value="field_mappings", nulls=Nulls.SKIP)
        public Builder fieldMappings(Optional<Map<String, JsonNode>> fieldMappings) {
            this.fieldMappings = fieldMappings;
            return this;
        }

        public Builder fieldMappings(Map<String, JsonNode> fieldMappings) {
            this.fieldMappings = Optional.of(fieldMappings);
            return this;
        }

        @JsonSetter(value="remote_data", nulls=Nulls.SKIP)
        public Builder remoteData(Optional<List<RemoteData>> remoteData) {
            this.remoteData = remoteData;
            return this;
        }

        public Builder remoteData(List<RemoteData> remoteData) {
            this.remoteData = Optional.of(remoteData);
            return this;
        }

        @JsonSetter(value="remote_fields", nulls=Nulls.SKIP)
        public Builder remoteFields(Optional<List<RemoteField>> remoteFields) {
            this.remoteFields = remoteFields;
            return this;
        }

        public Builder remoteFields(List<RemoteField> remoteFields) {
            this.remoteFields = Optional.of(remoteFields);
            return this;
        }

        public Payment build() {
            return new Payment(this.id, this.remoteId, this.createdAt, this.modifiedAt, this.transactionDate, this.contact, this.account, this.currency, this.exchangeRate, this.company, this.totalAmount, this.type, this.trackingCategories, this.accountingPeriod, this.appliedToLines, this.remoteUpdatedAt, this.remoteWasDeleted, this.fieldMappings, this.remoteData, this.remoteFields, this.additionalProperties);
        }
    }
}

