/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.accounting.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import com.merge.api.resources.accounting.types.PaymentRequestAccount;
import com.merge.api.resources.accounting.types.PaymentRequestAccountingPeriod;
import com.merge.api.resources.accounting.types.PaymentRequestAppliedToLinesItem;
import com.merge.api.resources.accounting.types.PaymentRequestCompany;
import com.merge.api.resources.accounting.types.PaymentRequestContact;
import com.merge.api.resources.accounting.types.PaymentRequestCurrency;
import com.merge.api.resources.accounting.types.PaymentRequestTrackingCategoriesItem;
import com.merge.api.resources.accounting.types.PaymentRequestType;
import com.merge.api.resources.accounting.types.RemoteFieldRequest;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class PaymentRequest {
    private final Optional<OffsetDateTime> transactionDate;
    private final Optional<PaymentRequestContact> contact;
    private final Optional<PaymentRequestAccount> account;
    private final Optional<PaymentRequestCurrency> currency;
    private final Optional<String> exchangeRate;
    private final Optional<PaymentRequestCompany> company;
    private final Optional<Double> totalAmount;
    private final Optional<PaymentRequestType> type;
    private final Optional<List<Optional<PaymentRequestTrackingCategoriesItem>>> trackingCategories;
    private final Optional<PaymentRequestAccountingPeriod> accountingPeriod;
    private final Optional<List<PaymentRequestAppliedToLinesItem>> appliedToLines;
    private final Optional<Map<String, JsonNode>> integrationParams;
    private final Optional<Map<String, JsonNode>> linkedAccountParams;
    private final Optional<List<RemoteFieldRequest>> remoteFields;
    private final Map<String, Object> additionalProperties;

    private PaymentRequest(Optional<OffsetDateTime> transactionDate, Optional<PaymentRequestContact> contact, Optional<PaymentRequestAccount> account, Optional<PaymentRequestCurrency> currency, Optional<String> exchangeRate, Optional<PaymentRequestCompany> company, Optional<Double> totalAmount, Optional<PaymentRequestType> type, Optional<List<Optional<PaymentRequestTrackingCategoriesItem>>> trackingCategories, Optional<PaymentRequestAccountingPeriod> accountingPeriod, Optional<List<PaymentRequestAppliedToLinesItem>> appliedToLines, Optional<Map<String, JsonNode>> integrationParams, Optional<Map<String, JsonNode>> linkedAccountParams, Optional<List<RemoteFieldRequest>> remoteFields, Map<String, Object> additionalProperties) {
        this.transactionDate = transactionDate;
        this.contact = contact;
        this.account = account;
        this.currency = currency;
        this.exchangeRate = exchangeRate;
        this.company = company;
        this.totalAmount = totalAmount;
        this.type = type;
        this.trackingCategories = trackingCategories;
        this.accountingPeriod = accountingPeriod;
        this.appliedToLines = appliedToLines;
        this.integrationParams = integrationParams;
        this.linkedAccountParams = linkedAccountParams;
        this.remoteFields = remoteFields;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="transaction_date")
    public Optional<OffsetDateTime> getTransactionDate() {
        return this.transactionDate;
    }

    @JsonProperty(value="contact")
    public Optional<PaymentRequestContact> getContact() {
        return this.contact;
    }

    @JsonProperty(value="account")
    public Optional<PaymentRequestAccount> getAccount() {
        return this.account;
    }

    @JsonProperty(value="currency")
    public Optional<PaymentRequestCurrency> getCurrency() {
        return this.currency;
    }

    @JsonProperty(value="exchange_rate")
    public Optional<String> getExchangeRate() {
        return this.exchangeRate;
    }

    @JsonProperty(value="company")
    public Optional<PaymentRequestCompany> getCompany() {
        return this.company;
    }

    @JsonProperty(value="total_amount")
    public Optional<Double> getTotalAmount() {
        return this.totalAmount;
    }

    @JsonProperty(value="type")
    public Optional<PaymentRequestType> getType() {
        return this.type;
    }

    @JsonProperty(value="tracking_categories")
    public Optional<List<Optional<PaymentRequestTrackingCategoriesItem>>> getTrackingCategories() {
        return this.trackingCategories;
    }

    @JsonProperty(value="accounting_period")
    public Optional<PaymentRequestAccountingPeriod> getAccountingPeriod() {
        return this.accountingPeriod;
    }

    @JsonProperty(value="applied_to_lines")
    public Optional<List<PaymentRequestAppliedToLinesItem>> getAppliedToLines() {
        return this.appliedToLines;
    }

    @JsonProperty(value="integration_params")
    public Optional<Map<String, JsonNode>> getIntegrationParams() {
        return this.integrationParams;
    }

    @JsonProperty(value="linked_account_params")
    public Optional<Map<String, JsonNode>> getLinkedAccountParams() {
        return this.linkedAccountParams;
    }

    @JsonProperty(value="remote_fields")
    public Optional<List<RemoteFieldRequest>> getRemoteFields() {
        return this.remoteFields;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof PaymentRequest && this.equalTo((PaymentRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(PaymentRequest other) {
        return this.transactionDate.equals(other.transactionDate) && this.contact.equals(other.contact) && this.account.equals(other.account) && this.currency.equals(other.currency) && this.exchangeRate.equals(other.exchangeRate) && this.company.equals(other.company) && this.totalAmount.equals(other.totalAmount) && this.type.equals(other.type) && this.trackingCategories.equals(other.trackingCategories) && this.accountingPeriod.equals(other.accountingPeriod) && this.appliedToLines.equals(other.appliedToLines) && this.integrationParams.equals(other.integrationParams) && this.linkedAccountParams.equals(other.linkedAccountParams) && this.remoteFields.equals(other.remoteFields);
    }

    public int hashCode() {
        return Objects.hash(this.transactionDate, this.contact, this.account, this.currency, this.exchangeRate, this.company, this.totalAmount, this.type, this.trackingCategories, this.accountingPeriod, this.appliedToLines, this.integrationParams, this.linkedAccountParams, this.remoteFields);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<OffsetDateTime> transactionDate = Optional.empty();
        private Optional<PaymentRequestContact> contact = Optional.empty();
        private Optional<PaymentRequestAccount> account = Optional.empty();
        private Optional<PaymentRequestCurrency> currency = Optional.empty();
        private Optional<String> exchangeRate = Optional.empty();
        private Optional<PaymentRequestCompany> company = Optional.empty();
        private Optional<Double> totalAmount = Optional.empty();
        private Optional<PaymentRequestType> type = Optional.empty();
        private Optional<List<Optional<PaymentRequestTrackingCategoriesItem>>> trackingCategories = Optional.empty();
        private Optional<PaymentRequestAccountingPeriod> accountingPeriod = Optional.empty();
        private Optional<List<PaymentRequestAppliedToLinesItem>> appliedToLines = Optional.empty();
        private Optional<Map<String, JsonNode>> integrationParams = Optional.empty();
        private Optional<Map<String, JsonNode>> linkedAccountParams = Optional.empty();
        private Optional<List<RemoteFieldRequest>> remoteFields = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(PaymentRequest other) {
            this.transactionDate(other.getTransactionDate());
            this.contact(other.getContact());
            this.account(other.getAccount());
            this.currency(other.getCurrency());
            this.exchangeRate(other.getExchangeRate());
            this.company(other.getCompany());
            this.totalAmount(other.getTotalAmount());
            this.type(other.getType());
            this.trackingCategories(other.getTrackingCategories());
            this.accountingPeriod(other.getAccountingPeriod());
            this.appliedToLines(other.getAppliedToLines());
            this.integrationParams(other.getIntegrationParams());
            this.linkedAccountParams(other.getLinkedAccountParams());
            this.remoteFields(other.getRemoteFields());
            return this;
        }

        @JsonSetter(value="transaction_date", nulls=Nulls.SKIP)
        public Builder transactionDate(Optional<OffsetDateTime> transactionDate) {
            this.transactionDate = transactionDate;
            return this;
        }

        public Builder transactionDate(OffsetDateTime transactionDate) {
            this.transactionDate = Optional.of(transactionDate);
            return this;
        }

        @JsonSetter(value="contact", nulls=Nulls.SKIP)
        public Builder contact(Optional<PaymentRequestContact> contact) {
            this.contact = contact;
            return this;
        }

        public Builder contact(PaymentRequestContact contact) {
            this.contact = Optional.of(contact);
            return this;
        }

        @JsonSetter(value="account", nulls=Nulls.SKIP)
        public Builder account(Optional<PaymentRequestAccount> account) {
            this.account = account;
            return this;
        }

        public Builder account(PaymentRequestAccount account) {
            this.account = Optional.of(account);
            return this;
        }

        @JsonSetter(value="currency", nulls=Nulls.SKIP)
        public Builder currency(Optional<PaymentRequestCurrency> currency) {
            this.currency = currency;
            return this;
        }

        public Builder currency(PaymentRequestCurrency currency) {
            this.currency = Optional.of(currency);
            return this;
        }

        @JsonSetter(value="exchange_rate", nulls=Nulls.SKIP)
        public Builder exchangeRate(Optional<String> exchangeRate) {
            this.exchangeRate = exchangeRate;
            return this;
        }

        public Builder exchangeRate(String exchangeRate) {
            this.exchangeRate = Optional.of(exchangeRate);
            return this;
        }

        @JsonSetter(value="company", nulls=Nulls.SKIP)
        public Builder company(Optional<PaymentRequestCompany> company) {
            this.company = company;
            return this;
        }

        public Builder company(PaymentRequestCompany company) {
            this.company = Optional.of(company);
            return this;
        }

        @JsonSetter(value="total_amount", nulls=Nulls.SKIP)
        public Builder totalAmount(Optional<Double> totalAmount) {
            this.totalAmount = totalAmount;
            return this;
        }

        public Builder totalAmount(Double totalAmount) {
            this.totalAmount = Optional.of(totalAmount);
            return this;
        }

        @JsonSetter(value="type", nulls=Nulls.SKIP)
        public Builder type(Optional<PaymentRequestType> type) {
            this.type = type;
            return this;
        }

        public Builder type(PaymentRequestType type) {
            this.type = Optional.of(type);
            return this;
        }

        @JsonSetter(value="tracking_categories", nulls=Nulls.SKIP)
        public Builder trackingCategories(Optional<List<Optional<PaymentRequestTrackingCategoriesItem>>> trackingCategories) {
            this.trackingCategories = trackingCategories;
            return this;
        }

        public Builder trackingCategories(List<Optional<PaymentRequestTrackingCategoriesItem>> trackingCategories) {
            this.trackingCategories = Optional.of(trackingCategories);
            return this;
        }

        @JsonSetter(value="accounting_period", nulls=Nulls.SKIP)
        public Builder accountingPeriod(Optional<PaymentRequestAccountingPeriod> accountingPeriod) {
            this.accountingPeriod = accountingPeriod;
            return this;
        }

        public Builder accountingPeriod(PaymentRequestAccountingPeriod accountingPeriod) {
            this.accountingPeriod = Optional.of(accountingPeriod);
            return this;
        }

        @JsonSetter(value="applied_to_lines", nulls=Nulls.SKIP)
        public Builder appliedToLines(Optional<List<PaymentRequestAppliedToLinesItem>> appliedToLines) {
            this.appliedToLines = appliedToLines;
            return this;
        }

        public Builder appliedToLines(List<PaymentRequestAppliedToLinesItem> appliedToLines) {
            this.appliedToLines = Optional.of(appliedToLines);
            return this;
        }

        @JsonSetter(value="integration_params", nulls=Nulls.SKIP)
        public Builder integrationParams(Optional<Map<String, JsonNode>> integrationParams) {
            this.integrationParams = integrationParams;
            return this;
        }

        public Builder integrationParams(Map<String, JsonNode> integrationParams) {
            this.integrationParams = Optional.of(integrationParams);
            return this;
        }

        @JsonSetter(value="linked_account_params", nulls=Nulls.SKIP)
        public Builder linkedAccountParams(Optional<Map<String, JsonNode>> linkedAccountParams) {
            this.linkedAccountParams = linkedAccountParams;
            return this;
        }

        public Builder linkedAccountParams(Map<String, JsonNode> linkedAccountParams) {
            this.linkedAccountParams = Optional.of(linkedAccountParams);
            return this;
        }

        @JsonSetter(value="remote_fields", nulls=Nulls.SKIP)
        public Builder remoteFields(Optional<List<RemoteFieldRequest>> remoteFields) {
            this.remoteFields = remoteFields;
            return this;
        }

        public Builder remoteFields(List<RemoteFieldRequest> remoteFields) {
            this.remoteFields = Optional.of(remoteFields);
            return this;
        }

        public PaymentRequest build() {
            return new PaymentRequest(this.transactionDate, this.contact, this.account, this.currency, this.exchangeRate, this.company, this.totalAmount, this.type, this.trackingCategories, this.accountingPeriod, this.appliedToLines, this.integrationParams, this.linkedAccountParams, this.remoteFields, this.additionalProperties);
        }
    }
}

