/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.accounting.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import com.merge.api.resources.accounting.types.PurchaseOrderAccountingPeriod;
import com.merge.api.resources.accounting.types.PurchaseOrderCompany;
import com.merge.api.resources.accounting.types.PurchaseOrderCurrency;
import com.merge.api.resources.accounting.types.PurchaseOrderDeliveryAddress;
import com.merge.api.resources.accounting.types.PurchaseOrderLineItem;
import com.merge.api.resources.accounting.types.PurchaseOrderStatus;
import com.merge.api.resources.accounting.types.PurchaseOrderTrackingCategoriesItem;
import com.merge.api.resources.accounting.types.PurchaseOrderVendor;
import com.merge.api.resources.accounting.types.RemoteData;
import com.merge.api.resources.accounting.types.RemoteField;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class PurchaseOrder {
    private final Optional<String> id;
    private final Optional<String> remoteId;
    private final Optional<OffsetDateTime> createdAt;
    private final Optional<OffsetDateTime> modifiedAt;
    private final Optional<PurchaseOrderStatus> status;
    private final Optional<OffsetDateTime> issueDate;
    private final Optional<String> purchaseOrderNumber;
    private final Optional<OffsetDateTime> deliveryDate;
    private final Optional<PurchaseOrderDeliveryAddress> deliveryAddress;
    private final Optional<String> customer;
    private final Optional<PurchaseOrderVendor> vendor;
    private final Optional<String> memo;
    private final Optional<PurchaseOrderCompany> company;
    private final Optional<Double> totalAmount;
    private final Optional<PurchaseOrderCurrency> currency;
    private final Optional<String> exchangeRate;
    private final Optional<List<PurchaseOrderLineItem>> lineItems;
    private final Optional<Boolean> inclusiveOfTax;
    private final Optional<List<Optional<PurchaseOrderTrackingCategoriesItem>>> trackingCategories;
    private final Optional<PurchaseOrderAccountingPeriod> accountingPeriod;
    private final Optional<OffsetDateTime> remoteCreatedAt;
    private final Optional<OffsetDateTime> remoteUpdatedAt;
    private final Optional<Boolean> remoteWasDeleted;
    private final Optional<Map<String, JsonNode>> fieldMappings;
    private final Optional<List<RemoteData>> remoteData;
    private final Optional<List<RemoteField>> remoteFields;
    private final Map<String, Object> additionalProperties;

    private PurchaseOrder(Optional<String> id, Optional<String> remoteId, Optional<OffsetDateTime> createdAt, Optional<OffsetDateTime> modifiedAt, Optional<PurchaseOrderStatus> status, Optional<OffsetDateTime> issueDate, Optional<String> purchaseOrderNumber, Optional<OffsetDateTime> deliveryDate, Optional<PurchaseOrderDeliveryAddress> deliveryAddress, Optional<String> customer, Optional<PurchaseOrderVendor> vendor, Optional<String> memo, Optional<PurchaseOrderCompany> company, Optional<Double> totalAmount, Optional<PurchaseOrderCurrency> currency, Optional<String> exchangeRate, Optional<List<PurchaseOrderLineItem>> lineItems, Optional<Boolean> inclusiveOfTax, Optional<List<Optional<PurchaseOrderTrackingCategoriesItem>>> trackingCategories, Optional<PurchaseOrderAccountingPeriod> accountingPeriod, Optional<OffsetDateTime> remoteCreatedAt, Optional<OffsetDateTime> remoteUpdatedAt, Optional<Boolean> remoteWasDeleted, Optional<Map<String, JsonNode>> fieldMappings, Optional<List<RemoteData>> remoteData, Optional<List<RemoteField>> remoteFields, Map<String, Object> additionalProperties) {
        this.id = id;
        this.remoteId = remoteId;
        this.createdAt = createdAt;
        this.modifiedAt = modifiedAt;
        this.status = status;
        this.issueDate = issueDate;
        this.purchaseOrderNumber = purchaseOrderNumber;
        this.deliveryDate = deliveryDate;
        this.deliveryAddress = deliveryAddress;
        this.customer = customer;
        this.vendor = vendor;
        this.memo = memo;
        this.company = company;
        this.totalAmount = totalAmount;
        this.currency = currency;
        this.exchangeRate = exchangeRate;
        this.lineItems = lineItems;
        this.inclusiveOfTax = inclusiveOfTax;
        this.trackingCategories = trackingCategories;
        this.accountingPeriod = accountingPeriod;
        this.remoteCreatedAt = remoteCreatedAt;
        this.remoteUpdatedAt = remoteUpdatedAt;
        this.remoteWasDeleted = remoteWasDeleted;
        this.fieldMappings = fieldMappings;
        this.remoteData = remoteData;
        this.remoteFields = remoteFields;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="remote_id")
    public Optional<String> getRemoteId() {
        return this.remoteId;
    }

    @JsonProperty(value="created_at")
    public Optional<OffsetDateTime> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="modified_at")
    public Optional<OffsetDateTime> getModifiedAt() {
        return this.modifiedAt;
    }

    @JsonProperty(value="status")
    public Optional<PurchaseOrderStatus> getStatus() {
        return this.status;
    }

    @JsonProperty(value="issue_date")
    public Optional<OffsetDateTime> getIssueDate() {
        return this.issueDate;
    }

    @JsonProperty(value="purchase_order_number")
    public Optional<String> getPurchaseOrderNumber() {
        return this.purchaseOrderNumber;
    }

    @JsonProperty(value="delivery_date")
    public Optional<OffsetDateTime> getDeliveryDate() {
        return this.deliveryDate;
    }

    @JsonProperty(value="delivery_address")
    public Optional<PurchaseOrderDeliveryAddress> getDeliveryAddress() {
        return this.deliveryAddress;
    }

    @JsonProperty(value="customer")
    public Optional<String> getCustomer() {
        return this.customer;
    }

    @JsonProperty(value="vendor")
    public Optional<PurchaseOrderVendor> getVendor() {
        return this.vendor;
    }

    @JsonProperty(value="memo")
    public Optional<String> getMemo() {
        return this.memo;
    }

    @JsonProperty(value="company")
    public Optional<PurchaseOrderCompany> getCompany() {
        return this.company;
    }

    @JsonProperty(value="total_amount")
    public Optional<Double> getTotalAmount() {
        return this.totalAmount;
    }

    @JsonProperty(value="currency")
    public Optional<PurchaseOrderCurrency> getCurrency() {
        return this.currency;
    }

    @JsonProperty(value="exchange_rate")
    public Optional<String> getExchangeRate() {
        return this.exchangeRate;
    }

    @JsonProperty(value="line_items")
    public Optional<List<PurchaseOrderLineItem>> getLineItems() {
        return this.lineItems;
    }

    @JsonProperty(value="inclusive_of_tax")
    public Optional<Boolean> getInclusiveOfTax() {
        return this.inclusiveOfTax;
    }

    @JsonProperty(value="tracking_categories")
    public Optional<List<Optional<PurchaseOrderTrackingCategoriesItem>>> getTrackingCategories() {
        return this.trackingCategories;
    }

    @JsonProperty(value="accounting_period")
    public Optional<PurchaseOrderAccountingPeriod> getAccountingPeriod() {
        return this.accountingPeriod;
    }

    @JsonProperty(value="remote_created_at")
    public Optional<OffsetDateTime> getRemoteCreatedAt() {
        return this.remoteCreatedAt;
    }

    @JsonProperty(value="remote_updated_at")
    public Optional<OffsetDateTime> getRemoteUpdatedAt() {
        return this.remoteUpdatedAt;
    }

    @JsonProperty(value="remote_was_deleted")
    public Optional<Boolean> getRemoteWasDeleted() {
        return this.remoteWasDeleted;
    }

    @JsonProperty(value="field_mappings")
    public Optional<Map<String, JsonNode>> getFieldMappings() {
        return this.fieldMappings;
    }

    @JsonProperty(value="remote_data")
    public Optional<List<RemoteData>> getRemoteData() {
        return this.remoteData;
    }

    @JsonProperty(value="remote_fields")
    public Optional<List<RemoteField>> getRemoteFields() {
        return this.remoteFields;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof PurchaseOrder && this.equalTo((PurchaseOrder)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(PurchaseOrder other) {
        return this.id.equals(other.id) && this.remoteId.equals(other.remoteId) && this.createdAt.equals(other.createdAt) && this.modifiedAt.equals(other.modifiedAt) && this.status.equals(other.status) && this.issueDate.equals(other.issueDate) && this.purchaseOrderNumber.equals(other.purchaseOrderNumber) && this.deliveryDate.equals(other.deliveryDate) && this.deliveryAddress.equals(other.deliveryAddress) && this.customer.equals(other.customer) && this.vendor.equals(other.vendor) && this.memo.equals(other.memo) && this.company.equals(other.company) && this.totalAmount.equals(other.totalAmount) && this.currency.equals(other.currency) && this.exchangeRate.equals(other.exchangeRate) && this.lineItems.equals(other.lineItems) && this.inclusiveOfTax.equals(other.inclusiveOfTax) && this.trackingCategories.equals(other.trackingCategories) && this.accountingPeriod.equals(other.accountingPeriod) && this.remoteCreatedAt.equals(other.remoteCreatedAt) && this.remoteUpdatedAt.equals(other.remoteUpdatedAt) && this.remoteWasDeleted.equals(other.remoteWasDeleted) && this.fieldMappings.equals(other.fieldMappings) && this.remoteData.equals(other.remoteData) && this.remoteFields.equals(other.remoteFields);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.remoteId, this.createdAt, this.modifiedAt, this.status, this.issueDate, this.purchaseOrderNumber, this.deliveryDate, this.deliveryAddress, this.customer, this.vendor, this.memo, this.company, this.totalAmount, this.currency, this.exchangeRate, this.lineItems, this.inclusiveOfTax, this.trackingCategories, this.accountingPeriod, this.remoteCreatedAt, this.remoteUpdatedAt, this.remoteWasDeleted, this.fieldMappings, this.remoteData, this.remoteFields);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> id = Optional.empty();
        private Optional<String> remoteId = Optional.empty();
        private Optional<OffsetDateTime> createdAt = Optional.empty();
        private Optional<OffsetDateTime> modifiedAt = Optional.empty();
        private Optional<PurchaseOrderStatus> status = Optional.empty();
        private Optional<OffsetDateTime> issueDate = Optional.empty();
        private Optional<String> purchaseOrderNumber = Optional.empty();
        private Optional<OffsetDateTime> deliveryDate = Optional.empty();
        private Optional<PurchaseOrderDeliveryAddress> deliveryAddress = Optional.empty();
        private Optional<String> customer = Optional.empty();
        private Optional<PurchaseOrderVendor> vendor = Optional.empty();
        private Optional<String> memo = Optional.empty();
        private Optional<PurchaseOrderCompany> company = Optional.empty();
        private Optional<Double> totalAmount = Optional.empty();
        private Optional<PurchaseOrderCurrency> currency = Optional.empty();
        private Optional<String> exchangeRate = Optional.empty();
        private Optional<List<PurchaseOrderLineItem>> lineItems = Optional.empty();
        private Optional<Boolean> inclusiveOfTax = Optional.empty();
        private Optional<List<Optional<PurchaseOrderTrackingCategoriesItem>>> trackingCategories = Optional.empty();
        private Optional<PurchaseOrderAccountingPeriod> accountingPeriod = Optional.empty();
        private Optional<OffsetDateTime> remoteCreatedAt = Optional.empty();
        private Optional<OffsetDateTime> remoteUpdatedAt = Optional.empty();
        private Optional<Boolean> remoteWasDeleted = Optional.empty();
        private Optional<Map<String, JsonNode>> fieldMappings = Optional.empty();
        private Optional<List<RemoteData>> remoteData = Optional.empty();
        private Optional<List<RemoteField>> remoteFields = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(PurchaseOrder other) {
            this.id(other.getId());
            this.remoteId(other.getRemoteId());
            this.createdAt(other.getCreatedAt());
            this.modifiedAt(other.getModifiedAt());
            this.status(other.getStatus());
            this.issueDate(other.getIssueDate());
            this.purchaseOrderNumber(other.getPurchaseOrderNumber());
            this.deliveryDate(other.getDeliveryDate());
            this.deliveryAddress(other.getDeliveryAddress());
            this.customer(other.getCustomer());
            this.vendor(other.getVendor());
            this.memo(other.getMemo());
            this.company(other.getCompany());
            this.totalAmount(other.getTotalAmount());
            this.currency(other.getCurrency());
            this.exchangeRate(other.getExchangeRate());
            this.lineItems(other.getLineItems());
            this.inclusiveOfTax(other.getInclusiveOfTax());
            this.trackingCategories(other.getTrackingCategories());
            this.accountingPeriod(other.getAccountingPeriod());
            this.remoteCreatedAt(other.getRemoteCreatedAt());
            this.remoteUpdatedAt(other.getRemoteUpdatedAt());
            this.remoteWasDeleted(other.getRemoteWasDeleted());
            this.fieldMappings(other.getFieldMappings());
            this.remoteData(other.getRemoteData());
            this.remoteFields(other.getRemoteFields());
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.of(id);
            return this;
        }

        @JsonSetter(value="remote_id", nulls=Nulls.SKIP)
        public Builder remoteId(Optional<String> remoteId) {
            this.remoteId = remoteId;
            return this;
        }

        public Builder remoteId(String remoteId) {
            this.remoteId = Optional.of(remoteId);
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<OffsetDateTime> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(OffsetDateTime createdAt) {
            this.createdAt = Optional.of(createdAt);
            return this;
        }

        @JsonSetter(value="modified_at", nulls=Nulls.SKIP)
        public Builder modifiedAt(Optional<OffsetDateTime> modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public Builder modifiedAt(OffsetDateTime modifiedAt) {
            this.modifiedAt = Optional.of(modifiedAt);
            return this;
        }

        @JsonSetter(value="status", nulls=Nulls.SKIP)
        public Builder status(Optional<PurchaseOrderStatus> status) {
            this.status = status;
            return this;
        }

        public Builder status(PurchaseOrderStatus status) {
            this.status = Optional.of(status);
            return this;
        }

        @JsonSetter(value="issue_date", nulls=Nulls.SKIP)
        public Builder issueDate(Optional<OffsetDateTime> issueDate) {
            this.issueDate = issueDate;
            return this;
        }

        public Builder issueDate(OffsetDateTime issueDate) {
            this.issueDate = Optional.of(issueDate);
            return this;
        }

        @JsonSetter(value="purchase_order_number", nulls=Nulls.SKIP)
        public Builder purchaseOrderNumber(Optional<String> purchaseOrderNumber) {
            this.purchaseOrderNumber = purchaseOrderNumber;
            return this;
        }

        public Builder purchaseOrderNumber(String purchaseOrderNumber) {
            this.purchaseOrderNumber = Optional.of(purchaseOrderNumber);
            return this;
        }

        @JsonSetter(value="delivery_date", nulls=Nulls.SKIP)
        public Builder deliveryDate(Optional<OffsetDateTime> deliveryDate) {
            this.deliveryDate = deliveryDate;
            return this;
        }

        public Builder deliveryDate(OffsetDateTime deliveryDate) {
            this.deliveryDate = Optional.of(deliveryDate);
            return this;
        }

        @JsonSetter(value="delivery_address", nulls=Nulls.SKIP)
        public Builder deliveryAddress(Optional<PurchaseOrderDeliveryAddress> deliveryAddress) {
            this.deliveryAddress = deliveryAddress;
            return this;
        }

        public Builder deliveryAddress(PurchaseOrderDeliveryAddress deliveryAddress) {
            this.deliveryAddress = Optional.of(deliveryAddress);
            return this;
        }

        @JsonSetter(value="customer", nulls=Nulls.SKIP)
        public Builder customer(Optional<String> customer) {
            this.customer = customer;
            return this;
        }

        public Builder customer(String customer) {
            this.customer = Optional.of(customer);
            return this;
        }

        @JsonSetter(value="vendor", nulls=Nulls.SKIP)
        public Builder vendor(Optional<PurchaseOrderVendor> vendor) {
            this.vendor = vendor;
            return this;
        }

        public Builder vendor(PurchaseOrderVendor vendor) {
            this.vendor = Optional.of(vendor);
            return this;
        }

        @JsonSetter(value="memo", nulls=Nulls.SKIP)
        public Builder memo(Optional<String> memo) {
            this.memo = memo;
            return this;
        }

        public Builder memo(String memo) {
            this.memo = Optional.of(memo);
            return this;
        }

        @JsonSetter(value="company", nulls=Nulls.SKIP)
        public Builder company(Optional<PurchaseOrderCompany> company) {
            this.company = company;
            return this;
        }

        public Builder company(PurchaseOrderCompany company) {
            this.company = Optional.of(company);
            return this;
        }

        @JsonSetter(value="total_amount", nulls=Nulls.SKIP)
        public Builder totalAmount(Optional<Double> totalAmount) {
            this.totalAmount = totalAmount;
            return this;
        }

        public Builder totalAmount(Double totalAmount) {
            this.totalAmount = Optional.of(totalAmount);
            return this;
        }

        @JsonSetter(value="currency", nulls=Nulls.SKIP)
        public Builder currency(Optional<PurchaseOrderCurrency> currency) {
            this.currency = currency;
            return this;
        }

        public Builder currency(PurchaseOrderCurrency currency) {
            this.currency = Optional.of(currency);
            return this;
        }

        @JsonSetter(value="exchange_rate", nulls=Nulls.SKIP)
        public Builder exchangeRate(Optional<String> exchangeRate) {
            this.exchangeRate = exchangeRate;
            return this;
        }

        public Builder exchangeRate(String exchangeRate) {
            this.exchangeRate = Optional.of(exchangeRate);
            return this;
        }

        @JsonSetter(value="line_items", nulls=Nulls.SKIP)
        public Builder lineItems(Optional<List<PurchaseOrderLineItem>> lineItems) {
            this.lineItems = lineItems;
            return this;
        }

        public Builder lineItems(List<PurchaseOrderLineItem> lineItems) {
            this.lineItems = Optional.of(lineItems);
            return this;
        }

        @JsonSetter(value="inclusive_of_tax", nulls=Nulls.SKIP)
        public Builder inclusiveOfTax(Optional<Boolean> inclusiveOfTax) {
            this.inclusiveOfTax = inclusiveOfTax;
            return this;
        }

        public Builder inclusiveOfTax(Boolean inclusiveOfTax) {
            this.inclusiveOfTax = Optional.of(inclusiveOfTax);
            return this;
        }

        @JsonSetter(value="tracking_categories", nulls=Nulls.SKIP)
        public Builder trackingCategories(Optional<List<Optional<PurchaseOrderTrackingCategoriesItem>>> trackingCategories) {
            this.trackingCategories = trackingCategories;
            return this;
        }

        public Builder trackingCategories(List<Optional<PurchaseOrderTrackingCategoriesItem>> trackingCategories) {
            this.trackingCategories = Optional.of(trackingCategories);
            return this;
        }

        @JsonSetter(value="accounting_period", nulls=Nulls.SKIP)
        public Builder accountingPeriod(Optional<PurchaseOrderAccountingPeriod> accountingPeriod) {
            this.accountingPeriod = accountingPeriod;
            return this;
        }

        public Builder accountingPeriod(PurchaseOrderAccountingPeriod accountingPeriod) {
            this.accountingPeriod = Optional.of(accountingPeriod);
            return this;
        }

        @JsonSetter(value="remote_created_at", nulls=Nulls.SKIP)
        public Builder remoteCreatedAt(Optional<OffsetDateTime> remoteCreatedAt) {
            this.remoteCreatedAt = remoteCreatedAt;
            return this;
        }

        public Builder remoteCreatedAt(OffsetDateTime remoteCreatedAt) {
            this.remoteCreatedAt = Optional.of(remoteCreatedAt);
            return this;
        }

        @JsonSetter(value="remote_updated_at", nulls=Nulls.SKIP)
        public Builder remoteUpdatedAt(Optional<OffsetDateTime> remoteUpdatedAt) {
            this.remoteUpdatedAt = remoteUpdatedAt;
            return this;
        }

        public Builder remoteUpdatedAt(OffsetDateTime remoteUpdatedAt) {
            this.remoteUpdatedAt = Optional.of(remoteUpdatedAt);
            return this;
        }

        @JsonSetter(value="remote_was_deleted", nulls=Nulls.SKIP)
        public Builder remoteWasDeleted(Optional<Boolean> remoteWasDeleted) {
            this.remoteWasDeleted = remoteWasDeleted;
            return this;
        }

        public Builder remoteWasDeleted(Boolean remoteWasDeleted) {
            this.remoteWasDeleted = Optional.of(remoteWasDeleted);
            return this;
        }

        @JsonSetter(value="field_mappings", nulls=Nulls.SKIP)
        public Builder fieldMappings(Optional<Map<String, JsonNode>> fieldMappings) {
            this.fieldMappings = fieldMappings;
            return this;
        }

        public Builder fieldMappings(Map<String, JsonNode> fieldMappings) {
            this.fieldMappings = Optional.of(fieldMappings);
            return this;
        }

        @JsonSetter(value="remote_data", nulls=Nulls.SKIP)
        public Builder remoteData(Optional<List<RemoteData>> remoteData) {
            this.remoteData = remoteData;
            return this;
        }

        public Builder remoteData(List<RemoteData> remoteData) {
            this.remoteData = Optional.of(remoteData);
            return this;
        }

        @JsonSetter(value="remote_fields", nulls=Nulls.SKIP)
        public Builder remoteFields(Optional<List<RemoteField>> remoteFields) {
            this.remoteFields = remoteFields;
            return this;
        }

        public Builder remoteFields(List<RemoteField> remoteFields) {
            this.remoteFields = Optional.of(remoteFields);
            return this;
        }

        public PurchaseOrder build() {
            return new PurchaseOrder(this.id, this.remoteId, this.createdAt, this.modifiedAt, this.status, this.issueDate, this.purchaseOrderNumber, this.deliveryDate, this.deliveryAddress, this.customer, this.vendor, this.memo, this.company, this.totalAmount, this.currency, this.exchangeRate, this.lineItems, this.inclusiveOfTax, this.trackingCategories, this.accountingPeriod, this.remoteCreatedAt, this.remoteUpdatedAt, this.remoteWasDeleted, this.fieldMappings, this.remoteData, this.remoteFields, this.additionalProperties);
        }
    }
}

