/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.accounting.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import com.merge.api.resources.accounting.types.PurchaseOrderLineItemCurrency;
import com.merge.api.resources.accounting.types.PurchaseOrderLineItemItem;
import com.merge.api.resources.accounting.types.RemoteField;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class PurchaseOrderLineItem {
    private final Optional<String> id;
    private final Optional<String> remoteId;
    private final Optional<OffsetDateTime> createdAt;
    private final Optional<OffsetDateTime> modifiedAt;
    private final Optional<String> description;
    private final Optional<Double> unitPrice;
    private final Optional<Double> quantity;
    private final Optional<PurchaseOrderLineItemItem> item;
    private final Optional<String> account;
    private final Optional<String> trackingCategory;
    private final Optional<List<Optional<String>>> trackingCategories;
    private final Optional<String> taxAmount;
    private final Optional<String> totalLineAmount;
    private final Optional<PurchaseOrderLineItemCurrency> currency;
    private final Optional<String> taxRate;
    private final Optional<String> exchangeRate;
    private final Optional<String> company;
    private final Optional<Boolean> remoteWasDeleted;
    private final Optional<List<RemoteField>> remoteFields;
    private final Map<String, Object> additionalProperties;

    private PurchaseOrderLineItem(Optional<String> id, Optional<String> remoteId, Optional<OffsetDateTime> createdAt, Optional<OffsetDateTime> modifiedAt, Optional<String> description, Optional<Double> unitPrice, Optional<Double> quantity, Optional<PurchaseOrderLineItemItem> item, Optional<String> account, Optional<String> trackingCategory, Optional<List<Optional<String>>> trackingCategories, Optional<String> taxAmount, Optional<String> totalLineAmount, Optional<PurchaseOrderLineItemCurrency> currency, Optional<String> taxRate, Optional<String> exchangeRate, Optional<String> company, Optional<Boolean> remoteWasDeleted, Optional<List<RemoteField>> remoteFields, Map<String, Object> additionalProperties) {
        this.id = id;
        this.remoteId = remoteId;
        this.createdAt = createdAt;
        this.modifiedAt = modifiedAt;
        this.description = description;
        this.unitPrice = unitPrice;
        this.quantity = quantity;
        this.item = item;
        this.account = account;
        this.trackingCategory = trackingCategory;
        this.trackingCategories = trackingCategories;
        this.taxAmount = taxAmount;
        this.totalLineAmount = totalLineAmount;
        this.currency = currency;
        this.taxRate = taxRate;
        this.exchangeRate = exchangeRate;
        this.company = company;
        this.remoteWasDeleted = remoteWasDeleted;
        this.remoteFields = remoteFields;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="remote_id")
    public Optional<String> getRemoteId() {
        return this.remoteId;
    }

    @JsonProperty(value="created_at")
    public Optional<OffsetDateTime> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="modified_at")
    public Optional<OffsetDateTime> getModifiedAt() {
        return this.modifiedAt;
    }

    @JsonProperty(value="description")
    public Optional<String> getDescription() {
        return this.description;
    }

    @JsonProperty(value="unit_price")
    public Optional<Double> getUnitPrice() {
        return this.unitPrice;
    }

    @JsonProperty(value="quantity")
    public Optional<Double> getQuantity() {
        return this.quantity;
    }

    @JsonProperty(value="item")
    public Optional<PurchaseOrderLineItemItem> getItem() {
        return this.item;
    }

    @JsonProperty(value="account")
    public Optional<String> getAccount() {
        return this.account;
    }

    @JsonProperty(value="tracking_category")
    public Optional<String> getTrackingCategory() {
        return this.trackingCategory;
    }

    @JsonProperty(value="tracking_categories")
    public Optional<List<Optional<String>>> getTrackingCategories() {
        return this.trackingCategories;
    }

    @JsonProperty(value="tax_amount")
    public Optional<String> getTaxAmount() {
        return this.taxAmount;
    }

    @JsonProperty(value="total_line_amount")
    public Optional<String> getTotalLineAmount() {
        return this.totalLineAmount;
    }

    @JsonProperty(value="currency")
    public Optional<PurchaseOrderLineItemCurrency> getCurrency() {
        return this.currency;
    }

    @JsonProperty(value="tax_rate")
    public Optional<String> getTaxRate() {
        return this.taxRate;
    }

    @JsonProperty(value="exchange_rate")
    public Optional<String> getExchangeRate() {
        return this.exchangeRate;
    }

    @JsonProperty(value="company")
    public Optional<String> getCompany() {
        return this.company;
    }

    @JsonProperty(value="remote_was_deleted")
    public Optional<Boolean> getRemoteWasDeleted() {
        return this.remoteWasDeleted;
    }

    @JsonProperty(value="remote_fields")
    public Optional<List<RemoteField>> getRemoteFields() {
        return this.remoteFields;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof PurchaseOrderLineItem && this.equalTo((PurchaseOrderLineItem)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(PurchaseOrderLineItem other) {
        return this.id.equals(other.id) && this.remoteId.equals(other.remoteId) && this.createdAt.equals(other.createdAt) && this.modifiedAt.equals(other.modifiedAt) && this.description.equals(other.description) && this.unitPrice.equals(other.unitPrice) && this.quantity.equals(other.quantity) && this.item.equals(other.item) && this.account.equals(other.account) && this.trackingCategory.equals(other.trackingCategory) && this.trackingCategories.equals(other.trackingCategories) && this.taxAmount.equals(other.taxAmount) && this.totalLineAmount.equals(other.totalLineAmount) && this.currency.equals(other.currency) && this.taxRate.equals(other.taxRate) && this.exchangeRate.equals(other.exchangeRate) && this.company.equals(other.company) && this.remoteWasDeleted.equals(other.remoteWasDeleted) && this.remoteFields.equals(other.remoteFields);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.remoteId, this.createdAt, this.modifiedAt, this.description, this.unitPrice, this.quantity, this.item, this.account, this.trackingCategory, this.trackingCategories, this.taxAmount, this.totalLineAmount, this.currency, this.taxRate, this.exchangeRate, this.company, this.remoteWasDeleted, this.remoteFields);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> id = Optional.empty();
        private Optional<String> remoteId = Optional.empty();
        private Optional<OffsetDateTime> createdAt = Optional.empty();
        private Optional<OffsetDateTime> modifiedAt = Optional.empty();
        private Optional<String> description = Optional.empty();
        private Optional<Double> unitPrice = Optional.empty();
        private Optional<Double> quantity = Optional.empty();
        private Optional<PurchaseOrderLineItemItem> item = Optional.empty();
        private Optional<String> account = Optional.empty();
        private Optional<String> trackingCategory = Optional.empty();
        private Optional<List<Optional<String>>> trackingCategories = Optional.empty();
        private Optional<String> taxAmount = Optional.empty();
        private Optional<String> totalLineAmount = Optional.empty();
        private Optional<PurchaseOrderLineItemCurrency> currency = Optional.empty();
        private Optional<String> taxRate = Optional.empty();
        private Optional<String> exchangeRate = Optional.empty();
        private Optional<String> company = Optional.empty();
        private Optional<Boolean> remoteWasDeleted = Optional.empty();
        private Optional<List<RemoteField>> remoteFields = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(PurchaseOrderLineItem other) {
            this.id(other.getId());
            this.remoteId(other.getRemoteId());
            this.createdAt(other.getCreatedAt());
            this.modifiedAt(other.getModifiedAt());
            this.description(other.getDescription());
            this.unitPrice(other.getUnitPrice());
            this.quantity(other.getQuantity());
            this.item(other.getItem());
            this.account(other.getAccount());
            this.trackingCategory(other.getTrackingCategory());
            this.trackingCategories(other.getTrackingCategories());
            this.taxAmount(other.getTaxAmount());
            this.totalLineAmount(other.getTotalLineAmount());
            this.currency(other.getCurrency());
            this.taxRate(other.getTaxRate());
            this.exchangeRate(other.getExchangeRate());
            this.company(other.getCompany());
            this.remoteWasDeleted(other.getRemoteWasDeleted());
            this.remoteFields(other.getRemoteFields());
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.of(id);
            return this;
        }

        @JsonSetter(value="remote_id", nulls=Nulls.SKIP)
        public Builder remoteId(Optional<String> remoteId) {
            this.remoteId = remoteId;
            return this;
        }

        public Builder remoteId(String remoteId) {
            this.remoteId = Optional.of(remoteId);
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<OffsetDateTime> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(OffsetDateTime createdAt) {
            this.createdAt = Optional.of(createdAt);
            return this;
        }

        @JsonSetter(value="modified_at", nulls=Nulls.SKIP)
        public Builder modifiedAt(Optional<OffsetDateTime> modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public Builder modifiedAt(OffsetDateTime modifiedAt) {
            this.modifiedAt = Optional.of(modifiedAt);
            return this;
        }

        @JsonSetter(value="description", nulls=Nulls.SKIP)
        public Builder description(Optional<String> description) {
            this.description = description;
            return this;
        }

        public Builder description(String description) {
            this.description = Optional.of(description);
            return this;
        }

        @JsonSetter(value="unit_price", nulls=Nulls.SKIP)
        public Builder unitPrice(Optional<Double> unitPrice) {
            this.unitPrice = unitPrice;
            return this;
        }

        public Builder unitPrice(Double unitPrice) {
            this.unitPrice = Optional.of(unitPrice);
            return this;
        }

        @JsonSetter(value="quantity", nulls=Nulls.SKIP)
        public Builder quantity(Optional<Double> quantity) {
            this.quantity = quantity;
            return this;
        }

        public Builder quantity(Double quantity) {
            this.quantity = Optional.of(quantity);
            return this;
        }

        @JsonSetter(value="item", nulls=Nulls.SKIP)
        public Builder item(Optional<PurchaseOrderLineItemItem> item) {
            this.item = item;
            return this;
        }

        public Builder item(PurchaseOrderLineItemItem item) {
            this.item = Optional.of(item);
            return this;
        }

        @JsonSetter(value="account", nulls=Nulls.SKIP)
        public Builder account(Optional<String> account) {
            this.account = account;
            return this;
        }

        public Builder account(String account) {
            this.account = Optional.of(account);
            return this;
        }

        @JsonSetter(value="tracking_category", nulls=Nulls.SKIP)
        public Builder trackingCategory(Optional<String> trackingCategory) {
            this.trackingCategory = trackingCategory;
            return this;
        }

        public Builder trackingCategory(String trackingCategory) {
            this.trackingCategory = Optional.of(trackingCategory);
            return this;
        }

        @JsonSetter(value="tracking_categories", nulls=Nulls.SKIP)
        public Builder trackingCategories(Optional<List<Optional<String>>> trackingCategories) {
            this.trackingCategories = trackingCategories;
            return this;
        }

        public Builder trackingCategories(List<Optional<String>> trackingCategories) {
            this.trackingCategories = Optional.of(trackingCategories);
            return this;
        }

        @JsonSetter(value="tax_amount", nulls=Nulls.SKIP)
        public Builder taxAmount(Optional<String> taxAmount) {
            this.taxAmount = taxAmount;
            return this;
        }

        public Builder taxAmount(String taxAmount) {
            this.taxAmount = Optional.of(taxAmount);
            return this;
        }

        @JsonSetter(value="total_line_amount", nulls=Nulls.SKIP)
        public Builder totalLineAmount(Optional<String> totalLineAmount) {
            this.totalLineAmount = totalLineAmount;
            return this;
        }

        public Builder totalLineAmount(String totalLineAmount) {
            this.totalLineAmount = Optional.of(totalLineAmount);
            return this;
        }

        @JsonSetter(value="currency", nulls=Nulls.SKIP)
        public Builder currency(Optional<PurchaseOrderLineItemCurrency> currency) {
            this.currency = currency;
            return this;
        }

        public Builder currency(PurchaseOrderLineItemCurrency currency) {
            this.currency = Optional.of(currency);
            return this;
        }

        @JsonSetter(value="tax_rate", nulls=Nulls.SKIP)
        public Builder taxRate(Optional<String> taxRate) {
            this.taxRate = taxRate;
            return this;
        }

        public Builder taxRate(String taxRate) {
            this.taxRate = Optional.of(taxRate);
            return this;
        }

        @JsonSetter(value="exchange_rate", nulls=Nulls.SKIP)
        public Builder exchangeRate(Optional<String> exchangeRate) {
            this.exchangeRate = exchangeRate;
            return this;
        }

        public Builder exchangeRate(String exchangeRate) {
            this.exchangeRate = Optional.of(exchangeRate);
            return this;
        }

        @JsonSetter(value="company", nulls=Nulls.SKIP)
        public Builder company(Optional<String> company) {
            this.company = company;
            return this;
        }

        public Builder company(String company) {
            this.company = Optional.of(company);
            return this;
        }

        @JsonSetter(value="remote_was_deleted", nulls=Nulls.SKIP)
        public Builder remoteWasDeleted(Optional<Boolean> remoteWasDeleted) {
            this.remoteWasDeleted = remoteWasDeleted;
            return this;
        }

        public Builder remoteWasDeleted(Boolean remoteWasDeleted) {
            this.remoteWasDeleted = Optional.of(remoteWasDeleted);
            return this;
        }

        @JsonSetter(value="remote_fields", nulls=Nulls.SKIP)
        public Builder remoteFields(Optional<List<RemoteField>> remoteFields) {
            this.remoteFields = remoteFields;
            return this;
        }

        public Builder remoteFields(List<RemoteField> remoteFields) {
            this.remoteFields = Optional.of(remoteFields);
            return this;
        }

        public PurchaseOrderLineItem build() {
            return new PurchaseOrderLineItem(this.id, this.remoteId, this.createdAt, this.modifiedAt, this.description, this.unitPrice, this.quantity, this.item, this.account, this.trackingCategory, this.trackingCategories, this.taxAmount, this.totalLineAmount, this.currency, this.taxRate, this.exchangeRate, this.company, this.remoteWasDeleted, this.remoteFields, this.additionalProperties);
        }
    }
}

