/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.accounting.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import com.merge.api.resources.accounting.types.PurchaseOrderLineItemRequest;
import com.merge.api.resources.accounting.types.PurchaseOrderRequestCompany;
import com.merge.api.resources.accounting.types.PurchaseOrderRequestCurrency;
import com.merge.api.resources.accounting.types.PurchaseOrderRequestDeliveryAddress;
import com.merge.api.resources.accounting.types.PurchaseOrderRequestStatus;
import com.merge.api.resources.accounting.types.PurchaseOrderRequestTrackingCategoriesItem;
import com.merge.api.resources.accounting.types.PurchaseOrderRequestVendor;
import com.merge.api.resources.accounting.types.RemoteFieldRequest;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class PurchaseOrderRequest {
    private final Optional<PurchaseOrderRequestStatus> status;
    private final Optional<OffsetDateTime> issueDate;
    private final Optional<OffsetDateTime> deliveryDate;
    private final Optional<PurchaseOrderRequestDeliveryAddress> deliveryAddress;
    private final Optional<String> customer;
    private final Optional<PurchaseOrderRequestVendor> vendor;
    private final Optional<String> memo;
    private final Optional<PurchaseOrderRequestCompany> company;
    private final Optional<Double> totalAmount;
    private final Optional<PurchaseOrderRequestCurrency> currency;
    private final Optional<Boolean> inclusiveOfTax;
    private final Optional<String> exchangeRate;
    private final Optional<List<Optional<PurchaseOrderRequestTrackingCategoriesItem>>> trackingCategories;
    private final Optional<List<PurchaseOrderLineItemRequest>> lineItems;
    private final Optional<Map<String, JsonNode>> integrationParams;
    private final Optional<Map<String, JsonNode>> linkedAccountParams;
    private final Optional<List<RemoteFieldRequest>> remoteFields;
    private final Map<String, Object> additionalProperties;

    private PurchaseOrderRequest(Optional<PurchaseOrderRequestStatus> status, Optional<OffsetDateTime> issueDate, Optional<OffsetDateTime> deliveryDate, Optional<PurchaseOrderRequestDeliveryAddress> deliveryAddress, Optional<String> customer, Optional<PurchaseOrderRequestVendor> vendor, Optional<String> memo, Optional<PurchaseOrderRequestCompany> company, Optional<Double> totalAmount, Optional<PurchaseOrderRequestCurrency> currency, Optional<Boolean> inclusiveOfTax, Optional<String> exchangeRate, Optional<List<Optional<PurchaseOrderRequestTrackingCategoriesItem>>> trackingCategories, Optional<List<PurchaseOrderLineItemRequest>> lineItems, Optional<Map<String, JsonNode>> integrationParams, Optional<Map<String, JsonNode>> linkedAccountParams, Optional<List<RemoteFieldRequest>> remoteFields, Map<String, Object> additionalProperties) {
        this.status = status;
        this.issueDate = issueDate;
        this.deliveryDate = deliveryDate;
        this.deliveryAddress = deliveryAddress;
        this.customer = customer;
        this.vendor = vendor;
        this.memo = memo;
        this.company = company;
        this.totalAmount = totalAmount;
        this.currency = currency;
        this.inclusiveOfTax = inclusiveOfTax;
        this.exchangeRate = exchangeRate;
        this.trackingCategories = trackingCategories;
        this.lineItems = lineItems;
        this.integrationParams = integrationParams;
        this.linkedAccountParams = linkedAccountParams;
        this.remoteFields = remoteFields;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="status")
    public Optional<PurchaseOrderRequestStatus> getStatus() {
        return this.status;
    }

    @JsonProperty(value="issue_date")
    public Optional<OffsetDateTime> getIssueDate() {
        return this.issueDate;
    }

    @JsonProperty(value="delivery_date")
    public Optional<OffsetDateTime> getDeliveryDate() {
        return this.deliveryDate;
    }

    @JsonProperty(value="delivery_address")
    public Optional<PurchaseOrderRequestDeliveryAddress> getDeliveryAddress() {
        return this.deliveryAddress;
    }

    @JsonProperty(value="customer")
    public Optional<String> getCustomer() {
        return this.customer;
    }

    @JsonProperty(value="vendor")
    public Optional<PurchaseOrderRequestVendor> getVendor() {
        return this.vendor;
    }

    @JsonProperty(value="memo")
    public Optional<String> getMemo() {
        return this.memo;
    }

    @JsonProperty(value="company")
    public Optional<PurchaseOrderRequestCompany> getCompany() {
        return this.company;
    }

    @JsonProperty(value="total_amount")
    public Optional<Double> getTotalAmount() {
        return this.totalAmount;
    }

    @JsonProperty(value="currency")
    public Optional<PurchaseOrderRequestCurrency> getCurrency() {
        return this.currency;
    }

    @JsonProperty(value="inclusive_of_tax")
    public Optional<Boolean> getInclusiveOfTax() {
        return this.inclusiveOfTax;
    }

    @JsonProperty(value="exchange_rate")
    public Optional<String> getExchangeRate() {
        return this.exchangeRate;
    }

    @JsonProperty(value="tracking_categories")
    public Optional<List<Optional<PurchaseOrderRequestTrackingCategoriesItem>>> getTrackingCategories() {
        return this.trackingCategories;
    }

    @JsonProperty(value="line_items")
    public Optional<List<PurchaseOrderLineItemRequest>> getLineItems() {
        return this.lineItems;
    }

    @JsonProperty(value="integration_params")
    public Optional<Map<String, JsonNode>> getIntegrationParams() {
        return this.integrationParams;
    }

    @JsonProperty(value="linked_account_params")
    public Optional<Map<String, JsonNode>> getLinkedAccountParams() {
        return this.linkedAccountParams;
    }

    @JsonProperty(value="remote_fields")
    public Optional<List<RemoteFieldRequest>> getRemoteFields() {
        return this.remoteFields;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof PurchaseOrderRequest && this.equalTo((PurchaseOrderRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(PurchaseOrderRequest other) {
        return this.status.equals(other.status) && this.issueDate.equals(other.issueDate) && this.deliveryDate.equals(other.deliveryDate) && this.deliveryAddress.equals(other.deliveryAddress) && this.customer.equals(other.customer) && this.vendor.equals(other.vendor) && this.memo.equals(other.memo) && this.company.equals(other.company) && this.totalAmount.equals(other.totalAmount) && this.currency.equals(other.currency) && this.inclusiveOfTax.equals(other.inclusiveOfTax) && this.exchangeRate.equals(other.exchangeRate) && this.trackingCategories.equals(other.trackingCategories) && this.lineItems.equals(other.lineItems) && this.integrationParams.equals(other.integrationParams) && this.linkedAccountParams.equals(other.linkedAccountParams) && this.remoteFields.equals(other.remoteFields);
    }

    public int hashCode() {
        return Objects.hash(this.status, this.issueDate, this.deliveryDate, this.deliveryAddress, this.customer, this.vendor, this.memo, this.company, this.totalAmount, this.currency, this.inclusiveOfTax, this.exchangeRate, this.trackingCategories, this.lineItems, this.integrationParams, this.linkedAccountParams, this.remoteFields);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<PurchaseOrderRequestStatus> status = Optional.empty();
        private Optional<OffsetDateTime> issueDate = Optional.empty();
        private Optional<OffsetDateTime> deliveryDate = Optional.empty();
        private Optional<PurchaseOrderRequestDeliveryAddress> deliveryAddress = Optional.empty();
        private Optional<String> customer = Optional.empty();
        private Optional<PurchaseOrderRequestVendor> vendor = Optional.empty();
        private Optional<String> memo = Optional.empty();
        private Optional<PurchaseOrderRequestCompany> company = Optional.empty();
        private Optional<Double> totalAmount = Optional.empty();
        private Optional<PurchaseOrderRequestCurrency> currency = Optional.empty();
        private Optional<Boolean> inclusiveOfTax = Optional.empty();
        private Optional<String> exchangeRate = Optional.empty();
        private Optional<List<Optional<PurchaseOrderRequestTrackingCategoriesItem>>> trackingCategories = Optional.empty();
        private Optional<List<PurchaseOrderLineItemRequest>> lineItems = Optional.empty();
        private Optional<Map<String, JsonNode>> integrationParams = Optional.empty();
        private Optional<Map<String, JsonNode>> linkedAccountParams = Optional.empty();
        private Optional<List<RemoteFieldRequest>> remoteFields = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(PurchaseOrderRequest other) {
            this.status(other.getStatus());
            this.issueDate(other.getIssueDate());
            this.deliveryDate(other.getDeliveryDate());
            this.deliveryAddress(other.getDeliveryAddress());
            this.customer(other.getCustomer());
            this.vendor(other.getVendor());
            this.memo(other.getMemo());
            this.company(other.getCompany());
            this.totalAmount(other.getTotalAmount());
            this.currency(other.getCurrency());
            this.inclusiveOfTax(other.getInclusiveOfTax());
            this.exchangeRate(other.getExchangeRate());
            this.trackingCategories(other.getTrackingCategories());
            this.lineItems(other.getLineItems());
            this.integrationParams(other.getIntegrationParams());
            this.linkedAccountParams(other.getLinkedAccountParams());
            this.remoteFields(other.getRemoteFields());
            return this;
        }

        @JsonSetter(value="status", nulls=Nulls.SKIP)
        public Builder status(Optional<PurchaseOrderRequestStatus> status) {
            this.status = status;
            return this;
        }

        public Builder status(PurchaseOrderRequestStatus status) {
            this.status = Optional.of(status);
            return this;
        }

        @JsonSetter(value="issue_date", nulls=Nulls.SKIP)
        public Builder issueDate(Optional<OffsetDateTime> issueDate) {
            this.issueDate = issueDate;
            return this;
        }

        public Builder issueDate(OffsetDateTime issueDate) {
            this.issueDate = Optional.of(issueDate);
            return this;
        }

        @JsonSetter(value="delivery_date", nulls=Nulls.SKIP)
        public Builder deliveryDate(Optional<OffsetDateTime> deliveryDate) {
            this.deliveryDate = deliveryDate;
            return this;
        }

        public Builder deliveryDate(OffsetDateTime deliveryDate) {
            this.deliveryDate = Optional.of(deliveryDate);
            return this;
        }

        @JsonSetter(value="delivery_address", nulls=Nulls.SKIP)
        public Builder deliveryAddress(Optional<PurchaseOrderRequestDeliveryAddress> deliveryAddress) {
            this.deliveryAddress = deliveryAddress;
            return this;
        }

        public Builder deliveryAddress(PurchaseOrderRequestDeliveryAddress deliveryAddress) {
            this.deliveryAddress = Optional.of(deliveryAddress);
            return this;
        }

        @JsonSetter(value="customer", nulls=Nulls.SKIP)
        public Builder customer(Optional<String> customer) {
            this.customer = customer;
            return this;
        }

        public Builder customer(String customer) {
            this.customer = Optional.of(customer);
            return this;
        }

        @JsonSetter(value="vendor", nulls=Nulls.SKIP)
        public Builder vendor(Optional<PurchaseOrderRequestVendor> vendor) {
            this.vendor = vendor;
            return this;
        }

        public Builder vendor(PurchaseOrderRequestVendor vendor) {
            this.vendor = Optional.of(vendor);
            return this;
        }

        @JsonSetter(value="memo", nulls=Nulls.SKIP)
        public Builder memo(Optional<String> memo) {
            this.memo = memo;
            return this;
        }

        public Builder memo(String memo) {
            this.memo = Optional.of(memo);
            return this;
        }

        @JsonSetter(value="company", nulls=Nulls.SKIP)
        public Builder company(Optional<PurchaseOrderRequestCompany> company) {
            this.company = company;
            return this;
        }

        public Builder company(PurchaseOrderRequestCompany company) {
            this.company = Optional.of(company);
            return this;
        }

        @JsonSetter(value="total_amount", nulls=Nulls.SKIP)
        public Builder totalAmount(Optional<Double> totalAmount) {
            this.totalAmount = totalAmount;
            return this;
        }

        public Builder totalAmount(Double totalAmount) {
            this.totalAmount = Optional.of(totalAmount);
            return this;
        }

        @JsonSetter(value="currency", nulls=Nulls.SKIP)
        public Builder currency(Optional<PurchaseOrderRequestCurrency> currency) {
            this.currency = currency;
            return this;
        }

        public Builder currency(PurchaseOrderRequestCurrency currency) {
            this.currency = Optional.of(currency);
            return this;
        }

        @JsonSetter(value="inclusive_of_tax", nulls=Nulls.SKIP)
        public Builder inclusiveOfTax(Optional<Boolean> inclusiveOfTax) {
            this.inclusiveOfTax = inclusiveOfTax;
            return this;
        }

        public Builder inclusiveOfTax(Boolean inclusiveOfTax) {
            this.inclusiveOfTax = Optional.of(inclusiveOfTax);
            return this;
        }

        @JsonSetter(value="exchange_rate", nulls=Nulls.SKIP)
        public Builder exchangeRate(Optional<String> exchangeRate) {
            this.exchangeRate = exchangeRate;
            return this;
        }

        public Builder exchangeRate(String exchangeRate) {
            this.exchangeRate = Optional.of(exchangeRate);
            return this;
        }

        @JsonSetter(value="tracking_categories", nulls=Nulls.SKIP)
        public Builder trackingCategories(Optional<List<Optional<PurchaseOrderRequestTrackingCategoriesItem>>> trackingCategories) {
            this.trackingCategories = trackingCategories;
            return this;
        }

        public Builder trackingCategories(List<Optional<PurchaseOrderRequestTrackingCategoriesItem>> trackingCategories) {
            this.trackingCategories = Optional.of(trackingCategories);
            return this;
        }

        @JsonSetter(value="line_items", nulls=Nulls.SKIP)
        public Builder lineItems(Optional<List<PurchaseOrderLineItemRequest>> lineItems) {
            this.lineItems = lineItems;
            return this;
        }

        public Builder lineItems(List<PurchaseOrderLineItemRequest> lineItems) {
            this.lineItems = Optional.of(lineItems);
            return this;
        }

        @JsonSetter(value="integration_params", nulls=Nulls.SKIP)
        public Builder integrationParams(Optional<Map<String, JsonNode>> integrationParams) {
            this.integrationParams = integrationParams;
            return this;
        }

        public Builder integrationParams(Map<String, JsonNode> integrationParams) {
            this.integrationParams = Optional.of(integrationParams);
            return this;
        }

        @JsonSetter(value="linked_account_params", nulls=Nulls.SKIP)
        public Builder linkedAccountParams(Optional<Map<String, JsonNode>> linkedAccountParams) {
            this.linkedAccountParams = linkedAccountParams;
            return this;
        }

        public Builder linkedAccountParams(Map<String, JsonNode> linkedAccountParams) {
            this.linkedAccountParams = Optional.of(linkedAccountParams);
            return this;
        }

        @JsonSetter(value="remote_fields", nulls=Nulls.SKIP)
        public Builder remoteFields(Optional<List<RemoteFieldRequest>> remoteFields) {
            this.remoteFields = remoteFields;
            return this;
        }

        public Builder remoteFields(List<RemoteFieldRequest> remoteFields) {
            this.remoteFields = Optional.of(remoteFields);
            return this;
        }

        public PurchaseOrderRequest build() {
            return new PurchaseOrderRequest(this.status, this.issueDate, this.deliveryDate, this.deliveryAddress, this.customer, this.vendor, this.memo, this.company, this.totalAmount, this.currency, this.inclusiveOfTax, this.exchangeRate, this.trackingCategories, this.lineItems, this.integrationParams, this.linkedAccountParams, this.remoteFields, this.additionalProperties);
        }
    }
}

