/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.accounting.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class RemoteEndpointInfo {
    private final String method;
    private final String urlPath;
    private final List<JsonNode> fieldTraversalPath;
    private final Map<String, Object> additionalProperties;

    private RemoteEndpointInfo(String method, String urlPath, List<JsonNode> fieldTraversalPath, Map<String, Object> additionalProperties) {
        this.method = method;
        this.urlPath = urlPath;
        this.fieldTraversalPath = fieldTraversalPath;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="method")
    public String getMethod() {
        return this.method;
    }

    @JsonProperty(value="url_path")
    public String getUrlPath() {
        return this.urlPath;
    }

    @JsonProperty(value="field_traversal_path")
    public List<JsonNode> getFieldTraversalPath() {
        return this.fieldTraversalPath;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof RemoteEndpointInfo && this.equalTo((RemoteEndpointInfo)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(RemoteEndpointInfo other) {
        return this.method.equals(other.method) && this.urlPath.equals(other.urlPath) && this.fieldTraversalPath.equals(other.fieldTraversalPath);
    }

    public int hashCode() {
        return Objects.hash(this.method, this.urlPath, this.fieldTraversalPath);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static MethodStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements MethodStage,
    UrlPathStage,
    _FinalStage {
        private String method;
        private String urlPath;
        private List<JsonNode> fieldTraversalPath = new ArrayList<JsonNode>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(RemoteEndpointInfo other) {
            this.method(other.getMethod());
            this.urlPath(other.getUrlPath());
            this.fieldTraversalPath(other.getFieldTraversalPath());
            return this;
        }

        @Override
        @JsonSetter(value="method")
        public UrlPathStage method(String method) {
            this.method = method;
            return this;
        }

        @Override
        @JsonSetter(value="url_path")
        public _FinalStage urlPath(String urlPath) {
            this.urlPath = urlPath;
            return this;
        }

        @Override
        public _FinalStage addAllFieldTraversalPath(List<JsonNode> fieldTraversalPath) {
            this.fieldTraversalPath.addAll(fieldTraversalPath);
            return this;
        }

        @Override
        public _FinalStage addFieldTraversalPath(JsonNode fieldTraversalPath) {
            this.fieldTraversalPath.add(fieldTraversalPath);
            return this;
        }

        @Override
        @JsonSetter(value="field_traversal_path", nulls=Nulls.SKIP)
        public _FinalStage fieldTraversalPath(List<JsonNode> fieldTraversalPath) {
            this.fieldTraversalPath.clear();
            this.fieldTraversalPath.addAll(fieldTraversalPath);
            return this;
        }

        @Override
        public RemoteEndpointInfo build() {
            return new RemoteEndpointInfo(this.method, this.urlPath, this.fieldTraversalPath, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public RemoteEndpointInfo build();

        public _FinalStage fieldTraversalPath(List<JsonNode> var1);

        public _FinalStage addFieldTraversalPath(JsonNode var1);

        public _FinalStage addAllFieldTraversalPath(List<JsonNode> var1);
    }

    public static interface UrlPathStage {
        public _FinalStage urlPath(String var1);
    }

    public static interface MethodStage {
        public UrlPathStage method(String var1);

        public Builder from(RemoteEndpointInfo var1);
    }
}

