/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.accounting.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import com.merge.api.resources.accounting.types.TaxComponentComponentType;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class TaxComponent {
    private final Optional<String> id;
    private final Optional<String> remoteId;
    private final Optional<OffsetDateTime> createdAt;
    private final Optional<OffsetDateTime> modifiedAt;
    private final Optional<String> name;
    private final Optional<String> rate;
    private final Optional<Boolean> isCompound;
    private final Optional<TaxComponentComponentType> componentType;
    private final Optional<Boolean> remoteWasDeleted;
    private final Map<String, Object> additionalProperties;

    private TaxComponent(Optional<String> id, Optional<String> remoteId, Optional<OffsetDateTime> createdAt, Optional<OffsetDateTime> modifiedAt, Optional<String> name, Optional<String> rate, Optional<Boolean> isCompound, Optional<TaxComponentComponentType> componentType, Optional<Boolean> remoteWasDeleted, Map<String, Object> additionalProperties) {
        this.id = id;
        this.remoteId = remoteId;
        this.createdAt = createdAt;
        this.modifiedAt = modifiedAt;
        this.name = name;
        this.rate = rate;
        this.isCompound = isCompound;
        this.componentType = componentType;
        this.remoteWasDeleted = remoteWasDeleted;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="remote_id")
    public Optional<String> getRemoteId() {
        return this.remoteId;
    }

    @JsonProperty(value="created_at")
    public Optional<OffsetDateTime> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="modified_at")
    public Optional<OffsetDateTime> getModifiedAt() {
        return this.modifiedAt;
    }

    @JsonProperty(value="name")
    public Optional<String> getName() {
        return this.name;
    }

    @JsonProperty(value="rate")
    public Optional<String> getRate() {
        return this.rate;
    }

    @JsonProperty(value="is_compound")
    public Optional<Boolean> getIsCompound() {
        return this.isCompound;
    }

    @JsonProperty(value="component_type")
    public Optional<TaxComponentComponentType> getComponentType() {
        return this.componentType;
    }

    @JsonProperty(value="remote_was_deleted")
    public Optional<Boolean> getRemoteWasDeleted() {
        return this.remoteWasDeleted;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TaxComponent && this.equalTo((TaxComponent)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TaxComponent other) {
        return this.id.equals(other.id) && this.remoteId.equals(other.remoteId) && this.createdAt.equals(other.createdAt) && this.modifiedAt.equals(other.modifiedAt) && this.name.equals(other.name) && this.rate.equals(other.rate) && this.isCompound.equals(other.isCompound) && this.componentType.equals(other.componentType) && this.remoteWasDeleted.equals(other.remoteWasDeleted);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.remoteId, this.createdAt, this.modifiedAt, this.name, this.rate, this.isCompound, this.componentType, this.remoteWasDeleted);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> id = Optional.empty();
        private Optional<String> remoteId = Optional.empty();
        private Optional<OffsetDateTime> createdAt = Optional.empty();
        private Optional<OffsetDateTime> modifiedAt = Optional.empty();
        private Optional<String> name = Optional.empty();
        private Optional<String> rate = Optional.empty();
        private Optional<Boolean> isCompound = Optional.empty();
        private Optional<TaxComponentComponentType> componentType = Optional.empty();
        private Optional<Boolean> remoteWasDeleted = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(TaxComponent other) {
            this.id(other.getId());
            this.remoteId(other.getRemoteId());
            this.createdAt(other.getCreatedAt());
            this.modifiedAt(other.getModifiedAt());
            this.name(other.getName());
            this.rate(other.getRate());
            this.isCompound(other.getIsCompound());
            this.componentType(other.getComponentType());
            this.remoteWasDeleted(other.getRemoteWasDeleted());
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.of(id);
            return this;
        }

        @JsonSetter(value="remote_id", nulls=Nulls.SKIP)
        public Builder remoteId(Optional<String> remoteId) {
            this.remoteId = remoteId;
            return this;
        }

        public Builder remoteId(String remoteId) {
            this.remoteId = Optional.of(remoteId);
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<OffsetDateTime> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(OffsetDateTime createdAt) {
            this.createdAt = Optional.of(createdAt);
            return this;
        }

        @JsonSetter(value="modified_at", nulls=Nulls.SKIP)
        public Builder modifiedAt(Optional<OffsetDateTime> modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public Builder modifiedAt(OffsetDateTime modifiedAt) {
            this.modifiedAt = Optional.of(modifiedAt);
            return this;
        }

        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.of(name);
            return this;
        }

        @JsonSetter(value="rate", nulls=Nulls.SKIP)
        public Builder rate(Optional<String> rate) {
            this.rate = rate;
            return this;
        }

        public Builder rate(String rate) {
            this.rate = Optional.of(rate);
            return this;
        }

        @JsonSetter(value="is_compound", nulls=Nulls.SKIP)
        public Builder isCompound(Optional<Boolean> isCompound) {
            this.isCompound = isCompound;
            return this;
        }

        public Builder isCompound(Boolean isCompound) {
            this.isCompound = Optional.of(isCompound);
            return this;
        }

        @JsonSetter(value="component_type", nulls=Nulls.SKIP)
        public Builder componentType(Optional<TaxComponentComponentType> componentType) {
            this.componentType = componentType;
            return this;
        }

        public Builder componentType(TaxComponentComponentType componentType) {
            this.componentType = Optional.of(componentType);
            return this;
        }

        @JsonSetter(value="remote_was_deleted", nulls=Nulls.SKIP)
        public Builder remoteWasDeleted(Optional<Boolean> remoteWasDeleted) {
            this.remoteWasDeleted = remoteWasDeleted;
            return this;
        }

        public Builder remoteWasDeleted(Boolean remoteWasDeleted) {
            this.remoteWasDeleted = Optional.of(remoteWasDeleted);
            return this;
        }

        public TaxComponent build() {
            return new TaxComponent(this.id, this.remoteId, this.createdAt, this.modifiedAt, this.name, this.rate, this.isCompound, this.componentType, this.remoteWasDeleted, this.additionalProperties);
        }
    }
}

