/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.accounting.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import com.merge.api.resources.accounting.types.RemoteData;
import com.merge.api.resources.accounting.types.TaxRateCompany;
import com.merge.api.resources.accounting.types.TaxRateStatus;
import com.merge.api.resources.accounting.types.TaxRateTaxComponentsItem;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class TaxRate {
    private final Optional<String> id;
    private final Optional<String> remoteId;
    private final Optional<OffsetDateTime> createdAt;
    private final Optional<OffsetDateTime> modifiedAt;
    private final Optional<TaxRateCompany> company;
    private final Optional<String> code;
    private final Optional<String> name;
    private final Optional<String> description;
    private final Optional<TaxRateStatus> status;
    private final Optional<String> country;
    private final Optional<Double> totalTaxRate;
    private final Optional<Double> effectiveTaxRate;
    private final Optional<List<TaxRateTaxComponentsItem>> taxComponents;
    private final Optional<Boolean> remoteWasDeleted;
    private final Optional<Map<String, JsonNode>> fieldMappings;
    private final Optional<List<RemoteData>> remoteData;
    private final Map<String, Object> additionalProperties;

    private TaxRate(Optional<String> id, Optional<String> remoteId, Optional<OffsetDateTime> createdAt, Optional<OffsetDateTime> modifiedAt, Optional<TaxRateCompany> company, Optional<String> code, Optional<String> name, Optional<String> description, Optional<TaxRateStatus> status, Optional<String> country, Optional<Double> totalTaxRate, Optional<Double> effectiveTaxRate, Optional<List<TaxRateTaxComponentsItem>> taxComponents, Optional<Boolean> remoteWasDeleted, Optional<Map<String, JsonNode>> fieldMappings, Optional<List<RemoteData>> remoteData, Map<String, Object> additionalProperties) {
        this.id = id;
        this.remoteId = remoteId;
        this.createdAt = createdAt;
        this.modifiedAt = modifiedAt;
        this.company = company;
        this.code = code;
        this.name = name;
        this.description = description;
        this.status = status;
        this.country = country;
        this.totalTaxRate = totalTaxRate;
        this.effectiveTaxRate = effectiveTaxRate;
        this.taxComponents = taxComponents;
        this.remoteWasDeleted = remoteWasDeleted;
        this.fieldMappings = fieldMappings;
        this.remoteData = remoteData;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="remote_id")
    public Optional<String> getRemoteId() {
        return this.remoteId;
    }

    @JsonProperty(value="created_at")
    public Optional<OffsetDateTime> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="modified_at")
    public Optional<OffsetDateTime> getModifiedAt() {
        return this.modifiedAt;
    }

    @JsonProperty(value="company")
    public Optional<TaxRateCompany> getCompany() {
        return this.company;
    }

    @JsonProperty(value="code")
    public Optional<String> getCode() {
        return this.code;
    }

    @JsonProperty(value="name")
    public Optional<String> getName() {
        return this.name;
    }

    @JsonProperty(value="description")
    public Optional<String> getDescription() {
        return this.description;
    }

    @JsonProperty(value="status")
    public Optional<TaxRateStatus> getStatus() {
        return this.status;
    }

    @JsonProperty(value="country")
    public Optional<String> getCountry() {
        return this.country;
    }

    @JsonProperty(value="total_tax_rate")
    public Optional<Double> getTotalTaxRate() {
        return this.totalTaxRate;
    }

    @JsonProperty(value="effective_tax_rate")
    public Optional<Double> getEffectiveTaxRate() {
        return this.effectiveTaxRate;
    }

    @JsonProperty(value="tax_components")
    public Optional<List<TaxRateTaxComponentsItem>> getTaxComponents() {
        return this.taxComponents;
    }

    @JsonProperty(value="remote_was_deleted")
    public Optional<Boolean> getRemoteWasDeleted() {
        return this.remoteWasDeleted;
    }

    @JsonProperty(value="field_mappings")
    public Optional<Map<String, JsonNode>> getFieldMappings() {
        return this.fieldMappings;
    }

    @JsonProperty(value="remote_data")
    public Optional<List<RemoteData>> getRemoteData() {
        return this.remoteData;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TaxRate && this.equalTo((TaxRate)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TaxRate other) {
        return this.id.equals(other.id) && this.remoteId.equals(other.remoteId) && this.createdAt.equals(other.createdAt) && this.modifiedAt.equals(other.modifiedAt) && this.company.equals(other.company) && this.code.equals(other.code) && this.name.equals(other.name) && this.description.equals(other.description) && this.status.equals(other.status) && this.country.equals(other.country) && this.totalTaxRate.equals(other.totalTaxRate) && this.effectiveTaxRate.equals(other.effectiveTaxRate) && this.taxComponents.equals(other.taxComponents) && this.remoteWasDeleted.equals(other.remoteWasDeleted) && this.fieldMappings.equals(other.fieldMappings) && this.remoteData.equals(other.remoteData);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.remoteId, this.createdAt, this.modifiedAt, this.company, this.code, this.name, this.description, this.status, this.country, this.totalTaxRate, this.effectiveTaxRate, this.taxComponents, this.remoteWasDeleted, this.fieldMappings, this.remoteData);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> id = Optional.empty();
        private Optional<String> remoteId = Optional.empty();
        private Optional<OffsetDateTime> createdAt = Optional.empty();
        private Optional<OffsetDateTime> modifiedAt = Optional.empty();
        private Optional<TaxRateCompany> company = Optional.empty();
        private Optional<String> code = Optional.empty();
        private Optional<String> name = Optional.empty();
        private Optional<String> description = Optional.empty();
        private Optional<TaxRateStatus> status = Optional.empty();
        private Optional<String> country = Optional.empty();
        private Optional<Double> totalTaxRate = Optional.empty();
        private Optional<Double> effectiveTaxRate = Optional.empty();
        private Optional<List<TaxRateTaxComponentsItem>> taxComponents = Optional.empty();
        private Optional<Boolean> remoteWasDeleted = Optional.empty();
        private Optional<Map<String, JsonNode>> fieldMappings = Optional.empty();
        private Optional<List<RemoteData>> remoteData = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(TaxRate other) {
            this.id(other.getId());
            this.remoteId(other.getRemoteId());
            this.createdAt(other.getCreatedAt());
            this.modifiedAt(other.getModifiedAt());
            this.company(other.getCompany());
            this.code(other.getCode());
            this.name(other.getName());
            this.description(other.getDescription());
            this.status(other.getStatus());
            this.country(other.getCountry());
            this.totalTaxRate(other.getTotalTaxRate());
            this.effectiveTaxRate(other.getEffectiveTaxRate());
            this.taxComponents(other.getTaxComponents());
            this.remoteWasDeleted(other.getRemoteWasDeleted());
            this.fieldMappings(other.getFieldMappings());
            this.remoteData(other.getRemoteData());
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.of(id);
            return this;
        }

        @JsonSetter(value="remote_id", nulls=Nulls.SKIP)
        public Builder remoteId(Optional<String> remoteId) {
            this.remoteId = remoteId;
            return this;
        }

        public Builder remoteId(String remoteId) {
            this.remoteId = Optional.of(remoteId);
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<OffsetDateTime> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(OffsetDateTime createdAt) {
            this.createdAt = Optional.of(createdAt);
            return this;
        }

        @JsonSetter(value="modified_at", nulls=Nulls.SKIP)
        public Builder modifiedAt(Optional<OffsetDateTime> modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public Builder modifiedAt(OffsetDateTime modifiedAt) {
            this.modifiedAt = Optional.of(modifiedAt);
            return this;
        }

        @JsonSetter(value="company", nulls=Nulls.SKIP)
        public Builder company(Optional<TaxRateCompany> company) {
            this.company = company;
            return this;
        }

        public Builder company(TaxRateCompany company) {
            this.company = Optional.of(company);
            return this;
        }

        @JsonSetter(value="code", nulls=Nulls.SKIP)
        public Builder code(Optional<String> code) {
            this.code = code;
            return this;
        }

        public Builder code(String code) {
            this.code = Optional.of(code);
            return this;
        }

        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.of(name);
            return this;
        }

        @JsonSetter(value="description", nulls=Nulls.SKIP)
        public Builder description(Optional<String> description) {
            this.description = description;
            return this;
        }

        public Builder description(String description) {
            this.description = Optional.of(description);
            return this;
        }

        @JsonSetter(value="status", nulls=Nulls.SKIP)
        public Builder status(Optional<TaxRateStatus> status) {
            this.status = status;
            return this;
        }

        public Builder status(TaxRateStatus status) {
            this.status = Optional.of(status);
            return this;
        }

        @JsonSetter(value="country", nulls=Nulls.SKIP)
        public Builder country(Optional<String> country) {
            this.country = country;
            return this;
        }

        public Builder country(String country) {
            this.country = Optional.of(country);
            return this;
        }

        @JsonSetter(value="total_tax_rate", nulls=Nulls.SKIP)
        public Builder totalTaxRate(Optional<Double> totalTaxRate) {
            this.totalTaxRate = totalTaxRate;
            return this;
        }

        public Builder totalTaxRate(Double totalTaxRate) {
            this.totalTaxRate = Optional.of(totalTaxRate);
            return this;
        }

        @JsonSetter(value="effective_tax_rate", nulls=Nulls.SKIP)
        public Builder effectiveTaxRate(Optional<Double> effectiveTaxRate) {
            this.effectiveTaxRate = effectiveTaxRate;
            return this;
        }

        public Builder effectiveTaxRate(Double effectiveTaxRate) {
            this.effectiveTaxRate = Optional.of(effectiveTaxRate);
            return this;
        }

        @JsonSetter(value="tax_components", nulls=Nulls.SKIP)
        public Builder taxComponents(Optional<List<TaxRateTaxComponentsItem>> taxComponents) {
            this.taxComponents = taxComponents;
            return this;
        }

        public Builder taxComponents(List<TaxRateTaxComponentsItem> taxComponents) {
            this.taxComponents = Optional.of(taxComponents);
            return this;
        }

        @JsonSetter(value="remote_was_deleted", nulls=Nulls.SKIP)
        public Builder remoteWasDeleted(Optional<Boolean> remoteWasDeleted) {
            this.remoteWasDeleted = remoteWasDeleted;
            return this;
        }

        public Builder remoteWasDeleted(Boolean remoteWasDeleted) {
            this.remoteWasDeleted = Optional.of(remoteWasDeleted);
            return this;
        }

        @JsonSetter(value="field_mappings", nulls=Nulls.SKIP)
        public Builder fieldMappings(Optional<Map<String, JsonNode>> fieldMappings) {
            this.fieldMappings = fieldMappings;
            return this;
        }

        public Builder fieldMappings(Map<String, JsonNode> fieldMappings) {
            this.fieldMappings = Optional.of(fieldMappings);
            return this;
        }

        @JsonSetter(value="remote_data", nulls=Nulls.SKIP)
        public Builder remoteData(Optional<List<RemoteData>> remoteData) {
            this.remoteData = remoteData;
            return this;
        }

        public Builder remoteData(List<RemoteData> remoteData) {
            this.remoteData = Optional.of(remoteData);
            return this;
        }

        public TaxRate build() {
            return new TaxRate(this.id, this.remoteId, this.createdAt, this.modifiedAt, this.company, this.code, this.name, this.description, this.status, this.country, this.totalTaxRate, this.effectiveTaxRate, this.taxComponents, this.remoteWasDeleted, this.fieldMappings, this.remoteData, this.additionalProperties);
        }
    }
}

