/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.accounting.types;

import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.merge.api.core.ObjectMappers;
import com.merge.api.resources.accounting.types.TaxComponent;
import java.io.IOException;
import java.util.Objects;

@JsonDeserialize(using=Deserializer.class)
public final class TaxRateTaxComponentsItem {
    private final Object value;
    private final int type;

    private TaxRateTaxComponentsItem(Object value, int type) {
        this.value = value;
        this.type = type;
    }

    @JsonValue
    public Object get() {
        return this.value;
    }

    public <T> T visit(Visitor<T> visitor) {
        if (this.type == 0) {
            return visitor.visit((String)this.value);
        }
        if (this.type == 1) {
            return visitor.visit((TaxComponent)this.value);
        }
        throw new IllegalStateException("Failed to visit value. This should never happen.");
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TaxRateTaxComponentsItem && this.equalTo((TaxRateTaxComponentsItem)other);
    }

    private boolean equalTo(TaxRateTaxComponentsItem other) {
        return this.value.equals(other.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return this.value.toString();
    }

    public static TaxRateTaxComponentsItem of(String value) {
        return new TaxRateTaxComponentsItem(value, 0);
    }

    public static TaxRateTaxComponentsItem of(TaxComponent value) {
        return new TaxRateTaxComponentsItem(value, 1);
    }

    static final class Deserializer
    extends StdDeserializer<TaxRateTaxComponentsItem> {
        Deserializer() {
            super(TaxRateTaxComponentsItem.class);
        }

        public TaxRateTaxComponentsItem deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            Object value = p.readValueAs(Object.class);
            try {
                return TaxRateTaxComponentsItem.of((String)ObjectMappers.JSON_MAPPER.convertValue(value, String.class));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                try {
                    return TaxRateTaxComponentsItem.of((TaxComponent)ObjectMappers.JSON_MAPPER.convertValue(value, TaxComponent.class));
                }
                catch (IllegalArgumentException illegalArgumentException2) {
                    throw new JsonParseException(p, "Failed to deserialize");
                }
            }
        }
    }

    public static interface Visitor<T> {
        public T visit(String var1);

        public T visit(TaxComponent var1);
    }
}

