/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.accounting.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import com.merge.api.resources.accounting.types.RemoteData;
import com.merge.api.resources.accounting.types.TransactionAccount;
import com.merge.api.resources.accounting.types.TransactionAccountingPeriod;
import com.merge.api.resources.accounting.types.TransactionContact;
import com.merge.api.resources.accounting.types.TransactionCurrency;
import com.merge.api.resources.accounting.types.TransactionLineItem;
import com.merge.api.resources.accounting.types.TransactionTrackingCategoriesItem;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class Transaction {
    private final Optional<String> id;
    private final Optional<String> remoteId;
    private final Optional<OffsetDateTime> createdAt;
    private final Optional<OffsetDateTime> modifiedAt;
    private final Optional<String> transactionType;
    private final Optional<String> number;
    private final Optional<OffsetDateTime> transactionDate;
    private final Optional<TransactionAccount> account;
    private final Optional<TransactionContact> contact;
    private final Optional<Boolean> inclusiveOfTax;
    private final Optional<String> totalAmount;
    private final Optional<TransactionCurrency> currency;
    private final Optional<String> exchangeRate;
    private final Optional<String> company;
    private final Optional<List<Optional<TransactionTrackingCategoriesItem>>> trackingCategories;
    private final Optional<List<TransactionLineItem>> lineItems;
    private final Optional<Boolean> remoteWasDeleted;
    private final Optional<TransactionAccountingPeriod> accountingPeriod;
    private final Optional<Map<String, JsonNode>> fieldMappings;
    private final Optional<List<RemoteData>> remoteData;
    private final Map<String, Object> additionalProperties;

    private Transaction(Optional<String> id, Optional<String> remoteId, Optional<OffsetDateTime> createdAt, Optional<OffsetDateTime> modifiedAt, Optional<String> transactionType, Optional<String> number, Optional<OffsetDateTime> transactionDate, Optional<TransactionAccount> account, Optional<TransactionContact> contact, Optional<Boolean> inclusiveOfTax, Optional<String> totalAmount, Optional<TransactionCurrency> currency, Optional<String> exchangeRate, Optional<String> company, Optional<List<Optional<TransactionTrackingCategoriesItem>>> trackingCategories, Optional<List<TransactionLineItem>> lineItems, Optional<Boolean> remoteWasDeleted, Optional<TransactionAccountingPeriod> accountingPeriod, Optional<Map<String, JsonNode>> fieldMappings, Optional<List<RemoteData>> remoteData, Map<String, Object> additionalProperties) {
        this.id = id;
        this.remoteId = remoteId;
        this.createdAt = createdAt;
        this.modifiedAt = modifiedAt;
        this.transactionType = transactionType;
        this.number = number;
        this.transactionDate = transactionDate;
        this.account = account;
        this.contact = contact;
        this.inclusiveOfTax = inclusiveOfTax;
        this.totalAmount = totalAmount;
        this.currency = currency;
        this.exchangeRate = exchangeRate;
        this.company = company;
        this.trackingCategories = trackingCategories;
        this.lineItems = lineItems;
        this.remoteWasDeleted = remoteWasDeleted;
        this.accountingPeriod = accountingPeriod;
        this.fieldMappings = fieldMappings;
        this.remoteData = remoteData;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="remote_id")
    public Optional<String> getRemoteId() {
        return this.remoteId;
    }

    @JsonProperty(value="created_at")
    public Optional<OffsetDateTime> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="modified_at")
    public Optional<OffsetDateTime> getModifiedAt() {
        return this.modifiedAt;
    }

    @JsonProperty(value="transaction_type")
    public Optional<String> getTransactionType() {
        return this.transactionType;
    }

    @JsonProperty(value="number")
    public Optional<String> getNumber() {
        return this.number;
    }

    @JsonProperty(value="transaction_date")
    public Optional<OffsetDateTime> getTransactionDate() {
        return this.transactionDate;
    }

    @JsonProperty(value="account")
    public Optional<TransactionAccount> getAccount() {
        return this.account;
    }

    @JsonProperty(value="contact")
    public Optional<TransactionContact> getContact() {
        return this.contact;
    }

    @JsonProperty(value="inclusive_of_tax")
    public Optional<Boolean> getInclusiveOfTax() {
        return this.inclusiveOfTax;
    }

    @JsonProperty(value="total_amount")
    public Optional<String> getTotalAmount() {
        return this.totalAmount;
    }

    @JsonProperty(value="currency")
    public Optional<TransactionCurrency> getCurrency() {
        return this.currency;
    }

    @JsonProperty(value="exchange_rate")
    public Optional<String> getExchangeRate() {
        return this.exchangeRate;
    }

    @JsonProperty(value="company")
    public Optional<String> getCompany() {
        return this.company;
    }

    @JsonProperty(value="tracking_categories")
    public Optional<List<Optional<TransactionTrackingCategoriesItem>>> getTrackingCategories() {
        return this.trackingCategories;
    }

    @JsonProperty(value="line_items")
    public Optional<List<TransactionLineItem>> getLineItems() {
        return this.lineItems;
    }

    @JsonProperty(value="remote_was_deleted")
    public Optional<Boolean> getRemoteWasDeleted() {
        return this.remoteWasDeleted;
    }

    @JsonProperty(value="accounting_period")
    public Optional<TransactionAccountingPeriod> getAccountingPeriod() {
        return this.accountingPeriod;
    }

    @JsonProperty(value="field_mappings")
    public Optional<Map<String, JsonNode>> getFieldMappings() {
        return this.fieldMappings;
    }

    @JsonProperty(value="remote_data")
    public Optional<List<RemoteData>> getRemoteData() {
        return this.remoteData;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Transaction && this.equalTo((Transaction)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Transaction other) {
        return this.id.equals(other.id) && this.remoteId.equals(other.remoteId) && this.createdAt.equals(other.createdAt) && this.modifiedAt.equals(other.modifiedAt) && this.transactionType.equals(other.transactionType) && this.number.equals(other.number) && this.transactionDate.equals(other.transactionDate) && this.account.equals(other.account) && this.contact.equals(other.contact) && this.inclusiveOfTax.equals(other.inclusiveOfTax) && this.totalAmount.equals(other.totalAmount) && this.currency.equals(other.currency) && this.exchangeRate.equals(other.exchangeRate) && this.company.equals(other.company) && this.trackingCategories.equals(other.trackingCategories) && this.lineItems.equals(other.lineItems) && this.remoteWasDeleted.equals(other.remoteWasDeleted) && this.accountingPeriod.equals(other.accountingPeriod) && this.fieldMappings.equals(other.fieldMappings) && this.remoteData.equals(other.remoteData);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.remoteId, this.createdAt, this.modifiedAt, this.transactionType, this.number, this.transactionDate, this.account, this.contact, this.inclusiveOfTax, this.totalAmount, this.currency, this.exchangeRate, this.company, this.trackingCategories, this.lineItems, this.remoteWasDeleted, this.accountingPeriod, this.fieldMappings, this.remoteData);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> id = Optional.empty();
        private Optional<String> remoteId = Optional.empty();
        private Optional<OffsetDateTime> createdAt = Optional.empty();
        private Optional<OffsetDateTime> modifiedAt = Optional.empty();
        private Optional<String> transactionType = Optional.empty();
        private Optional<String> number = Optional.empty();
        private Optional<OffsetDateTime> transactionDate = Optional.empty();
        private Optional<TransactionAccount> account = Optional.empty();
        private Optional<TransactionContact> contact = Optional.empty();
        private Optional<Boolean> inclusiveOfTax = Optional.empty();
        private Optional<String> totalAmount = Optional.empty();
        private Optional<TransactionCurrency> currency = Optional.empty();
        private Optional<String> exchangeRate = Optional.empty();
        private Optional<String> company = Optional.empty();
        private Optional<List<Optional<TransactionTrackingCategoriesItem>>> trackingCategories = Optional.empty();
        private Optional<List<TransactionLineItem>> lineItems = Optional.empty();
        private Optional<Boolean> remoteWasDeleted = Optional.empty();
        private Optional<TransactionAccountingPeriod> accountingPeriod = Optional.empty();
        private Optional<Map<String, JsonNode>> fieldMappings = Optional.empty();
        private Optional<List<RemoteData>> remoteData = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(Transaction other) {
            this.id(other.getId());
            this.remoteId(other.getRemoteId());
            this.createdAt(other.getCreatedAt());
            this.modifiedAt(other.getModifiedAt());
            this.transactionType(other.getTransactionType());
            this.number(other.getNumber());
            this.transactionDate(other.getTransactionDate());
            this.account(other.getAccount());
            this.contact(other.getContact());
            this.inclusiveOfTax(other.getInclusiveOfTax());
            this.totalAmount(other.getTotalAmount());
            this.currency(other.getCurrency());
            this.exchangeRate(other.getExchangeRate());
            this.company(other.getCompany());
            this.trackingCategories(other.getTrackingCategories());
            this.lineItems(other.getLineItems());
            this.remoteWasDeleted(other.getRemoteWasDeleted());
            this.accountingPeriod(other.getAccountingPeriod());
            this.fieldMappings(other.getFieldMappings());
            this.remoteData(other.getRemoteData());
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.of(id);
            return this;
        }

        @JsonSetter(value="remote_id", nulls=Nulls.SKIP)
        public Builder remoteId(Optional<String> remoteId) {
            this.remoteId = remoteId;
            return this;
        }

        public Builder remoteId(String remoteId) {
            this.remoteId = Optional.of(remoteId);
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<OffsetDateTime> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(OffsetDateTime createdAt) {
            this.createdAt = Optional.of(createdAt);
            return this;
        }

        @JsonSetter(value="modified_at", nulls=Nulls.SKIP)
        public Builder modifiedAt(Optional<OffsetDateTime> modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public Builder modifiedAt(OffsetDateTime modifiedAt) {
            this.modifiedAt = Optional.of(modifiedAt);
            return this;
        }

        @JsonSetter(value="transaction_type", nulls=Nulls.SKIP)
        public Builder transactionType(Optional<String> transactionType) {
            this.transactionType = transactionType;
            return this;
        }

        public Builder transactionType(String transactionType) {
            this.transactionType = Optional.of(transactionType);
            return this;
        }

        @JsonSetter(value="number", nulls=Nulls.SKIP)
        public Builder number(Optional<String> number) {
            this.number = number;
            return this;
        }

        public Builder number(String number) {
            this.number = Optional.of(number);
            return this;
        }

        @JsonSetter(value="transaction_date", nulls=Nulls.SKIP)
        public Builder transactionDate(Optional<OffsetDateTime> transactionDate) {
            this.transactionDate = transactionDate;
            return this;
        }

        public Builder transactionDate(OffsetDateTime transactionDate) {
            this.transactionDate = Optional.of(transactionDate);
            return this;
        }

        @JsonSetter(value="account", nulls=Nulls.SKIP)
        public Builder account(Optional<TransactionAccount> account) {
            this.account = account;
            return this;
        }

        public Builder account(TransactionAccount account) {
            this.account = Optional.of(account);
            return this;
        }

        @JsonSetter(value="contact", nulls=Nulls.SKIP)
        public Builder contact(Optional<TransactionContact> contact) {
            this.contact = contact;
            return this;
        }

        public Builder contact(TransactionContact contact) {
            this.contact = Optional.of(contact);
            return this;
        }

        @JsonSetter(value="inclusive_of_tax", nulls=Nulls.SKIP)
        public Builder inclusiveOfTax(Optional<Boolean> inclusiveOfTax) {
            this.inclusiveOfTax = inclusiveOfTax;
            return this;
        }

        public Builder inclusiveOfTax(Boolean inclusiveOfTax) {
            this.inclusiveOfTax = Optional.of(inclusiveOfTax);
            return this;
        }

        @JsonSetter(value="total_amount", nulls=Nulls.SKIP)
        public Builder totalAmount(Optional<String> totalAmount) {
            this.totalAmount = totalAmount;
            return this;
        }

        public Builder totalAmount(String totalAmount) {
            this.totalAmount = Optional.of(totalAmount);
            return this;
        }

        @JsonSetter(value="currency", nulls=Nulls.SKIP)
        public Builder currency(Optional<TransactionCurrency> currency) {
            this.currency = currency;
            return this;
        }

        public Builder currency(TransactionCurrency currency) {
            this.currency = Optional.of(currency);
            return this;
        }

        @JsonSetter(value="exchange_rate", nulls=Nulls.SKIP)
        public Builder exchangeRate(Optional<String> exchangeRate) {
            this.exchangeRate = exchangeRate;
            return this;
        }

        public Builder exchangeRate(String exchangeRate) {
            this.exchangeRate = Optional.of(exchangeRate);
            return this;
        }

        @JsonSetter(value="company", nulls=Nulls.SKIP)
        public Builder company(Optional<String> company) {
            this.company = company;
            return this;
        }

        public Builder company(String company) {
            this.company = Optional.of(company);
            return this;
        }

        @JsonSetter(value="tracking_categories", nulls=Nulls.SKIP)
        public Builder trackingCategories(Optional<List<Optional<TransactionTrackingCategoriesItem>>> trackingCategories) {
            this.trackingCategories = trackingCategories;
            return this;
        }

        public Builder trackingCategories(List<Optional<TransactionTrackingCategoriesItem>> trackingCategories) {
            this.trackingCategories = Optional.of(trackingCategories);
            return this;
        }

        @JsonSetter(value="line_items", nulls=Nulls.SKIP)
        public Builder lineItems(Optional<List<TransactionLineItem>> lineItems) {
            this.lineItems = lineItems;
            return this;
        }

        public Builder lineItems(List<TransactionLineItem> lineItems) {
            this.lineItems = Optional.of(lineItems);
            return this;
        }

        @JsonSetter(value="remote_was_deleted", nulls=Nulls.SKIP)
        public Builder remoteWasDeleted(Optional<Boolean> remoteWasDeleted) {
            this.remoteWasDeleted = remoteWasDeleted;
            return this;
        }

        public Builder remoteWasDeleted(Boolean remoteWasDeleted) {
            this.remoteWasDeleted = Optional.of(remoteWasDeleted);
            return this;
        }

        @JsonSetter(value="accounting_period", nulls=Nulls.SKIP)
        public Builder accountingPeriod(Optional<TransactionAccountingPeriod> accountingPeriod) {
            this.accountingPeriod = accountingPeriod;
            return this;
        }

        public Builder accountingPeriod(TransactionAccountingPeriod accountingPeriod) {
            this.accountingPeriod = Optional.of(accountingPeriod);
            return this;
        }

        @JsonSetter(value="field_mappings", nulls=Nulls.SKIP)
        public Builder fieldMappings(Optional<Map<String, JsonNode>> fieldMappings) {
            this.fieldMappings = fieldMappings;
            return this;
        }

        public Builder fieldMappings(Map<String, JsonNode> fieldMappings) {
            this.fieldMappings = Optional.of(fieldMappings);
            return this;
        }

        @JsonSetter(value="remote_data", nulls=Nulls.SKIP)
        public Builder remoteData(Optional<List<RemoteData>> remoteData) {
            this.remoteData = remoteData;
            return this;
        }

        public Builder remoteData(List<RemoteData> remoteData) {
            this.remoteData = Optional.of(remoteData);
            return this;
        }

        public Transaction build() {
            return new Transaction(this.id, this.remoteId, this.createdAt, this.modifiedAt, this.transactionType, this.number, this.transactionDate, this.account, this.contact, this.inclusiveOfTax, this.totalAmount, this.currency, this.exchangeRate, this.company, this.trackingCategories, this.lineItems, this.remoteWasDeleted, this.accountingPeriod, this.fieldMappings, this.remoteData, this.additionalProperties);
        }
    }
}

