/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.accounting.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import com.merge.api.resources.accounting.types.RemoteData;
import com.merge.api.resources.accounting.types.VendorCreditAccountingPeriod;
import com.merge.api.resources.accounting.types.VendorCreditCompany;
import com.merge.api.resources.accounting.types.VendorCreditCurrency;
import com.merge.api.resources.accounting.types.VendorCreditLine;
import com.merge.api.resources.accounting.types.VendorCreditTrackingCategoriesItem;
import com.merge.api.resources.accounting.types.VendorCreditVendor;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class VendorCredit {
    private final Optional<String> id;
    private final Optional<String> remoteId;
    private final Optional<OffsetDateTime> createdAt;
    private final Optional<OffsetDateTime> modifiedAt;
    private final Optional<String> number;
    private final Optional<OffsetDateTime> transactionDate;
    private final Optional<VendorCreditVendor> vendor;
    private final Optional<Double> totalAmount;
    private final Optional<VendorCreditCurrency> currency;
    private final Optional<String> exchangeRate;
    private final Optional<Boolean> inclusiveOfTax;
    private final Optional<VendorCreditCompany> company;
    private final Optional<List<VendorCreditLine>> lines;
    private final Optional<List<Optional<VendorCreditTrackingCategoriesItem>>> trackingCategories;
    private final Optional<Boolean> remoteWasDeleted;
    private final Optional<VendorCreditAccountingPeriod> accountingPeriod;
    private final Optional<Map<String, JsonNode>> fieldMappings;
    private final Optional<List<RemoteData>> remoteData;
    private final Map<String, Object> additionalProperties;

    private VendorCredit(Optional<String> id, Optional<String> remoteId, Optional<OffsetDateTime> createdAt, Optional<OffsetDateTime> modifiedAt, Optional<String> number, Optional<OffsetDateTime> transactionDate, Optional<VendorCreditVendor> vendor, Optional<Double> totalAmount, Optional<VendorCreditCurrency> currency, Optional<String> exchangeRate, Optional<Boolean> inclusiveOfTax, Optional<VendorCreditCompany> company, Optional<List<VendorCreditLine>> lines, Optional<List<Optional<VendorCreditTrackingCategoriesItem>>> trackingCategories, Optional<Boolean> remoteWasDeleted, Optional<VendorCreditAccountingPeriod> accountingPeriod, Optional<Map<String, JsonNode>> fieldMappings, Optional<List<RemoteData>> remoteData, Map<String, Object> additionalProperties) {
        this.id = id;
        this.remoteId = remoteId;
        this.createdAt = createdAt;
        this.modifiedAt = modifiedAt;
        this.number = number;
        this.transactionDate = transactionDate;
        this.vendor = vendor;
        this.totalAmount = totalAmount;
        this.currency = currency;
        this.exchangeRate = exchangeRate;
        this.inclusiveOfTax = inclusiveOfTax;
        this.company = company;
        this.lines = lines;
        this.trackingCategories = trackingCategories;
        this.remoteWasDeleted = remoteWasDeleted;
        this.accountingPeriod = accountingPeriod;
        this.fieldMappings = fieldMappings;
        this.remoteData = remoteData;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="remote_id")
    public Optional<String> getRemoteId() {
        return this.remoteId;
    }

    @JsonProperty(value="created_at")
    public Optional<OffsetDateTime> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="modified_at")
    public Optional<OffsetDateTime> getModifiedAt() {
        return this.modifiedAt;
    }

    @JsonProperty(value="number")
    public Optional<String> getNumber() {
        return this.number;
    }

    @JsonProperty(value="transaction_date")
    public Optional<OffsetDateTime> getTransactionDate() {
        return this.transactionDate;
    }

    @JsonProperty(value="vendor")
    public Optional<VendorCreditVendor> getVendor() {
        return this.vendor;
    }

    @JsonProperty(value="total_amount")
    public Optional<Double> getTotalAmount() {
        return this.totalAmount;
    }

    @JsonProperty(value="currency")
    public Optional<VendorCreditCurrency> getCurrency() {
        return this.currency;
    }

    @JsonProperty(value="exchange_rate")
    public Optional<String> getExchangeRate() {
        return this.exchangeRate;
    }

    @JsonProperty(value="inclusive_of_tax")
    public Optional<Boolean> getInclusiveOfTax() {
        return this.inclusiveOfTax;
    }

    @JsonProperty(value="company")
    public Optional<VendorCreditCompany> getCompany() {
        return this.company;
    }

    @JsonProperty(value="lines")
    public Optional<List<VendorCreditLine>> getLines() {
        return this.lines;
    }

    @JsonProperty(value="tracking_categories")
    public Optional<List<Optional<VendorCreditTrackingCategoriesItem>>> getTrackingCategories() {
        return this.trackingCategories;
    }

    @JsonProperty(value="remote_was_deleted")
    public Optional<Boolean> getRemoteWasDeleted() {
        return this.remoteWasDeleted;
    }

    @JsonProperty(value="accounting_period")
    public Optional<VendorCreditAccountingPeriod> getAccountingPeriod() {
        return this.accountingPeriod;
    }

    @JsonProperty(value="field_mappings")
    public Optional<Map<String, JsonNode>> getFieldMappings() {
        return this.fieldMappings;
    }

    @JsonProperty(value="remote_data")
    public Optional<List<RemoteData>> getRemoteData() {
        return this.remoteData;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof VendorCredit && this.equalTo((VendorCredit)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(VendorCredit other) {
        return this.id.equals(other.id) && this.remoteId.equals(other.remoteId) && this.createdAt.equals(other.createdAt) && this.modifiedAt.equals(other.modifiedAt) && this.number.equals(other.number) && this.transactionDate.equals(other.transactionDate) && this.vendor.equals(other.vendor) && this.totalAmount.equals(other.totalAmount) && this.currency.equals(other.currency) && this.exchangeRate.equals(other.exchangeRate) && this.inclusiveOfTax.equals(other.inclusiveOfTax) && this.company.equals(other.company) && this.lines.equals(other.lines) && this.trackingCategories.equals(other.trackingCategories) && this.remoteWasDeleted.equals(other.remoteWasDeleted) && this.accountingPeriod.equals(other.accountingPeriod) && this.fieldMappings.equals(other.fieldMappings) && this.remoteData.equals(other.remoteData);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.remoteId, this.createdAt, this.modifiedAt, this.number, this.transactionDate, this.vendor, this.totalAmount, this.currency, this.exchangeRate, this.inclusiveOfTax, this.company, this.lines, this.trackingCategories, this.remoteWasDeleted, this.accountingPeriod, this.fieldMappings, this.remoteData);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> id = Optional.empty();
        private Optional<String> remoteId = Optional.empty();
        private Optional<OffsetDateTime> createdAt = Optional.empty();
        private Optional<OffsetDateTime> modifiedAt = Optional.empty();
        private Optional<String> number = Optional.empty();
        private Optional<OffsetDateTime> transactionDate = Optional.empty();
        private Optional<VendorCreditVendor> vendor = Optional.empty();
        private Optional<Double> totalAmount = Optional.empty();
        private Optional<VendorCreditCurrency> currency = Optional.empty();
        private Optional<String> exchangeRate = Optional.empty();
        private Optional<Boolean> inclusiveOfTax = Optional.empty();
        private Optional<VendorCreditCompany> company = Optional.empty();
        private Optional<List<VendorCreditLine>> lines = Optional.empty();
        private Optional<List<Optional<VendorCreditTrackingCategoriesItem>>> trackingCategories = Optional.empty();
        private Optional<Boolean> remoteWasDeleted = Optional.empty();
        private Optional<VendorCreditAccountingPeriod> accountingPeriod = Optional.empty();
        private Optional<Map<String, JsonNode>> fieldMappings = Optional.empty();
        private Optional<List<RemoteData>> remoteData = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(VendorCredit other) {
            this.id(other.getId());
            this.remoteId(other.getRemoteId());
            this.createdAt(other.getCreatedAt());
            this.modifiedAt(other.getModifiedAt());
            this.number(other.getNumber());
            this.transactionDate(other.getTransactionDate());
            this.vendor(other.getVendor());
            this.totalAmount(other.getTotalAmount());
            this.currency(other.getCurrency());
            this.exchangeRate(other.getExchangeRate());
            this.inclusiveOfTax(other.getInclusiveOfTax());
            this.company(other.getCompany());
            this.lines(other.getLines());
            this.trackingCategories(other.getTrackingCategories());
            this.remoteWasDeleted(other.getRemoteWasDeleted());
            this.accountingPeriod(other.getAccountingPeriod());
            this.fieldMappings(other.getFieldMappings());
            this.remoteData(other.getRemoteData());
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.of(id);
            return this;
        }

        @JsonSetter(value="remote_id", nulls=Nulls.SKIP)
        public Builder remoteId(Optional<String> remoteId) {
            this.remoteId = remoteId;
            return this;
        }

        public Builder remoteId(String remoteId) {
            this.remoteId = Optional.of(remoteId);
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<OffsetDateTime> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(OffsetDateTime createdAt) {
            this.createdAt = Optional.of(createdAt);
            return this;
        }

        @JsonSetter(value="modified_at", nulls=Nulls.SKIP)
        public Builder modifiedAt(Optional<OffsetDateTime> modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public Builder modifiedAt(OffsetDateTime modifiedAt) {
            this.modifiedAt = Optional.of(modifiedAt);
            return this;
        }

        @JsonSetter(value="number", nulls=Nulls.SKIP)
        public Builder number(Optional<String> number) {
            this.number = number;
            return this;
        }

        public Builder number(String number) {
            this.number = Optional.of(number);
            return this;
        }

        @JsonSetter(value="transaction_date", nulls=Nulls.SKIP)
        public Builder transactionDate(Optional<OffsetDateTime> transactionDate) {
            this.transactionDate = transactionDate;
            return this;
        }

        public Builder transactionDate(OffsetDateTime transactionDate) {
            this.transactionDate = Optional.of(transactionDate);
            return this;
        }

        @JsonSetter(value="vendor", nulls=Nulls.SKIP)
        public Builder vendor(Optional<VendorCreditVendor> vendor) {
            this.vendor = vendor;
            return this;
        }

        public Builder vendor(VendorCreditVendor vendor) {
            this.vendor = Optional.of(vendor);
            return this;
        }

        @JsonSetter(value="total_amount", nulls=Nulls.SKIP)
        public Builder totalAmount(Optional<Double> totalAmount) {
            this.totalAmount = totalAmount;
            return this;
        }

        public Builder totalAmount(Double totalAmount) {
            this.totalAmount = Optional.of(totalAmount);
            return this;
        }

        @JsonSetter(value="currency", nulls=Nulls.SKIP)
        public Builder currency(Optional<VendorCreditCurrency> currency) {
            this.currency = currency;
            return this;
        }

        public Builder currency(VendorCreditCurrency currency) {
            this.currency = Optional.of(currency);
            return this;
        }

        @JsonSetter(value="exchange_rate", nulls=Nulls.SKIP)
        public Builder exchangeRate(Optional<String> exchangeRate) {
            this.exchangeRate = exchangeRate;
            return this;
        }

        public Builder exchangeRate(String exchangeRate) {
            this.exchangeRate = Optional.of(exchangeRate);
            return this;
        }

        @JsonSetter(value="inclusive_of_tax", nulls=Nulls.SKIP)
        public Builder inclusiveOfTax(Optional<Boolean> inclusiveOfTax) {
            this.inclusiveOfTax = inclusiveOfTax;
            return this;
        }

        public Builder inclusiveOfTax(Boolean inclusiveOfTax) {
            this.inclusiveOfTax = Optional.of(inclusiveOfTax);
            return this;
        }

        @JsonSetter(value="company", nulls=Nulls.SKIP)
        public Builder company(Optional<VendorCreditCompany> company) {
            this.company = company;
            return this;
        }

        public Builder company(VendorCreditCompany company) {
            this.company = Optional.of(company);
            return this;
        }

        @JsonSetter(value="lines", nulls=Nulls.SKIP)
        public Builder lines(Optional<List<VendorCreditLine>> lines) {
            this.lines = lines;
            return this;
        }

        public Builder lines(List<VendorCreditLine> lines) {
            this.lines = Optional.of(lines);
            return this;
        }

        @JsonSetter(value="tracking_categories", nulls=Nulls.SKIP)
        public Builder trackingCategories(Optional<List<Optional<VendorCreditTrackingCategoriesItem>>> trackingCategories) {
            this.trackingCategories = trackingCategories;
            return this;
        }

        public Builder trackingCategories(List<Optional<VendorCreditTrackingCategoriesItem>> trackingCategories) {
            this.trackingCategories = Optional.of(trackingCategories);
            return this;
        }

        @JsonSetter(value="remote_was_deleted", nulls=Nulls.SKIP)
        public Builder remoteWasDeleted(Optional<Boolean> remoteWasDeleted) {
            this.remoteWasDeleted = remoteWasDeleted;
            return this;
        }

        public Builder remoteWasDeleted(Boolean remoteWasDeleted) {
            this.remoteWasDeleted = Optional.of(remoteWasDeleted);
            return this;
        }

        @JsonSetter(value="accounting_period", nulls=Nulls.SKIP)
        public Builder accountingPeriod(Optional<VendorCreditAccountingPeriod> accountingPeriod) {
            this.accountingPeriod = accountingPeriod;
            return this;
        }

        public Builder accountingPeriod(VendorCreditAccountingPeriod accountingPeriod) {
            this.accountingPeriod = Optional.of(accountingPeriod);
            return this;
        }

        @JsonSetter(value="field_mappings", nulls=Nulls.SKIP)
        public Builder fieldMappings(Optional<Map<String, JsonNode>> fieldMappings) {
            this.fieldMappings = fieldMappings;
            return this;
        }

        public Builder fieldMappings(Map<String, JsonNode> fieldMappings) {
            this.fieldMappings = Optional.of(fieldMappings);
            return this;
        }

        @JsonSetter(value="remote_data", nulls=Nulls.SKIP)
        public Builder remoteData(Optional<List<RemoteData>> remoteData) {
            this.remoteData = remoteData;
            return this;
        }

        public Builder remoteData(List<RemoteData> remoteData) {
            this.remoteData = Optional.of(remoteData);
            return this;
        }

        public VendorCredit build() {
            return new VendorCredit(this.id, this.remoteId, this.createdAt, this.modifiedAt, this.number, this.transactionDate, this.vendor, this.totalAmount, this.currency, this.exchangeRate, this.inclusiveOfTax, this.company, this.lines, this.trackingCategories, this.remoteWasDeleted, this.accountingPeriod, this.fieldMappings, this.remoteData, this.additionalProperties);
        }
    }
}

