/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.accounting.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import com.merge.api.resources.accounting.types.VendorCreditLineAccount;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class VendorCreditLine {
    private final Optional<String> id;
    private final Optional<String> remoteId;
    private final Optional<OffsetDateTime> createdAt;
    private final Optional<OffsetDateTime> modifiedAt;
    private final Optional<Double> netAmount;
    private final Optional<String> trackingCategory;
    private final Optional<List<Optional<String>>> trackingCategories;
    private final Optional<String> description;
    private final Optional<VendorCreditLineAccount> account;
    private final Optional<String> company;
    private final Optional<String> taxRate;
    private final Optional<String> exchangeRate;
    private final Optional<Boolean> remoteWasDeleted;
    private final Map<String, Object> additionalProperties;

    private VendorCreditLine(Optional<String> id, Optional<String> remoteId, Optional<OffsetDateTime> createdAt, Optional<OffsetDateTime> modifiedAt, Optional<Double> netAmount, Optional<String> trackingCategory, Optional<List<Optional<String>>> trackingCategories, Optional<String> description, Optional<VendorCreditLineAccount> account, Optional<String> company, Optional<String> taxRate, Optional<String> exchangeRate, Optional<Boolean> remoteWasDeleted, Map<String, Object> additionalProperties) {
        this.id = id;
        this.remoteId = remoteId;
        this.createdAt = createdAt;
        this.modifiedAt = modifiedAt;
        this.netAmount = netAmount;
        this.trackingCategory = trackingCategory;
        this.trackingCategories = trackingCategories;
        this.description = description;
        this.account = account;
        this.company = company;
        this.taxRate = taxRate;
        this.exchangeRate = exchangeRate;
        this.remoteWasDeleted = remoteWasDeleted;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="remote_id")
    public Optional<String> getRemoteId() {
        return this.remoteId;
    }

    @JsonProperty(value="created_at")
    public Optional<OffsetDateTime> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="modified_at")
    public Optional<OffsetDateTime> getModifiedAt() {
        return this.modifiedAt;
    }

    @JsonProperty(value="net_amount")
    public Optional<Double> getNetAmount() {
        return this.netAmount;
    }

    @JsonProperty(value="tracking_category")
    public Optional<String> getTrackingCategory() {
        return this.trackingCategory;
    }

    @JsonProperty(value="tracking_categories")
    public Optional<List<Optional<String>>> getTrackingCategories() {
        return this.trackingCategories;
    }

    @JsonProperty(value="description")
    public Optional<String> getDescription() {
        return this.description;
    }

    @JsonProperty(value="account")
    public Optional<VendorCreditLineAccount> getAccount() {
        return this.account;
    }

    @JsonProperty(value="company")
    public Optional<String> getCompany() {
        return this.company;
    }

    @JsonProperty(value="tax_rate")
    public Optional<String> getTaxRate() {
        return this.taxRate;
    }

    @JsonProperty(value="exchange_rate")
    public Optional<String> getExchangeRate() {
        return this.exchangeRate;
    }

    @JsonProperty(value="remote_was_deleted")
    public Optional<Boolean> getRemoteWasDeleted() {
        return this.remoteWasDeleted;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof VendorCreditLine && this.equalTo((VendorCreditLine)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(VendorCreditLine other) {
        return this.id.equals(other.id) && this.remoteId.equals(other.remoteId) && this.createdAt.equals(other.createdAt) && this.modifiedAt.equals(other.modifiedAt) && this.netAmount.equals(other.netAmount) && this.trackingCategory.equals(other.trackingCategory) && this.trackingCategories.equals(other.trackingCategories) && this.description.equals(other.description) && this.account.equals(other.account) && this.company.equals(other.company) && this.taxRate.equals(other.taxRate) && this.exchangeRate.equals(other.exchangeRate) && this.remoteWasDeleted.equals(other.remoteWasDeleted);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.remoteId, this.createdAt, this.modifiedAt, this.netAmount, this.trackingCategory, this.trackingCategories, this.description, this.account, this.company, this.taxRate, this.exchangeRate, this.remoteWasDeleted);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> id = Optional.empty();
        private Optional<String> remoteId = Optional.empty();
        private Optional<OffsetDateTime> createdAt = Optional.empty();
        private Optional<OffsetDateTime> modifiedAt = Optional.empty();
        private Optional<Double> netAmount = Optional.empty();
        private Optional<String> trackingCategory = Optional.empty();
        private Optional<List<Optional<String>>> trackingCategories = Optional.empty();
        private Optional<String> description = Optional.empty();
        private Optional<VendorCreditLineAccount> account = Optional.empty();
        private Optional<String> company = Optional.empty();
        private Optional<String> taxRate = Optional.empty();
        private Optional<String> exchangeRate = Optional.empty();
        private Optional<Boolean> remoteWasDeleted = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(VendorCreditLine other) {
            this.id(other.getId());
            this.remoteId(other.getRemoteId());
            this.createdAt(other.getCreatedAt());
            this.modifiedAt(other.getModifiedAt());
            this.netAmount(other.getNetAmount());
            this.trackingCategory(other.getTrackingCategory());
            this.trackingCategories(other.getTrackingCategories());
            this.description(other.getDescription());
            this.account(other.getAccount());
            this.company(other.getCompany());
            this.taxRate(other.getTaxRate());
            this.exchangeRate(other.getExchangeRate());
            this.remoteWasDeleted(other.getRemoteWasDeleted());
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.of(id);
            return this;
        }

        @JsonSetter(value="remote_id", nulls=Nulls.SKIP)
        public Builder remoteId(Optional<String> remoteId) {
            this.remoteId = remoteId;
            return this;
        }

        public Builder remoteId(String remoteId) {
            this.remoteId = Optional.of(remoteId);
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<OffsetDateTime> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(OffsetDateTime createdAt) {
            this.createdAt = Optional.of(createdAt);
            return this;
        }

        @JsonSetter(value="modified_at", nulls=Nulls.SKIP)
        public Builder modifiedAt(Optional<OffsetDateTime> modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public Builder modifiedAt(OffsetDateTime modifiedAt) {
            this.modifiedAt = Optional.of(modifiedAt);
            return this;
        }

        @JsonSetter(value="net_amount", nulls=Nulls.SKIP)
        public Builder netAmount(Optional<Double> netAmount) {
            this.netAmount = netAmount;
            return this;
        }

        public Builder netAmount(Double netAmount) {
            this.netAmount = Optional.of(netAmount);
            return this;
        }

        @JsonSetter(value="tracking_category", nulls=Nulls.SKIP)
        public Builder trackingCategory(Optional<String> trackingCategory) {
            this.trackingCategory = trackingCategory;
            return this;
        }

        public Builder trackingCategory(String trackingCategory) {
            this.trackingCategory = Optional.of(trackingCategory);
            return this;
        }

        @JsonSetter(value="tracking_categories", nulls=Nulls.SKIP)
        public Builder trackingCategories(Optional<List<Optional<String>>> trackingCategories) {
            this.trackingCategories = trackingCategories;
            return this;
        }

        public Builder trackingCategories(List<Optional<String>> trackingCategories) {
            this.trackingCategories = Optional.of(trackingCategories);
            return this;
        }

        @JsonSetter(value="description", nulls=Nulls.SKIP)
        public Builder description(Optional<String> description) {
            this.description = description;
            return this;
        }

        public Builder description(String description) {
            this.description = Optional.of(description);
            return this;
        }

        @JsonSetter(value="account", nulls=Nulls.SKIP)
        public Builder account(Optional<VendorCreditLineAccount> account) {
            this.account = account;
            return this;
        }

        public Builder account(VendorCreditLineAccount account) {
            this.account = Optional.of(account);
            return this;
        }

        @JsonSetter(value="company", nulls=Nulls.SKIP)
        public Builder company(Optional<String> company) {
            this.company = company;
            return this;
        }

        public Builder company(String company) {
            this.company = Optional.of(company);
            return this;
        }

        @JsonSetter(value="tax_rate", nulls=Nulls.SKIP)
        public Builder taxRate(Optional<String> taxRate) {
            this.taxRate = taxRate;
            return this;
        }

        public Builder taxRate(String taxRate) {
            this.taxRate = Optional.of(taxRate);
            return this;
        }

        @JsonSetter(value="exchange_rate", nulls=Nulls.SKIP)
        public Builder exchangeRate(Optional<String> exchangeRate) {
            this.exchangeRate = exchangeRate;
            return this;
        }

        public Builder exchangeRate(String exchangeRate) {
            this.exchangeRate = Optional.of(exchangeRate);
            return this;
        }

        @JsonSetter(value="remote_was_deleted", nulls=Nulls.SKIP)
        public Builder remoteWasDeleted(Optional<Boolean> remoteWasDeleted) {
            this.remoteWasDeleted = remoteWasDeleted;
            return this;
        }

        public Builder remoteWasDeleted(Boolean remoteWasDeleted) {
            this.remoteWasDeleted = Optional.of(remoteWasDeleted);
            return this;
        }

        public VendorCreditLine build() {
            return new VendorCreditLine(this.id, this.remoteId, this.createdAt, this.modifiedAt, this.netAmount, this.trackingCategory, this.trackingCategories, this.description, this.account, this.company, this.taxRate, this.exchangeRate, this.remoteWasDeleted, this.additionalProperties);
        }
    }
}

