/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.ats.activities.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import com.merge.api.resources.ats.activities.types.ActivitiesRetrieveRequestRemoteFields;
import com.merge.api.resources.ats.activities.types.ActivitiesRetrieveRequestShowEnumOrigins;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class ActivitiesRetrieveRequest {
    private final Optional<String> expand;
    private final Optional<Boolean> includeRemoteData;
    private final Optional<ActivitiesRetrieveRequestRemoteFields> remoteFields;
    private final Optional<ActivitiesRetrieveRequestShowEnumOrigins> showEnumOrigins;
    private final Map<String, Object> additionalProperties;

    private ActivitiesRetrieveRequest(Optional<String> expand, Optional<Boolean> includeRemoteData, Optional<ActivitiesRetrieveRequestRemoteFields> remoteFields, Optional<ActivitiesRetrieveRequestShowEnumOrigins> showEnumOrigins, Map<String, Object> additionalProperties) {
        this.expand = expand;
        this.includeRemoteData = includeRemoteData;
        this.remoteFields = remoteFields;
        this.showEnumOrigins = showEnumOrigins;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="expand")
    public Optional<String> getExpand() {
        return this.expand;
    }

    @JsonProperty(value="include_remote_data")
    public Optional<Boolean> getIncludeRemoteData() {
        return this.includeRemoteData;
    }

    @JsonProperty(value="remote_fields")
    public Optional<ActivitiesRetrieveRequestRemoteFields> getRemoteFields() {
        return this.remoteFields;
    }

    @JsonProperty(value="show_enum_origins")
    public Optional<ActivitiesRetrieveRequestShowEnumOrigins> getShowEnumOrigins() {
        return this.showEnumOrigins;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ActivitiesRetrieveRequest && this.equalTo((ActivitiesRetrieveRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ActivitiesRetrieveRequest other) {
        return this.expand.equals(other.expand) && this.includeRemoteData.equals(other.includeRemoteData) && this.remoteFields.equals(other.remoteFields) && this.showEnumOrigins.equals(other.showEnumOrigins);
    }

    public int hashCode() {
        return Objects.hash(this.expand, this.includeRemoteData, this.remoteFields, this.showEnumOrigins);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> expand = Optional.empty();
        private Optional<Boolean> includeRemoteData = Optional.empty();
        private Optional<ActivitiesRetrieveRequestRemoteFields> remoteFields = Optional.empty();
        private Optional<ActivitiesRetrieveRequestShowEnumOrigins> showEnumOrigins = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ActivitiesRetrieveRequest other) {
            this.expand(other.getExpand());
            this.includeRemoteData(other.getIncludeRemoteData());
            this.remoteFields(other.getRemoteFields());
            this.showEnumOrigins(other.getShowEnumOrigins());
            return this;
        }

        @JsonSetter(value="expand", nulls=Nulls.SKIP)
        public Builder expand(Optional<String> expand) {
            this.expand = expand;
            return this;
        }

        public Builder expand(String expand) {
            this.expand = Optional.of(expand);
            return this;
        }

        @JsonSetter(value="include_remote_data", nulls=Nulls.SKIP)
        public Builder includeRemoteData(Optional<Boolean> includeRemoteData) {
            this.includeRemoteData = includeRemoteData;
            return this;
        }

        public Builder includeRemoteData(Boolean includeRemoteData) {
            this.includeRemoteData = Optional.of(includeRemoteData);
            return this;
        }

        @JsonSetter(value="remote_fields", nulls=Nulls.SKIP)
        public Builder remoteFields(Optional<ActivitiesRetrieveRequestRemoteFields> remoteFields) {
            this.remoteFields = remoteFields;
            return this;
        }

        public Builder remoteFields(ActivitiesRetrieveRequestRemoteFields remoteFields) {
            this.remoteFields = Optional.of(remoteFields);
            return this;
        }

        @JsonSetter(value="show_enum_origins", nulls=Nulls.SKIP)
        public Builder showEnumOrigins(Optional<ActivitiesRetrieveRequestShowEnumOrigins> showEnumOrigins) {
            this.showEnumOrigins = showEnumOrigins;
            return this;
        }

        public Builder showEnumOrigins(ActivitiesRetrieveRequestShowEnumOrigins showEnumOrigins) {
            this.showEnumOrigins = Optional.of(showEnumOrigins);
            return this;
        }

        public ActivitiesRetrieveRequest build() {
            return new ActivitiesRetrieveRequest(this.expand, this.includeRemoteData, this.remoteFields, this.showEnumOrigins, this.additionalProperties);
        }
    }
}

