/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.ats.applications;

import com.merge.api.core.ApiError;
import com.merge.api.core.ClientOptions;
import com.merge.api.core.MediaTypes;
import com.merge.api.core.MergeException;
import com.merge.api.core.ObjectMappers;
import com.merge.api.core.RequestOptions;
import com.merge.api.resources.ats.applications.requests.ApplicationEndpointRequest;
import com.merge.api.resources.ats.applications.requests.ApplicationsListRequest;
import com.merge.api.resources.ats.applications.requests.ApplicationsMetaPostRetrieveRequest;
import com.merge.api.resources.ats.applications.requests.ApplicationsRetrieveRequest;
import com.merge.api.resources.ats.applications.requests.UpdateApplicationStageRequest;
import com.merge.api.resources.ats.types.Application;
import com.merge.api.resources.ats.types.ApplicationResponse;
import com.merge.api.resources.ats.types.MetaResponse;
import com.merge.api.resources.ats.types.PaginatedApplicationList;
import java.io.IOException;
import java.util.HashMap;
import java.util.Optional;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class ApplicationsClient {
    protected final ClientOptions clientOptions;

    public ApplicationsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public PaginatedApplicationList list() {
        return this.list(ApplicationsListRequest.builder().build());
    }

    public PaginatedApplicationList list(ApplicationsListRequest request) {
        return this.list(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PaginatedApplicationList list(ApplicationsListRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("ats/v1/applications");
        if (request.getCandidateId().isPresent()) {
            httpUrl.addQueryParameter("candidate_id", request.getCandidateId().get());
        }
        if (request.getCreatedAfter().isPresent()) {
            httpUrl.addQueryParameter("created_after", request.getCreatedAfter().get().toString());
        }
        if (request.getCreatedBefore().isPresent()) {
            httpUrl.addQueryParameter("created_before", request.getCreatedBefore().get().toString());
        }
        if (request.getCreditedToId().isPresent()) {
            httpUrl.addQueryParameter("credited_to_id", request.getCreditedToId().get());
        }
        if (request.getCurrentStageId().isPresent()) {
            httpUrl.addQueryParameter("current_stage_id", request.getCurrentStageId().get());
        }
        if (request.getCursor().isPresent()) {
            httpUrl.addQueryParameter("cursor", request.getCursor().get());
        }
        if (request.getExpand().isPresent()) {
            httpUrl.addQueryParameter("expand", request.getExpand().get().toString());
        }
        if (request.getIncludeDeletedData().isPresent()) {
            httpUrl.addQueryParameter("include_deleted_data", request.getIncludeDeletedData().get().toString());
        }
        if (request.getIncludeRemoteData().isPresent()) {
            httpUrl.addQueryParameter("include_remote_data", request.getIncludeRemoteData().get().toString());
        }
        if (request.getIncludeShellData().isPresent()) {
            httpUrl.addQueryParameter("include_shell_data", request.getIncludeShellData().get().toString());
        }
        if (request.getJobId().isPresent()) {
            httpUrl.addQueryParameter("job_id", request.getJobId().get());
        }
        if (request.getModifiedAfter().isPresent()) {
            httpUrl.addQueryParameter("modified_after", request.getModifiedAfter().get().toString());
        }
        if (request.getModifiedBefore().isPresent()) {
            httpUrl.addQueryParameter("modified_before", request.getModifiedBefore().get().toString());
        }
        if (request.getPageSize().isPresent()) {
            httpUrl.addQueryParameter("page_size", request.getPageSize().get().toString());
        }
        if (request.getRejectReasonId().isPresent()) {
            httpUrl.addQueryParameter("reject_reason_id", request.getRejectReasonId().get());
        }
        if (request.getRemoteId().isPresent()) {
            httpUrl.addQueryParameter("remote_id", request.getRemoteId().get());
        }
        if (request.getSource().isPresent()) {
            httpUrl.addQueryParameter("source", request.getSource().get());
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                PaginatedApplicationList paginatedApplicationList = (PaginatedApplicationList)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), PaginatedApplicationList.class);
                return paginatedApplicationList;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new ApiError("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new MergeException("Network error executing HTTP request", e);
        }
    }

    public ApplicationResponse create(ApplicationEndpointRequest request) {
        return this.create(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ApplicationResponse create(ApplicationEndpointRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("ats/v1/applications");
        if (request.getIsDebugMode().isPresent()) {
            httpUrl.addQueryParameter("is_debug_mode", request.getIsDebugMode().get().toString());
        }
        if (request.getRunAsync().isPresent()) {
            httpUrl.addQueryParameter("run_async", request.getRunAsync().get().toString());
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("model", request.getModel());
        properties.put("remote_user_id", request.getRemoteUserId());
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes(properties), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                ApplicationResponse applicationResponse = (ApplicationResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), ApplicationResponse.class);
                return applicationResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new ApiError("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new MergeException("Network error executing HTTP request", e);
        }
    }

    public Application retrieve(String id) {
        return this.retrieve(id, ApplicationsRetrieveRequest.builder().build());
    }

    public Application retrieve(String id, ApplicationsRetrieveRequest request) {
        return this.retrieve(id, request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Application retrieve(String id, ApplicationsRetrieveRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("ats/v1/applications").addPathSegment(id);
        if (request.getExpand().isPresent()) {
            httpUrl.addQueryParameter("expand", request.getExpand().get().toString());
        }
        if (request.getIncludeRemoteData().isPresent()) {
            httpUrl.addQueryParameter("include_remote_data", request.getIncludeRemoteData().get().toString());
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                Application application = (Application)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), Application.class);
                return application;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new ApiError("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new MergeException("Network error executing HTTP request", e);
        }
    }

    public ApplicationResponse changeStageCreate(String id) {
        return this.changeStageCreate(id, UpdateApplicationStageRequest.builder().build());
    }

    public ApplicationResponse changeStageCreate(String id, UpdateApplicationStageRequest request) {
        return this.changeStageCreate(id, request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ApplicationResponse changeStageCreate(String id, UpdateApplicationStageRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("ats/v1/applications").addPathSegment(id).addPathSegments("change-stage");
        if (request.getIsDebugMode().isPresent()) {
            httpUrl.addQueryParameter("is_debug_mode", request.getIsDebugMode().get().toString());
        }
        if (request.getRunAsync().isPresent()) {
            httpUrl.addQueryParameter("run_async", request.getRunAsync().get().toString());
        }
        HashMap<String, Optional<String>> properties = new HashMap<String, Optional<String>>();
        if (request.getJobInterviewStage().isPresent()) {
            properties.put("job_interview_stage", request.getJobInterviewStage());
        }
        if (request.getRemoteUserId().isPresent()) {
            properties.put("remote_user_id", request.getRemoteUserId());
        }
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes(properties), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                ApplicationResponse applicationResponse = (ApplicationResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), ApplicationResponse.class);
                return applicationResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new ApiError("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new MergeException("Network error executing HTTP request", e);
        }
    }

    public MetaResponse metaPostRetrieve() {
        return this.metaPostRetrieve(ApplicationsMetaPostRetrieveRequest.builder().build());
    }

    public MetaResponse metaPostRetrieve(ApplicationsMetaPostRetrieveRequest request) {
        return this.metaPostRetrieve(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MetaResponse metaPostRetrieve(ApplicationsMetaPostRetrieveRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("ats/v1/applications/meta/post");
        if (request.getApplicationRemoteTemplateId().isPresent()) {
            httpUrl.addQueryParameter("application_remote_template_id", request.getApplicationRemoteTemplateId().get());
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                MetaResponse metaResponse = (MetaResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), MetaResponse.class);
                return metaResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new ApiError("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new MergeException("Network error executing HTTP request", e);
        }
    }
}

