/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.ats.applications.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import com.merge.api.resources.ats.applications.types.ApplicationsListRequestExpand;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class ApplicationsListRequest {
    private final Optional<String> candidateId;
    private final Optional<OffsetDateTime> createdAfter;
    private final Optional<OffsetDateTime> createdBefore;
    private final Optional<String> creditedToId;
    private final Optional<String> currentStageId;
    private final Optional<String> cursor;
    private final Optional<ApplicationsListRequestExpand> expand;
    private final Optional<Boolean> includeDeletedData;
    private final Optional<Boolean> includeRemoteData;
    private final Optional<Boolean> includeShellData;
    private final Optional<String> jobId;
    private final Optional<OffsetDateTime> modifiedAfter;
    private final Optional<OffsetDateTime> modifiedBefore;
    private final Optional<Integer> pageSize;
    private final Optional<String> rejectReasonId;
    private final Optional<String> remoteId;
    private final Optional<String> source;
    private final Map<String, Object> additionalProperties;

    private ApplicationsListRequest(Optional<String> candidateId, Optional<OffsetDateTime> createdAfter, Optional<OffsetDateTime> createdBefore, Optional<String> creditedToId, Optional<String> currentStageId, Optional<String> cursor, Optional<ApplicationsListRequestExpand> expand, Optional<Boolean> includeDeletedData, Optional<Boolean> includeRemoteData, Optional<Boolean> includeShellData, Optional<String> jobId, Optional<OffsetDateTime> modifiedAfter, Optional<OffsetDateTime> modifiedBefore, Optional<Integer> pageSize, Optional<String> rejectReasonId, Optional<String> remoteId, Optional<String> source, Map<String, Object> additionalProperties) {
        this.candidateId = candidateId;
        this.createdAfter = createdAfter;
        this.createdBefore = createdBefore;
        this.creditedToId = creditedToId;
        this.currentStageId = currentStageId;
        this.cursor = cursor;
        this.expand = expand;
        this.includeDeletedData = includeDeletedData;
        this.includeRemoteData = includeRemoteData;
        this.includeShellData = includeShellData;
        this.jobId = jobId;
        this.modifiedAfter = modifiedAfter;
        this.modifiedBefore = modifiedBefore;
        this.pageSize = pageSize;
        this.rejectReasonId = rejectReasonId;
        this.remoteId = remoteId;
        this.source = source;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="candidate_id")
    public Optional<String> getCandidateId() {
        return this.candidateId;
    }

    @JsonProperty(value="created_after")
    public Optional<OffsetDateTime> getCreatedAfter() {
        return this.createdAfter;
    }

    @JsonProperty(value="created_before")
    public Optional<OffsetDateTime> getCreatedBefore() {
        return this.createdBefore;
    }

    @JsonProperty(value="credited_to_id")
    public Optional<String> getCreditedToId() {
        return this.creditedToId;
    }

    @JsonProperty(value="current_stage_id")
    public Optional<String> getCurrentStageId() {
        return this.currentStageId;
    }

    @JsonProperty(value="cursor")
    public Optional<String> getCursor() {
        return this.cursor;
    }

    @JsonProperty(value="expand")
    public Optional<ApplicationsListRequestExpand> getExpand() {
        return this.expand;
    }

    @JsonProperty(value="include_deleted_data")
    public Optional<Boolean> getIncludeDeletedData() {
        return this.includeDeletedData;
    }

    @JsonProperty(value="include_remote_data")
    public Optional<Boolean> getIncludeRemoteData() {
        return this.includeRemoteData;
    }

    @JsonProperty(value="include_shell_data")
    public Optional<Boolean> getIncludeShellData() {
        return this.includeShellData;
    }

    @JsonProperty(value="job_id")
    public Optional<String> getJobId() {
        return this.jobId;
    }

    @JsonProperty(value="modified_after")
    public Optional<OffsetDateTime> getModifiedAfter() {
        return this.modifiedAfter;
    }

    @JsonProperty(value="modified_before")
    public Optional<OffsetDateTime> getModifiedBefore() {
        return this.modifiedBefore;
    }

    @JsonProperty(value="page_size")
    public Optional<Integer> getPageSize() {
        return this.pageSize;
    }

    @JsonProperty(value="reject_reason_id")
    public Optional<String> getRejectReasonId() {
        return this.rejectReasonId;
    }

    @JsonProperty(value="remote_id")
    public Optional<String> getRemoteId() {
        return this.remoteId;
    }

    @JsonProperty(value="source")
    public Optional<String> getSource() {
        return this.source;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ApplicationsListRequest && this.equalTo((ApplicationsListRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ApplicationsListRequest other) {
        return this.candidateId.equals(other.candidateId) && this.createdAfter.equals(other.createdAfter) && this.createdBefore.equals(other.createdBefore) && this.creditedToId.equals(other.creditedToId) && this.currentStageId.equals(other.currentStageId) && this.cursor.equals(other.cursor) && this.expand.equals(other.expand) && this.includeDeletedData.equals(other.includeDeletedData) && this.includeRemoteData.equals(other.includeRemoteData) && this.includeShellData.equals(other.includeShellData) && this.jobId.equals(other.jobId) && this.modifiedAfter.equals(other.modifiedAfter) && this.modifiedBefore.equals(other.modifiedBefore) && this.pageSize.equals(other.pageSize) && this.rejectReasonId.equals(other.rejectReasonId) && this.remoteId.equals(other.remoteId) && this.source.equals(other.source);
    }

    public int hashCode() {
        return Objects.hash(this.candidateId, this.createdAfter, this.createdBefore, this.creditedToId, this.currentStageId, this.cursor, this.expand, this.includeDeletedData, this.includeRemoteData, this.includeShellData, this.jobId, this.modifiedAfter, this.modifiedBefore, this.pageSize, this.rejectReasonId, this.remoteId, this.source);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> candidateId = Optional.empty();
        private Optional<OffsetDateTime> createdAfter = Optional.empty();
        private Optional<OffsetDateTime> createdBefore = Optional.empty();
        private Optional<String> creditedToId = Optional.empty();
        private Optional<String> currentStageId = Optional.empty();
        private Optional<String> cursor = Optional.empty();
        private Optional<ApplicationsListRequestExpand> expand = Optional.empty();
        private Optional<Boolean> includeDeletedData = Optional.empty();
        private Optional<Boolean> includeRemoteData = Optional.empty();
        private Optional<Boolean> includeShellData = Optional.empty();
        private Optional<String> jobId = Optional.empty();
        private Optional<OffsetDateTime> modifiedAfter = Optional.empty();
        private Optional<OffsetDateTime> modifiedBefore = Optional.empty();
        private Optional<Integer> pageSize = Optional.empty();
        private Optional<String> rejectReasonId = Optional.empty();
        private Optional<String> remoteId = Optional.empty();
        private Optional<String> source = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ApplicationsListRequest other) {
            this.candidateId(other.getCandidateId());
            this.createdAfter(other.getCreatedAfter());
            this.createdBefore(other.getCreatedBefore());
            this.creditedToId(other.getCreditedToId());
            this.currentStageId(other.getCurrentStageId());
            this.cursor(other.getCursor());
            this.expand(other.getExpand());
            this.includeDeletedData(other.getIncludeDeletedData());
            this.includeRemoteData(other.getIncludeRemoteData());
            this.includeShellData(other.getIncludeShellData());
            this.jobId(other.getJobId());
            this.modifiedAfter(other.getModifiedAfter());
            this.modifiedBefore(other.getModifiedBefore());
            this.pageSize(other.getPageSize());
            this.rejectReasonId(other.getRejectReasonId());
            this.remoteId(other.getRemoteId());
            this.source(other.getSource());
            return this;
        }

        @JsonSetter(value="candidate_id", nulls=Nulls.SKIP)
        public Builder candidateId(Optional<String> candidateId) {
            this.candidateId = candidateId;
            return this;
        }

        public Builder candidateId(String candidateId) {
            this.candidateId = Optional.of(candidateId);
            return this;
        }

        @JsonSetter(value="created_after", nulls=Nulls.SKIP)
        public Builder createdAfter(Optional<OffsetDateTime> createdAfter) {
            this.createdAfter = createdAfter;
            return this;
        }

        public Builder createdAfter(OffsetDateTime createdAfter) {
            this.createdAfter = Optional.of(createdAfter);
            return this;
        }

        @JsonSetter(value="created_before", nulls=Nulls.SKIP)
        public Builder createdBefore(Optional<OffsetDateTime> createdBefore) {
            this.createdBefore = createdBefore;
            return this;
        }

        public Builder createdBefore(OffsetDateTime createdBefore) {
            this.createdBefore = Optional.of(createdBefore);
            return this;
        }

        @JsonSetter(value="credited_to_id", nulls=Nulls.SKIP)
        public Builder creditedToId(Optional<String> creditedToId) {
            this.creditedToId = creditedToId;
            return this;
        }

        public Builder creditedToId(String creditedToId) {
            this.creditedToId = Optional.of(creditedToId);
            return this;
        }

        @JsonSetter(value="current_stage_id", nulls=Nulls.SKIP)
        public Builder currentStageId(Optional<String> currentStageId) {
            this.currentStageId = currentStageId;
            return this;
        }

        public Builder currentStageId(String currentStageId) {
            this.currentStageId = Optional.of(currentStageId);
            return this;
        }

        @JsonSetter(value="cursor", nulls=Nulls.SKIP)
        public Builder cursor(Optional<String> cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = Optional.of(cursor);
            return this;
        }

        @JsonSetter(value="expand", nulls=Nulls.SKIP)
        public Builder expand(Optional<ApplicationsListRequestExpand> expand) {
            this.expand = expand;
            return this;
        }

        public Builder expand(ApplicationsListRequestExpand expand) {
            this.expand = Optional.of(expand);
            return this;
        }

        @JsonSetter(value="include_deleted_data", nulls=Nulls.SKIP)
        public Builder includeDeletedData(Optional<Boolean> includeDeletedData) {
            this.includeDeletedData = includeDeletedData;
            return this;
        }

        public Builder includeDeletedData(Boolean includeDeletedData) {
            this.includeDeletedData = Optional.of(includeDeletedData);
            return this;
        }

        @JsonSetter(value="include_remote_data", nulls=Nulls.SKIP)
        public Builder includeRemoteData(Optional<Boolean> includeRemoteData) {
            this.includeRemoteData = includeRemoteData;
            return this;
        }

        public Builder includeRemoteData(Boolean includeRemoteData) {
            this.includeRemoteData = Optional.of(includeRemoteData);
            return this;
        }

        @JsonSetter(value="include_shell_data", nulls=Nulls.SKIP)
        public Builder includeShellData(Optional<Boolean> includeShellData) {
            this.includeShellData = includeShellData;
            return this;
        }

        public Builder includeShellData(Boolean includeShellData) {
            this.includeShellData = Optional.of(includeShellData);
            return this;
        }

        @JsonSetter(value="job_id", nulls=Nulls.SKIP)
        public Builder jobId(Optional<String> jobId) {
            this.jobId = jobId;
            return this;
        }

        public Builder jobId(String jobId) {
            this.jobId = Optional.of(jobId);
            return this;
        }

        @JsonSetter(value="modified_after", nulls=Nulls.SKIP)
        public Builder modifiedAfter(Optional<OffsetDateTime> modifiedAfter) {
            this.modifiedAfter = modifiedAfter;
            return this;
        }

        public Builder modifiedAfter(OffsetDateTime modifiedAfter) {
            this.modifiedAfter = Optional.of(modifiedAfter);
            return this;
        }

        @JsonSetter(value="modified_before", nulls=Nulls.SKIP)
        public Builder modifiedBefore(Optional<OffsetDateTime> modifiedBefore) {
            this.modifiedBefore = modifiedBefore;
            return this;
        }

        public Builder modifiedBefore(OffsetDateTime modifiedBefore) {
            this.modifiedBefore = Optional.of(modifiedBefore);
            return this;
        }

        @JsonSetter(value="page_size", nulls=Nulls.SKIP)
        public Builder pageSize(Optional<Integer> pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public Builder pageSize(Integer pageSize) {
            this.pageSize = Optional.of(pageSize);
            return this;
        }

        @JsonSetter(value="reject_reason_id", nulls=Nulls.SKIP)
        public Builder rejectReasonId(Optional<String> rejectReasonId) {
            this.rejectReasonId = rejectReasonId;
            return this;
        }

        public Builder rejectReasonId(String rejectReasonId) {
            this.rejectReasonId = Optional.of(rejectReasonId);
            return this;
        }

        @JsonSetter(value="remote_id", nulls=Nulls.SKIP)
        public Builder remoteId(Optional<String> remoteId) {
            this.remoteId = remoteId;
            return this;
        }

        public Builder remoteId(String remoteId) {
            this.remoteId = Optional.of(remoteId);
            return this;
        }

        @JsonSetter(value="source", nulls=Nulls.SKIP)
        public Builder source(Optional<String> source) {
            this.source = source;
            return this;
        }

        public Builder source(String source) {
            this.source = Optional.of(source);
            return this;
        }

        public ApplicationsListRequest build() {
            return new ApplicationsListRequest(this.candidateId, this.createdAfter, this.createdBefore, this.creditedToId, this.currentStageId, this.cursor, this.expand, this.includeDeletedData, this.includeRemoteData, this.includeShellData, this.jobId, this.modifiedAfter, this.modifiedBefore, this.pageSize, this.rejectReasonId, this.remoteId, this.source, this.additionalProperties);
        }
    }
}

