/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.ats.candidates.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import com.merge.api.resources.ats.candidates.types.CandidatesRetrieveRequestExpand;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class CandidatesRetrieveRequest {
    private final Optional<CandidatesRetrieveRequestExpand> expand;
    private final Optional<Boolean> includeRemoteData;
    private final Map<String, Object> additionalProperties;

    private CandidatesRetrieveRequest(Optional<CandidatesRetrieveRequestExpand> expand, Optional<Boolean> includeRemoteData, Map<String, Object> additionalProperties) {
        this.expand = expand;
        this.includeRemoteData = includeRemoteData;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="expand")
    public Optional<CandidatesRetrieveRequestExpand> getExpand() {
        return this.expand;
    }

    @JsonProperty(value="include_remote_data")
    public Optional<Boolean> getIncludeRemoteData() {
        return this.includeRemoteData;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CandidatesRetrieveRequest && this.equalTo((CandidatesRetrieveRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CandidatesRetrieveRequest other) {
        return this.expand.equals(other.expand) && this.includeRemoteData.equals(other.includeRemoteData);
    }

    public int hashCode() {
        return Objects.hash(this.expand, this.includeRemoteData);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<CandidatesRetrieveRequestExpand> expand = Optional.empty();
        private Optional<Boolean> includeRemoteData = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CandidatesRetrieveRequest other) {
            this.expand(other.getExpand());
            this.includeRemoteData(other.getIncludeRemoteData());
            return this;
        }

        @JsonSetter(value="expand", nulls=Nulls.SKIP)
        public Builder expand(Optional<CandidatesRetrieveRequestExpand> expand) {
            this.expand = expand;
            return this;
        }

        public Builder expand(CandidatesRetrieveRequestExpand expand) {
            this.expand = Optional.of(expand);
            return this;
        }

        @JsonSetter(value="include_remote_data", nulls=Nulls.SKIP)
        public Builder includeRemoteData(Optional<Boolean> includeRemoteData) {
            this.includeRemoteData = includeRemoteData;
            return this;
        }

        public Builder includeRemoteData(Boolean includeRemoteData) {
            this.includeRemoteData = Optional.of(includeRemoteData);
            return this;
        }

        public CandidatesRetrieveRequest build() {
            return new CandidatesRetrieveRequest(this.expand, this.includeRemoteData, this.additionalProperties);
        }
    }
}

