/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.ats.fieldmapping.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class CreateFieldMappingRequest {
    private final String targetFieldName;
    private final String targetFieldDescription;
    private final List<JsonNode> remoteFieldTraversalPath;
    private final String remoteMethod;
    private final String remoteUrlPath;
    private final String commonModelName;
    private final Map<String, Object> additionalProperties;

    private CreateFieldMappingRequest(String targetFieldName, String targetFieldDescription, List<JsonNode> remoteFieldTraversalPath, String remoteMethod, String remoteUrlPath, String commonModelName, Map<String, Object> additionalProperties) {
        this.targetFieldName = targetFieldName;
        this.targetFieldDescription = targetFieldDescription;
        this.remoteFieldTraversalPath = remoteFieldTraversalPath;
        this.remoteMethod = remoteMethod;
        this.remoteUrlPath = remoteUrlPath;
        this.commonModelName = commonModelName;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="target_field_name")
    public String getTargetFieldName() {
        return this.targetFieldName;
    }

    @JsonProperty(value="target_field_description")
    public String getTargetFieldDescription() {
        return this.targetFieldDescription;
    }

    @JsonProperty(value="remote_field_traversal_path")
    public List<JsonNode> getRemoteFieldTraversalPath() {
        return this.remoteFieldTraversalPath;
    }

    @JsonProperty(value="remote_method")
    public String getRemoteMethod() {
        return this.remoteMethod;
    }

    @JsonProperty(value="remote_url_path")
    public String getRemoteUrlPath() {
        return this.remoteUrlPath;
    }

    @JsonProperty(value="common_model_name")
    public String getCommonModelName() {
        return this.commonModelName;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateFieldMappingRequest && this.equalTo((CreateFieldMappingRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateFieldMappingRequest other) {
        return this.targetFieldName.equals(other.targetFieldName) && this.targetFieldDescription.equals(other.targetFieldDescription) && this.remoteFieldTraversalPath.equals(other.remoteFieldTraversalPath) && this.remoteMethod.equals(other.remoteMethod) && this.remoteUrlPath.equals(other.remoteUrlPath) && this.commonModelName.equals(other.commonModelName);
    }

    public int hashCode() {
        return Objects.hash(this.targetFieldName, this.targetFieldDescription, this.remoteFieldTraversalPath, this.remoteMethod, this.remoteUrlPath, this.commonModelName);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TargetFieldNameStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TargetFieldNameStage,
    TargetFieldDescriptionStage,
    RemoteMethodStage,
    RemoteUrlPathStage,
    CommonModelNameStage,
    _FinalStage {
        private String targetFieldName;
        private String targetFieldDescription;
        private String remoteMethod;
        private String remoteUrlPath;
        private String commonModelName;
        private List<JsonNode> remoteFieldTraversalPath = new ArrayList<JsonNode>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CreateFieldMappingRequest other) {
            this.targetFieldName(other.getTargetFieldName());
            this.targetFieldDescription(other.getTargetFieldDescription());
            this.remoteFieldTraversalPath(other.getRemoteFieldTraversalPath());
            this.remoteMethod(other.getRemoteMethod());
            this.remoteUrlPath(other.getRemoteUrlPath());
            this.commonModelName(other.getCommonModelName());
            return this;
        }

        @Override
        @JsonSetter(value="target_field_name")
        public TargetFieldDescriptionStage targetFieldName(String targetFieldName) {
            this.targetFieldName = targetFieldName;
            return this;
        }

        @Override
        @JsonSetter(value="target_field_description")
        public RemoteMethodStage targetFieldDescription(String targetFieldDescription) {
            this.targetFieldDescription = targetFieldDescription;
            return this;
        }

        @Override
        @JsonSetter(value="remote_method")
        public RemoteUrlPathStage remoteMethod(String remoteMethod) {
            this.remoteMethod = remoteMethod;
            return this;
        }

        @Override
        @JsonSetter(value="remote_url_path")
        public CommonModelNameStage remoteUrlPath(String remoteUrlPath) {
            this.remoteUrlPath = remoteUrlPath;
            return this;
        }

        @Override
        @JsonSetter(value="common_model_name")
        public _FinalStage commonModelName(String commonModelName) {
            this.commonModelName = commonModelName;
            return this;
        }

        @Override
        public _FinalStage addAllRemoteFieldTraversalPath(List<JsonNode> remoteFieldTraversalPath) {
            this.remoteFieldTraversalPath.addAll(remoteFieldTraversalPath);
            return this;
        }

        @Override
        public _FinalStage addRemoteFieldTraversalPath(JsonNode remoteFieldTraversalPath) {
            this.remoteFieldTraversalPath.add(remoteFieldTraversalPath);
            return this;
        }

        @Override
        @JsonSetter(value="remote_field_traversal_path", nulls=Nulls.SKIP)
        public _FinalStage remoteFieldTraversalPath(List<JsonNode> remoteFieldTraversalPath) {
            this.remoteFieldTraversalPath.clear();
            this.remoteFieldTraversalPath.addAll(remoteFieldTraversalPath);
            return this;
        }

        @Override
        public CreateFieldMappingRequest build() {
            return new CreateFieldMappingRequest(this.targetFieldName, this.targetFieldDescription, this.remoteFieldTraversalPath, this.remoteMethod, this.remoteUrlPath, this.commonModelName, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CreateFieldMappingRequest build();

        public _FinalStage remoteFieldTraversalPath(List<JsonNode> var1);

        public _FinalStage addRemoteFieldTraversalPath(JsonNode var1);

        public _FinalStage addAllRemoteFieldTraversalPath(List<JsonNode> var1);
    }

    public static interface CommonModelNameStage {
        public _FinalStage commonModelName(String var1);
    }

    public static interface RemoteUrlPathStage {
        public CommonModelNameStage remoteUrlPath(String var1);
    }

    public static interface RemoteMethodStage {
        public RemoteUrlPathStage remoteMethod(String var1);
    }

    public static interface TargetFieldDescriptionStage {
        public RemoteMethodStage targetFieldDescription(String var1);
    }

    public static interface TargetFieldNameStage {
        public TargetFieldDescriptionStage targetFieldName(String var1);

        public Builder from(CreateFieldMappingRequest var1);
    }
}

