/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.ats.interviews.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import com.merge.api.resources.ats.interviews.types.InterviewsListRequestExpand;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class InterviewsListRequest {
    private final Optional<String> applicationId;
    private final Optional<OffsetDateTime> createdAfter;
    private final Optional<OffsetDateTime> createdBefore;
    private final Optional<String> cursor;
    private final Optional<InterviewsListRequestExpand> expand;
    private final Optional<Boolean> includeDeletedData;
    private final Optional<Boolean> includeRemoteData;
    private final Optional<Boolean> includeShellData;
    private final Optional<String> jobId;
    private final Optional<String> jobInterviewStageId;
    private final Optional<OffsetDateTime> modifiedAfter;
    private final Optional<OffsetDateTime> modifiedBefore;
    private final Optional<String> organizerId;
    private final Optional<Integer> pageSize;
    private final Optional<String> remoteFields;
    private final Optional<String> remoteId;
    private final Optional<String> showEnumOrigins;
    private final Map<String, Object> additionalProperties;

    private InterviewsListRequest(Optional<String> applicationId, Optional<OffsetDateTime> createdAfter, Optional<OffsetDateTime> createdBefore, Optional<String> cursor, Optional<InterviewsListRequestExpand> expand, Optional<Boolean> includeDeletedData, Optional<Boolean> includeRemoteData, Optional<Boolean> includeShellData, Optional<String> jobId, Optional<String> jobInterviewStageId, Optional<OffsetDateTime> modifiedAfter, Optional<OffsetDateTime> modifiedBefore, Optional<String> organizerId, Optional<Integer> pageSize, Optional<String> remoteFields, Optional<String> remoteId, Optional<String> showEnumOrigins, Map<String, Object> additionalProperties) {
        this.applicationId = applicationId;
        this.createdAfter = createdAfter;
        this.createdBefore = createdBefore;
        this.cursor = cursor;
        this.expand = expand;
        this.includeDeletedData = includeDeletedData;
        this.includeRemoteData = includeRemoteData;
        this.includeShellData = includeShellData;
        this.jobId = jobId;
        this.jobInterviewStageId = jobInterviewStageId;
        this.modifiedAfter = modifiedAfter;
        this.modifiedBefore = modifiedBefore;
        this.organizerId = organizerId;
        this.pageSize = pageSize;
        this.remoteFields = remoteFields;
        this.remoteId = remoteId;
        this.showEnumOrigins = showEnumOrigins;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="application_id")
    public Optional<String> getApplicationId() {
        return this.applicationId;
    }

    @JsonProperty(value="created_after")
    public Optional<OffsetDateTime> getCreatedAfter() {
        return this.createdAfter;
    }

    @JsonProperty(value="created_before")
    public Optional<OffsetDateTime> getCreatedBefore() {
        return this.createdBefore;
    }

    @JsonProperty(value="cursor")
    public Optional<String> getCursor() {
        return this.cursor;
    }

    @JsonProperty(value="expand")
    public Optional<InterviewsListRequestExpand> getExpand() {
        return this.expand;
    }

    @JsonProperty(value="include_deleted_data")
    public Optional<Boolean> getIncludeDeletedData() {
        return this.includeDeletedData;
    }

    @JsonProperty(value="include_remote_data")
    public Optional<Boolean> getIncludeRemoteData() {
        return this.includeRemoteData;
    }

    @JsonProperty(value="include_shell_data")
    public Optional<Boolean> getIncludeShellData() {
        return this.includeShellData;
    }

    @JsonProperty(value="job_id")
    public Optional<String> getJobId() {
        return this.jobId;
    }

    @JsonProperty(value="job_interview_stage_id")
    public Optional<String> getJobInterviewStageId() {
        return this.jobInterviewStageId;
    }

    @JsonProperty(value="modified_after")
    public Optional<OffsetDateTime> getModifiedAfter() {
        return this.modifiedAfter;
    }

    @JsonProperty(value="modified_before")
    public Optional<OffsetDateTime> getModifiedBefore() {
        return this.modifiedBefore;
    }

    @JsonProperty(value="organizer_id")
    public Optional<String> getOrganizerId() {
        return this.organizerId;
    }

    @JsonProperty(value="page_size")
    public Optional<Integer> getPageSize() {
        return this.pageSize;
    }

    @JsonProperty(value="remote_fields")
    public Optional<String> getRemoteFields() {
        return this.remoteFields;
    }

    @JsonProperty(value="remote_id")
    public Optional<String> getRemoteId() {
        return this.remoteId;
    }

    @JsonProperty(value="show_enum_origins")
    public Optional<String> getShowEnumOrigins() {
        return this.showEnumOrigins;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof InterviewsListRequest && this.equalTo((InterviewsListRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(InterviewsListRequest other) {
        return this.applicationId.equals(other.applicationId) && this.createdAfter.equals(other.createdAfter) && this.createdBefore.equals(other.createdBefore) && this.cursor.equals(other.cursor) && this.expand.equals(other.expand) && this.includeDeletedData.equals(other.includeDeletedData) && this.includeRemoteData.equals(other.includeRemoteData) && this.includeShellData.equals(other.includeShellData) && this.jobId.equals(other.jobId) && this.jobInterviewStageId.equals(other.jobInterviewStageId) && this.modifiedAfter.equals(other.modifiedAfter) && this.modifiedBefore.equals(other.modifiedBefore) && this.organizerId.equals(other.organizerId) && this.pageSize.equals(other.pageSize) && this.remoteFields.equals(other.remoteFields) && this.remoteId.equals(other.remoteId) && this.showEnumOrigins.equals(other.showEnumOrigins);
    }

    public int hashCode() {
        return Objects.hash(this.applicationId, this.createdAfter, this.createdBefore, this.cursor, this.expand, this.includeDeletedData, this.includeRemoteData, this.includeShellData, this.jobId, this.jobInterviewStageId, this.modifiedAfter, this.modifiedBefore, this.organizerId, this.pageSize, this.remoteFields, this.remoteId, this.showEnumOrigins);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> applicationId = Optional.empty();
        private Optional<OffsetDateTime> createdAfter = Optional.empty();
        private Optional<OffsetDateTime> createdBefore = Optional.empty();
        private Optional<String> cursor = Optional.empty();
        private Optional<InterviewsListRequestExpand> expand = Optional.empty();
        private Optional<Boolean> includeDeletedData = Optional.empty();
        private Optional<Boolean> includeRemoteData = Optional.empty();
        private Optional<Boolean> includeShellData = Optional.empty();
        private Optional<String> jobId = Optional.empty();
        private Optional<String> jobInterviewStageId = Optional.empty();
        private Optional<OffsetDateTime> modifiedAfter = Optional.empty();
        private Optional<OffsetDateTime> modifiedBefore = Optional.empty();
        private Optional<String> organizerId = Optional.empty();
        private Optional<Integer> pageSize = Optional.empty();
        private Optional<String> remoteFields = Optional.empty();
        private Optional<String> remoteId = Optional.empty();
        private Optional<String> showEnumOrigins = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(InterviewsListRequest other) {
            this.applicationId(other.getApplicationId());
            this.createdAfter(other.getCreatedAfter());
            this.createdBefore(other.getCreatedBefore());
            this.cursor(other.getCursor());
            this.expand(other.getExpand());
            this.includeDeletedData(other.getIncludeDeletedData());
            this.includeRemoteData(other.getIncludeRemoteData());
            this.includeShellData(other.getIncludeShellData());
            this.jobId(other.getJobId());
            this.jobInterviewStageId(other.getJobInterviewStageId());
            this.modifiedAfter(other.getModifiedAfter());
            this.modifiedBefore(other.getModifiedBefore());
            this.organizerId(other.getOrganizerId());
            this.pageSize(other.getPageSize());
            this.remoteFields(other.getRemoteFields());
            this.remoteId(other.getRemoteId());
            this.showEnumOrigins(other.getShowEnumOrigins());
            return this;
        }

        @JsonSetter(value="application_id", nulls=Nulls.SKIP)
        public Builder applicationId(Optional<String> applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public Builder applicationId(String applicationId) {
            this.applicationId = Optional.of(applicationId);
            return this;
        }

        @JsonSetter(value="created_after", nulls=Nulls.SKIP)
        public Builder createdAfter(Optional<OffsetDateTime> createdAfter) {
            this.createdAfter = createdAfter;
            return this;
        }

        public Builder createdAfter(OffsetDateTime createdAfter) {
            this.createdAfter = Optional.of(createdAfter);
            return this;
        }

        @JsonSetter(value="created_before", nulls=Nulls.SKIP)
        public Builder createdBefore(Optional<OffsetDateTime> createdBefore) {
            this.createdBefore = createdBefore;
            return this;
        }

        public Builder createdBefore(OffsetDateTime createdBefore) {
            this.createdBefore = Optional.of(createdBefore);
            return this;
        }

        @JsonSetter(value="cursor", nulls=Nulls.SKIP)
        public Builder cursor(Optional<String> cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = Optional.of(cursor);
            return this;
        }

        @JsonSetter(value="expand", nulls=Nulls.SKIP)
        public Builder expand(Optional<InterviewsListRequestExpand> expand) {
            this.expand = expand;
            return this;
        }

        public Builder expand(InterviewsListRequestExpand expand) {
            this.expand = Optional.of(expand);
            return this;
        }

        @JsonSetter(value="include_deleted_data", nulls=Nulls.SKIP)
        public Builder includeDeletedData(Optional<Boolean> includeDeletedData) {
            this.includeDeletedData = includeDeletedData;
            return this;
        }

        public Builder includeDeletedData(Boolean includeDeletedData) {
            this.includeDeletedData = Optional.of(includeDeletedData);
            return this;
        }

        @JsonSetter(value="include_remote_data", nulls=Nulls.SKIP)
        public Builder includeRemoteData(Optional<Boolean> includeRemoteData) {
            this.includeRemoteData = includeRemoteData;
            return this;
        }

        public Builder includeRemoteData(Boolean includeRemoteData) {
            this.includeRemoteData = Optional.of(includeRemoteData);
            return this;
        }

        @JsonSetter(value="include_shell_data", nulls=Nulls.SKIP)
        public Builder includeShellData(Optional<Boolean> includeShellData) {
            this.includeShellData = includeShellData;
            return this;
        }

        public Builder includeShellData(Boolean includeShellData) {
            this.includeShellData = Optional.of(includeShellData);
            return this;
        }

        @JsonSetter(value="job_id", nulls=Nulls.SKIP)
        public Builder jobId(Optional<String> jobId) {
            this.jobId = jobId;
            return this;
        }

        public Builder jobId(String jobId) {
            this.jobId = Optional.of(jobId);
            return this;
        }

        @JsonSetter(value="job_interview_stage_id", nulls=Nulls.SKIP)
        public Builder jobInterviewStageId(Optional<String> jobInterviewStageId) {
            this.jobInterviewStageId = jobInterviewStageId;
            return this;
        }

        public Builder jobInterviewStageId(String jobInterviewStageId) {
            this.jobInterviewStageId = Optional.of(jobInterviewStageId);
            return this;
        }

        @JsonSetter(value="modified_after", nulls=Nulls.SKIP)
        public Builder modifiedAfter(Optional<OffsetDateTime> modifiedAfter) {
            this.modifiedAfter = modifiedAfter;
            return this;
        }

        public Builder modifiedAfter(OffsetDateTime modifiedAfter) {
            this.modifiedAfter = Optional.of(modifiedAfter);
            return this;
        }

        @JsonSetter(value="modified_before", nulls=Nulls.SKIP)
        public Builder modifiedBefore(Optional<OffsetDateTime> modifiedBefore) {
            this.modifiedBefore = modifiedBefore;
            return this;
        }

        public Builder modifiedBefore(OffsetDateTime modifiedBefore) {
            this.modifiedBefore = Optional.of(modifiedBefore);
            return this;
        }

        @JsonSetter(value="organizer_id", nulls=Nulls.SKIP)
        public Builder organizerId(Optional<String> organizerId) {
            this.organizerId = organizerId;
            return this;
        }

        public Builder organizerId(String organizerId) {
            this.organizerId = Optional.of(organizerId);
            return this;
        }

        @JsonSetter(value="page_size", nulls=Nulls.SKIP)
        public Builder pageSize(Optional<Integer> pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public Builder pageSize(Integer pageSize) {
            this.pageSize = Optional.of(pageSize);
            return this;
        }

        @JsonSetter(value="remote_fields", nulls=Nulls.SKIP)
        public Builder remoteFields(Optional<String> remoteFields) {
            this.remoteFields = remoteFields;
            return this;
        }

        public Builder remoteFields(String remoteFields) {
            this.remoteFields = Optional.of(remoteFields);
            return this;
        }

        @JsonSetter(value="remote_id", nulls=Nulls.SKIP)
        public Builder remoteId(Optional<String> remoteId) {
            this.remoteId = remoteId;
            return this;
        }

        public Builder remoteId(String remoteId) {
            this.remoteId = Optional.of(remoteId);
            return this;
        }

        @JsonSetter(value="show_enum_origins", nulls=Nulls.SKIP)
        public Builder showEnumOrigins(Optional<String> showEnumOrigins) {
            this.showEnumOrigins = showEnumOrigins;
            return this;
        }

        public Builder showEnumOrigins(String showEnumOrigins) {
            this.showEnumOrigins = Optional.of(showEnumOrigins);
            return this;
        }

        public InterviewsListRequest build() {
            return new InterviewsListRequest(this.applicationId, this.createdAfter, this.createdBefore, this.cursor, this.expand, this.includeDeletedData, this.includeRemoteData, this.includeShellData, this.jobId, this.jobInterviewStageId, this.modifiedAfter, this.modifiedBefore, this.organizerId, this.pageSize, this.remoteFields, this.remoteId, this.showEnumOrigins, this.additionalProperties);
        }
    }
}

