/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.ats.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import com.merge.api.resources.ats.types.CategoriesEnum;
import com.merge.api.resources.ats.types.ModelOperation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class AccountDetailsAndActionsIntegration {
    private final String name;
    private final List<CategoriesEnum> categories;
    private final Optional<String> image;
    private final Optional<String> squareImage;
    private final String color;
    private final String slug;
    private final boolean passthroughAvailable;
    private final Optional<List<ModelOperation>> availableModelOperations;
    private final Map<String, Object> additionalProperties;

    private AccountDetailsAndActionsIntegration(String name, List<CategoriesEnum> categories, Optional<String> image, Optional<String> squareImage, String color, String slug, boolean passthroughAvailable, Optional<List<ModelOperation>> availableModelOperations, Map<String, Object> additionalProperties) {
        this.name = name;
        this.categories = categories;
        this.image = image;
        this.squareImage = squareImage;
        this.color = color;
        this.slug = slug;
        this.passthroughAvailable = passthroughAvailable;
        this.availableModelOperations = availableModelOperations;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="categories")
    public List<CategoriesEnum> getCategories() {
        return this.categories;
    }

    @JsonProperty(value="image")
    public Optional<String> getImage() {
        return this.image;
    }

    @JsonProperty(value="square_image")
    public Optional<String> getSquareImage() {
        return this.squareImage;
    }

    @JsonProperty(value="color")
    public String getColor() {
        return this.color;
    }

    @JsonProperty(value="slug")
    public String getSlug() {
        return this.slug;
    }

    @JsonProperty(value="passthrough_available")
    public boolean getPassthroughAvailable() {
        return this.passthroughAvailable;
    }

    @JsonProperty(value="available_model_operations")
    public Optional<List<ModelOperation>> getAvailableModelOperations() {
        return this.availableModelOperations;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof AccountDetailsAndActionsIntegration && this.equalTo((AccountDetailsAndActionsIntegration)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(AccountDetailsAndActionsIntegration other) {
        return this.name.equals(other.name) && this.categories.equals(other.categories) && this.image.equals(other.image) && this.squareImage.equals(other.squareImage) && this.color.equals(other.color) && this.slug.equals(other.slug) && this.passthroughAvailable == other.passthroughAvailable && this.availableModelOperations.equals(other.availableModelOperations);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.categories, this.image, this.squareImage, this.color, this.slug, this.passthroughAvailable, this.availableModelOperations);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static NameStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements NameStage,
    ColorStage,
    SlugStage,
    PassthroughAvailableStage,
    _FinalStage {
        private String name;
        private String color;
        private String slug;
        private boolean passthroughAvailable;
        private Optional<List<ModelOperation>> availableModelOperations = Optional.empty();
        private Optional<String> squareImage = Optional.empty();
        private Optional<String> image = Optional.empty();
        private List<CategoriesEnum> categories = new ArrayList<CategoriesEnum>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(AccountDetailsAndActionsIntegration other) {
            this.name(other.getName());
            this.categories(other.getCategories());
            this.image(other.getImage());
            this.squareImage(other.getSquareImage());
            this.color(other.getColor());
            this.slug(other.getSlug());
            this.passthroughAvailable(other.getPassthroughAvailable());
            this.availableModelOperations(other.getAvailableModelOperations());
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public ColorStage name(String name) {
            this.name = name;
            return this;
        }

        @Override
        @JsonSetter(value="color")
        public SlugStage color(String color) {
            this.color = color;
            return this;
        }

        @Override
        @JsonSetter(value="slug")
        public PassthroughAvailableStage slug(String slug) {
            this.slug = slug;
            return this;
        }

        @Override
        @JsonSetter(value="passthrough_available")
        public _FinalStage passthroughAvailable(boolean passthroughAvailable) {
            this.passthroughAvailable = passthroughAvailable;
            return this;
        }

        @Override
        public _FinalStage availableModelOperations(List<ModelOperation> availableModelOperations) {
            this.availableModelOperations = Optional.of(availableModelOperations);
            return this;
        }

        @Override
        @JsonSetter(value="available_model_operations", nulls=Nulls.SKIP)
        public _FinalStage availableModelOperations(Optional<List<ModelOperation>> availableModelOperations) {
            this.availableModelOperations = availableModelOperations;
            return this;
        }

        @Override
        public _FinalStage squareImage(String squareImage) {
            this.squareImage = Optional.of(squareImage);
            return this;
        }

        @Override
        @JsonSetter(value="square_image", nulls=Nulls.SKIP)
        public _FinalStage squareImage(Optional<String> squareImage) {
            this.squareImage = squareImage;
            return this;
        }

        @Override
        public _FinalStage image(String image) {
            this.image = Optional.of(image);
            return this;
        }

        @Override
        @JsonSetter(value="image", nulls=Nulls.SKIP)
        public _FinalStage image(Optional<String> image) {
            this.image = image;
            return this;
        }

        @Override
        public _FinalStage addAllCategories(List<CategoriesEnum> categories) {
            this.categories.addAll(categories);
            return this;
        }

        @Override
        public _FinalStage addCategories(CategoriesEnum categories) {
            this.categories.add(categories);
            return this;
        }

        @Override
        @JsonSetter(value="categories", nulls=Nulls.SKIP)
        public _FinalStage categories(List<CategoriesEnum> categories) {
            this.categories.clear();
            this.categories.addAll(categories);
            return this;
        }

        @Override
        public AccountDetailsAndActionsIntegration build() {
            return new AccountDetailsAndActionsIntegration(this.name, this.categories, this.image, this.squareImage, this.color, this.slug, this.passthroughAvailable, this.availableModelOperations, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public AccountDetailsAndActionsIntegration build();

        public _FinalStage categories(List<CategoriesEnum> var1);

        public _FinalStage addCategories(CategoriesEnum var1);

        public _FinalStage addAllCategories(List<CategoriesEnum> var1);

        public _FinalStage image(Optional<String> var1);

        public _FinalStage image(String var1);

        public _FinalStage squareImage(Optional<String> var1);

        public _FinalStage squareImage(String var1);

        public _FinalStage availableModelOperations(Optional<List<ModelOperation>> var1);

        public _FinalStage availableModelOperations(List<ModelOperation> var1);
    }

    public static interface PassthroughAvailableStage {
        public _FinalStage passthroughAvailable(boolean var1);
    }

    public static interface SlugStage {
        public PassthroughAvailableStage slug(String var1);
    }

    public static interface ColorStage {
        public SlugStage color(String var1);
    }

    public static interface NameStage {
        public ColorStage name(String var1);

        public Builder from(AccountDetailsAndActionsIntegration var1);
    }
}

