/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.ats.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import com.merge.api.resources.ats.types.AccountIntegration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class AccountToken {
    private final String accountToken;
    private final AccountIntegration integration;
    private final Map<String, Object> additionalProperties;

    private AccountToken(String accountToken, AccountIntegration integration, Map<String, Object> additionalProperties) {
        this.accountToken = accountToken;
        this.integration = integration;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="account_token")
    public String getAccountToken() {
        return this.accountToken;
    }

    @JsonProperty(value="integration")
    public AccountIntegration getIntegration() {
        return this.integration;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof AccountToken && this.equalTo((AccountToken)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(AccountToken other) {
        return this.accountToken.equals(other.accountToken) && this.integration.equals(other.integration);
    }

    public int hashCode() {
        return Objects.hash(this.accountToken, this.integration);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static AccountTokenStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements AccountTokenStage,
    IntegrationStage,
    _FinalStage {
        private String accountToken;
        private AccountIntegration integration;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(AccountToken other) {
            this.accountToken(other.getAccountToken());
            this.integration(other.getIntegration());
            return this;
        }

        @Override
        @JsonSetter(value="account_token")
        public IntegrationStage accountToken(String accountToken) {
            this.accountToken = accountToken;
            return this;
        }

        @Override
        @JsonSetter(value="integration")
        public _FinalStage integration(AccountIntegration integration) {
            this.integration = integration;
            return this;
        }

        @Override
        public AccountToken build() {
            return new AccountToken(this.accountToken, this.integration, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public AccountToken build();
    }

    public static interface IntegrationStage {
        public _FinalStage integration(AccountIntegration var1);
    }

    public static interface AccountTokenStage {
        public IntegrationStage accountToken(String var1);

        public Builder from(AccountToken var1);
    }
}

