/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.ats.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import com.merge.api.resources.ats.types.ActivityActivityType;
import com.merge.api.resources.ats.types.ActivityUser;
import com.merge.api.resources.ats.types.ActivityVisibility;
import com.merge.api.resources.ats.types.RemoteData;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class Activity {
    private final Optional<String> id;
    private final Optional<String> remoteId;
    private final Optional<OffsetDateTime> createdAt;
    private final Optional<OffsetDateTime> modifiedAt;
    private final Optional<ActivityUser> user;
    private final Optional<OffsetDateTime> remoteCreatedAt;
    private final Optional<ActivityActivityType> activityType;
    private final Optional<String> subject;
    private final Optional<String> body;
    private final Optional<ActivityVisibility> visibility;
    private final Optional<String> candidate;
    private final Optional<Boolean> remoteWasDeleted;
    private final Optional<Map<String, JsonNode>> fieldMappings;
    private final Optional<List<RemoteData>> remoteData;
    private final Map<String, Object> additionalProperties;

    private Activity(Optional<String> id, Optional<String> remoteId, Optional<OffsetDateTime> createdAt, Optional<OffsetDateTime> modifiedAt, Optional<ActivityUser> user, Optional<OffsetDateTime> remoteCreatedAt, Optional<ActivityActivityType> activityType, Optional<String> subject, Optional<String> body, Optional<ActivityVisibility> visibility, Optional<String> candidate, Optional<Boolean> remoteWasDeleted, Optional<Map<String, JsonNode>> fieldMappings, Optional<List<RemoteData>> remoteData, Map<String, Object> additionalProperties) {
        this.id = id;
        this.remoteId = remoteId;
        this.createdAt = createdAt;
        this.modifiedAt = modifiedAt;
        this.user = user;
        this.remoteCreatedAt = remoteCreatedAt;
        this.activityType = activityType;
        this.subject = subject;
        this.body = body;
        this.visibility = visibility;
        this.candidate = candidate;
        this.remoteWasDeleted = remoteWasDeleted;
        this.fieldMappings = fieldMappings;
        this.remoteData = remoteData;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="remote_id")
    public Optional<String> getRemoteId() {
        return this.remoteId;
    }

    @JsonProperty(value="created_at")
    public Optional<OffsetDateTime> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="modified_at")
    public Optional<OffsetDateTime> getModifiedAt() {
        return this.modifiedAt;
    }

    @JsonProperty(value="user")
    public Optional<ActivityUser> getUser() {
        return this.user;
    }

    @JsonProperty(value="remote_created_at")
    public Optional<OffsetDateTime> getRemoteCreatedAt() {
        return this.remoteCreatedAt;
    }

    @JsonProperty(value="activity_type")
    public Optional<ActivityActivityType> getActivityType() {
        return this.activityType;
    }

    @JsonProperty(value="subject")
    public Optional<String> getSubject() {
        return this.subject;
    }

    @JsonProperty(value="body")
    public Optional<String> getBody() {
        return this.body;
    }

    @JsonProperty(value="visibility")
    public Optional<ActivityVisibility> getVisibility() {
        return this.visibility;
    }

    @JsonProperty(value="candidate")
    public Optional<String> getCandidate() {
        return this.candidate;
    }

    @JsonProperty(value="remote_was_deleted")
    public Optional<Boolean> getRemoteWasDeleted() {
        return this.remoteWasDeleted;
    }

    @JsonProperty(value="field_mappings")
    public Optional<Map<String, JsonNode>> getFieldMappings() {
        return this.fieldMappings;
    }

    @JsonProperty(value="remote_data")
    public Optional<List<RemoteData>> getRemoteData() {
        return this.remoteData;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Activity && this.equalTo((Activity)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Activity other) {
        return this.id.equals(other.id) && this.remoteId.equals(other.remoteId) && this.createdAt.equals(other.createdAt) && this.modifiedAt.equals(other.modifiedAt) && this.user.equals(other.user) && this.remoteCreatedAt.equals(other.remoteCreatedAt) && this.activityType.equals(other.activityType) && this.subject.equals(other.subject) && this.body.equals(other.body) && this.visibility.equals(other.visibility) && this.candidate.equals(other.candidate) && this.remoteWasDeleted.equals(other.remoteWasDeleted) && this.fieldMappings.equals(other.fieldMappings) && this.remoteData.equals(other.remoteData);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.remoteId, this.createdAt, this.modifiedAt, this.user, this.remoteCreatedAt, this.activityType, this.subject, this.body, this.visibility, this.candidate, this.remoteWasDeleted, this.fieldMappings, this.remoteData);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> id = Optional.empty();
        private Optional<String> remoteId = Optional.empty();
        private Optional<OffsetDateTime> createdAt = Optional.empty();
        private Optional<OffsetDateTime> modifiedAt = Optional.empty();
        private Optional<ActivityUser> user = Optional.empty();
        private Optional<OffsetDateTime> remoteCreatedAt = Optional.empty();
        private Optional<ActivityActivityType> activityType = Optional.empty();
        private Optional<String> subject = Optional.empty();
        private Optional<String> body = Optional.empty();
        private Optional<ActivityVisibility> visibility = Optional.empty();
        private Optional<String> candidate = Optional.empty();
        private Optional<Boolean> remoteWasDeleted = Optional.empty();
        private Optional<Map<String, JsonNode>> fieldMappings = Optional.empty();
        private Optional<List<RemoteData>> remoteData = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(Activity other) {
            this.id(other.getId());
            this.remoteId(other.getRemoteId());
            this.createdAt(other.getCreatedAt());
            this.modifiedAt(other.getModifiedAt());
            this.user(other.getUser());
            this.remoteCreatedAt(other.getRemoteCreatedAt());
            this.activityType(other.getActivityType());
            this.subject(other.getSubject());
            this.body(other.getBody());
            this.visibility(other.getVisibility());
            this.candidate(other.getCandidate());
            this.remoteWasDeleted(other.getRemoteWasDeleted());
            this.fieldMappings(other.getFieldMappings());
            this.remoteData(other.getRemoteData());
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.of(id);
            return this;
        }

        @JsonSetter(value="remote_id", nulls=Nulls.SKIP)
        public Builder remoteId(Optional<String> remoteId) {
            this.remoteId = remoteId;
            return this;
        }

        public Builder remoteId(String remoteId) {
            this.remoteId = Optional.of(remoteId);
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<OffsetDateTime> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(OffsetDateTime createdAt) {
            this.createdAt = Optional.of(createdAt);
            return this;
        }

        @JsonSetter(value="modified_at", nulls=Nulls.SKIP)
        public Builder modifiedAt(Optional<OffsetDateTime> modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public Builder modifiedAt(OffsetDateTime modifiedAt) {
            this.modifiedAt = Optional.of(modifiedAt);
            return this;
        }

        @JsonSetter(value="user", nulls=Nulls.SKIP)
        public Builder user(Optional<ActivityUser> user) {
            this.user = user;
            return this;
        }

        public Builder user(ActivityUser user) {
            this.user = Optional.of(user);
            return this;
        }

        @JsonSetter(value="remote_created_at", nulls=Nulls.SKIP)
        public Builder remoteCreatedAt(Optional<OffsetDateTime> remoteCreatedAt) {
            this.remoteCreatedAt = remoteCreatedAt;
            return this;
        }

        public Builder remoteCreatedAt(OffsetDateTime remoteCreatedAt) {
            this.remoteCreatedAt = Optional.of(remoteCreatedAt);
            return this;
        }

        @JsonSetter(value="activity_type", nulls=Nulls.SKIP)
        public Builder activityType(Optional<ActivityActivityType> activityType) {
            this.activityType = activityType;
            return this;
        }

        public Builder activityType(ActivityActivityType activityType) {
            this.activityType = Optional.of(activityType);
            return this;
        }

        @JsonSetter(value="subject", nulls=Nulls.SKIP)
        public Builder subject(Optional<String> subject) {
            this.subject = subject;
            return this;
        }

        public Builder subject(String subject) {
            this.subject = Optional.of(subject);
            return this;
        }

        @JsonSetter(value="body", nulls=Nulls.SKIP)
        public Builder body(Optional<String> body) {
            this.body = body;
            return this;
        }

        public Builder body(String body) {
            this.body = Optional.of(body);
            return this;
        }

        @JsonSetter(value="visibility", nulls=Nulls.SKIP)
        public Builder visibility(Optional<ActivityVisibility> visibility) {
            this.visibility = visibility;
            return this;
        }

        public Builder visibility(ActivityVisibility visibility) {
            this.visibility = Optional.of(visibility);
            return this;
        }

        @JsonSetter(value="candidate", nulls=Nulls.SKIP)
        public Builder candidate(Optional<String> candidate) {
            this.candidate = candidate;
            return this;
        }

        public Builder candidate(String candidate) {
            this.candidate = Optional.of(candidate);
            return this;
        }

        @JsonSetter(value="remote_was_deleted", nulls=Nulls.SKIP)
        public Builder remoteWasDeleted(Optional<Boolean> remoteWasDeleted) {
            this.remoteWasDeleted = remoteWasDeleted;
            return this;
        }

        public Builder remoteWasDeleted(Boolean remoteWasDeleted) {
            this.remoteWasDeleted = Optional.of(remoteWasDeleted);
            return this;
        }

        @JsonSetter(value="field_mappings", nulls=Nulls.SKIP)
        public Builder fieldMappings(Optional<Map<String, JsonNode>> fieldMappings) {
            this.fieldMappings = fieldMappings;
            return this;
        }

        public Builder fieldMappings(Map<String, JsonNode> fieldMappings) {
            this.fieldMappings = Optional.of(fieldMappings);
            return this;
        }

        @JsonSetter(value="remote_data", nulls=Nulls.SKIP)
        public Builder remoteData(Optional<List<RemoteData>> remoteData) {
            this.remoteData = remoteData;
            return this;
        }

        public Builder remoteData(List<RemoteData> remoteData) {
            this.remoteData = Optional.of(remoteData);
            return this;
        }

        public Activity build() {
            return new Activity(this.id, this.remoteId, this.createdAt, this.modifiedAt, this.user, this.remoteCreatedAt, this.activityType, this.subject, this.body, this.visibility, this.candidate, this.remoteWasDeleted, this.fieldMappings, this.remoteData, this.additionalProperties);
        }
    }
}

