/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.ats.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import com.merge.api.resources.ats.types.ActivityRequestActivityType;
import com.merge.api.resources.ats.types.ActivityRequestUser;
import com.merge.api.resources.ats.types.ActivityRequestVisibility;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class ActivityRequest {
    private final Optional<ActivityRequestUser> user;
    private final Optional<ActivityRequestActivityType> activityType;
    private final Optional<String> subject;
    private final Optional<String> body;
    private final Optional<ActivityRequestVisibility> visibility;
    private final Optional<String> candidate;
    private final Optional<Map<String, JsonNode>> integrationParams;
    private final Optional<Map<String, JsonNode>> linkedAccountParams;
    private final Map<String, Object> additionalProperties;

    private ActivityRequest(Optional<ActivityRequestUser> user, Optional<ActivityRequestActivityType> activityType, Optional<String> subject, Optional<String> body, Optional<ActivityRequestVisibility> visibility, Optional<String> candidate, Optional<Map<String, JsonNode>> integrationParams, Optional<Map<String, JsonNode>> linkedAccountParams, Map<String, Object> additionalProperties) {
        this.user = user;
        this.activityType = activityType;
        this.subject = subject;
        this.body = body;
        this.visibility = visibility;
        this.candidate = candidate;
        this.integrationParams = integrationParams;
        this.linkedAccountParams = linkedAccountParams;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="user")
    public Optional<ActivityRequestUser> getUser() {
        return this.user;
    }

    @JsonProperty(value="activity_type")
    public Optional<ActivityRequestActivityType> getActivityType() {
        return this.activityType;
    }

    @JsonProperty(value="subject")
    public Optional<String> getSubject() {
        return this.subject;
    }

    @JsonProperty(value="body")
    public Optional<String> getBody() {
        return this.body;
    }

    @JsonProperty(value="visibility")
    public Optional<ActivityRequestVisibility> getVisibility() {
        return this.visibility;
    }

    @JsonProperty(value="candidate")
    public Optional<String> getCandidate() {
        return this.candidate;
    }

    @JsonProperty(value="integration_params")
    public Optional<Map<String, JsonNode>> getIntegrationParams() {
        return this.integrationParams;
    }

    @JsonProperty(value="linked_account_params")
    public Optional<Map<String, JsonNode>> getLinkedAccountParams() {
        return this.linkedAccountParams;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ActivityRequest && this.equalTo((ActivityRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ActivityRequest other) {
        return this.user.equals(other.user) && this.activityType.equals(other.activityType) && this.subject.equals(other.subject) && this.body.equals(other.body) && this.visibility.equals(other.visibility) && this.candidate.equals(other.candidate) && this.integrationParams.equals(other.integrationParams) && this.linkedAccountParams.equals(other.linkedAccountParams);
    }

    public int hashCode() {
        return Objects.hash(this.user, this.activityType, this.subject, this.body, this.visibility, this.candidate, this.integrationParams, this.linkedAccountParams);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<ActivityRequestUser> user = Optional.empty();
        private Optional<ActivityRequestActivityType> activityType = Optional.empty();
        private Optional<String> subject = Optional.empty();
        private Optional<String> body = Optional.empty();
        private Optional<ActivityRequestVisibility> visibility = Optional.empty();
        private Optional<String> candidate = Optional.empty();
        private Optional<Map<String, JsonNode>> integrationParams = Optional.empty();
        private Optional<Map<String, JsonNode>> linkedAccountParams = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ActivityRequest other) {
            this.user(other.getUser());
            this.activityType(other.getActivityType());
            this.subject(other.getSubject());
            this.body(other.getBody());
            this.visibility(other.getVisibility());
            this.candidate(other.getCandidate());
            this.integrationParams(other.getIntegrationParams());
            this.linkedAccountParams(other.getLinkedAccountParams());
            return this;
        }

        @JsonSetter(value="user", nulls=Nulls.SKIP)
        public Builder user(Optional<ActivityRequestUser> user) {
            this.user = user;
            return this;
        }

        public Builder user(ActivityRequestUser user) {
            this.user = Optional.of(user);
            return this;
        }

        @JsonSetter(value="activity_type", nulls=Nulls.SKIP)
        public Builder activityType(Optional<ActivityRequestActivityType> activityType) {
            this.activityType = activityType;
            return this;
        }

        public Builder activityType(ActivityRequestActivityType activityType) {
            this.activityType = Optional.of(activityType);
            return this;
        }

        @JsonSetter(value="subject", nulls=Nulls.SKIP)
        public Builder subject(Optional<String> subject) {
            this.subject = subject;
            return this;
        }

        public Builder subject(String subject) {
            this.subject = Optional.of(subject);
            return this;
        }

        @JsonSetter(value="body", nulls=Nulls.SKIP)
        public Builder body(Optional<String> body) {
            this.body = body;
            return this;
        }

        public Builder body(String body) {
            this.body = Optional.of(body);
            return this;
        }

        @JsonSetter(value="visibility", nulls=Nulls.SKIP)
        public Builder visibility(Optional<ActivityRequestVisibility> visibility) {
            this.visibility = visibility;
            return this;
        }

        public Builder visibility(ActivityRequestVisibility visibility) {
            this.visibility = Optional.of(visibility);
            return this;
        }

        @JsonSetter(value="candidate", nulls=Nulls.SKIP)
        public Builder candidate(Optional<String> candidate) {
            this.candidate = candidate;
            return this;
        }

        public Builder candidate(String candidate) {
            this.candidate = Optional.of(candidate);
            return this;
        }

        @JsonSetter(value="integration_params", nulls=Nulls.SKIP)
        public Builder integrationParams(Optional<Map<String, JsonNode>> integrationParams) {
            this.integrationParams = integrationParams;
            return this;
        }

        public Builder integrationParams(Map<String, JsonNode> integrationParams) {
            this.integrationParams = Optional.of(integrationParams);
            return this;
        }

        @JsonSetter(value="linked_account_params", nulls=Nulls.SKIP)
        public Builder linkedAccountParams(Optional<Map<String, JsonNode>> linkedAccountParams) {
            this.linkedAccountParams = linkedAccountParams;
            return this;
        }

        public Builder linkedAccountParams(Map<String, JsonNode> linkedAccountParams) {
            this.linkedAccountParams = Optional.of(linkedAccountParams);
            return this;
        }

        public ActivityRequest build() {
            return new ActivityRequest(this.user, this.activityType, this.subject, this.body, this.visibility, this.candidate, this.integrationParams, this.linkedAccountParams, this.additionalProperties);
        }
    }
}

