/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.ats.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import com.merge.api.resources.ats.types.ApplicationRequestCandidate;
import com.merge.api.resources.ats.types.ApplicationRequestCreditedTo;
import com.merge.api.resources.ats.types.ApplicationRequestCurrentStage;
import com.merge.api.resources.ats.types.ApplicationRequestJob;
import com.merge.api.resources.ats.types.ApplicationRequestOffersItem;
import com.merge.api.resources.ats.types.ApplicationRequestRejectReason;
import com.merge.api.resources.ats.types.ApplicationRequestScreeningQuestionAnswersItem;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class ApplicationRequest {
    private final Optional<ApplicationRequestCandidate> candidate;
    private final Optional<ApplicationRequestJob> job;
    private final Optional<OffsetDateTime> appliedAt;
    private final Optional<OffsetDateTime> rejectedAt;
    private final Optional<List<Optional<ApplicationRequestOffersItem>>> offers;
    private final Optional<String> source;
    private final Optional<ApplicationRequestCreditedTo> creditedTo;
    private final Optional<List<ApplicationRequestScreeningQuestionAnswersItem>> screeningQuestionAnswers;
    private final Optional<ApplicationRequestCurrentStage> currentStage;
    private final Optional<ApplicationRequestRejectReason> rejectReason;
    private final Optional<String> remoteTemplateId;
    private final Optional<Map<String, JsonNode>> integrationParams;
    private final Optional<Map<String, JsonNode>> linkedAccountParams;
    private final Map<String, Object> additionalProperties;

    private ApplicationRequest(Optional<ApplicationRequestCandidate> candidate, Optional<ApplicationRequestJob> job, Optional<OffsetDateTime> appliedAt, Optional<OffsetDateTime> rejectedAt, Optional<List<Optional<ApplicationRequestOffersItem>>> offers, Optional<String> source, Optional<ApplicationRequestCreditedTo> creditedTo, Optional<List<ApplicationRequestScreeningQuestionAnswersItem>> screeningQuestionAnswers, Optional<ApplicationRequestCurrentStage> currentStage, Optional<ApplicationRequestRejectReason> rejectReason, Optional<String> remoteTemplateId, Optional<Map<String, JsonNode>> integrationParams, Optional<Map<String, JsonNode>> linkedAccountParams, Map<String, Object> additionalProperties) {
        this.candidate = candidate;
        this.job = job;
        this.appliedAt = appliedAt;
        this.rejectedAt = rejectedAt;
        this.offers = offers;
        this.source = source;
        this.creditedTo = creditedTo;
        this.screeningQuestionAnswers = screeningQuestionAnswers;
        this.currentStage = currentStage;
        this.rejectReason = rejectReason;
        this.remoteTemplateId = remoteTemplateId;
        this.integrationParams = integrationParams;
        this.linkedAccountParams = linkedAccountParams;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="candidate")
    public Optional<ApplicationRequestCandidate> getCandidate() {
        return this.candidate;
    }

    @JsonProperty(value="job")
    public Optional<ApplicationRequestJob> getJob() {
        return this.job;
    }

    @JsonProperty(value="applied_at")
    public Optional<OffsetDateTime> getAppliedAt() {
        return this.appliedAt;
    }

    @JsonProperty(value="rejected_at")
    public Optional<OffsetDateTime> getRejectedAt() {
        return this.rejectedAt;
    }

    @JsonProperty(value="offers")
    public Optional<List<Optional<ApplicationRequestOffersItem>>> getOffers() {
        return this.offers;
    }

    @JsonProperty(value="source")
    public Optional<String> getSource() {
        return this.source;
    }

    @JsonProperty(value="credited_to")
    public Optional<ApplicationRequestCreditedTo> getCreditedTo() {
        return this.creditedTo;
    }

    @JsonProperty(value="screening_question_answers")
    public Optional<List<ApplicationRequestScreeningQuestionAnswersItem>> getScreeningQuestionAnswers() {
        return this.screeningQuestionAnswers;
    }

    @JsonProperty(value="current_stage")
    public Optional<ApplicationRequestCurrentStage> getCurrentStage() {
        return this.currentStage;
    }

    @JsonProperty(value="reject_reason")
    public Optional<ApplicationRequestRejectReason> getRejectReason() {
        return this.rejectReason;
    }

    @JsonProperty(value="remote_template_id")
    public Optional<String> getRemoteTemplateId() {
        return this.remoteTemplateId;
    }

    @JsonProperty(value="integration_params")
    public Optional<Map<String, JsonNode>> getIntegrationParams() {
        return this.integrationParams;
    }

    @JsonProperty(value="linked_account_params")
    public Optional<Map<String, JsonNode>> getLinkedAccountParams() {
        return this.linkedAccountParams;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ApplicationRequest && this.equalTo((ApplicationRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ApplicationRequest other) {
        return this.candidate.equals(other.candidate) && this.job.equals(other.job) && this.appliedAt.equals(other.appliedAt) && this.rejectedAt.equals(other.rejectedAt) && this.offers.equals(other.offers) && this.source.equals(other.source) && this.creditedTo.equals(other.creditedTo) && this.screeningQuestionAnswers.equals(other.screeningQuestionAnswers) && this.currentStage.equals(other.currentStage) && this.rejectReason.equals(other.rejectReason) && this.remoteTemplateId.equals(other.remoteTemplateId) && this.integrationParams.equals(other.integrationParams) && this.linkedAccountParams.equals(other.linkedAccountParams);
    }

    public int hashCode() {
        return Objects.hash(this.candidate, this.job, this.appliedAt, this.rejectedAt, this.offers, this.source, this.creditedTo, this.screeningQuestionAnswers, this.currentStage, this.rejectReason, this.remoteTemplateId, this.integrationParams, this.linkedAccountParams);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<ApplicationRequestCandidate> candidate = Optional.empty();
        private Optional<ApplicationRequestJob> job = Optional.empty();
        private Optional<OffsetDateTime> appliedAt = Optional.empty();
        private Optional<OffsetDateTime> rejectedAt = Optional.empty();
        private Optional<List<Optional<ApplicationRequestOffersItem>>> offers = Optional.empty();
        private Optional<String> source = Optional.empty();
        private Optional<ApplicationRequestCreditedTo> creditedTo = Optional.empty();
        private Optional<List<ApplicationRequestScreeningQuestionAnswersItem>> screeningQuestionAnswers = Optional.empty();
        private Optional<ApplicationRequestCurrentStage> currentStage = Optional.empty();
        private Optional<ApplicationRequestRejectReason> rejectReason = Optional.empty();
        private Optional<String> remoteTemplateId = Optional.empty();
        private Optional<Map<String, JsonNode>> integrationParams = Optional.empty();
        private Optional<Map<String, JsonNode>> linkedAccountParams = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ApplicationRequest other) {
            this.candidate(other.getCandidate());
            this.job(other.getJob());
            this.appliedAt(other.getAppliedAt());
            this.rejectedAt(other.getRejectedAt());
            this.offers(other.getOffers());
            this.source(other.getSource());
            this.creditedTo(other.getCreditedTo());
            this.screeningQuestionAnswers(other.getScreeningQuestionAnswers());
            this.currentStage(other.getCurrentStage());
            this.rejectReason(other.getRejectReason());
            this.remoteTemplateId(other.getRemoteTemplateId());
            this.integrationParams(other.getIntegrationParams());
            this.linkedAccountParams(other.getLinkedAccountParams());
            return this;
        }

        @JsonSetter(value="candidate", nulls=Nulls.SKIP)
        public Builder candidate(Optional<ApplicationRequestCandidate> candidate) {
            this.candidate = candidate;
            return this;
        }

        public Builder candidate(ApplicationRequestCandidate candidate) {
            this.candidate = Optional.of(candidate);
            return this;
        }

        @JsonSetter(value="job", nulls=Nulls.SKIP)
        public Builder job(Optional<ApplicationRequestJob> job) {
            this.job = job;
            return this;
        }

        public Builder job(ApplicationRequestJob job) {
            this.job = Optional.of(job);
            return this;
        }

        @JsonSetter(value="applied_at", nulls=Nulls.SKIP)
        public Builder appliedAt(Optional<OffsetDateTime> appliedAt) {
            this.appliedAt = appliedAt;
            return this;
        }

        public Builder appliedAt(OffsetDateTime appliedAt) {
            this.appliedAt = Optional.of(appliedAt);
            return this;
        }

        @JsonSetter(value="rejected_at", nulls=Nulls.SKIP)
        public Builder rejectedAt(Optional<OffsetDateTime> rejectedAt) {
            this.rejectedAt = rejectedAt;
            return this;
        }

        public Builder rejectedAt(OffsetDateTime rejectedAt) {
            this.rejectedAt = Optional.of(rejectedAt);
            return this;
        }

        @JsonSetter(value="offers", nulls=Nulls.SKIP)
        public Builder offers(Optional<List<Optional<ApplicationRequestOffersItem>>> offers) {
            this.offers = offers;
            return this;
        }

        public Builder offers(List<Optional<ApplicationRequestOffersItem>> offers) {
            this.offers = Optional.of(offers);
            return this;
        }

        @JsonSetter(value="source", nulls=Nulls.SKIP)
        public Builder source(Optional<String> source) {
            this.source = source;
            return this;
        }

        public Builder source(String source) {
            this.source = Optional.of(source);
            return this;
        }

        @JsonSetter(value="credited_to", nulls=Nulls.SKIP)
        public Builder creditedTo(Optional<ApplicationRequestCreditedTo> creditedTo) {
            this.creditedTo = creditedTo;
            return this;
        }

        public Builder creditedTo(ApplicationRequestCreditedTo creditedTo) {
            this.creditedTo = Optional.of(creditedTo);
            return this;
        }

        @JsonSetter(value="screening_question_answers", nulls=Nulls.SKIP)
        public Builder screeningQuestionAnswers(Optional<List<ApplicationRequestScreeningQuestionAnswersItem>> screeningQuestionAnswers) {
            this.screeningQuestionAnswers = screeningQuestionAnswers;
            return this;
        }

        public Builder screeningQuestionAnswers(List<ApplicationRequestScreeningQuestionAnswersItem> screeningQuestionAnswers) {
            this.screeningQuestionAnswers = Optional.of(screeningQuestionAnswers);
            return this;
        }

        @JsonSetter(value="current_stage", nulls=Nulls.SKIP)
        public Builder currentStage(Optional<ApplicationRequestCurrentStage> currentStage) {
            this.currentStage = currentStage;
            return this;
        }

        public Builder currentStage(ApplicationRequestCurrentStage currentStage) {
            this.currentStage = Optional.of(currentStage);
            return this;
        }

        @JsonSetter(value="reject_reason", nulls=Nulls.SKIP)
        public Builder rejectReason(Optional<ApplicationRequestRejectReason> rejectReason) {
            this.rejectReason = rejectReason;
            return this;
        }

        public Builder rejectReason(ApplicationRequestRejectReason rejectReason) {
            this.rejectReason = Optional.of(rejectReason);
            return this;
        }

        @JsonSetter(value="remote_template_id", nulls=Nulls.SKIP)
        public Builder remoteTemplateId(Optional<String> remoteTemplateId) {
            this.remoteTemplateId = remoteTemplateId;
            return this;
        }

        public Builder remoteTemplateId(String remoteTemplateId) {
            this.remoteTemplateId = Optional.of(remoteTemplateId);
            return this;
        }

        @JsonSetter(value="integration_params", nulls=Nulls.SKIP)
        public Builder integrationParams(Optional<Map<String, JsonNode>> integrationParams) {
            this.integrationParams = integrationParams;
            return this;
        }

        public Builder integrationParams(Map<String, JsonNode> integrationParams) {
            this.integrationParams = Optional.of(integrationParams);
            return this;
        }

        @JsonSetter(value="linked_account_params", nulls=Nulls.SKIP)
        public Builder linkedAccountParams(Optional<Map<String, JsonNode>> linkedAccountParams) {
            this.linkedAccountParams = linkedAccountParams;
            return this;
        }

        public Builder linkedAccountParams(Map<String, JsonNode> linkedAccountParams) {
            this.linkedAccountParams = Optional.of(linkedAccountParams);
            return this;
        }

        public ApplicationRequest build() {
            return new ApplicationRequest(this.candidate, this.job, this.appliedAt, this.rejectedAt, this.offers, this.source, this.creditedTo, this.screeningQuestionAnswers, this.currentStage, this.rejectReason, this.remoteTemplateId, this.integrationParams, this.linkedAccountParams, this.additionalProperties);
        }
    }
}

