/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.ats.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import com.merge.api.resources.ats.types.CandidateRequestApplicationsItem;
import com.merge.api.resources.ats.types.CandidateRequestAttachmentsItem;
import com.merge.api.resources.ats.types.EmailAddressRequest;
import com.merge.api.resources.ats.types.PhoneNumberRequest;
import com.merge.api.resources.ats.types.UrlRequest;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class CandidateRequest {
    private final Optional<String> firstName;
    private final Optional<String> lastName;
    private final Optional<String> company;
    private final Optional<String> title;
    private final Optional<OffsetDateTime> lastInteractionAt;
    private final Optional<Boolean> isPrivate;
    private final Optional<Boolean> canEmail;
    private final Optional<List<Optional<String>>> locations;
    private final Optional<List<PhoneNumberRequest>> phoneNumbers;
    private final Optional<List<EmailAddressRequest>> emailAddresses;
    private final Optional<List<UrlRequest>> urls;
    private final Optional<List<Optional<String>>> tags;
    private final Optional<List<Optional<CandidateRequestApplicationsItem>>> applications;
    private final Optional<List<Optional<CandidateRequestAttachmentsItem>>> attachments;
    private final Optional<String> remoteTemplateId;
    private final Optional<Map<String, JsonNode>> integrationParams;
    private final Optional<Map<String, JsonNode>> linkedAccountParams;
    private final Map<String, Object> additionalProperties;

    private CandidateRequest(Optional<String> firstName, Optional<String> lastName, Optional<String> company, Optional<String> title, Optional<OffsetDateTime> lastInteractionAt, Optional<Boolean> isPrivate, Optional<Boolean> canEmail, Optional<List<Optional<String>>> locations, Optional<List<PhoneNumberRequest>> phoneNumbers, Optional<List<EmailAddressRequest>> emailAddresses, Optional<List<UrlRequest>> urls, Optional<List<Optional<String>>> tags, Optional<List<Optional<CandidateRequestApplicationsItem>>> applications, Optional<List<Optional<CandidateRequestAttachmentsItem>>> attachments, Optional<String> remoteTemplateId, Optional<Map<String, JsonNode>> integrationParams, Optional<Map<String, JsonNode>> linkedAccountParams, Map<String, Object> additionalProperties) {
        this.firstName = firstName;
        this.lastName = lastName;
        this.company = company;
        this.title = title;
        this.lastInteractionAt = lastInteractionAt;
        this.isPrivate = isPrivate;
        this.canEmail = canEmail;
        this.locations = locations;
        this.phoneNumbers = phoneNumbers;
        this.emailAddresses = emailAddresses;
        this.urls = urls;
        this.tags = tags;
        this.applications = applications;
        this.attachments = attachments;
        this.remoteTemplateId = remoteTemplateId;
        this.integrationParams = integrationParams;
        this.linkedAccountParams = linkedAccountParams;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="first_name")
    public Optional<String> getFirstName() {
        return this.firstName;
    }

    @JsonProperty(value="last_name")
    public Optional<String> getLastName() {
        return this.lastName;
    }

    @JsonProperty(value="company")
    public Optional<String> getCompany() {
        return this.company;
    }

    @JsonProperty(value="title")
    public Optional<String> getTitle() {
        return this.title;
    }

    @JsonProperty(value="last_interaction_at")
    public Optional<OffsetDateTime> getLastInteractionAt() {
        return this.lastInteractionAt;
    }

    @JsonProperty(value="is_private")
    public Optional<Boolean> getIsPrivate() {
        return this.isPrivate;
    }

    @JsonProperty(value="can_email")
    public Optional<Boolean> getCanEmail() {
        return this.canEmail;
    }

    @JsonProperty(value="locations")
    public Optional<List<Optional<String>>> getLocations() {
        return this.locations;
    }

    @JsonProperty(value="phone_numbers")
    public Optional<List<PhoneNumberRequest>> getPhoneNumbers() {
        return this.phoneNumbers;
    }

    @JsonProperty(value="email_addresses")
    public Optional<List<EmailAddressRequest>> getEmailAddresses() {
        return this.emailAddresses;
    }

    @JsonProperty(value="urls")
    public Optional<List<UrlRequest>> getUrls() {
        return this.urls;
    }

    @JsonProperty(value="tags")
    public Optional<List<Optional<String>>> getTags() {
        return this.tags;
    }

    @JsonProperty(value="applications")
    public Optional<List<Optional<CandidateRequestApplicationsItem>>> getApplications() {
        return this.applications;
    }

    @JsonProperty(value="attachments")
    public Optional<List<Optional<CandidateRequestAttachmentsItem>>> getAttachments() {
        return this.attachments;
    }

    @JsonProperty(value="remote_template_id")
    public Optional<String> getRemoteTemplateId() {
        return this.remoteTemplateId;
    }

    @JsonProperty(value="integration_params")
    public Optional<Map<String, JsonNode>> getIntegrationParams() {
        return this.integrationParams;
    }

    @JsonProperty(value="linked_account_params")
    public Optional<Map<String, JsonNode>> getLinkedAccountParams() {
        return this.linkedAccountParams;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CandidateRequest && this.equalTo((CandidateRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CandidateRequest other) {
        return this.firstName.equals(other.firstName) && this.lastName.equals(other.lastName) && this.company.equals(other.company) && this.title.equals(other.title) && this.lastInteractionAt.equals(other.lastInteractionAt) && this.isPrivate.equals(other.isPrivate) && this.canEmail.equals(other.canEmail) && this.locations.equals(other.locations) && this.phoneNumbers.equals(other.phoneNumbers) && this.emailAddresses.equals(other.emailAddresses) && this.urls.equals(other.urls) && this.tags.equals(other.tags) && this.applications.equals(other.applications) && this.attachments.equals(other.attachments) && this.remoteTemplateId.equals(other.remoteTemplateId) && this.integrationParams.equals(other.integrationParams) && this.linkedAccountParams.equals(other.linkedAccountParams);
    }

    public int hashCode() {
        return Objects.hash(this.firstName, this.lastName, this.company, this.title, this.lastInteractionAt, this.isPrivate, this.canEmail, this.locations, this.phoneNumbers, this.emailAddresses, this.urls, this.tags, this.applications, this.attachments, this.remoteTemplateId, this.integrationParams, this.linkedAccountParams);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> firstName = Optional.empty();
        private Optional<String> lastName = Optional.empty();
        private Optional<String> company = Optional.empty();
        private Optional<String> title = Optional.empty();
        private Optional<OffsetDateTime> lastInteractionAt = Optional.empty();
        private Optional<Boolean> isPrivate = Optional.empty();
        private Optional<Boolean> canEmail = Optional.empty();
        private Optional<List<Optional<String>>> locations = Optional.empty();
        private Optional<List<PhoneNumberRequest>> phoneNumbers = Optional.empty();
        private Optional<List<EmailAddressRequest>> emailAddresses = Optional.empty();
        private Optional<List<UrlRequest>> urls = Optional.empty();
        private Optional<List<Optional<String>>> tags = Optional.empty();
        private Optional<List<Optional<CandidateRequestApplicationsItem>>> applications = Optional.empty();
        private Optional<List<Optional<CandidateRequestAttachmentsItem>>> attachments = Optional.empty();
        private Optional<String> remoteTemplateId = Optional.empty();
        private Optional<Map<String, JsonNode>> integrationParams = Optional.empty();
        private Optional<Map<String, JsonNode>> linkedAccountParams = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CandidateRequest other) {
            this.firstName(other.getFirstName());
            this.lastName(other.getLastName());
            this.company(other.getCompany());
            this.title(other.getTitle());
            this.lastInteractionAt(other.getLastInteractionAt());
            this.isPrivate(other.getIsPrivate());
            this.canEmail(other.getCanEmail());
            this.locations(other.getLocations());
            this.phoneNumbers(other.getPhoneNumbers());
            this.emailAddresses(other.getEmailAddresses());
            this.urls(other.getUrls());
            this.tags(other.getTags());
            this.applications(other.getApplications());
            this.attachments(other.getAttachments());
            this.remoteTemplateId(other.getRemoteTemplateId());
            this.integrationParams(other.getIntegrationParams());
            this.linkedAccountParams(other.getLinkedAccountParams());
            return this;
        }

        @JsonSetter(value="first_name", nulls=Nulls.SKIP)
        public Builder firstName(Optional<String> firstName) {
            this.firstName = firstName;
            return this;
        }

        public Builder firstName(String firstName) {
            this.firstName = Optional.of(firstName);
            return this;
        }

        @JsonSetter(value="last_name", nulls=Nulls.SKIP)
        public Builder lastName(Optional<String> lastName) {
            this.lastName = lastName;
            return this;
        }

        public Builder lastName(String lastName) {
            this.lastName = Optional.of(lastName);
            return this;
        }

        @JsonSetter(value="company", nulls=Nulls.SKIP)
        public Builder company(Optional<String> company) {
            this.company = company;
            return this;
        }

        public Builder company(String company) {
            this.company = Optional.of(company);
            return this;
        }

        @JsonSetter(value="title", nulls=Nulls.SKIP)
        public Builder title(Optional<String> title) {
            this.title = title;
            return this;
        }

        public Builder title(String title) {
            this.title = Optional.of(title);
            return this;
        }

        @JsonSetter(value="last_interaction_at", nulls=Nulls.SKIP)
        public Builder lastInteractionAt(Optional<OffsetDateTime> lastInteractionAt) {
            this.lastInteractionAt = lastInteractionAt;
            return this;
        }

        public Builder lastInteractionAt(OffsetDateTime lastInteractionAt) {
            this.lastInteractionAt = Optional.of(lastInteractionAt);
            return this;
        }

        @JsonSetter(value="is_private", nulls=Nulls.SKIP)
        public Builder isPrivate(Optional<Boolean> isPrivate) {
            this.isPrivate = isPrivate;
            return this;
        }

        public Builder isPrivate(Boolean isPrivate) {
            this.isPrivate = Optional.of(isPrivate);
            return this;
        }

        @JsonSetter(value="can_email", nulls=Nulls.SKIP)
        public Builder canEmail(Optional<Boolean> canEmail) {
            this.canEmail = canEmail;
            return this;
        }

        public Builder canEmail(Boolean canEmail) {
            this.canEmail = Optional.of(canEmail);
            return this;
        }

        @JsonSetter(value="locations", nulls=Nulls.SKIP)
        public Builder locations(Optional<List<Optional<String>>> locations) {
            this.locations = locations;
            return this;
        }

        public Builder locations(List<Optional<String>> locations) {
            this.locations = Optional.of(locations);
            return this;
        }

        @JsonSetter(value="phone_numbers", nulls=Nulls.SKIP)
        public Builder phoneNumbers(Optional<List<PhoneNumberRequest>> phoneNumbers) {
            this.phoneNumbers = phoneNumbers;
            return this;
        }

        public Builder phoneNumbers(List<PhoneNumberRequest> phoneNumbers) {
            this.phoneNumbers = Optional.of(phoneNumbers);
            return this;
        }

        @JsonSetter(value="email_addresses", nulls=Nulls.SKIP)
        public Builder emailAddresses(Optional<List<EmailAddressRequest>> emailAddresses) {
            this.emailAddresses = emailAddresses;
            return this;
        }

        public Builder emailAddresses(List<EmailAddressRequest> emailAddresses) {
            this.emailAddresses = Optional.of(emailAddresses);
            return this;
        }

        @JsonSetter(value="urls", nulls=Nulls.SKIP)
        public Builder urls(Optional<List<UrlRequest>> urls) {
            this.urls = urls;
            return this;
        }

        public Builder urls(List<UrlRequest> urls) {
            this.urls = Optional.of(urls);
            return this;
        }

        @JsonSetter(value="tags", nulls=Nulls.SKIP)
        public Builder tags(Optional<List<Optional<String>>> tags) {
            this.tags = tags;
            return this;
        }

        public Builder tags(List<Optional<String>> tags) {
            this.tags = Optional.of(tags);
            return this;
        }

        @JsonSetter(value="applications", nulls=Nulls.SKIP)
        public Builder applications(Optional<List<Optional<CandidateRequestApplicationsItem>>> applications) {
            this.applications = applications;
            return this;
        }

        public Builder applications(List<Optional<CandidateRequestApplicationsItem>> applications) {
            this.applications = Optional.of(applications);
            return this;
        }

        @JsonSetter(value="attachments", nulls=Nulls.SKIP)
        public Builder attachments(Optional<List<Optional<CandidateRequestAttachmentsItem>>> attachments) {
            this.attachments = attachments;
            return this;
        }

        public Builder attachments(List<Optional<CandidateRequestAttachmentsItem>> attachments) {
            this.attachments = Optional.of(attachments);
            return this;
        }

        @JsonSetter(value="remote_template_id", nulls=Nulls.SKIP)
        public Builder remoteTemplateId(Optional<String> remoteTemplateId) {
            this.remoteTemplateId = remoteTemplateId;
            return this;
        }

        public Builder remoteTemplateId(String remoteTemplateId) {
            this.remoteTemplateId = Optional.of(remoteTemplateId);
            return this;
        }

        @JsonSetter(value="integration_params", nulls=Nulls.SKIP)
        public Builder integrationParams(Optional<Map<String, JsonNode>> integrationParams) {
            this.integrationParams = integrationParams;
            return this;
        }

        public Builder integrationParams(Map<String, JsonNode> integrationParams) {
            this.integrationParams = Optional.of(integrationParams);
            return this;
        }

        @JsonSetter(value="linked_account_params", nulls=Nulls.SKIP)
        public Builder linkedAccountParams(Optional<Map<String, JsonNode>> linkedAccountParams) {
            this.linkedAccountParams = linkedAccountParams;
            return this;
        }

        public Builder linkedAccountParams(Map<String, JsonNode> linkedAccountParams) {
            this.linkedAccountParams = Optional.of(linkedAccountParams);
            return this;
        }

        public CandidateRequest build() {
            return new CandidateRequest(this.firstName, this.lastName, this.company, this.title, this.lastInteractionAt, this.isPrivate, this.canEmail, this.locations, this.phoneNumbers, this.emailAddresses, this.urls, this.tags, this.applications, this.attachments, this.remoteTemplateId, this.integrationParams, this.linkedAccountParams, this.additionalProperties);
        }
    }
}

