/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.ats.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import com.merge.api.resources.ats.types.EmailAddressEmailAddressType;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class EmailAddress {
    private final Optional<OffsetDateTime> createdAt;
    private final Optional<OffsetDateTime> modifiedAt;
    private final Optional<String> value;
    private final Optional<EmailAddressEmailAddressType> emailAddressType;
    private final Optional<Boolean> remoteWasDeleted;
    private final Map<String, Object> additionalProperties;

    private EmailAddress(Optional<OffsetDateTime> createdAt, Optional<OffsetDateTime> modifiedAt, Optional<String> value, Optional<EmailAddressEmailAddressType> emailAddressType, Optional<Boolean> remoteWasDeleted, Map<String, Object> additionalProperties) {
        this.createdAt = createdAt;
        this.modifiedAt = modifiedAt;
        this.value = value;
        this.emailAddressType = emailAddressType;
        this.remoteWasDeleted = remoteWasDeleted;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="created_at")
    public Optional<OffsetDateTime> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="modified_at")
    public Optional<OffsetDateTime> getModifiedAt() {
        return this.modifiedAt;
    }

    @JsonProperty(value="value")
    public Optional<String> getValue() {
        return this.value;
    }

    @JsonProperty(value="email_address_type")
    public Optional<EmailAddressEmailAddressType> getEmailAddressType() {
        return this.emailAddressType;
    }

    @JsonProperty(value="remote_was_deleted")
    public Optional<Boolean> getRemoteWasDeleted() {
        return this.remoteWasDeleted;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof EmailAddress && this.equalTo((EmailAddress)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(EmailAddress other) {
        return this.createdAt.equals(other.createdAt) && this.modifiedAt.equals(other.modifiedAt) && this.value.equals(other.value) && this.emailAddressType.equals(other.emailAddressType) && this.remoteWasDeleted.equals(other.remoteWasDeleted);
    }

    public int hashCode() {
        return Objects.hash(this.createdAt, this.modifiedAt, this.value, this.emailAddressType, this.remoteWasDeleted);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<OffsetDateTime> createdAt = Optional.empty();
        private Optional<OffsetDateTime> modifiedAt = Optional.empty();
        private Optional<String> value = Optional.empty();
        private Optional<EmailAddressEmailAddressType> emailAddressType = Optional.empty();
        private Optional<Boolean> remoteWasDeleted = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(EmailAddress other) {
            this.createdAt(other.getCreatedAt());
            this.modifiedAt(other.getModifiedAt());
            this.value(other.getValue());
            this.emailAddressType(other.getEmailAddressType());
            this.remoteWasDeleted(other.getRemoteWasDeleted());
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<OffsetDateTime> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(OffsetDateTime createdAt) {
            this.createdAt = Optional.of(createdAt);
            return this;
        }

        @JsonSetter(value="modified_at", nulls=Nulls.SKIP)
        public Builder modifiedAt(Optional<OffsetDateTime> modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public Builder modifiedAt(OffsetDateTime modifiedAt) {
            this.modifiedAt = Optional.of(modifiedAt);
            return this;
        }

        @JsonSetter(value="value", nulls=Nulls.SKIP)
        public Builder value(Optional<String> value) {
            this.value = value;
            return this;
        }

        public Builder value(String value) {
            this.value = Optional.of(value);
            return this;
        }

        @JsonSetter(value="email_address_type", nulls=Nulls.SKIP)
        public Builder emailAddressType(Optional<EmailAddressEmailAddressType> emailAddressType) {
            this.emailAddressType = emailAddressType;
            return this;
        }

        public Builder emailAddressType(EmailAddressEmailAddressType emailAddressType) {
            this.emailAddressType = Optional.of(emailAddressType);
            return this;
        }

        @JsonSetter(value="remote_was_deleted", nulls=Nulls.SKIP)
        public Builder remoteWasDeleted(Optional<Boolean> remoteWasDeleted) {
            this.remoteWasDeleted = remoteWasDeleted;
            return this;
        }

        public Builder remoteWasDeleted(Boolean remoteWasDeleted) {
            this.remoteWasDeleted = Optional.of(remoteWasDeleted);
            return this;
        }

        public EmailAddress build() {
            return new EmailAddress(this.createdAt, this.modifiedAt, this.value, this.emailAddressType, this.remoteWasDeleted, this.additionalProperties);
        }
    }
}

