/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.ats.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import com.merge.api.resources.ats.types.IssueStatus;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class Issue {
    private final Optional<String> id;
    private final Optional<IssueStatus> status;
    private final String errorDescription;
    private final Optional<Map<String, JsonNode>> endUser;
    private final Optional<OffsetDateTime> firstIncidentTime;
    private final Optional<OffsetDateTime> lastIncidentTime;
    private final Optional<Boolean> isMuted;
    private final Optional<List<String>> errorDetails;
    private final Map<String, Object> additionalProperties;

    private Issue(Optional<String> id, Optional<IssueStatus> status, String errorDescription, Optional<Map<String, JsonNode>> endUser, Optional<OffsetDateTime> firstIncidentTime, Optional<OffsetDateTime> lastIncidentTime, Optional<Boolean> isMuted, Optional<List<String>> errorDetails, Map<String, Object> additionalProperties) {
        this.id = id;
        this.status = status;
        this.errorDescription = errorDescription;
        this.endUser = endUser;
        this.firstIncidentTime = firstIncidentTime;
        this.lastIncidentTime = lastIncidentTime;
        this.isMuted = isMuted;
        this.errorDetails = errorDetails;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="status")
    public Optional<IssueStatus> getStatus() {
        return this.status;
    }

    @JsonProperty(value="error_description")
    public String getErrorDescription() {
        return this.errorDescription;
    }

    @JsonProperty(value="end_user")
    public Optional<Map<String, JsonNode>> getEndUser() {
        return this.endUser;
    }

    @JsonProperty(value="first_incident_time")
    public Optional<OffsetDateTime> getFirstIncidentTime() {
        return this.firstIncidentTime;
    }

    @JsonProperty(value="last_incident_time")
    public Optional<OffsetDateTime> getLastIncidentTime() {
        return this.lastIncidentTime;
    }

    @JsonProperty(value="is_muted")
    public Optional<Boolean> getIsMuted() {
        return this.isMuted;
    }

    @JsonProperty(value="error_details")
    public Optional<List<String>> getErrorDetails() {
        return this.errorDetails;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Issue && this.equalTo((Issue)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Issue other) {
        return this.id.equals(other.id) && this.status.equals(other.status) && this.errorDescription.equals(other.errorDescription) && this.endUser.equals(other.endUser) && this.firstIncidentTime.equals(other.firstIncidentTime) && this.lastIncidentTime.equals(other.lastIncidentTime) && this.isMuted.equals(other.isMuted) && this.errorDetails.equals(other.errorDetails);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.status, this.errorDescription, this.endUser, this.firstIncidentTime, this.lastIncidentTime, this.isMuted, this.errorDetails);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ErrorDescriptionStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ErrorDescriptionStage,
    _FinalStage {
        private String errorDescription;
        private Optional<List<String>> errorDetails = Optional.empty();
        private Optional<Boolean> isMuted = Optional.empty();
        private Optional<OffsetDateTime> lastIncidentTime = Optional.empty();
        private Optional<OffsetDateTime> firstIncidentTime = Optional.empty();
        private Optional<Map<String, JsonNode>> endUser = Optional.empty();
        private Optional<IssueStatus> status = Optional.empty();
        private Optional<String> id = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(Issue other) {
            this.id(other.getId());
            this.status(other.getStatus());
            this.errorDescription(other.getErrorDescription());
            this.endUser(other.getEndUser());
            this.firstIncidentTime(other.getFirstIncidentTime());
            this.lastIncidentTime(other.getLastIncidentTime());
            this.isMuted(other.getIsMuted());
            this.errorDetails(other.getErrorDetails());
            return this;
        }

        @Override
        @JsonSetter(value="error_description")
        public _FinalStage errorDescription(String errorDescription) {
            this.errorDescription = errorDescription;
            return this;
        }

        @Override
        public _FinalStage errorDetails(List<String> errorDetails) {
            this.errorDetails = Optional.of(errorDetails);
            return this;
        }

        @Override
        @JsonSetter(value="error_details", nulls=Nulls.SKIP)
        public _FinalStage errorDetails(Optional<List<String>> errorDetails) {
            this.errorDetails = errorDetails;
            return this;
        }

        @Override
        public _FinalStage isMuted(Boolean isMuted) {
            this.isMuted = Optional.of(isMuted);
            return this;
        }

        @Override
        @JsonSetter(value="is_muted", nulls=Nulls.SKIP)
        public _FinalStage isMuted(Optional<Boolean> isMuted) {
            this.isMuted = isMuted;
            return this;
        }

        @Override
        public _FinalStage lastIncidentTime(OffsetDateTime lastIncidentTime) {
            this.lastIncidentTime = Optional.of(lastIncidentTime);
            return this;
        }

        @Override
        @JsonSetter(value="last_incident_time", nulls=Nulls.SKIP)
        public _FinalStage lastIncidentTime(Optional<OffsetDateTime> lastIncidentTime) {
            this.lastIncidentTime = lastIncidentTime;
            return this;
        }

        @Override
        public _FinalStage firstIncidentTime(OffsetDateTime firstIncidentTime) {
            this.firstIncidentTime = Optional.of(firstIncidentTime);
            return this;
        }

        @Override
        @JsonSetter(value="first_incident_time", nulls=Nulls.SKIP)
        public _FinalStage firstIncidentTime(Optional<OffsetDateTime> firstIncidentTime) {
            this.firstIncidentTime = firstIncidentTime;
            return this;
        }

        @Override
        public _FinalStage endUser(Map<String, JsonNode> endUser) {
            this.endUser = Optional.of(endUser);
            return this;
        }

        @Override
        @JsonSetter(value="end_user", nulls=Nulls.SKIP)
        public _FinalStage endUser(Optional<Map<String, JsonNode>> endUser) {
            this.endUser = endUser;
            return this;
        }

        @Override
        public _FinalStage status(IssueStatus status) {
            this.status = Optional.of(status);
            return this;
        }

        @Override
        @JsonSetter(value="status", nulls=Nulls.SKIP)
        public _FinalStage status(Optional<IssueStatus> status) {
            this.status = status;
            return this;
        }

        @Override
        public _FinalStage id(String id) {
            this.id = Optional.of(id);
            return this;
        }

        @Override
        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public _FinalStage id(Optional<String> id) {
            this.id = id;
            return this;
        }

        @Override
        public Issue build() {
            return new Issue(this.id, this.status, this.errorDescription, this.endUser, this.firstIncidentTime, this.lastIncidentTime, this.isMuted, this.errorDetails, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public Issue build();

        public _FinalStage id(Optional<String> var1);

        public _FinalStage id(String var1);

        public _FinalStage status(Optional<IssueStatus> var1);

        public _FinalStage status(IssueStatus var1);

        public _FinalStage endUser(Optional<Map<String, JsonNode>> var1);

        public _FinalStage endUser(Map<String, JsonNode> var1);

        public _FinalStage firstIncidentTime(Optional<OffsetDateTime> var1);

        public _FinalStage firstIncidentTime(OffsetDateTime var1);

        public _FinalStage lastIncidentTime(Optional<OffsetDateTime> var1);

        public _FinalStage lastIncidentTime(OffsetDateTime var1);

        public _FinalStage isMuted(Optional<Boolean> var1);

        public _FinalStage isMuted(Boolean var1);

        public _FinalStage errorDetails(Optional<List<String>> var1);

        public _FinalStage errorDetails(List<String> var1);
    }

    public static interface ErrorDescriptionStage {
        public _FinalStage errorDescription(String var1);

        public Builder from(Issue var1);
    }
}

