/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.ats.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import com.merge.api.resources.ats.types.JobDepartmentsItem;
import com.merge.api.resources.ats.types.JobHiringManagersItem;
import com.merge.api.resources.ats.types.JobOfficesItem;
import com.merge.api.resources.ats.types.JobRecruitersItem;
import com.merge.api.resources.ats.types.JobStatus;
import com.merge.api.resources.ats.types.JobTypeEnum;
import com.merge.api.resources.ats.types.RemoteData;
import com.merge.api.resources.ats.types.Url;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class Job {
    private final Optional<String> id;
    private final Optional<String> remoteId;
    private final Optional<OffsetDateTime> createdAt;
    private final Optional<OffsetDateTime> modifiedAt;
    private final Optional<String> name;
    private final Optional<String> description;
    private final Optional<String> code;
    private final Optional<JobStatus> status;
    private final Optional<JobTypeEnum> type;
    private final Optional<List<Optional<String>>> jobPostings;
    private final Optional<List<Url>> jobPostingUrls;
    private final Optional<OffsetDateTime> remoteCreatedAt;
    private final Optional<OffsetDateTime> remoteUpdatedAt;
    private final Optional<Boolean> confidential;
    private final Optional<List<Optional<JobDepartmentsItem>>> departments;
    private final Optional<List<Optional<JobOfficesItem>>> offices;
    private final Optional<List<Optional<JobHiringManagersItem>>> hiringManagers;
    private final Optional<List<Optional<JobRecruitersItem>>> recruiters;
    private final Optional<Boolean> remoteWasDeleted;
    private final Optional<Map<String, JsonNode>> fieldMappings;
    private final Optional<List<RemoteData>> remoteData;
    private final Map<String, Object> additionalProperties;

    private Job(Optional<String> id, Optional<String> remoteId, Optional<OffsetDateTime> createdAt, Optional<OffsetDateTime> modifiedAt, Optional<String> name, Optional<String> description, Optional<String> code, Optional<JobStatus> status, Optional<JobTypeEnum> type, Optional<List<Optional<String>>> jobPostings, Optional<List<Url>> jobPostingUrls, Optional<OffsetDateTime> remoteCreatedAt, Optional<OffsetDateTime> remoteUpdatedAt, Optional<Boolean> confidential, Optional<List<Optional<JobDepartmentsItem>>> departments, Optional<List<Optional<JobOfficesItem>>> offices, Optional<List<Optional<JobHiringManagersItem>>> hiringManagers, Optional<List<Optional<JobRecruitersItem>>> recruiters, Optional<Boolean> remoteWasDeleted, Optional<Map<String, JsonNode>> fieldMappings, Optional<List<RemoteData>> remoteData, Map<String, Object> additionalProperties) {
        this.id = id;
        this.remoteId = remoteId;
        this.createdAt = createdAt;
        this.modifiedAt = modifiedAt;
        this.name = name;
        this.description = description;
        this.code = code;
        this.status = status;
        this.type = type;
        this.jobPostings = jobPostings;
        this.jobPostingUrls = jobPostingUrls;
        this.remoteCreatedAt = remoteCreatedAt;
        this.remoteUpdatedAt = remoteUpdatedAt;
        this.confidential = confidential;
        this.departments = departments;
        this.offices = offices;
        this.hiringManagers = hiringManagers;
        this.recruiters = recruiters;
        this.remoteWasDeleted = remoteWasDeleted;
        this.fieldMappings = fieldMappings;
        this.remoteData = remoteData;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="remote_id")
    public Optional<String> getRemoteId() {
        return this.remoteId;
    }

    @JsonProperty(value="created_at")
    public Optional<OffsetDateTime> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="modified_at")
    public Optional<OffsetDateTime> getModifiedAt() {
        return this.modifiedAt;
    }

    @JsonProperty(value="name")
    public Optional<String> getName() {
        return this.name;
    }

    @JsonProperty(value="description")
    public Optional<String> getDescription() {
        return this.description;
    }

    @JsonProperty(value="code")
    public Optional<String> getCode() {
        return this.code;
    }

    @JsonProperty(value="status")
    public Optional<JobStatus> getStatus() {
        return this.status;
    }

    @JsonProperty(value="type")
    public Optional<JobTypeEnum> getType() {
        return this.type;
    }

    @JsonProperty(value="job_postings")
    public Optional<List<Optional<String>>> getJobPostings() {
        return this.jobPostings;
    }

    @JsonProperty(value="job_posting_urls")
    public Optional<List<Url>> getJobPostingUrls() {
        return this.jobPostingUrls;
    }

    @JsonProperty(value="remote_created_at")
    public Optional<OffsetDateTime> getRemoteCreatedAt() {
        return this.remoteCreatedAt;
    }

    @JsonProperty(value="remote_updated_at")
    public Optional<OffsetDateTime> getRemoteUpdatedAt() {
        return this.remoteUpdatedAt;
    }

    @JsonProperty(value="confidential")
    public Optional<Boolean> getConfidential() {
        return this.confidential;
    }

    @JsonProperty(value="departments")
    public Optional<List<Optional<JobDepartmentsItem>>> getDepartments() {
        return this.departments;
    }

    @JsonProperty(value="offices")
    public Optional<List<Optional<JobOfficesItem>>> getOffices() {
        return this.offices;
    }

    @JsonProperty(value="hiring_managers")
    public Optional<List<Optional<JobHiringManagersItem>>> getHiringManagers() {
        return this.hiringManagers;
    }

    @JsonProperty(value="recruiters")
    public Optional<List<Optional<JobRecruitersItem>>> getRecruiters() {
        return this.recruiters;
    }

    @JsonProperty(value="remote_was_deleted")
    public Optional<Boolean> getRemoteWasDeleted() {
        return this.remoteWasDeleted;
    }

    @JsonProperty(value="field_mappings")
    public Optional<Map<String, JsonNode>> getFieldMappings() {
        return this.fieldMappings;
    }

    @JsonProperty(value="remote_data")
    public Optional<List<RemoteData>> getRemoteData() {
        return this.remoteData;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Job && this.equalTo((Job)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Job other) {
        return this.id.equals(other.id) && this.remoteId.equals(other.remoteId) && this.createdAt.equals(other.createdAt) && this.modifiedAt.equals(other.modifiedAt) && this.name.equals(other.name) && this.description.equals(other.description) && this.code.equals(other.code) && this.status.equals(other.status) && this.type.equals(other.type) && this.jobPostings.equals(other.jobPostings) && this.jobPostingUrls.equals(other.jobPostingUrls) && this.remoteCreatedAt.equals(other.remoteCreatedAt) && this.remoteUpdatedAt.equals(other.remoteUpdatedAt) && this.confidential.equals(other.confidential) && this.departments.equals(other.departments) && this.offices.equals(other.offices) && this.hiringManagers.equals(other.hiringManagers) && this.recruiters.equals(other.recruiters) && this.remoteWasDeleted.equals(other.remoteWasDeleted) && this.fieldMappings.equals(other.fieldMappings) && this.remoteData.equals(other.remoteData);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.remoteId, this.createdAt, this.modifiedAt, this.name, this.description, this.code, this.status, this.type, this.jobPostings, this.jobPostingUrls, this.remoteCreatedAt, this.remoteUpdatedAt, this.confidential, this.departments, this.offices, this.hiringManagers, this.recruiters, this.remoteWasDeleted, this.fieldMappings, this.remoteData);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> id = Optional.empty();
        private Optional<String> remoteId = Optional.empty();
        private Optional<OffsetDateTime> createdAt = Optional.empty();
        private Optional<OffsetDateTime> modifiedAt = Optional.empty();
        private Optional<String> name = Optional.empty();
        private Optional<String> description = Optional.empty();
        private Optional<String> code = Optional.empty();
        private Optional<JobStatus> status = Optional.empty();
        private Optional<JobTypeEnum> type = Optional.empty();
        private Optional<List<Optional<String>>> jobPostings = Optional.empty();
        private Optional<List<Url>> jobPostingUrls = Optional.empty();
        private Optional<OffsetDateTime> remoteCreatedAt = Optional.empty();
        private Optional<OffsetDateTime> remoteUpdatedAt = Optional.empty();
        private Optional<Boolean> confidential = Optional.empty();
        private Optional<List<Optional<JobDepartmentsItem>>> departments = Optional.empty();
        private Optional<List<Optional<JobOfficesItem>>> offices = Optional.empty();
        private Optional<List<Optional<JobHiringManagersItem>>> hiringManagers = Optional.empty();
        private Optional<List<Optional<JobRecruitersItem>>> recruiters = Optional.empty();
        private Optional<Boolean> remoteWasDeleted = Optional.empty();
        private Optional<Map<String, JsonNode>> fieldMappings = Optional.empty();
        private Optional<List<RemoteData>> remoteData = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(Job other) {
            this.id(other.getId());
            this.remoteId(other.getRemoteId());
            this.createdAt(other.getCreatedAt());
            this.modifiedAt(other.getModifiedAt());
            this.name(other.getName());
            this.description(other.getDescription());
            this.code(other.getCode());
            this.status(other.getStatus());
            this.type(other.getType());
            this.jobPostings(other.getJobPostings());
            this.jobPostingUrls(other.getJobPostingUrls());
            this.remoteCreatedAt(other.getRemoteCreatedAt());
            this.remoteUpdatedAt(other.getRemoteUpdatedAt());
            this.confidential(other.getConfidential());
            this.departments(other.getDepartments());
            this.offices(other.getOffices());
            this.hiringManagers(other.getHiringManagers());
            this.recruiters(other.getRecruiters());
            this.remoteWasDeleted(other.getRemoteWasDeleted());
            this.fieldMappings(other.getFieldMappings());
            this.remoteData(other.getRemoteData());
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.of(id);
            return this;
        }

        @JsonSetter(value="remote_id", nulls=Nulls.SKIP)
        public Builder remoteId(Optional<String> remoteId) {
            this.remoteId = remoteId;
            return this;
        }

        public Builder remoteId(String remoteId) {
            this.remoteId = Optional.of(remoteId);
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<OffsetDateTime> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(OffsetDateTime createdAt) {
            this.createdAt = Optional.of(createdAt);
            return this;
        }

        @JsonSetter(value="modified_at", nulls=Nulls.SKIP)
        public Builder modifiedAt(Optional<OffsetDateTime> modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public Builder modifiedAt(OffsetDateTime modifiedAt) {
            this.modifiedAt = Optional.of(modifiedAt);
            return this;
        }

        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.of(name);
            return this;
        }

        @JsonSetter(value="description", nulls=Nulls.SKIP)
        public Builder description(Optional<String> description) {
            this.description = description;
            return this;
        }

        public Builder description(String description) {
            this.description = Optional.of(description);
            return this;
        }

        @JsonSetter(value="code", nulls=Nulls.SKIP)
        public Builder code(Optional<String> code) {
            this.code = code;
            return this;
        }

        public Builder code(String code) {
            this.code = Optional.of(code);
            return this;
        }

        @JsonSetter(value="status", nulls=Nulls.SKIP)
        public Builder status(Optional<JobStatus> status) {
            this.status = status;
            return this;
        }

        public Builder status(JobStatus status) {
            this.status = Optional.of(status);
            return this;
        }

        @JsonSetter(value="type", nulls=Nulls.SKIP)
        public Builder type(Optional<JobTypeEnum> type) {
            this.type = type;
            return this;
        }

        public Builder type(JobTypeEnum type) {
            this.type = Optional.of(type);
            return this;
        }

        @JsonSetter(value="job_postings", nulls=Nulls.SKIP)
        public Builder jobPostings(Optional<List<Optional<String>>> jobPostings) {
            this.jobPostings = jobPostings;
            return this;
        }

        public Builder jobPostings(List<Optional<String>> jobPostings) {
            this.jobPostings = Optional.of(jobPostings);
            return this;
        }

        @JsonSetter(value="job_posting_urls", nulls=Nulls.SKIP)
        public Builder jobPostingUrls(Optional<List<Url>> jobPostingUrls) {
            this.jobPostingUrls = jobPostingUrls;
            return this;
        }

        public Builder jobPostingUrls(List<Url> jobPostingUrls) {
            this.jobPostingUrls = Optional.of(jobPostingUrls);
            return this;
        }

        @JsonSetter(value="remote_created_at", nulls=Nulls.SKIP)
        public Builder remoteCreatedAt(Optional<OffsetDateTime> remoteCreatedAt) {
            this.remoteCreatedAt = remoteCreatedAt;
            return this;
        }

        public Builder remoteCreatedAt(OffsetDateTime remoteCreatedAt) {
            this.remoteCreatedAt = Optional.of(remoteCreatedAt);
            return this;
        }

        @JsonSetter(value="remote_updated_at", nulls=Nulls.SKIP)
        public Builder remoteUpdatedAt(Optional<OffsetDateTime> remoteUpdatedAt) {
            this.remoteUpdatedAt = remoteUpdatedAt;
            return this;
        }

        public Builder remoteUpdatedAt(OffsetDateTime remoteUpdatedAt) {
            this.remoteUpdatedAt = Optional.of(remoteUpdatedAt);
            return this;
        }

        @JsonSetter(value="confidential", nulls=Nulls.SKIP)
        public Builder confidential(Optional<Boolean> confidential) {
            this.confidential = confidential;
            return this;
        }

        public Builder confidential(Boolean confidential) {
            this.confidential = Optional.of(confidential);
            return this;
        }

        @JsonSetter(value="departments", nulls=Nulls.SKIP)
        public Builder departments(Optional<List<Optional<JobDepartmentsItem>>> departments) {
            this.departments = departments;
            return this;
        }

        public Builder departments(List<Optional<JobDepartmentsItem>> departments) {
            this.departments = Optional.of(departments);
            return this;
        }

        @JsonSetter(value="offices", nulls=Nulls.SKIP)
        public Builder offices(Optional<List<Optional<JobOfficesItem>>> offices) {
            this.offices = offices;
            return this;
        }

        public Builder offices(List<Optional<JobOfficesItem>> offices) {
            this.offices = Optional.of(offices);
            return this;
        }

        @JsonSetter(value="hiring_managers", nulls=Nulls.SKIP)
        public Builder hiringManagers(Optional<List<Optional<JobHiringManagersItem>>> hiringManagers) {
            this.hiringManagers = hiringManagers;
            return this;
        }

        public Builder hiringManagers(List<Optional<JobHiringManagersItem>> hiringManagers) {
            this.hiringManagers = Optional.of(hiringManagers);
            return this;
        }

        @JsonSetter(value="recruiters", nulls=Nulls.SKIP)
        public Builder recruiters(Optional<List<Optional<JobRecruitersItem>>> recruiters) {
            this.recruiters = recruiters;
            return this;
        }

        public Builder recruiters(List<Optional<JobRecruitersItem>> recruiters) {
            this.recruiters = Optional.of(recruiters);
            return this;
        }

        @JsonSetter(value="remote_was_deleted", nulls=Nulls.SKIP)
        public Builder remoteWasDeleted(Optional<Boolean> remoteWasDeleted) {
            this.remoteWasDeleted = remoteWasDeleted;
            return this;
        }

        public Builder remoteWasDeleted(Boolean remoteWasDeleted) {
            this.remoteWasDeleted = Optional.of(remoteWasDeleted);
            return this;
        }

        @JsonSetter(value="field_mappings", nulls=Nulls.SKIP)
        public Builder fieldMappings(Optional<Map<String, JsonNode>> fieldMappings) {
            this.fieldMappings = fieldMappings;
            return this;
        }

        public Builder fieldMappings(Map<String, JsonNode> fieldMappings) {
            this.fieldMappings = Optional.of(fieldMappings);
            return this;
        }

        @JsonSetter(value="remote_data", nulls=Nulls.SKIP)
        public Builder remoteData(Optional<List<RemoteData>> remoteData) {
            this.remoteData = remoteData;
            return this;
        }

        public Builder remoteData(List<RemoteData> remoteData) {
            this.remoteData = Optional.of(remoteData);
            return this;
        }

        public Job build() {
            return new Job(this.id, this.remoteId, this.createdAt, this.modifiedAt, this.name, this.description, this.code, this.status, this.type, this.jobPostings, this.jobPostingUrls, this.remoteCreatedAt, this.remoteUpdatedAt, this.confidential, this.departments, this.offices, this.hiringManagers, this.recruiters, this.remoteWasDeleted, this.fieldMappings, this.remoteData, this.additionalProperties);
        }
    }
}

