/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.ats.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import com.merge.api.resources.ats.types.LinkedAccountStatus;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class MetaResponse {
    private final Map<String, JsonNode> requestSchema;
    private final Optional<Map<String, JsonNode>> remoteFieldClasses;
    private final Optional<LinkedAccountStatus> status;
    private final boolean hasConditionalParams;
    private final boolean hasRequiredLinkedAccountParams;
    private final Map<String, Object> additionalProperties;

    private MetaResponse(Map<String, JsonNode> requestSchema, Optional<Map<String, JsonNode>> remoteFieldClasses, Optional<LinkedAccountStatus> status, boolean hasConditionalParams, boolean hasRequiredLinkedAccountParams, Map<String, Object> additionalProperties) {
        this.requestSchema = requestSchema;
        this.remoteFieldClasses = remoteFieldClasses;
        this.status = status;
        this.hasConditionalParams = hasConditionalParams;
        this.hasRequiredLinkedAccountParams = hasRequiredLinkedAccountParams;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="request_schema")
    public Map<String, JsonNode> getRequestSchema() {
        return this.requestSchema;
    }

    @JsonProperty(value="remote_field_classes")
    public Optional<Map<String, JsonNode>> getRemoteFieldClasses() {
        return this.remoteFieldClasses;
    }

    @JsonProperty(value="status")
    public Optional<LinkedAccountStatus> getStatus() {
        return this.status;
    }

    @JsonProperty(value="has_conditional_params")
    public boolean getHasConditionalParams() {
        return this.hasConditionalParams;
    }

    @JsonProperty(value="has_required_linked_account_params")
    public boolean getHasRequiredLinkedAccountParams() {
        return this.hasRequiredLinkedAccountParams;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof MetaResponse && this.equalTo((MetaResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(MetaResponse other) {
        return this.requestSchema.equals(other.requestSchema) && this.remoteFieldClasses.equals(other.remoteFieldClasses) && this.status.equals(other.status) && this.hasConditionalParams == other.hasConditionalParams && this.hasRequiredLinkedAccountParams == other.hasRequiredLinkedAccountParams;
    }

    public int hashCode() {
        return Objects.hash(this.requestSchema, this.remoteFieldClasses, this.status, this.hasConditionalParams, this.hasRequiredLinkedAccountParams);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static HasConditionalParamsStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements HasConditionalParamsStage,
    HasRequiredLinkedAccountParamsStage,
    _FinalStage {
        private boolean hasConditionalParams;
        private boolean hasRequiredLinkedAccountParams;
        private Optional<LinkedAccountStatus> status = Optional.empty();
        private Optional<Map<String, JsonNode>> remoteFieldClasses = Optional.empty();
        private Map<String, JsonNode> requestSchema = new LinkedHashMap<String, JsonNode>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(MetaResponse other) {
            this.requestSchema(other.getRequestSchema());
            this.remoteFieldClasses(other.getRemoteFieldClasses());
            this.status(other.getStatus());
            this.hasConditionalParams(other.getHasConditionalParams());
            this.hasRequiredLinkedAccountParams(other.getHasRequiredLinkedAccountParams());
            return this;
        }

        @Override
        @JsonSetter(value="has_conditional_params")
        public HasRequiredLinkedAccountParamsStage hasConditionalParams(boolean hasConditionalParams) {
            this.hasConditionalParams = hasConditionalParams;
            return this;
        }

        @Override
        @JsonSetter(value="has_required_linked_account_params")
        public _FinalStage hasRequiredLinkedAccountParams(boolean hasRequiredLinkedAccountParams) {
            this.hasRequiredLinkedAccountParams = hasRequiredLinkedAccountParams;
            return this;
        }

        @Override
        public _FinalStage status(LinkedAccountStatus status) {
            this.status = Optional.of(status);
            return this;
        }

        @Override
        @JsonSetter(value="status", nulls=Nulls.SKIP)
        public _FinalStage status(Optional<LinkedAccountStatus> status) {
            this.status = status;
            return this;
        }

        @Override
        public _FinalStage remoteFieldClasses(Map<String, JsonNode> remoteFieldClasses) {
            this.remoteFieldClasses = Optional.of(remoteFieldClasses);
            return this;
        }

        @Override
        @JsonSetter(value="remote_field_classes", nulls=Nulls.SKIP)
        public _FinalStage remoteFieldClasses(Optional<Map<String, JsonNode>> remoteFieldClasses) {
            this.remoteFieldClasses = remoteFieldClasses;
            return this;
        }

        @Override
        public _FinalStage requestSchema(String key, JsonNode value) {
            this.requestSchema.put(key, value);
            return this;
        }

        @Override
        public _FinalStage putAllRequestSchema(Map<String, JsonNode> requestSchema) {
            this.requestSchema.putAll(requestSchema);
            return this;
        }

        @Override
        @JsonSetter(value="request_schema", nulls=Nulls.SKIP)
        public _FinalStage requestSchema(Map<String, JsonNode> requestSchema) {
            this.requestSchema.clear();
            this.requestSchema.putAll(requestSchema);
            return this;
        }

        @Override
        public MetaResponse build() {
            return new MetaResponse(this.requestSchema, this.remoteFieldClasses, this.status, this.hasConditionalParams, this.hasRequiredLinkedAccountParams, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public MetaResponse build();

        public _FinalStage requestSchema(Map<String, JsonNode> var1);

        public _FinalStage putAllRequestSchema(Map<String, JsonNode> var1);

        public _FinalStage requestSchema(String var1, JsonNode var2);

        public _FinalStage remoteFieldClasses(Optional<Map<String, JsonNode>> var1);

        public _FinalStage remoteFieldClasses(Map<String, JsonNode> var1);

        public _FinalStage status(Optional<LinkedAccountStatus> var1);

        public _FinalStage status(LinkedAccountStatus var1);
    }

    public static interface HasRequiredLinkedAccountParamsStage {
        public _FinalStage hasRequiredLinkedAccountParams(boolean var1);
    }

    public static interface HasConditionalParamsStage {
        public HasRequiredLinkedAccountParamsStage hasConditionalParams(boolean var1);

        public Builder from(MetaResponse var1);
    }
}

