/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.ats.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import com.merge.api.resources.ats.types.Job;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class PaginatedJobList {
    private final Optional<String> next;
    private final Optional<String> previous;
    private final Optional<List<Job>> results;
    private final Map<String, Object> additionalProperties;

    private PaginatedJobList(Optional<String> next, Optional<String> previous, Optional<List<Job>> results, Map<String, Object> additionalProperties) {
        this.next = next;
        this.previous = previous;
        this.results = results;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="next")
    public Optional<String> getNext() {
        return this.next;
    }

    @JsonProperty(value="previous")
    public Optional<String> getPrevious() {
        return this.previous;
    }

    @JsonProperty(value="results")
    public Optional<List<Job>> getResults() {
        return this.results;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof PaginatedJobList && this.equalTo((PaginatedJobList)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(PaginatedJobList other) {
        return this.next.equals(other.next) && this.previous.equals(other.previous) && this.results.equals(other.results);
    }

    public int hashCode() {
        return Objects.hash(this.next, this.previous, this.results);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> next = Optional.empty();
        private Optional<String> previous = Optional.empty();
        private Optional<List<Job>> results = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(PaginatedJobList other) {
            this.next(other.getNext());
            this.previous(other.getPrevious());
            this.results(other.getResults());
            return this;
        }

        @JsonSetter(value="next", nulls=Nulls.SKIP)
        public Builder next(Optional<String> next) {
            this.next = next;
            return this;
        }

        public Builder next(String next) {
            this.next = Optional.of(next);
            return this;
        }

        @JsonSetter(value="previous", nulls=Nulls.SKIP)
        public Builder previous(Optional<String> previous) {
            this.previous = previous;
            return this;
        }

        public Builder previous(String previous) {
            this.previous = Optional.of(previous);
            return this;
        }

        @JsonSetter(value="results", nulls=Nulls.SKIP)
        public Builder results(Optional<List<Job>> results) {
            this.results = results;
            return this;
        }

        public Builder results(List<Job> results) {
            this.results = Optional.of(results);
            return this;
        }

        public PaginatedJobList build() {
            return new PaginatedJobList(this.next, this.previous, this.results, this.additionalProperties);
        }
    }
}

