/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.ats.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import com.merge.api.resources.ats.types.RemoteResponseResponseType;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class RemoteResponse {
    private final String method;
    private final String path;
    private final int status;
    private final JsonNode response;
    private final Optional<Map<String, JsonNode>> responseHeaders;
    private final Optional<RemoteResponseResponseType> responseType;
    private final Optional<Map<String, JsonNode>> headers;
    private final Map<String, Object> additionalProperties;

    private RemoteResponse(String method, String path, int status, JsonNode response, Optional<Map<String, JsonNode>> responseHeaders, Optional<RemoteResponseResponseType> responseType, Optional<Map<String, JsonNode>> headers, Map<String, Object> additionalProperties) {
        this.method = method;
        this.path = path;
        this.status = status;
        this.response = response;
        this.responseHeaders = responseHeaders;
        this.responseType = responseType;
        this.headers = headers;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="method")
    public String getMethod() {
        return this.method;
    }

    @JsonProperty(value="path")
    public String getPath() {
        return this.path;
    }

    @JsonProperty(value="status")
    public int getStatus() {
        return this.status;
    }

    @JsonProperty(value="response")
    public JsonNode getResponse() {
        return this.response;
    }

    @JsonProperty(value="response_headers")
    public Optional<Map<String, JsonNode>> getResponseHeaders() {
        return this.responseHeaders;
    }

    @JsonProperty(value="response_type")
    public Optional<RemoteResponseResponseType> getResponseType() {
        return this.responseType;
    }

    @JsonProperty(value="headers")
    public Optional<Map<String, JsonNode>> getHeaders() {
        return this.headers;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof RemoteResponse && this.equalTo((RemoteResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(RemoteResponse other) {
        return this.method.equals(other.method) && this.path.equals(other.path) && this.status == other.status && this.response.equals((Object)other.response) && this.responseHeaders.equals(other.responseHeaders) && this.responseType.equals(other.responseType) && this.headers.equals(other.headers);
    }

    public int hashCode() {
        return Objects.hash(this.method, this.path, this.status, this.response, this.responseHeaders, this.responseType, this.headers);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static MethodStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements MethodStage,
    PathStage,
    StatusStage,
    ResponseStage,
    _FinalStage {
        private String method;
        private String path;
        private int status;
        private JsonNode response;
        private Optional<Map<String, JsonNode>> headers = Optional.empty();
        private Optional<RemoteResponseResponseType> responseType = Optional.empty();
        private Optional<Map<String, JsonNode>> responseHeaders = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(RemoteResponse other) {
            this.method(other.getMethod());
            this.path(other.getPath());
            this.status(other.getStatus());
            this.response(other.getResponse());
            this.responseHeaders(other.getResponseHeaders());
            this.responseType(other.getResponseType());
            this.headers(other.getHeaders());
            return this;
        }

        @Override
        @JsonSetter(value="method")
        public PathStage method(String method) {
            this.method = method;
            return this;
        }

        @Override
        @JsonSetter(value="path")
        public StatusStage path(String path) {
            this.path = path;
            return this;
        }

        @Override
        @JsonSetter(value="status")
        public ResponseStage status(int status) {
            this.status = status;
            return this;
        }

        @Override
        @JsonSetter(value="response")
        public _FinalStage response(JsonNode response) {
            this.response = response;
            return this;
        }

        @Override
        public _FinalStage headers(Map<String, JsonNode> headers) {
            this.headers = Optional.of(headers);
            return this;
        }

        @Override
        @JsonSetter(value="headers", nulls=Nulls.SKIP)
        public _FinalStage headers(Optional<Map<String, JsonNode>> headers) {
            this.headers = headers;
            return this;
        }

        @Override
        public _FinalStage responseType(RemoteResponseResponseType responseType) {
            this.responseType = Optional.of(responseType);
            return this;
        }

        @Override
        @JsonSetter(value="response_type", nulls=Nulls.SKIP)
        public _FinalStage responseType(Optional<RemoteResponseResponseType> responseType) {
            this.responseType = responseType;
            return this;
        }

        @Override
        public _FinalStage responseHeaders(Map<String, JsonNode> responseHeaders) {
            this.responseHeaders = Optional.of(responseHeaders);
            return this;
        }

        @Override
        @JsonSetter(value="response_headers", nulls=Nulls.SKIP)
        public _FinalStage responseHeaders(Optional<Map<String, JsonNode>> responseHeaders) {
            this.responseHeaders = responseHeaders;
            return this;
        }

        @Override
        public RemoteResponse build() {
            return new RemoteResponse(this.method, this.path, this.status, this.response, this.responseHeaders, this.responseType, this.headers, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public RemoteResponse build();

        public _FinalStage responseHeaders(Optional<Map<String, JsonNode>> var1);

        public _FinalStage responseHeaders(Map<String, JsonNode> var1);

        public _FinalStage responseType(Optional<RemoteResponseResponseType> var1);

        public _FinalStage responseType(RemoteResponseResponseType var1);

        public _FinalStage headers(Optional<Map<String, JsonNode>> var1);

        public _FinalStage headers(Map<String, JsonNode> var1);
    }

    public static interface ResponseStage {
        public _FinalStage response(JsonNode var1);
    }

    public static interface StatusStage {
        public ResponseStage status(int var1);
    }

    public static interface PathStage {
        public StatusStage path(String var1);
    }

    public static interface MethodStage {
        public PathStage method(String var1);

        public Builder from(RemoteResponse var1);
    }
}

