/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.ats.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import com.merge.api.resources.ats.types.ScheduledInterviewRequestApplication;
import com.merge.api.resources.ats.types.ScheduledInterviewRequestInterviewersItem;
import com.merge.api.resources.ats.types.ScheduledInterviewRequestJobInterviewStage;
import com.merge.api.resources.ats.types.ScheduledInterviewRequestOrganizer;
import com.merge.api.resources.ats.types.ScheduledInterviewRequestStatus;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class ScheduledInterviewRequest {
    private final Optional<ScheduledInterviewRequestApplication> application;
    private final Optional<ScheduledInterviewRequestJobInterviewStage> jobInterviewStage;
    private final Optional<ScheduledInterviewRequestOrganizer> organizer;
    private final Optional<List<Optional<ScheduledInterviewRequestInterviewersItem>>> interviewers;
    private final Optional<String> location;
    private final Optional<OffsetDateTime> startAt;
    private final Optional<OffsetDateTime> endAt;
    private final Optional<ScheduledInterviewRequestStatus> status;
    private final Optional<Map<String, JsonNode>> integrationParams;
    private final Optional<Map<String, JsonNode>> linkedAccountParams;
    private final Map<String, Object> additionalProperties;

    private ScheduledInterviewRequest(Optional<ScheduledInterviewRequestApplication> application, Optional<ScheduledInterviewRequestJobInterviewStage> jobInterviewStage, Optional<ScheduledInterviewRequestOrganizer> organizer, Optional<List<Optional<ScheduledInterviewRequestInterviewersItem>>> interviewers, Optional<String> location, Optional<OffsetDateTime> startAt, Optional<OffsetDateTime> endAt, Optional<ScheduledInterviewRequestStatus> status, Optional<Map<String, JsonNode>> integrationParams, Optional<Map<String, JsonNode>> linkedAccountParams, Map<String, Object> additionalProperties) {
        this.application = application;
        this.jobInterviewStage = jobInterviewStage;
        this.organizer = organizer;
        this.interviewers = interviewers;
        this.location = location;
        this.startAt = startAt;
        this.endAt = endAt;
        this.status = status;
        this.integrationParams = integrationParams;
        this.linkedAccountParams = linkedAccountParams;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="application")
    public Optional<ScheduledInterviewRequestApplication> getApplication() {
        return this.application;
    }

    @JsonProperty(value="job_interview_stage")
    public Optional<ScheduledInterviewRequestJobInterviewStage> getJobInterviewStage() {
        return this.jobInterviewStage;
    }

    @JsonProperty(value="organizer")
    public Optional<ScheduledInterviewRequestOrganizer> getOrganizer() {
        return this.organizer;
    }

    @JsonProperty(value="interviewers")
    public Optional<List<Optional<ScheduledInterviewRequestInterviewersItem>>> getInterviewers() {
        return this.interviewers;
    }

    @JsonProperty(value="location")
    public Optional<String> getLocation() {
        return this.location;
    }

    @JsonProperty(value="start_at")
    public Optional<OffsetDateTime> getStartAt() {
        return this.startAt;
    }

    @JsonProperty(value="end_at")
    public Optional<OffsetDateTime> getEndAt() {
        return this.endAt;
    }

    @JsonProperty(value="status")
    public Optional<ScheduledInterviewRequestStatus> getStatus() {
        return this.status;
    }

    @JsonProperty(value="integration_params")
    public Optional<Map<String, JsonNode>> getIntegrationParams() {
        return this.integrationParams;
    }

    @JsonProperty(value="linked_account_params")
    public Optional<Map<String, JsonNode>> getLinkedAccountParams() {
        return this.linkedAccountParams;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ScheduledInterviewRequest && this.equalTo((ScheduledInterviewRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ScheduledInterviewRequest other) {
        return this.application.equals(other.application) && this.jobInterviewStage.equals(other.jobInterviewStage) && this.organizer.equals(other.organizer) && this.interviewers.equals(other.interviewers) && this.location.equals(other.location) && this.startAt.equals(other.startAt) && this.endAt.equals(other.endAt) && this.status.equals(other.status) && this.integrationParams.equals(other.integrationParams) && this.linkedAccountParams.equals(other.linkedAccountParams);
    }

    public int hashCode() {
        return Objects.hash(this.application, this.jobInterviewStage, this.organizer, this.interviewers, this.location, this.startAt, this.endAt, this.status, this.integrationParams, this.linkedAccountParams);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<ScheduledInterviewRequestApplication> application = Optional.empty();
        private Optional<ScheduledInterviewRequestJobInterviewStage> jobInterviewStage = Optional.empty();
        private Optional<ScheduledInterviewRequestOrganizer> organizer = Optional.empty();
        private Optional<List<Optional<ScheduledInterviewRequestInterviewersItem>>> interviewers = Optional.empty();
        private Optional<String> location = Optional.empty();
        private Optional<OffsetDateTime> startAt = Optional.empty();
        private Optional<OffsetDateTime> endAt = Optional.empty();
        private Optional<ScheduledInterviewRequestStatus> status = Optional.empty();
        private Optional<Map<String, JsonNode>> integrationParams = Optional.empty();
        private Optional<Map<String, JsonNode>> linkedAccountParams = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ScheduledInterviewRequest other) {
            this.application(other.getApplication());
            this.jobInterviewStage(other.getJobInterviewStage());
            this.organizer(other.getOrganizer());
            this.interviewers(other.getInterviewers());
            this.location(other.getLocation());
            this.startAt(other.getStartAt());
            this.endAt(other.getEndAt());
            this.status(other.getStatus());
            this.integrationParams(other.getIntegrationParams());
            this.linkedAccountParams(other.getLinkedAccountParams());
            return this;
        }

        @JsonSetter(value="application", nulls=Nulls.SKIP)
        public Builder application(Optional<ScheduledInterviewRequestApplication> application) {
            this.application = application;
            return this;
        }

        public Builder application(ScheduledInterviewRequestApplication application) {
            this.application = Optional.of(application);
            return this;
        }

        @JsonSetter(value="job_interview_stage", nulls=Nulls.SKIP)
        public Builder jobInterviewStage(Optional<ScheduledInterviewRequestJobInterviewStage> jobInterviewStage) {
            this.jobInterviewStage = jobInterviewStage;
            return this;
        }

        public Builder jobInterviewStage(ScheduledInterviewRequestJobInterviewStage jobInterviewStage) {
            this.jobInterviewStage = Optional.of(jobInterviewStage);
            return this;
        }

        @JsonSetter(value="organizer", nulls=Nulls.SKIP)
        public Builder organizer(Optional<ScheduledInterviewRequestOrganizer> organizer) {
            this.organizer = organizer;
            return this;
        }

        public Builder organizer(ScheduledInterviewRequestOrganizer organizer) {
            this.organizer = Optional.of(organizer);
            return this;
        }

        @JsonSetter(value="interviewers", nulls=Nulls.SKIP)
        public Builder interviewers(Optional<List<Optional<ScheduledInterviewRequestInterviewersItem>>> interviewers) {
            this.interviewers = interviewers;
            return this;
        }

        public Builder interviewers(List<Optional<ScheduledInterviewRequestInterviewersItem>> interviewers) {
            this.interviewers = Optional.of(interviewers);
            return this;
        }

        @JsonSetter(value="location", nulls=Nulls.SKIP)
        public Builder location(Optional<String> location) {
            this.location = location;
            return this;
        }

        public Builder location(String location) {
            this.location = Optional.of(location);
            return this;
        }

        @JsonSetter(value="start_at", nulls=Nulls.SKIP)
        public Builder startAt(Optional<OffsetDateTime> startAt) {
            this.startAt = startAt;
            return this;
        }

        public Builder startAt(OffsetDateTime startAt) {
            this.startAt = Optional.of(startAt);
            return this;
        }

        @JsonSetter(value="end_at", nulls=Nulls.SKIP)
        public Builder endAt(Optional<OffsetDateTime> endAt) {
            this.endAt = endAt;
            return this;
        }

        public Builder endAt(OffsetDateTime endAt) {
            this.endAt = Optional.of(endAt);
            return this;
        }

        @JsonSetter(value="status", nulls=Nulls.SKIP)
        public Builder status(Optional<ScheduledInterviewRequestStatus> status) {
            this.status = status;
            return this;
        }

        public Builder status(ScheduledInterviewRequestStatus status) {
            this.status = Optional.of(status);
            return this;
        }

        @JsonSetter(value="integration_params", nulls=Nulls.SKIP)
        public Builder integrationParams(Optional<Map<String, JsonNode>> integrationParams) {
            this.integrationParams = integrationParams;
            return this;
        }

        public Builder integrationParams(Map<String, JsonNode> integrationParams) {
            this.integrationParams = Optional.of(integrationParams);
            return this;
        }

        @JsonSetter(value="linked_account_params", nulls=Nulls.SKIP)
        public Builder linkedAccountParams(Optional<Map<String, JsonNode>> linkedAccountParams) {
            this.linkedAccountParams = linkedAccountParams;
            return this;
        }

        public Builder linkedAccountParams(Map<String, JsonNode> linkedAccountParams) {
            this.linkedAccountParams = Optional.of(linkedAccountParams);
            return this;
        }

        public ScheduledInterviewRequest build() {
            return new ScheduledInterviewRequest(this.application, this.jobInterviewStage, this.organizer, this.interviewers, this.location, this.startAt, this.endAt, this.status, this.integrationParams, this.linkedAccountParams, this.additionalProperties);
        }
    }
}

