/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.ats.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import com.merge.api.resources.ats.types.RemoteData;
import com.merge.api.resources.ats.types.ScorecardApplication;
import com.merge.api.resources.ats.types.ScorecardInterview;
import com.merge.api.resources.ats.types.ScorecardInterviewer;
import com.merge.api.resources.ats.types.ScorecardOverallRecommendation;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class Scorecard {
    private final Optional<String> id;
    private final Optional<String> remoteId;
    private final Optional<OffsetDateTime> createdAt;
    private final Optional<OffsetDateTime> modifiedAt;
    private final Optional<ScorecardApplication> application;
    private final Optional<ScorecardInterview> interview;
    private final Optional<ScorecardInterviewer> interviewer;
    private final Optional<OffsetDateTime> remoteCreatedAt;
    private final Optional<OffsetDateTime> submittedAt;
    private final Optional<ScorecardOverallRecommendation> overallRecommendation;
    private final Optional<Boolean> remoteWasDeleted;
    private final Optional<Map<String, JsonNode>> fieldMappings;
    private final Optional<List<RemoteData>> remoteData;
    private final Map<String, Object> additionalProperties;

    private Scorecard(Optional<String> id, Optional<String> remoteId, Optional<OffsetDateTime> createdAt, Optional<OffsetDateTime> modifiedAt, Optional<ScorecardApplication> application, Optional<ScorecardInterview> interview, Optional<ScorecardInterviewer> interviewer, Optional<OffsetDateTime> remoteCreatedAt, Optional<OffsetDateTime> submittedAt, Optional<ScorecardOverallRecommendation> overallRecommendation, Optional<Boolean> remoteWasDeleted, Optional<Map<String, JsonNode>> fieldMappings, Optional<List<RemoteData>> remoteData, Map<String, Object> additionalProperties) {
        this.id = id;
        this.remoteId = remoteId;
        this.createdAt = createdAt;
        this.modifiedAt = modifiedAt;
        this.application = application;
        this.interview = interview;
        this.interviewer = interviewer;
        this.remoteCreatedAt = remoteCreatedAt;
        this.submittedAt = submittedAt;
        this.overallRecommendation = overallRecommendation;
        this.remoteWasDeleted = remoteWasDeleted;
        this.fieldMappings = fieldMappings;
        this.remoteData = remoteData;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="remote_id")
    public Optional<String> getRemoteId() {
        return this.remoteId;
    }

    @JsonProperty(value="created_at")
    public Optional<OffsetDateTime> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="modified_at")
    public Optional<OffsetDateTime> getModifiedAt() {
        return this.modifiedAt;
    }

    @JsonProperty(value="application")
    public Optional<ScorecardApplication> getApplication() {
        return this.application;
    }

    @JsonProperty(value="interview")
    public Optional<ScorecardInterview> getInterview() {
        return this.interview;
    }

    @JsonProperty(value="interviewer")
    public Optional<ScorecardInterviewer> getInterviewer() {
        return this.interviewer;
    }

    @JsonProperty(value="remote_created_at")
    public Optional<OffsetDateTime> getRemoteCreatedAt() {
        return this.remoteCreatedAt;
    }

    @JsonProperty(value="submitted_at")
    public Optional<OffsetDateTime> getSubmittedAt() {
        return this.submittedAt;
    }

    @JsonProperty(value="overall_recommendation")
    public Optional<ScorecardOverallRecommendation> getOverallRecommendation() {
        return this.overallRecommendation;
    }

    @JsonProperty(value="remote_was_deleted")
    public Optional<Boolean> getRemoteWasDeleted() {
        return this.remoteWasDeleted;
    }

    @JsonProperty(value="field_mappings")
    public Optional<Map<String, JsonNode>> getFieldMappings() {
        return this.fieldMappings;
    }

    @JsonProperty(value="remote_data")
    public Optional<List<RemoteData>> getRemoteData() {
        return this.remoteData;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Scorecard && this.equalTo((Scorecard)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Scorecard other) {
        return this.id.equals(other.id) && this.remoteId.equals(other.remoteId) && this.createdAt.equals(other.createdAt) && this.modifiedAt.equals(other.modifiedAt) && this.application.equals(other.application) && this.interview.equals(other.interview) && this.interviewer.equals(other.interviewer) && this.remoteCreatedAt.equals(other.remoteCreatedAt) && this.submittedAt.equals(other.submittedAt) && this.overallRecommendation.equals(other.overallRecommendation) && this.remoteWasDeleted.equals(other.remoteWasDeleted) && this.fieldMappings.equals(other.fieldMappings) && this.remoteData.equals(other.remoteData);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.remoteId, this.createdAt, this.modifiedAt, this.application, this.interview, this.interviewer, this.remoteCreatedAt, this.submittedAt, this.overallRecommendation, this.remoteWasDeleted, this.fieldMappings, this.remoteData);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> id = Optional.empty();
        private Optional<String> remoteId = Optional.empty();
        private Optional<OffsetDateTime> createdAt = Optional.empty();
        private Optional<OffsetDateTime> modifiedAt = Optional.empty();
        private Optional<ScorecardApplication> application = Optional.empty();
        private Optional<ScorecardInterview> interview = Optional.empty();
        private Optional<ScorecardInterviewer> interviewer = Optional.empty();
        private Optional<OffsetDateTime> remoteCreatedAt = Optional.empty();
        private Optional<OffsetDateTime> submittedAt = Optional.empty();
        private Optional<ScorecardOverallRecommendation> overallRecommendation = Optional.empty();
        private Optional<Boolean> remoteWasDeleted = Optional.empty();
        private Optional<Map<String, JsonNode>> fieldMappings = Optional.empty();
        private Optional<List<RemoteData>> remoteData = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(Scorecard other) {
            this.id(other.getId());
            this.remoteId(other.getRemoteId());
            this.createdAt(other.getCreatedAt());
            this.modifiedAt(other.getModifiedAt());
            this.application(other.getApplication());
            this.interview(other.getInterview());
            this.interviewer(other.getInterviewer());
            this.remoteCreatedAt(other.getRemoteCreatedAt());
            this.submittedAt(other.getSubmittedAt());
            this.overallRecommendation(other.getOverallRecommendation());
            this.remoteWasDeleted(other.getRemoteWasDeleted());
            this.fieldMappings(other.getFieldMappings());
            this.remoteData(other.getRemoteData());
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.of(id);
            return this;
        }

        @JsonSetter(value="remote_id", nulls=Nulls.SKIP)
        public Builder remoteId(Optional<String> remoteId) {
            this.remoteId = remoteId;
            return this;
        }

        public Builder remoteId(String remoteId) {
            this.remoteId = Optional.of(remoteId);
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<OffsetDateTime> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(OffsetDateTime createdAt) {
            this.createdAt = Optional.of(createdAt);
            return this;
        }

        @JsonSetter(value="modified_at", nulls=Nulls.SKIP)
        public Builder modifiedAt(Optional<OffsetDateTime> modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public Builder modifiedAt(OffsetDateTime modifiedAt) {
            this.modifiedAt = Optional.of(modifiedAt);
            return this;
        }

        @JsonSetter(value="application", nulls=Nulls.SKIP)
        public Builder application(Optional<ScorecardApplication> application) {
            this.application = application;
            return this;
        }

        public Builder application(ScorecardApplication application) {
            this.application = Optional.of(application);
            return this;
        }

        @JsonSetter(value="interview", nulls=Nulls.SKIP)
        public Builder interview(Optional<ScorecardInterview> interview) {
            this.interview = interview;
            return this;
        }

        public Builder interview(ScorecardInterview interview) {
            this.interview = Optional.of(interview);
            return this;
        }

        @JsonSetter(value="interviewer", nulls=Nulls.SKIP)
        public Builder interviewer(Optional<ScorecardInterviewer> interviewer) {
            this.interviewer = interviewer;
            return this;
        }

        public Builder interviewer(ScorecardInterviewer interviewer) {
            this.interviewer = Optional.of(interviewer);
            return this;
        }

        @JsonSetter(value="remote_created_at", nulls=Nulls.SKIP)
        public Builder remoteCreatedAt(Optional<OffsetDateTime> remoteCreatedAt) {
            this.remoteCreatedAt = remoteCreatedAt;
            return this;
        }

        public Builder remoteCreatedAt(OffsetDateTime remoteCreatedAt) {
            this.remoteCreatedAt = Optional.of(remoteCreatedAt);
            return this;
        }

        @JsonSetter(value="submitted_at", nulls=Nulls.SKIP)
        public Builder submittedAt(Optional<OffsetDateTime> submittedAt) {
            this.submittedAt = submittedAt;
            return this;
        }

        public Builder submittedAt(OffsetDateTime submittedAt) {
            this.submittedAt = Optional.of(submittedAt);
            return this;
        }

        @JsonSetter(value="overall_recommendation", nulls=Nulls.SKIP)
        public Builder overallRecommendation(Optional<ScorecardOverallRecommendation> overallRecommendation) {
            this.overallRecommendation = overallRecommendation;
            return this;
        }

        public Builder overallRecommendation(ScorecardOverallRecommendation overallRecommendation) {
            this.overallRecommendation = Optional.of(overallRecommendation);
            return this;
        }

        @JsonSetter(value="remote_was_deleted", nulls=Nulls.SKIP)
        public Builder remoteWasDeleted(Optional<Boolean> remoteWasDeleted) {
            this.remoteWasDeleted = remoteWasDeleted;
            return this;
        }

        public Builder remoteWasDeleted(Boolean remoteWasDeleted) {
            this.remoteWasDeleted = Optional.of(remoteWasDeleted);
            return this;
        }

        @JsonSetter(value="field_mappings", nulls=Nulls.SKIP)
        public Builder fieldMappings(Optional<Map<String, JsonNode>> fieldMappings) {
            this.fieldMappings = fieldMappings;
            return this;
        }

        public Builder fieldMappings(Map<String, JsonNode> fieldMappings) {
            this.fieldMappings = Optional.of(fieldMappings);
            return this;
        }

        @JsonSetter(value="remote_data", nulls=Nulls.SKIP)
        public Builder remoteData(Optional<List<RemoteData>> remoteData) {
            this.remoteData = remoteData;
            return this;
        }

        public Builder remoteData(List<RemoteData> remoteData) {
            this.remoteData = Optional.of(remoteData);
            return this;
        }

        public Scorecard build() {
            return new Scorecard(this.id, this.remoteId, this.createdAt, this.modifiedAt, this.application, this.interview, this.interviewer, this.remoteCreatedAt, this.submittedAt, this.overallRecommendation, this.remoteWasDeleted, this.fieldMappings, this.remoteData, this.additionalProperties);
        }
    }
}

