/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.ats.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import com.merge.api.resources.ats.types.ScreeningQuestionJob;
import com.merge.api.resources.ats.types.ScreeningQuestionType;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class ScreeningQuestion {
    private final Optional<String> id;
    private final Optional<String> remoteId;
    private final Optional<OffsetDateTime> createdAt;
    private final Optional<OffsetDateTime> modifiedAt;
    private final Optional<ScreeningQuestionJob> job;
    private final Optional<String> description;
    private final Optional<String> title;
    private final Optional<ScreeningQuestionType> type;
    private final Optional<Boolean> required;
    private final Optional<List<JsonNode>> options;
    private final Optional<Boolean> remoteWasDeleted;
    private final Map<String, Object> additionalProperties;

    private ScreeningQuestion(Optional<String> id, Optional<String> remoteId, Optional<OffsetDateTime> createdAt, Optional<OffsetDateTime> modifiedAt, Optional<ScreeningQuestionJob> job, Optional<String> description, Optional<String> title, Optional<ScreeningQuestionType> type, Optional<Boolean> required, Optional<List<JsonNode>> options, Optional<Boolean> remoteWasDeleted, Map<String, Object> additionalProperties) {
        this.id = id;
        this.remoteId = remoteId;
        this.createdAt = createdAt;
        this.modifiedAt = modifiedAt;
        this.job = job;
        this.description = description;
        this.title = title;
        this.type = type;
        this.required = required;
        this.options = options;
        this.remoteWasDeleted = remoteWasDeleted;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="remote_id")
    public Optional<String> getRemoteId() {
        return this.remoteId;
    }

    @JsonProperty(value="created_at")
    public Optional<OffsetDateTime> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="modified_at")
    public Optional<OffsetDateTime> getModifiedAt() {
        return this.modifiedAt;
    }

    @JsonProperty(value="job")
    public Optional<ScreeningQuestionJob> getJob() {
        return this.job;
    }

    @JsonProperty(value="description")
    public Optional<String> getDescription() {
        return this.description;
    }

    @JsonProperty(value="title")
    public Optional<String> getTitle() {
        return this.title;
    }

    @JsonProperty(value="type")
    public Optional<ScreeningQuestionType> getType() {
        return this.type;
    }

    @JsonProperty(value="required")
    public Optional<Boolean> getRequired() {
        return this.required;
    }

    @JsonProperty(value="options")
    public Optional<List<JsonNode>> getOptions() {
        return this.options;
    }

    @JsonProperty(value="remote_was_deleted")
    public Optional<Boolean> getRemoteWasDeleted() {
        return this.remoteWasDeleted;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ScreeningQuestion && this.equalTo((ScreeningQuestion)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ScreeningQuestion other) {
        return this.id.equals(other.id) && this.remoteId.equals(other.remoteId) && this.createdAt.equals(other.createdAt) && this.modifiedAt.equals(other.modifiedAt) && this.job.equals(other.job) && this.description.equals(other.description) && this.title.equals(other.title) && this.type.equals(other.type) && this.required.equals(other.required) && this.options.equals(other.options) && this.remoteWasDeleted.equals(other.remoteWasDeleted);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.remoteId, this.createdAt, this.modifiedAt, this.job, this.description, this.title, this.type, this.required, this.options, this.remoteWasDeleted);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> id = Optional.empty();
        private Optional<String> remoteId = Optional.empty();
        private Optional<OffsetDateTime> createdAt = Optional.empty();
        private Optional<OffsetDateTime> modifiedAt = Optional.empty();
        private Optional<ScreeningQuestionJob> job = Optional.empty();
        private Optional<String> description = Optional.empty();
        private Optional<String> title = Optional.empty();
        private Optional<ScreeningQuestionType> type = Optional.empty();
        private Optional<Boolean> required = Optional.empty();
        private Optional<List<JsonNode>> options = Optional.empty();
        private Optional<Boolean> remoteWasDeleted = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ScreeningQuestion other) {
            this.id(other.getId());
            this.remoteId(other.getRemoteId());
            this.createdAt(other.getCreatedAt());
            this.modifiedAt(other.getModifiedAt());
            this.job(other.getJob());
            this.description(other.getDescription());
            this.title(other.getTitle());
            this.type(other.getType());
            this.required(other.getRequired());
            this.options(other.getOptions());
            this.remoteWasDeleted(other.getRemoteWasDeleted());
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.of(id);
            return this;
        }

        @JsonSetter(value="remote_id", nulls=Nulls.SKIP)
        public Builder remoteId(Optional<String> remoteId) {
            this.remoteId = remoteId;
            return this;
        }

        public Builder remoteId(String remoteId) {
            this.remoteId = Optional.of(remoteId);
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<OffsetDateTime> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(OffsetDateTime createdAt) {
            this.createdAt = Optional.of(createdAt);
            return this;
        }

        @JsonSetter(value="modified_at", nulls=Nulls.SKIP)
        public Builder modifiedAt(Optional<OffsetDateTime> modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public Builder modifiedAt(OffsetDateTime modifiedAt) {
            this.modifiedAt = Optional.of(modifiedAt);
            return this;
        }

        @JsonSetter(value="job", nulls=Nulls.SKIP)
        public Builder job(Optional<ScreeningQuestionJob> job) {
            this.job = job;
            return this;
        }

        public Builder job(ScreeningQuestionJob job) {
            this.job = Optional.of(job);
            return this;
        }

        @JsonSetter(value="description", nulls=Nulls.SKIP)
        public Builder description(Optional<String> description) {
            this.description = description;
            return this;
        }

        public Builder description(String description) {
            this.description = Optional.of(description);
            return this;
        }

        @JsonSetter(value="title", nulls=Nulls.SKIP)
        public Builder title(Optional<String> title) {
            this.title = title;
            return this;
        }

        public Builder title(String title) {
            this.title = Optional.of(title);
            return this;
        }

        @JsonSetter(value="type", nulls=Nulls.SKIP)
        public Builder type(Optional<ScreeningQuestionType> type) {
            this.type = type;
            return this;
        }

        public Builder type(ScreeningQuestionType type) {
            this.type = Optional.of(type);
            return this;
        }

        @JsonSetter(value="required", nulls=Nulls.SKIP)
        public Builder required(Optional<Boolean> required) {
            this.required = required;
            return this;
        }

        public Builder required(Boolean required) {
            this.required = Optional.of(required);
            return this;
        }

        @JsonSetter(value="options", nulls=Nulls.SKIP)
        public Builder options(Optional<List<JsonNode>> options) {
            this.options = options;
            return this;
        }

        public Builder options(List<JsonNode> options) {
            this.options = Optional.of(options);
            return this;
        }

        @JsonSetter(value="remote_was_deleted", nulls=Nulls.SKIP)
        public Builder remoteWasDeleted(Optional<Boolean> remoteWasDeleted) {
            this.remoteWasDeleted = remoteWasDeleted;
            return this;
        }

        public Builder remoteWasDeleted(Boolean remoteWasDeleted) {
            this.remoteWasDeleted = Optional.of(remoteWasDeleted);
            return this;
        }

        public ScreeningQuestion build() {
            return new ScreeningQuestion(this.id, this.remoteId, this.createdAt, this.modifiedAt, this.job, this.description, this.title, this.type, this.required, this.options, this.remoteWasDeleted, this.additionalProperties);
        }
    }
}

