/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.crm.associationtypes;

import com.merge.api.core.ApiError;
import com.merge.api.core.ClientOptions;
import com.merge.api.core.MediaTypes;
import com.merge.api.core.MergeException;
import com.merge.api.core.ObjectMappers;
import com.merge.api.core.RequestOptions;
import com.merge.api.resources.crm.associationtypes.requests.CrmAssociationTypeEndpointRequest;
import com.merge.api.resources.crm.associationtypes.requests.CustomObjectClassesAssociationTypesListRequest;
import com.merge.api.resources.crm.associationtypes.requests.CustomObjectClassesAssociationTypesRetrieveRequest;
import com.merge.api.resources.crm.types.AssociationType;
import com.merge.api.resources.crm.types.AssociationTypeRequestRequest;
import com.merge.api.resources.crm.types.CrmAssociationTypeResponse;
import com.merge.api.resources.crm.types.MetaResponse;
import com.merge.api.resources.crm.types.PaginatedAssociationTypeList;
import java.io.IOException;
import java.util.HashMap;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class AssociationTypesClient {
    protected final ClientOptions clientOptions;

    public AssociationTypesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public PaginatedAssociationTypeList customObjectClassesAssociationTypesList(String customObjectClassId) {
        return this.customObjectClassesAssociationTypesList(customObjectClassId, CustomObjectClassesAssociationTypesListRequest.builder().build());
    }

    public PaginatedAssociationTypeList customObjectClassesAssociationTypesList(String customObjectClassId, CustomObjectClassesAssociationTypesListRequest request) {
        return this.customObjectClassesAssociationTypesList(customObjectClassId, request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PaginatedAssociationTypeList customObjectClassesAssociationTypesList(String customObjectClassId, CustomObjectClassesAssociationTypesListRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("crm/v1/custom-object-classes").addPathSegment(customObjectClassId).addPathSegments("association-types");
        if (request.getCreatedAfter().isPresent()) {
            httpUrl.addQueryParameter("created_after", request.getCreatedAfter().get().toString());
        }
        if (request.getCreatedBefore().isPresent()) {
            httpUrl.addQueryParameter("created_before", request.getCreatedBefore().get().toString());
        }
        if (request.getCursor().isPresent()) {
            httpUrl.addQueryParameter("cursor", request.getCursor().get());
        }
        if (request.getExpand().isPresent()) {
            httpUrl.addQueryParameter("expand", request.getExpand().get());
        }
        if (request.getIncludeDeletedData().isPresent()) {
            httpUrl.addQueryParameter("include_deleted_data", request.getIncludeDeletedData().get().toString());
        }
        if (request.getIncludeRemoteData().isPresent()) {
            httpUrl.addQueryParameter("include_remote_data", request.getIncludeRemoteData().get().toString());
        }
        if (request.getIncludeShellData().isPresent()) {
            httpUrl.addQueryParameter("include_shell_data", request.getIncludeShellData().get().toString());
        }
        if (request.getModifiedAfter().isPresent()) {
            httpUrl.addQueryParameter("modified_after", request.getModifiedAfter().get().toString());
        }
        if (request.getModifiedBefore().isPresent()) {
            httpUrl.addQueryParameter("modified_before", request.getModifiedBefore().get().toString());
        }
        if (request.getPageSize().isPresent()) {
            httpUrl.addQueryParameter("page_size", request.getPageSize().get().toString());
        }
        if (request.getRemoteId().isPresent()) {
            httpUrl.addQueryParameter("remote_id", request.getRemoteId().get());
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                PaginatedAssociationTypeList paginatedAssociationTypeList = (PaginatedAssociationTypeList)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), PaginatedAssociationTypeList.class);
                return paginatedAssociationTypeList;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new ApiError("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new MergeException("Network error executing HTTP request", e);
        }
    }

    public CrmAssociationTypeResponse customObjectClassesAssociationTypesCreate(String customObjectClassId, CrmAssociationTypeEndpointRequest request) {
        return this.customObjectClassesAssociationTypesCreate(customObjectClassId, request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CrmAssociationTypeResponse customObjectClassesAssociationTypesCreate(String customObjectClassId, CrmAssociationTypeEndpointRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("crm/v1/custom-object-classes").addPathSegment(customObjectClassId).addPathSegments("association-types");
        if (request.getIsDebugMode().isPresent()) {
            httpUrl.addQueryParameter("is_debug_mode", request.getIsDebugMode().get().toString());
        }
        if (request.getRunAsync().isPresent()) {
            httpUrl.addQueryParameter("run_async", request.getRunAsync().get().toString());
        }
        HashMap<String, AssociationTypeRequestRequest> properties = new HashMap<String, AssociationTypeRequestRequest>();
        properties.put("model", request.getModel());
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes(properties), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                CrmAssociationTypeResponse crmAssociationTypeResponse = (CrmAssociationTypeResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), CrmAssociationTypeResponse.class);
                return crmAssociationTypeResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new ApiError("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new MergeException("Network error executing HTTP request", e);
        }
    }

    public AssociationType customObjectClassesAssociationTypesRetrieve(String customObjectClassId, String id) {
        return this.customObjectClassesAssociationTypesRetrieve(customObjectClassId, id, CustomObjectClassesAssociationTypesRetrieveRequest.builder().build());
    }

    public AssociationType customObjectClassesAssociationTypesRetrieve(String customObjectClassId, String id, CustomObjectClassesAssociationTypesRetrieveRequest request) {
        return this.customObjectClassesAssociationTypesRetrieve(customObjectClassId, id, request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AssociationType customObjectClassesAssociationTypesRetrieve(String customObjectClassId, String id, CustomObjectClassesAssociationTypesRetrieveRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("crm/v1/custom-object-classes").addPathSegment(customObjectClassId).addPathSegments("association-types").addPathSegment(id);
        if (request.getExpand().isPresent()) {
            httpUrl.addQueryParameter("expand", request.getExpand().get());
        }
        if (request.getIncludeRemoteData().isPresent()) {
            httpUrl.addQueryParameter("include_remote_data", request.getIncludeRemoteData().get().toString());
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                AssociationType associationType = (AssociationType)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), AssociationType.class);
                return associationType;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new ApiError("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new MergeException("Network error executing HTTP request", e);
        }
    }

    public MetaResponse customObjectClassesAssociationTypesMetaPostRetrieve(String customObjectClassId) {
        return this.customObjectClassesAssociationTypesMetaPostRetrieve(customObjectClassId, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MetaResponse customObjectClassesAssociationTypesMetaPostRetrieve(String customObjectClassId, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("crm/v1/custom-object-classes").addPathSegment(customObjectClassId).addPathSegments("association-types/meta/post").build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                MetaResponse metaResponse = (MetaResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), MetaResponse.class);
                return metaResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new ApiError("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new MergeException("Network error executing HTTP request", e);
        }
    }
}

