/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.crm.fieldmapping.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class PatchedEditFieldMappingRequest {
    private final Optional<List<JsonNode>> remoteFieldTraversalPath;
    private final Optional<String> remoteMethod;
    private final Optional<String> remoteUrlPath;
    private final Map<String, Object> additionalProperties;

    private PatchedEditFieldMappingRequest(Optional<List<JsonNode>> remoteFieldTraversalPath, Optional<String> remoteMethod, Optional<String> remoteUrlPath, Map<String, Object> additionalProperties) {
        this.remoteFieldTraversalPath = remoteFieldTraversalPath;
        this.remoteMethod = remoteMethod;
        this.remoteUrlPath = remoteUrlPath;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="remote_field_traversal_path")
    public Optional<List<JsonNode>> getRemoteFieldTraversalPath() {
        return this.remoteFieldTraversalPath;
    }

    @JsonProperty(value="remote_method")
    public Optional<String> getRemoteMethod() {
        return this.remoteMethod;
    }

    @JsonProperty(value="remote_url_path")
    public Optional<String> getRemoteUrlPath() {
        return this.remoteUrlPath;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof PatchedEditFieldMappingRequest && this.equalTo((PatchedEditFieldMappingRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(PatchedEditFieldMappingRequest other) {
        return this.remoteFieldTraversalPath.equals(other.remoteFieldTraversalPath) && this.remoteMethod.equals(other.remoteMethod) && this.remoteUrlPath.equals(other.remoteUrlPath);
    }

    public int hashCode() {
        return Objects.hash(this.remoteFieldTraversalPath, this.remoteMethod, this.remoteUrlPath);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<JsonNode>> remoteFieldTraversalPath = Optional.empty();
        private Optional<String> remoteMethod = Optional.empty();
        private Optional<String> remoteUrlPath = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(PatchedEditFieldMappingRequest other) {
            this.remoteFieldTraversalPath(other.getRemoteFieldTraversalPath());
            this.remoteMethod(other.getRemoteMethod());
            this.remoteUrlPath(other.getRemoteUrlPath());
            return this;
        }

        @JsonSetter(value="remote_field_traversal_path", nulls=Nulls.SKIP)
        public Builder remoteFieldTraversalPath(Optional<List<JsonNode>> remoteFieldTraversalPath) {
            this.remoteFieldTraversalPath = remoteFieldTraversalPath;
            return this;
        }

        public Builder remoteFieldTraversalPath(List<JsonNode> remoteFieldTraversalPath) {
            this.remoteFieldTraversalPath = Optional.of(remoteFieldTraversalPath);
            return this;
        }

        @JsonSetter(value="remote_method", nulls=Nulls.SKIP)
        public Builder remoteMethod(Optional<String> remoteMethod) {
            this.remoteMethod = remoteMethod;
            return this;
        }

        public Builder remoteMethod(String remoteMethod) {
            this.remoteMethod = Optional.of(remoteMethod);
            return this;
        }

        @JsonSetter(value="remote_url_path", nulls=Nulls.SKIP)
        public Builder remoteUrlPath(Optional<String> remoteUrlPath) {
            this.remoteUrlPath = remoteUrlPath;
            return this;
        }

        public Builder remoteUrlPath(String remoteUrlPath) {
            this.remoteUrlPath = Optional.of(remoteUrlPath);
            return this;
        }

        public PatchedEditFieldMappingRequest build() {
            return new PatchedEditFieldMappingRequest(this.remoteFieldTraversalPath, this.remoteMethod, this.remoteUrlPath, this.additionalProperties);
        }
    }
}

