/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.crm.forceresync;

import com.fasterxml.jackson.core.type.TypeReference;
import com.merge.api.core.ApiError;
import com.merge.api.core.ClientOptions;
import com.merge.api.core.MergeException;
import com.merge.api.core.ObjectMappers;
import com.merge.api.core.RequestOptions;
import com.merge.api.resources.crm.types.SyncStatus;
import java.io.IOException;
import java.util.List;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class ForceResyncClient {
    protected final ClientOptions clientOptions;

    public ForceResyncClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public List<SyncStatus> syncStatusResyncCreate() {
        return this.syncStatusResyncCreate(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<SyncStatus> syncStatusResyncCreate(RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("crm/v1/sync-status/resync").build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", RequestBody.create((String)"", null)).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                List list = (List)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), (TypeReference)new TypeReference<List<SyncStatus>>(){});
                return list;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new ApiError("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new MergeException("Network error executing HTTP request", e);
        }
    }
}

