/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.crm.leads.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import com.merge.api.resources.crm.leads.types.LeadsListRequestExpand;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class LeadsListRequest {
    private final Optional<String> convertedAccountId;
    private final Optional<String> convertedContactId;
    private final Optional<OffsetDateTime> createdAfter;
    private final Optional<OffsetDateTime> createdBefore;
    private final Optional<String> cursor;
    private final Optional<String> emailAddresses;
    private final Optional<LeadsListRequestExpand> expand;
    private final Optional<Boolean> includeDeletedData;
    private final Optional<Boolean> includeRemoteData;
    private final Optional<Boolean> includeRemoteFields;
    private final Optional<Boolean> includeShellData;
    private final Optional<OffsetDateTime> modifiedAfter;
    private final Optional<OffsetDateTime> modifiedBefore;
    private final Optional<String> ownerId;
    private final Optional<Integer> pageSize;
    private final Optional<String> phoneNumbers;
    private final Optional<String> remoteId;
    private final Map<String, Object> additionalProperties;

    private LeadsListRequest(Optional<String> convertedAccountId, Optional<String> convertedContactId, Optional<OffsetDateTime> createdAfter, Optional<OffsetDateTime> createdBefore, Optional<String> cursor, Optional<String> emailAddresses, Optional<LeadsListRequestExpand> expand, Optional<Boolean> includeDeletedData, Optional<Boolean> includeRemoteData, Optional<Boolean> includeRemoteFields, Optional<Boolean> includeShellData, Optional<OffsetDateTime> modifiedAfter, Optional<OffsetDateTime> modifiedBefore, Optional<String> ownerId, Optional<Integer> pageSize, Optional<String> phoneNumbers, Optional<String> remoteId, Map<String, Object> additionalProperties) {
        this.convertedAccountId = convertedAccountId;
        this.convertedContactId = convertedContactId;
        this.createdAfter = createdAfter;
        this.createdBefore = createdBefore;
        this.cursor = cursor;
        this.emailAddresses = emailAddresses;
        this.expand = expand;
        this.includeDeletedData = includeDeletedData;
        this.includeRemoteData = includeRemoteData;
        this.includeRemoteFields = includeRemoteFields;
        this.includeShellData = includeShellData;
        this.modifiedAfter = modifiedAfter;
        this.modifiedBefore = modifiedBefore;
        this.ownerId = ownerId;
        this.pageSize = pageSize;
        this.phoneNumbers = phoneNumbers;
        this.remoteId = remoteId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="converted_account_id")
    public Optional<String> getConvertedAccountId() {
        return this.convertedAccountId;
    }

    @JsonProperty(value="converted_contact_id")
    public Optional<String> getConvertedContactId() {
        return this.convertedContactId;
    }

    @JsonProperty(value="created_after")
    public Optional<OffsetDateTime> getCreatedAfter() {
        return this.createdAfter;
    }

    @JsonProperty(value="created_before")
    public Optional<OffsetDateTime> getCreatedBefore() {
        return this.createdBefore;
    }

    @JsonProperty(value="cursor")
    public Optional<String> getCursor() {
        return this.cursor;
    }

    @JsonProperty(value="email_addresses")
    public Optional<String> getEmailAddresses() {
        return this.emailAddresses;
    }

    @JsonProperty(value="expand")
    public Optional<LeadsListRequestExpand> getExpand() {
        return this.expand;
    }

    @JsonProperty(value="include_deleted_data")
    public Optional<Boolean> getIncludeDeletedData() {
        return this.includeDeletedData;
    }

    @JsonProperty(value="include_remote_data")
    public Optional<Boolean> getIncludeRemoteData() {
        return this.includeRemoteData;
    }

    @JsonProperty(value="include_remote_fields")
    public Optional<Boolean> getIncludeRemoteFields() {
        return this.includeRemoteFields;
    }

    @JsonProperty(value="include_shell_data")
    public Optional<Boolean> getIncludeShellData() {
        return this.includeShellData;
    }

    @JsonProperty(value="modified_after")
    public Optional<OffsetDateTime> getModifiedAfter() {
        return this.modifiedAfter;
    }

    @JsonProperty(value="modified_before")
    public Optional<OffsetDateTime> getModifiedBefore() {
        return this.modifiedBefore;
    }

    @JsonProperty(value="owner_id")
    public Optional<String> getOwnerId() {
        return this.ownerId;
    }

    @JsonProperty(value="page_size")
    public Optional<Integer> getPageSize() {
        return this.pageSize;
    }

    @JsonProperty(value="phone_numbers")
    public Optional<String> getPhoneNumbers() {
        return this.phoneNumbers;
    }

    @JsonProperty(value="remote_id")
    public Optional<String> getRemoteId() {
        return this.remoteId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof LeadsListRequest && this.equalTo((LeadsListRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(LeadsListRequest other) {
        return this.convertedAccountId.equals(other.convertedAccountId) && this.convertedContactId.equals(other.convertedContactId) && this.createdAfter.equals(other.createdAfter) && this.createdBefore.equals(other.createdBefore) && this.cursor.equals(other.cursor) && this.emailAddresses.equals(other.emailAddresses) && this.expand.equals(other.expand) && this.includeDeletedData.equals(other.includeDeletedData) && this.includeRemoteData.equals(other.includeRemoteData) && this.includeRemoteFields.equals(other.includeRemoteFields) && this.includeShellData.equals(other.includeShellData) && this.modifiedAfter.equals(other.modifiedAfter) && this.modifiedBefore.equals(other.modifiedBefore) && this.ownerId.equals(other.ownerId) && this.pageSize.equals(other.pageSize) && this.phoneNumbers.equals(other.phoneNumbers) && this.remoteId.equals(other.remoteId);
    }

    public int hashCode() {
        return Objects.hash(this.convertedAccountId, this.convertedContactId, this.createdAfter, this.createdBefore, this.cursor, this.emailAddresses, this.expand, this.includeDeletedData, this.includeRemoteData, this.includeRemoteFields, this.includeShellData, this.modifiedAfter, this.modifiedBefore, this.ownerId, this.pageSize, this.phoneNumbers, this.remoteId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> convertedAccountId = Optional.empty();
        private Optional<String> convertedContactId = Optional.empty();
        private Optional<OffsetDateTime> createdAfter = Optional.empty();
        private Optional<OffsetDateTime> createdBefore = Optional.empty();
        private Optional<String> cursor = Optional.empty();
        private Optional<String> emailAddresses = Optional.empty();
        private Optional<LeadsListRequestExpand> expand = Optional.empty();
        private Optional<Boolean> includeDeletedData = Optional.empty();
        private Optional<Boolean> includeRemoteData = Optional.empty();
        private Optional<Boolean> includeRemoteFields = Optional.empty();
        private Optional<Boolean> includeShellData = Optional.empty();
        private Optional<OffsetDateTime> modifiedAfter = Optional.empty();
        private Optional<OffsetDateTime> modifiedBefore = Optional.empty();
        private Optional<String> ownerId = Optional.empty();
        private Optional<Integer> pageSize = Optional.empty();
        private Optional<String> phoneNumbers = Optional.empty();
        private Optional<String> remoteId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(LeadsListRequest other) {
            this.convertedAccountId(other.getConvertedAccountId());
            this.convertedContactId(other.getConvertedContactId());
            this.createdAfter(other.getCreatedAfter());
            this.createdBefore(other.getCreatedBefore());
            this.cursor(other.getCursor());
            this.emailAddresses(other.getEmailAddresses());
            this.expand(other.getExpand());
            this.includeDeletedData(other.getIncludeDeletedData());
            this.includeRemoteData(other.getIncludeRemoteData());
            this.includeRemoteFields(other.getIncludeRemoteFields());
            this.includeShellData(other.getIncludeShellData());
            this.modifiedAfter(other.getModifiedAfter());
            this.modifiedBefore(other.getModifiedBefore());
            this.ownerId(other.getOwnerId());
            this.pageSize(other.getPageSize());
            this.phoneNumbers(other.getPhoneNumbers());
            this.remoteId(other.getRemoteId());
            return this;
        }

        @JsonSetter(value="converted_account_id", nulls=Nulls.SKIP)
        public Builder convertedAccountId(Optional<String> convertedAccountId) {
            this.convertedAccountId = convertedAccountId;
            return this;
        }

        public Builder convertedAccountId(String convertedAccountId) {
            this.convertedAccountId = Optional.of(convertedAccountId);
            return this;
        }

        @JsonSetter(value="converted_contact_id", nulls=Nulls.SKIP)
        public Builder convertedContactId(Optional<String> convertedContactId) {
            this.convertedContactId = convertedContactId;
            return this;
        }

        public Builder convertedContactId(String convertedContactId) {
            this.convertedContactId = Optional.of(convertedContactId);
            return this;
        }

        @JsonSetter(value="created_after", nulls=Nulls.SKIP)
        public Builder createdAfter(Optional<OffsetDateTime> createdAfter) {
            this.createdAfter = createdAfter;
            return this;
        }

        public Builder createdAfter(OffsetDateTime createdAfter) {
            this.createdAfter = Optional.of(createdAfter);
            return this;
        }

        @JsonSetter(value="created_before", nulls=Nulls.SKIP)
        public Builder createdBefore(Optional<OffsetDateTime> createdBefore) {
            this.createdBefore = createdBefore;
            return this;
        }

        public Builder createdBefore(OffsetDateTime createdBefore) {
            this.createdBefore = Optional.of(createdBefore);
            return this;
        }

        @JsonSetter(value="cursor", nulls=Nulls.SKIP)
        public Builder cursor(Optional<String> cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = Optional.of(cursor);
            return this;
        }

        @JsonSetter(value="email_addresses", nulls=Nulls.SKIP)
        public Builder emailAddresses(Optional<String> emailAddresses) {
            this.emailAddresses = emailAddresses;
            return this;
        }

        public Builder emailAddresses(String emailAddresses) {
            this.emailAddresses = Optional.of(emailAddresses);
            return this;
        }

        @JsonSetter(value="expand", nulls=Nulls.SKIP)
        public Builder expand(Optional<LeadsListRequestExpand> expand) {
            this.expand = expand;
            return this;
        }

        public Builder expand(LeadsListRequestExpand expand) {
            this.expand = Optional.of(expand);
            return this;
        }

        @JsonSetter(value="include_deleted_data", nulls=Nulls.SKIP)
        public Builder includeDeletedData(Optional<Boolean> includeDeletedData) {
            this.includeDeletedData = includeDeletedData;
            return this;
        }

        public Builder includeDeletedData(Boolean includeDeletedData) {
            this.includeDeletedData = Optional.of(includeDeletedData);
            return this;
        }

        @JsonSetter(value="include_remote_data", nulls=Nulls.SKIP)
        public Builder includeRemoteData(Optional<Boolean> includeRemoteData) {
            this.includeRemoteData = includeRemoteData;
            return this;
        }

        public Builder includeRemoteData(Boolean includeRemoteData) {
            this.includeRemoteData = Optional.of(includeRemoteData);
            return this;
        }

        @JsonSetter(value="include_remote_fields", nulls=Nulls.SKIP)
        public Builder includeRemoteFields(Optional<Boolean> includeRemoteFields) {
            this.includeRemoteFields = includeRemoteFields;
            return this;
        }

        public Builder includeRemoteFields(Boolean includeRemoteFields) {
            this.includeRemoteFields = Optional.of(includeRemoteFields);
            return this;
        }

        @JsonSetter(value="include_shell_data", nulls=Nulls.SKIP)
        public Builder includeShellData(Optional<Boolean> includeShellData) {
            this.includeShellData = includeShellData;
            return this;
        }

        public Builder includeShellData(Boolean includeShellData) {
            this.includeShellData = Optional.of(includeShellData);
            return this;
        }

        @JsonSetter(value="modified_after", nulls=Nulls.SKIP)
        public Builder modifiedAfter(Optional<OffsetDateTime> modifiedAfter) {
            this.modifiedAfter = modifiedAfter;
            return this;
        }

        public Builder modifiedAfter(OffsetDateTime modifiedAfter) {
            this.modifiedAfter = Optional.of(modifiedAfter);
            return this;
        }

        @JsonSetter(value="modified_before", nulls=Nulls.SKIP)
        public Builder modifiedBefore(Optional<OffsetDateTime> modifiedBefore) {
            this.modifiedBefore = modifiedBefore;
            return this;
        }

        public Builder modifiedBefore(OffsetDateTime modifiedBefore) {
            this.modifiedBefore = Optional.of(modifiedBefore);
            return this;
        }

        @JsonSetter(value="owner_id", nulls=Nulls.SKIP)
        public Builder ownerId(Optional<String> ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public Builder ownerId(String ownerId) {
            this.ownerId = Optional.of(ownerId);
            return this;
        }

        @JsonSetter(value="page_size", nulls=Nulls.SKIP)
        public Builder pageSize(Optional<Integer> pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public Builder pageSize(Integer pageSize) {
            this.pageSize = Optional.of(pageSize);
            return this;
        }

        @JsonSetter(value="phone_numbers", nulls=Nulls.SKIP)
        public Builder phoneNumbers(Optional<String> phoneNumbers) {
            this.phoneNumbers = phoneNumbers;
            return this;
        }

        public Builder phoneNumbers(String phoneNumbers) {
            this.phoneNumbers = Optional.of(phoneNumbers);
            return this;
        }

        @JsonSetter(value="remote_id", nulls=Nulls.SKIP)
        public Builder remoteId(Optional<String> remoteId) {
            this.remoteId = remoteId;
            return this;
        }

        public Builder remoteId(String remoteId) {
            this.remoteId = Optional.of(remoteId);
            return this;
        }

        public LeadsListRequest build() {
            return new LeadsListRequest(this.convertedAccountId, this.convertedContactId, this.createdAfter, this.createdBefore, this.cursor, this.emailAddresses, this.expand, this.includeDeletedData, this.includeRemoteData, this.includeRemoteFields, this.includeShellData, this.modifiedAfter, this.modifiedBefore, this.ownerId, this.pageSize, this.phoneNumbers, this.remoteId, this.additionalProperties);
        }
    }
}

