/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.crm.tasks;

import com.merge.api.core.ApiError;
import com.merge.api.core.ClientOptions;
import com.merge.api.core.MediaTypes;
import com.merge.api.core.MergeException;
import com.merge.api.core.ObjectMappers;
import com.merge.api.core.RequestOptions;
import com.merge.api.resources.crm.tasks.requests.PatchedTaskEndpointRequest;
import com.merge.api.resources.crm.tasks.requests.TaskEndpointRequest;
import com.merge.api.resources.crm.tasks.requests.TasksListRequest;
import com.merge.api.resources.crm.tasks.requests.TasksRemoteFieldClassesListRequest;
import com.merge.api.resources.crm.tasks.requests.TasksRetrieveRequest;
import com.merge.api.resources.crm.types.MetaResponse;
import com.merge.api.resources.crm.types.PaginatedRemoteFieldClassList;
import com.merge.api.resources.crm.types.PaginatedTaskList;
import com.merge.api.resources.crm.types.PatchedTaskRequest;
import com.merge.api.resources.crm.types.Task;
import com.merge.api.resources.crm.types.TaskRequest;
import com.merge.api.resources.crm.types.TaskResponse;
import java.io.IOException;
import java.util.HashMap;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class TasksClient {
    protected final ClientOptions clientOptions;

    public TasksClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public PaginatedTaskList list() {
        return this.list(TasksListRequest.builder().build());
    }

    public PaginatedTaskList list(TasksListRequest request) {
        return this.list(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PaginatedTaskList list(TasksListRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("crm/v1/tasks");
        if (request.getCreatedAfter().isPresent()) {
            httpUrl.addQueryParameter("created_after", request.getCreatedAfter().get().toString());
        }
        if (request.getCreatedBefore().isPresent()) {
            httpUrl.addQueryParameter("created_before", request.getCreatedBefore().get().toString());
        }
        if (request.getCursor().isPresent()) {
            httpUrl.addQueryParameter("cursor", request.getCursor().get());
        }
        if (request.getExpand().isPresent()) {
            httpUrl.addQueryParameter("expand", request.getExpand().get().toString());
        }
        if (request.getIncludeDeletedData().isPresent()) {
            httpUrl.addQueryParameter("include_deleted_data", request.getIncludeDeletedData().get().toString());
        }
        if (request.getIncludeRemoteData().isPresent()) {
            httpUrl.addQueryParameter("include_remote_data", request.getIncludeRemoteData().get().toString());
        }
        if (request.getIncludeRemoteFields().isPresent()) {
            httpUrl.addQueryParameter("include_remote_fields", request.getIncludeRemoteFields().get().toString());
        }
        if (request.getIncludeShellData().isPresent()) {
            httpUrl.addQueryParameter("include_shell_data", request.getIncludeShellData().get().toString());
        }
        if (request.getModifiedAfter().isPresent()) {
            httpUrl.addQueryParameter("modified_after", request.getModifiedAfter().get().toString());
        }
        if (request.getModifiedBefore().isPresent()) {
            httpUrl.addQueryParameter("modified_before", request.getModifiedBefore().get().toString());
        }
        if (request.getPageSize().isPresent()) {
            httpUrl.addQueryParameter("page_size", request.getPageSize().get().toString());
        }
        if (request.getRemoteId().isPresent()) {
            httpUrl.addQueryParameter("remote_id", request.getRemoteId().get());
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                PaginatedTaskList paginatedTaskList = (PaginatedTaskList)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), PaginatedTaskList.class);
                return paginatedTaskList;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new ApiError("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new MergeException("Network error executing HTTP request", e);
        }
    }

    public TaskResponse create(TaskEndpointRequest request) {
        return this.create(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TaskResponse create(TaskEndpointRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("crm/v1/tasks");
        if (request.getIsDebugMode().isPresent()) {
            httpUrl.addQueryParameter("is_debug_mode", request.getIsDebugMode().get().toString());
        }
        if (request.getRunAsync().isPresent()) {
            httpUrl.addQueryParameter("run_async", request.getRunAsync().get().toString());
        }
        HashMap<String, TaskRequest> properties = new HashMap<String, TaskRequest>();
        properties.put("model", request.getModel());
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes(properties), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                TaskResponse taskResponse = (TaskResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), TaskResponse.class);
                return taskResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new ApiError("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new MergeException("Network error executing HTTP request", e);
        }
    }

    public Task retrieve(String id) {
        return this.retrieve(id, TasksRetrieveRequest.builder().build());
    }

    public Task retrieve(String id, TasksRetrieveRequest request) {
        return this.retrieve(id, request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Task retrieve(String id, TasksRetrieveRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("crm/v1/tasks").addPathSegment(id);
        if (request.getExpand().isPresent()) {
            httpUrl.addQueryParameter("expand", request.getExpand().get().toString());
        }
        if (request.getIncludeRemoteData().isPresent()) {
            httpUrl.addQueryParameter("include_remote_data", request.getIncludeRemoteData().get().toString());
        }
        if (request.getIncludeRemoteFields().isPresent()) {
            httpUrl.addQueryParameter("include_remote_fields", request.getIncludeRemoteFields().get().toString());
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                Task task = (Task)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), Task.class);
                return task;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new ApiError("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new MergeException("Network error executing HTTP request", e);
        }
    }

    public TaskResponse partialUpdate(String id, PatchedTaskEndpointRequest request) {
        return this.partialUpdate(id, request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TaskResponse partialUpdate(String id, PatchedTaskEndpointRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("crm/v1/tasks").addPathSegment(id);
        if (request.getIsDebugMode().isPresent()) {
            httpUrl.addQueryParameter("is_debug_mode", request.getIsDebugMode().get().toString());
        }
        if (request.getRunAsync().isPresent()) {
            httpUrl.addQueryParameter("run_async", request.getRunAsync().get().toString());
        }
        HashMap<String, PatchedTaskRequest> properties = new HashMap<String, PatchedTaskRequest>();
        properties.put("model", request.getModel());
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes(properties), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("PATCH", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                TaskResponse taskResponse = (TaskResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), TaskResponse.class);
                return taskResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new ApiError("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new MergeException("Network error executing HTTP request", e);
        }
    }

    public MetaResponse metaPatchRetrieve(String id) {
        return this.metaPatchRetrieve(id, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MetaResponse metaPatchRetrieve(String id, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("crm/v1/tasks/meta/patch").addPathSegment(id).build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                MetaResponse metaResponse = (MetaResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), MetaResponse.class);
                return metaResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new ApiError("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new MergeException("Network error executing HTTP request", e);
        }
    }

    public MetaResponse metaPostRetrieve() {
        return this.metaPostRetrieve(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MetaResponse metaPostRetrieve(RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("crm/v1/tasks/meta/post").build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                MetaResponse metaResponse = (MetaResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), MetaResponse.class);
                return metaResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new ApiError("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new MergeException("Network error executing HTTP request", e);
        }
    }

    public PaginatedRemoteFieldClassList remoteFieldClassesList() {
        return this.remoteFieldClassesList(TasksRemoteFieldClassesListRequest.builder().build());
    }

    public PaginatedRemoteFieldClassList remoteFieldClassesList(TasksRemoteFieldClassesListRequest request) {
        return this.remoteFieldClassesList(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PaginatedRemoteFieldClassList remoteFieldClassesList(TasksRemoteFieldClassesListRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("crm/v1/tasks/remote-field-classes");
        if (request.getCursor().isPresent()) {
            httpUrl.addQueryParameter("cursor", request.getCursor().get());
        }
        if (request.getIncludeDeletedData().isPresent()) {
            httpUrl.addQueryParameter("include_deleted_data", request.getIncludeDeletedData().get().toString());
        }
        if (request.getIncludeRemoteData().isPresent()) {
            httpUrl.addQueryParameter("include_remote_data", request.getIncludeRemoteData().get().toString());
        }
        if (request.getIncludeRemoteFields().isPresent()) {
            httpUrl.addQueryParameter("include_remote_fields", request.getIncludeRemoteFields().get().toString());
        }
        if (request.getIncludeShellData().isPresent()) {
            httpUrl.addQueryParameter("include_shell_data", request.getIncludeShellData().get().toString());
        }
        if (request.getIsCommonModelField().isPresent()) {
            httpUrl.addQueryParameter("is_common_model_field", request.getIsCommonModelField().get().toString());
        }
        if (request.getPageSize().isPresent()) {
            httpUrl.addQueryParameter("page_size", request.getPageSize().get().toString());
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                PaginatedRemoteFieldClassList paginatedRemoteFieldClassList = (PaginatedRemoteFieldClassList)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), PaginatedRemoteFieldClassList.class);
                return paginatedRemoteFieldClassList;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new ApiError("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new MergeException("Network error executing HTTP request", e);
        }
    }
}

