/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.crm.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import com.merge.api.resources.crm.types.AddressRequestAddressType;
import com.merge.api.resources.crm.types.AddressRequestCountry;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class AddressRequest {
    private final Optional<String> street1;
    private final Optional<String> street2;
    private final Optional<String> city;
    private final Optional<String> state;
    private final Optional<String> postalCode;
    private final Optional<AddressRequestCountry> country;
    private final Optional<AddressRequestAddressType> addressType;
    private final Optional<Map<String, JsonNode>> integrationParams;
    private final Optional<Map<String, JsonNode>> linkedAccountParams;
    private final Map<String, Object> additionalProperties;

    private AddressRequest(Optional<String> street1, Optional<String> street2, Optional<String> city, Optional<String> state, Optional<String> postalCode, Optional<AddressRequestCountry> country, Optional<AddressRequestAddressType> addressType, Optional<Map<String, JsonNode>> integrationParams, Optional<Map<String, JsonNode>> linkedAccountParams, Map<String, Object> additionalProperties) {
        this.street1 = street1;
        this.street2 = street2;
        this.city = city;
        this.state = state;
        this.postalCode = postalCode;
        this.country = country;
        this.addressType = addressType;
        this.integrationParams = integrationParams;
        this.linkedAccountParams = linkedAccountParams;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="street_1")
    public Optional<String> getStreet1() {
        return this.street1;
    }

    @JsonProperty(value="street_2")
    public Optional<String> getStreet2() {
        return this.street2;
    }

    @JsonProperty(value="city")
    public Optional<String> getCity() {
        return this.city;
    }

    @JsonProperty(value="state")
    public Optional<String> getState() {
        return this.state;
    }

    @JsonProperty(value="postal_code")
    public Optional<String> getPostalCode() {
        return this.postalCode;
    }

    @JsonProperty(value="country")
    public Optional<AddressRequestCountry> getCountry() {
        return this.country;
    }

    @JsonProperty(value="address_type")
    public Optional<AddressRequestAddressType> getAddressType() {
        return this.addressType;
    }

    @JsonProperty(value="integration_params")
    public Optional<Map<String, JsonNode>> getIntegrationParams() {
        return this.integrationParams;
    }

    @JsonProperty(value="linked_account_params")
    public Optional<Map<String, JsonNode>> getLinkedAccountParams() {
        return this.linkedAccountParams;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof AddressRequest && this.equalTo((AddressRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(AddressRequest other) {
        return this.street1.equals(other.street1) && this.street2.equals(other.street2) && this.city.equals(other.city) && this.state.equals(other.state) && this.postalCode.equals(other.postalCode) && this.country.equals(other.country) && this.addressType.equals(other.addressType) && this.integrationParams.equals(other.integrationParams) && this.linkedAccountParams.equals(other.linkedAccountParams);
    }

    public int hashCode() {
        return Objects.hash(this.street1, this.street2, this.city, this.state, this.postalCode, this.country, this.addressType, this.integrationParams, this.linkedAccountParams);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> street1 = Optional.empty();
        private Optional<String> street2 = Optional.empty();
        private Optional<String> city = Optional.empty();
        private Optional<String> state = Optional.empty();
        private Optional<String> postalCode = Optional.empty();
        private Optional<AddressRequestCountry> country = Optional.empty();
        private Optional<AddressRequestAddressType> addressType = Optional.empty();
        private Optional<Map<String, JsonNode>> integrationParams = Optional.empty();
        private Optional<Map<String, JsonNode>> linkedAccountParams = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(AddressRequest other) {
            this.street1(other.getStreet1());
            this.street2(other.getStreet2());
            this.city(other.getCity());
            this.state(other.getState());
            this.postalCode(other.getPostalCode());
            this.country(other.getCountry());
            this.addressType(other.getAddressType());
            this.integrationParams(other.getIntegrationParams());
            this.linkedAccountParams(other.getLinkedAccountParams());
            return this;
        }

        @JsonSetter(value="street_1", nulls=Nulls.SKIP)
        public Builder street1(Optional<String> street1) {
            this.street1 = street1;
            return this;
        }

        public Builder street1(String street1) {
            this.street1 = Optional.of(street1);
            return this;
        }

        @JsonSetter(value="street_2", nulls=Nulls.SKIP)
        public Builder street2(Optional<String> street2) {
            this.street2 = street2;
            return this;
        }

        public Builder street2(String street2) {
            this.street2 = Optional.of(street2);
            return this;
        }

        @JsonSetter(value="city", nulls=Nulls.SKIP)
        public Builder city(Optional<String> city) {
            this.city = city;
            return this;
        }

        public Builder city(String city) {
            this.city = Optional.of(city);
            return this;
        }

        @JsonSetter(value="state", nulls=Nulls.SKIP)
        public Builder state(Optional<String> state) {
            this.state = state;
            return this;
        }

        public Builder state(String state) {
            this.state = Optional.of(state);
            return this;
        }

        @JsonSetter(value="postal_code", nulls=Nulls.SKIP)
        public Builder postalCode(Optional<String> postalCode) {
            this.postalCode = postalCode;
            return this;
        }

        public Builder postalCode(String postalCode) {
            this.postalCode = Optional.of(postalCode);
            return this;
        }

        @JsonSetter(value="country", nulls=Nulls.SKIP)
        public Builder country(Optional<AddressRequestCountry> country) {
            this.country = country;
            return this;
        }

        public Builder country(AddressRequestCountry country) {
            this.country = Optional.of(country);
            return this;
        }

        @JsonSetter(value="address_type", nulls=Nulls.SKIP)
        public Builder addressType(Optional<AddressRequestAddressType> addressType) {
            this.addressType = addressType;
            return this;
        }

        public Builder addressType(AddressRequestAddressType addressType) {
            this.addressType = Optional.of(addressType);
            return this;
        }

        @JsonSetter(value="integration_params", nulls=Nulls.SKIP)
        public Builder integrationParams(Optional<Map<String, JsonNode>> integrationParams) {
            this.integrationParams = integrationParams;
            return this;
        }

        public Builder integrationParams(Map<String, JsonNode> integrationParams) {
            this.integrationParams = Optional.of(integrationParams);
            return this;
        }

        @JsonSetter(value="linked_account_params", nulls=Nulls.SKIP)
        public Builder linkedAccountParams(Optional<Map<String, JsonNode>> linkedAccountParams) {
            this.linkedAccountParams = linkedAccountParams;
            return this;
        }

        public Builder linkedAccountParams(Map<String, JsonNode> linkedAccountParams) {
            this.linkedAccountParams = Optional.of(linkedAccountParams);
            return this;
        }

        public AddressRequest build() {
            return new AddressRequest(this.street1, this.street2, this.city, this.state, this.postalCode, this.country, this.addressType, this.integrationParams, this.linkedAccountParams, this.additionalProperties);
        }
    }
}

