/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.crm.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import com.merge.api.resources.crm.types.AssociationAssociationType;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class Association {
    private final Optional<OffsetDateTime> createdAt;
    private final Optional<OffsetDateTime> modifiedAt;
    private final Optional<String> sourceObject;
    private final Optional<String> targetObject;
    private final Optional<AssociationAssociationType> associationType;
    private final Map<String, Object> additionalProperties;

    private Association(Optional<OffsetDateTime> createdAt, Optional<OffsetDateTime> modifiedAt, Optional<String> sourceObject, Optional<String> targetObject, Optional<AssociationAssociationType> associationType, Map<String, Object> additionalProperties) {
        this.createdAt = createdAt;
        this.modifiedAt = modifiedAt;
        this.sourceObject = sourceObject;
        this.targetObject = targetObject;
        this.associationType = associationType;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="created_at")
    public Optional<OffsetDateTime> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="modified_at")
    public Optional<OffsetDateTime> getModifiedAt() {
        return this.modifiedAt;
    }

    @JsonProperty(value="source_object")
    public Optional<String> getSourceObject() {
        return this.sourceObject;
    }

    @JsonProperty(value="target_object")
    public Optional<String> getTargetObject() {
        return this.targetObject;
    }

    @JsonProperty(value="association_type")
    public Optional<AssociationAssociationType> getAssociationType() {
        return this.associationType;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Association && this.equalTo((Association)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Association other) {
        return this.createdAt.equals(other.createdAt) && this.modifiedAt.equals(other.modifiedAt) && this.sourceObject.equals(other.sourceObject) && this.targetObject.equals(other.targetObject) && this.associationType.equals(other.associationType);
    }

    public int hashCode() {
        return Objects.hash(this.createdAt, this.modifiedAt, this.sourceObject, this.targetObject, this.associationType);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<OffsetDateTime> createdAt = Optional.empty();
        private Optional<OffsetDateTime> modifiedAt = Optional.empty();
        private Optional<String> sourceObject = Optional.empty();
        private Optional<String> targetObject = Optional.empty();
        private Optional<AssociationAssociationType> associationType = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(Association other) {
            this.createdAt(other.getCreatedAt());
            this.modifiedAt(other.getModifiedAt());
            this.sourceObject(other.getSourceObject());
            this.targetObject(other.getTargetObject());
            this.associationType(other.getAssociationType());
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<OffsetDateTime> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(OffsetDateTime createdAt) {
            this.createdAt = Optional.of(createdAt);
            return this;
        }

        @JsonSetter(value="modified_at", nulls=Nulls.SKIP)
        public Builder modifiedAt(Optional<OffsetDateTime> modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public Builder modifiedAt(OffsetDateTime modifiedAt) {
            this.modifiedAt = Optional.of(modifiedAt);
            return this;
        }

        @JsonSetter(value="source_object", nulls=Nulls.SKIP)
        public Builder sourceObject(Optional<String> sourceObject) {
            this.sourceObject = sourceObject;
            return this;
        }

        public Builder sourceObject(String sourceObject) {
            this.sourceObject = Optional.of(sourceObject);
            return this;
        }

        @JsonSetter(value="target_object", nulls=Nulls.SKIP)
        public Builder targetObject(Optional<String> targetObject) {
            this.targetObject = targetObject;
            return this;
        }

        public Builder targetObject(String targetObject) {
            this.targetObject = Optional.of(targetObject);
            return this;
        }

        @JsonSetter(value="association_type", nulls=Nulls.SKIP)
        public Builder associationType(Optional<AssociationAssociationType> associationType) {
            this.associationType = associationType;
            return this;
        }

        public Builder associationType(AssociationAssociationType associationType) {
            this.associationType = Optional.of(associationType);
            return this;
        }

        public Association build() {
            return new Association(this.createdAt, this.modifiedAt, this.sourceObject, this.targetObject, this.associationType, this.additionalProperties);
        }
    }
}

