/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.crm.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import com.merge.api.resources.crm.types.CardinalityEnum;
import com.merge.api.resources.crm.types.ObjectClassDescriptionRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class AssociationTypeRequestRequest {
    private final ObjectClassDescriptionRequest sourceObjectClass;
    private final List<ObjectClassDescriptionRequest> targetObjectClasses;
    private final String remoteKeyName;
    private final Optional<String> displayName;
    private final Optional<CardinalityEnum> cardinality;
    private final Optional<Boolean> isRequired;
    private final Map<String, Object> additionalProperties;

    private AssociationTypeRequestRequest(ObjectClassDescriptionRequest sourceObjectClass, List<ObjectClassDescriptionRequest> targetObjectClasses, String remoteKeyName, Optional<String> displayName, Optional<CardinalityEnum> cardinality, Optional<Boolean> isRequired, Map<String, Object> additionalProperties) {
        this.sourceObjectClass = sourceObjectClass;
        this.targetObjectClasses = targetObjectClasses;
        this.remoteKeyName = remoteKeyName;
        this.displayName = displayName;
        this.cardinality = cardinality;
        this.isRequired = isRequired;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="source_object_class")
    public ObjectClassDescriptionRequest getSourceObjectClass() {
        return this.sourceObjectClass;
    }

    @JsonProperty(value="target_object_classes")
    public List<ObjectClassDescriptionRequest> getTargetObjectClasses() {
        return this.targetObjectClasses;
    }

    @JsonProperty(value="remote_key_name")
    public String getRemoteKeyName() {
        return this.remoteKeyName;
    }

    @JsonProperty(value="display_name")
    public Optional<String> getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="cardinality")
    public Optional<CardinalityEnum> getCardinality() {
        return this.cardinality;
    }

    @JsonProperty(value="is_required")
    public Optional<Boolean> getIsRequired() {
        return this.isRequired;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof AssociationTypeRequestRequest && this.equalTo((AssociationTypeRequestRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(AssociationTypeRequestRequest other) {
        return this.sourceObjectClass.equals(other.sourceObjectClass) && this.targetObjectClasses.equals(other.targetObjectClasses) && this.remoteKeyName.equals(other.remoteKeyName) && this.displayName.equals(other.displayName) && this.cardinality.equals(other.cardinality) && this.isRequired.equals(other.isRequired);
    }

    public int hashCode() {
        return Objects.hash(this.sourceObjectClass, this.targetObjectClasses, this.remoteKeyName, this.displayName, this.cardinality, this.isRequired);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SourceObjectClassStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements SourceObjectClassStage,
    RemoteKeyNameStage,
    _FinalStage {
        private ObjectClassDescriptionRequest sourceObjectClass;
        private String remoteKeyName;
        private Optional<Boolean> isRequired = Optional.empty();
        private Optional<CardinalityEnum> cardinality = Optional.empty();
        private Optional<String> displayName = Optional.empty();
        private List<ObjectClassDescriptionRequest> targetObjectClasses = new ArrayList<ObjectClassDescriptionRequest>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(AssociationTypeRequestRequest other) {
            this.sourceObjectClass(other.getSourceObjectClass());
            this.targetObjectClasses(other.getTargetObjectClasses());
            this.remoteKeyName(other.getRemoteKeyName());
            this.displayName(other.getDisplayName());
            this.cardinality(other.getCardinality());
            this.isRequired(other.getIsRequired());
            return this;
        }

        @Override
        @JsonSetter(value="source_object_class")
        public RemoteKeyNameStage sourceObjectClass(ObjectClassDescriptionRequest sourceObjectClass) {
            this.sourceObjectClass = sourceObjectClass;
            return this;
        }

        @Override
        @JsonSetter(value="remote_key_name")
        public _FinalStage remoteKeyName(String remoteKeyName) {
            this.remoteKeyName = remoteKeyName;
            return this;
        }

        @Override
        public _FinalStage isRequired(Boolean isRequired) {
            this.isRequired = Optional.of(isRequired);
            return this;
        }

        @Override
        @JsonSetter(value="is_required", nulls=Nulls.SKIP)
        public _FinalStage isRequired(Optional<Boolean> isRequired) {
            this.isRequired = isRequired;
            return this;
        }

        @Override
        public _FinalStage cardinality(CardinalityEnum cardinality) {
            this.cardinality = Optional.of(cardinality);
            return this;
        }

        @Override
        @JsonSetter(value="cardinality", nulls=Nulls.SKIP)
        public _FinalStage cardinality(Optional<CardinalityEnum> cardinality) {
            this.cardinality = cardinality;
            return this;
        }

        @Override
        public _FinalStage displayName(String displayName) {
            this.displayName = Optional.of(displayName);
            return this;
        }

        @Override
        @JsonSetter(value="display_name", nulls=Nulls.SKIP)
        public _FinalStage displayName(Optional<String> displayName) {
            this.displayName = displayName;
            return this;
        }

        @Override
        public _FinalStage addAllTargetObjectClasses(List<ObjectClassDescriptionRequest> targetObjectClasses) {
            this.targetObjectClasses.addAll(targetObjectClasses);
            return this;
        }

        @Override
        public _FinalStage addTargetObjectClasses(ObjectClassDescriptionRequest targetObjectClasses) {
            this.targetObjectClasses.add(targetObjectClasses);
            return this;
        }

        @Override
        @JsonSetter(value="target_object_classes", nulls=Nulls.SKIP)
        public _FinalStage targetObjectClasses(List<ObjectClassDescriptionRequest> targetObjectClasses) {
            this.targetObjectClasses.clear();
            this.targetObjectClasses.addAll(targetObjectClasses);
            return this;
        }

        @Override
        public AssociationTypeRequestRequest build() {
            return new AssociationTypeRequestRequest(this.sourceObjectClass, this.targetObjectClasses, this.remoteKeyName, this.displayName, this.cardinality, this.isRequired, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public AssociationTypeRequestRequest build();

        public _FinalStage targetObjectClasses(List<ObjectClassDescriptionRequest> var1);

        public _FinalStage addTargetObjectClasses(ObjectClassDescriptionRequest var1);

        public _FinalStage addAllTargetObjectClasses(List<ObjectClassDescriptionRequest> var1);

        public _FinalStage displayName(Optional<String> var1);

        public _FinalStage displayName(String var1);

        public _FinalStage cardinality(Optional<CardinalityEnum> var1);

        public _FinalStage cardinality(CardinalityEnum var1);

        public _FinalStage isRequired(Optional<Boolean> var1);

        public _FinalStage isRequired(Boolean var1);
    }

    public static interface RemoteKeyNameStage {
        public _FinalStage remoteKeyName(String var1);
    }

    public static interface SourceObjectClassStage {
        public RemoteKeyNameStage sourceObjectClass(ObjectClassDescriptionRequest var1);

        public Builder from(AssociationTypeRequestRequest var1);
    }
}

