/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.crm.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import com.merge.api.resources.crm.types.Address;
import com.merge.api.resources.crm.types.ContactAccount;
import com.merge.api.resources.crm.types.ContactOwner;
import com.merge.api.resources.crm.types.EmailAddress;
import com.merge.api.resources.crm.types.PhoneNumber;
import com.merge.api.resources.crm.types.RemoteData;
import com.merge.api.resources.crm.types.RemoteField;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class Contact {
    private final Optional<String> id;
    private final Optional<String> remoteId;
    private final Optional<OffsetDateTime> createdAt;
    private final Optional<OffsetDateTime> modifiedAt;
    private final Optional<String> firstName;
    private final Optional<String> lastName;
    private final Optional<ContactAccount> account;
    private final Optional<ContactOwner> owner;
    private final Optional<List<Address>> addresses;
    private final Optional<List<EmailAddress>> emailAddresses;
    private final Optional<List<PhoneNumber>> phoneNumbers;
    private final Optional<OffsetDateTime> lastActivityAt;
    private final Optional<OffsetDateTime> remoteCreatedAt;
    private final Optional<Boolean> remoteWasDeleted;
    private final Optional<Map<String, JsonNode>> fieldMappings;
    private final Optional<List<RemoteData>> remoteData;
    private final Optional<List<RemoteField>> remoteFields;
    private final Map<String, Object> additionalProperties;

    private Contact(Optional<String> id, Optional<String> remoteId, Optional<OffsetDateTime> createdAt, Optional<OffsetDateTime> modifiedAt, Optional<String> firstName, Optional<String> lastName, Optional<ContactAccount> account, Optional<ContactOwner> owner, Optional<List<Address>> addresses, Optional<List<EmailAddress>> emailAddresses, Optional<List<PhoneNumber>> phoneNumbers, Optional<OffsetDateTime> lastActivityAt, Optional<OffsetDateTime> remoteCreatedAt, Optional<Boolean> remoteWasDeleted, Optional<Map<String, JsonNode>> fieldMappings, Optional<List<RemoteData>> remoteData, Optional<List<RemoteField>> remoteFields, Map<String, Object> additionalProperties) {
        this.id = id;
        this.remoteId = remoteId;
        this.createdAt = createdAt;
        this.modifiedAt = modifiedAt;
        this.firstName = firstName;
        this.lastName = lastName;
        this.account = account;
        this.owner = owner;
        this.addresses = addresses;
        this.emailAddresses = emailAddresses;
        this.phoneNumbers = phoneNumbers;
        this.lastActivityAt = lastActivityAt;
        this.remoteCreatedAt = remoteCreatedAt;
        this.remoteWasDeleted = remoteWasDeleted;
        this.fieldMappings = fieldMappings;
        this.remoteData = remoteData;
        this.remoteFields = remoteFields;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="remote_id")
    public Optional<String> getRemoteId() {
        return this.remoteId;
    }

    @JsonProperty(value="created_at")
    public Optional<OffsetDateTime> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="modified_at")
    public Optional<OffsetDateTime> getModifiedAt() {
        return this.modifiedAt;
    }

    @JsonProperty(value="first_name")
    public Optional<String> getFirstName() {
        return this.firstName;
    }

    @JsonProperty(value="last_name")
    public Optional<String> getLastName() {
        return this.lastName;
    }

    @JsonProperty(value="account")
    public Optional<ContactAccount> getAccount() {
        return this.account;
    }

    @JsonProperty(value="owner")
    public Optional<ContactOwner> getOwner() {
        return this.owner;
    }

    @JsonProperty(value="addresses")
    public Optional<List<Address>> getAddresses() {
        return this.addresses;
    }

    @JsonProperty(value="email_addresses")
    public Optional<List<EmailAddress>> getEmailAddresses() {
        return this.emailAddresses;
    }

    @JsonProperty(value="phone_numbers")
    public Optional<List<PhoneNumber>> getPhoneNumbers() {
        return this.phoneNumbers;
    }

    @JsonProperty(value="last_activity_at")
    public Optional<OffsetDateTime> getLastActivityAt() {
        return this.lastActivityAt;
    }

    @JsonProperty(value="remote_created_at")
    public Optional<OffsetDateTime> getRemoteCreatedAt() {
        return this.remoteCreatedAt;
    }

    @JsonProperty(value="remote_was_deleted")
    public Optional<Boolean> getRemoteWasDeleted() {
        return this.remoteWasDeleted;
    }

    @JsonProperty(value="field_mappings")
    public Optional<Map<String, JsonNode>> getFieldMappings() {
        return this.fieldMappings;
    }

    @JsonProperty(value="remote_data")
    public Optional<List<RemoteData>> getRemoteData() {
        return this.remoteData;
    }

    @JsonProperty(value="remote_fields")
    public Optional<List<RemoteField>> getRemoteFields() {
        return this.remoteFields;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Contact && this.equalTo((Contact)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Contact other) {
        return this.id.equals(other.id) && this.remoteId.equals(other.remoteId) && this.createdAt.equals(other.createdAt) && this.modifiedAt.equals(other.modifiedAt) && this.firstName.equals(other.firstName) && this.lastName.equals(other.lastName) && this.account.equals(other.account) && this.owner.equals(other.owner) && this.addresses.equals(other.addresses) && this.emailAddresses.equals(other.emailAddresses) && this.phoneNumbers.equals(other.phoneNumbers) && this.lastActivityAt.equals(other.lastActivityAt) && this.remoteCreatedAt.equals(other.remoteCreatedAt) && this.remoteWasDeleted.equals(other.remoteWasDeleted) && this.fieldMappings.equals(other.fieldMappings) && this.remoteData.equals(other.remoteData) && this.remoteFields.equals(other.remoteFields);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.remoteId, this.createdAt, this.modifiedAt, this.firstName, this.lastName, this.account, this.owner, this.addresses, this.emailAddresses, this.phoneNumbers, this.lastActivityAt, this.remoteCreatedAt, this.remoteWasDeleted, this.fieldMappings, this.remoteData, this.remoteFields);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> id = Optional.empty();
        private Optional<String> remoteId = Optional.empty();
        private Optional<OffsetDateTime> createdAt = Optional.empty();
        private Optional<OffsetDateTime> modifiedAt = Optional.empty();
        private Optional<String> firstName = Optional.empty();
        private Optional<String> lastName = Optional.empty();
        private Optional<ContactAccount> account = Optional.empty();
        private Optional<ContactOwner> owner = Optional.empty();
        private Optional<List<Address>> addresses = Optional.empty();
        private Optional<List<EmailAddress>> emailAddresses = Optional.empty();
        private Optional<List<PhoneNumber>> phoneNumbers = Optional.empty();
        private Optional<OffsetDateTime> lastActivityAt = Optional.empty();
        private Optional<OffsetDateTime> remoteCreatedAt = Optional.empty();
        private Optional<Boolean> remoteWasDeleted = Optional.empty();
        private Optional<Map<String, JsonNode>> fieldMappings = Optional.empty();
        private Optional<List<RemoteData>> remoteData = Optional.empty();
        private Optional<List<RemoteField>> remoteFields = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(Contact other) {
            this.id(other.getId());
            this.remoteId(other.getRemoteId());
            this.createdAt(other.getCreatedAt());
            this.modifiedAt(other.getModifiedAt());
            this.firstName(other.getFirstName());
            this.lastName(other.getLastName());
            this.account(other.getAccount());
            this.owner(other.getOwner());
            this.addresses(other.getAddresses());
            this.emailAddresses(other.getEmailAddresses());
            this.phoneNumbers(other.getPhoneNumbers());
            this.lastActivityAt(other.getLastActivityAt());
            this.remoteCreatedAt(other.getRemoteCreatedAt());
            this.remoteWasDeleted(other.getRemoteWasDeleted());
            this.fieldMappings(other.getFieldMappings());
            this.remoteData(other.getRemoteData());
            this.remoteFields(other.getRemoteFields());
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.of(id);
            return this;
        }

        @JsonSetter(value="remote_id", nulls=Nulls.SKIP)
        public Builder remoteId(Optional<String> remoteId) {
            this.remoteId = remoteId;
            return this;
        }

        public Builder remoteId(String remoteId) {
            this.remoteId = Optional.of(remoteId);
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<OffsetDateTime> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(OffsetDateTime createdAt) {
            this.createdAt = Optional.of(createdAt);
            return this;
        }

        @JsonSetter(value="modified_at", nulls=Nulls.SKIP)
        public Builder modifiedAt(Optional<OffsetDateTime> modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public Builder modifiedAt(OffsetDateTime modifiedAt) {
            this.modifiedAt = Optional.of(modifiedAt);
            return this;
        }

        @JsonSetter(value="first_name", nulls=Nulls.SKIP)
        public Builder firstName(Optional<String> firstName) {
            this.firstName = firstName;
            return this;
        }

        public Builder firstName(String firstName) {
            this.firstName = Optional.of(firstName);
            return this;
        }

        @JsonSetter(value="last_name", nulls=Nulls.SKIP)
        public Builder lastName(Optional<String> lastName) {
            this.lastName = lastName;
            return this;
        }

        public Builder lastName(String lastName) {
            this.lastName = Optional.of(lastName);
            return this;
        }

        @JsonSetter(value="account", nulls=Nulls.SKIP)
        public Builder account(Optional<ContactAccount> account) {
            this.account = account;
            return this;
        }

        public Builder account(ContactAccount account) {
            this.account = Optional.of(account);
            return this;
        }

        @JsonSetter(value="owner", nulls=Nulls.SKIP)
        public Builder owner(Optional<ContactOwner> owner) {
            this.owner = owner;
            return this;
        }

        public Builder owner(ContactOwner owner) {
            this.owner = Optional.of(owner);
            return this;
        }

        @JsonSetter(value="addresses", nulls=Nulls.SKIP)
        public Builder addresses(Optional<List<Address>> addresses) {
            this.addresses = addresses;
            return this;
        }

        public Builder addresses(List<Address> addresses) {
            this.addresses = Optional.of(addresses);
            return this;
        }

        @JsonSetter(value="email_addresses", nulls=Nulls.SKIP)
        public Builder emailAddresses(Optional<List<EmailAddress>> emailAddresses) {
            this.emailAddresses = emailAddresses;
            return this;
        }

        public Builder emailAddresses(List<EmailAddress> emailAddresses) {
            this.emailAddresses = Optional.of(emailAddresses);
            return this;
        }

        @JsonSetter(value="phone_numbers", nulls=Nulls.SKIP)
        public Builder phoneNumbers(Optional<List<PhoneNumber>> phoneNumbers) {
            this.phoneNumbers = phoneNumbers;
            return this;
        }

        public Builder phoneNumbers(List<PhoneNumber> phoneNumbers) {
            this.phoneNumbers = Optional.of(phoneNumbers);
            return this;
        }

        @JsonSetter(value="last_activity_at", nulls=Nulls.SKIP)
        public Builder lastActivityAt(Optional<OffsetDateTime> lastActivityAt) {
            this.lastActivityAt = lastActivityAt;
            return this;
        }

        public Builder lastActivityAt(OffsetDateTime lastActivityAt) {
            this.lastActivityAt = Optional.of(lastActivityAt);
            return this;
        }

        @JsonSetter(value="remote_created_at", nulls=Nulls.SKIP)
        public Builder remoteCreatedAt(Optional<OffsetDateTime> remoteCreatedAt) {
            this.remoteCreatedAt = remoteCreatedAt;
            return this;
        }

        public Builder remoteCreatedAt(OffsetDateTime remoteCreatedAt) {
            this.remoteCreatedAt = Optional.of(remoteCreatedAt);
            return this;
        }

        @JsonSetter(value="remote_was_deleted", nulls=Nulls.SKIP)
        public Builder remoteWasDeleted(Optional<Boolean> remoteWasDeleted) {
            this.remoteWasDeleted = remoteWasDeleted;
            return this;
        }

        public Builder remoteWasDeleted(Boolean remoteWasDeleted) {
            this.remoteWasDeleted = Optional.of(remoteWasDeleted);
            return this;
        }

        @JsonSetter(value="field_mappings", nulls=Nulls.SKIP)
        public Builder fieldMappings(Optional<Map<String, JsonNode>> fieldMappings) {
            this.fieldMappings = fieldMappings;
            return this;
        }

        public Builder fieldMappings(Map<String, JsonNode> fieldMappings) {
            this.fieldMappings = Optional.of(fieldMappings);
            return this;
        }

        @JsonSetter(value="remote_data", nulls=Nulls.SKIP)
        public Builder remoteData(Optional<List<RemoteData>> remoteData) {
            this.remoteData = remoteData;
            return this;
        }

        public Builder remoteData(List<RemoteData> remoteData) {
            this.remoteData = Optional.of(remoteData);
            return this;
        }

        @JsonSetter(value="remote_fields", nulls=Nulls.SKIP)
        public Builder remoteFields(Optional<List<RemoteField>> remoteFields) {
            this.remoteFields = remoteFields;
            return this;
        }

        public Builder remoteFields(List<RemoteField> remoteFields) {
            this.remoteFields = Optional.of(remoteFields);
            return this;
        }

        public Contact build() {
            return new Contact(this.id, this.remoteId, this.createdAt, this.modifiedAt, this.firstName, this.lastName, this.account, this.owner, this.addresses, this.emailAddresses, this.phoneNumbers, this.lastActivityAt, this.remoteCreatedAt, this.remoteWasDeleted, this.fieldMappings, this.remoteData, this.remoteFields, this.additionalProperties);
        }
    }
}

