/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.crm.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import com.merge.api.resources.crm.types.RemoteFieldClassForCustomObjectClass;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class CustomObjectClass {
    private final Optional<String> id;
    private final Optional<String> remoteId;
    private final Optional<OffsetDateTime> createdAt;
    private final Optional<OffsetDateTime> modifiedAt;
    private final Optional<String> name;
    private final Optional<String> description;
    private final Optional<Map<String, Optional<String>>> labels;
    private final Optional<List<RemoteFieldClassForCustomObjectClass>> fields;
    private final Optional<List<Map<String, JsonNode>>> associationTypes;
    private final Map<String, Object> additionalProperties;

    private CustomObjectClass(Optional<String> id, Optional<String> remoteId, Optional<OffsetDateTime> createdAt, Optional<OffsetDateTime> modifiedAt, Optional<String> name, Optional<String> description, Optional<Map<String, Optional<String>>> labels, Optional<List<RemoteFieldClassForCustomObjectClass>> fields, Optional<List<Map<String, JsonNode>>> associationTypes, Map<String, Object> additionalProperties) {
        this.id = id;
        this.remoteId = remoteId;
        this.createdAt = createdAt;
        this.modifiedAt = modifiedAt;
        this.name = name;
        this.description = description;
        this.labels = labels;
        this.fields = fields;
        this.associationTypes = associationTypes;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="remote_id")
    public Optional<String> getRemoteId() {
        return this.remoteId;
    }

    @JsonProperty(value="created_at")
    public Optional<OffsetDateTime> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="modified_at")
    public Optional<OffsetDateTime> getModifiedAt() {
        return this.modifiedAt;
    }

    @JsonProperty(value="name")
    public Optional<String> getName() {
        return this.name;
    }

    @JsonProperty(value="description")
    public Optional<String> getDescription() {
        return this.description;
    }

    @JsonProperty(value="labels")
    public Optional<Map<String, Optional<String>>> getLabels() {
        return this.labels;
    }

    @JsonProperty(value="fields")
    public Optional<List<RemoteFieldClassForCustomObjectClass>> getFields() {
        return this.fields;
    }

    @JsonProperty(value="association_types")
    public Optional<List<Map<String, JsonNode>>> getAssociationTypes() {
        return this.associationTypes;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CustomObjectClass && this.equalTo((CustomObjectClass)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CustomObjectClass other) {
        return this.id.equals(other.id) && this.remoteId.equals(other.remoteId) && this.createdAt.equals(other.createdAt) && this.modifiedAt.equals(other.modifiedAt) && this.name.equals(other.name) && this.description.equals(other.description) && this.labels.equals(other.labels) && this.fields.equals(other.fields) && this.associationTypes.equals(other.associationTypes);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.remoteId, this.createdAt, this.modifiedAt, this.name, this.description, this.labels, this.fields, this.associationTypes);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> id = Optional.empty();
        private Optional<String> remoteId = Optional.empty();
        private Optional<OffsetDateTime> createdAt = Optional.empty();
        private Optional<OffsetDateTime> modifiedAt = Optional.empty();
        private Optional<String> name = Optional.empty();
        private Optional<String> description = Optional.empty();
        private Optional<Map<String, Optional<String>>> labels = Optional.empty();
        private Optional<List<RemoteFieldClassForCustomObjectClass>> fields = Optional.empty();
        private Optional<List<Map<String, JsonNode>>> associationTypes = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CustomObjectClass other) {
            this.id(other.getId());
            this.remoteId(other.getRemoteId());
            this.createdAt(other.getCreatedAt());
            this.modifiedAt(other.getModifiedAt());
            this.name(other.getName());
            this.description(other.getDescription());
            this.labels(other.getLabels());
            this.fields(other.getFields());
            this.associationTypes(other.getAssociationTypes());
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.of(id);
            return this;
        }

        @JsonSetter(value="remote_id", nulls=Nulls.SKIP)
        public Builder remoteId(Optional<String> remoteId) {
            this.remoteId = remoteId;
            return this;
        }

        public Builder remoteId(String remoteId) {
            this.remoteId = Optional.of(remoteId);
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<OffsetDateTime> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(OffsetDateTime createdAt) {
            this.createdAt = Optional.of(createdAt);
            return this;
        }

        @JsonSetter(value="modified_at", nulls=Nulls.SKIP)
        public Builder modifiedAt(Optional<OffsetDateTime> modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public Builder modifiedAt(OffsetDateTime modifiedAt) {
            this.modifiedAt = Optional.of(modifiedAt);
            return this;
        }

        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.of(name);
            return this;
        }

        @JsonSetter(value="description", nulls=Nulls.SKIP)
        public Builder description(Optional<String> description) {
            this.description = description;
            return this;
        }

        public Builder description(String description) {
            this.description = Optional.of(description);
            return this;
        }

        @JsonSetter(value="labels", nulls=Nulls.SKIP)
        public Builder labels(Optional<Map<String, Optional<String>>> labels) {
            this.labels = labels;
            return this;
        }

        public Builder labels(Map<String, Optional<String>> labels) {
            this.labels = Optional.of(labels);
            return this;
        }

        @JsonSetter(value="fields", nulls=Nulls.SKIP)
        public Builder fields(Optional<List<RemoteFieldClassForCustomObjectClass>> fields) {
            this.fields = fields;
            return this;
        }

        public Builder fields(List<RemoteFieldClassForCustomObjectClass> fields) {
            this.fields = Optional.of(fields);
            return this;
        }

        @JsonSetter(value="association_types", nulls=Nulls.SKIP)
        public Builder associationTypes(Optional<List<Map<String, JsonNode>>> associationTypes) {
            this.associationTypes = associationTypes;
            return this;
        }

        public Builder associationTypes(List<Map<String, JsonNode>> associationTypes) {
            this.associationTypes = Optional.of(associationTypes);
            return this;
        }

        public CustomObjectClass build() {
            return new CustomObjectClass(this.id, this.remoteId, this.createdAt, this.modifiedAt, this.name, this.description, this.labels, this.fields, this.associationTypes, this.additionalProperties);
        }
    }
}

