/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.crm.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class CustomObjectRequest {
    private final Map<String, JsonNode> fields;
    private final Map<String, Object> additionalProperties;

    private CustomObjectRequest(Map<String, JsonNode> fields, Map<String, Object> additionalProperties) {
        this.fields = fields;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="fields")
    public Map<String, JsonNode> getFields() {
        return this.fields;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CustomObjectRequest && this.equalTo((CustomObjectRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CustomObjectRequest other) {
        return this.fields.equals(other.fields);
    }

    public int hashCode() {
        return Objects.hash(this.fields);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Map<String, JsonNode> fields = new LinkedHashMap<String, JsonNode>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CustomObjectRequest other) {
            this.fields(other.getFields());
            return this;
        }

        @JsonSetter(value="fields", nulls=Nulls.SKIP)
        public Builder fields(Map<String, JsonNode> fields) {
            this.fields.clear();
            this.fields.putAll(fields);
            return this;
        }

        public Builder putAllFields(Map<String, JsonNode> fields) {
            this.fields.putAll(fields);
            return this;
        }

        public Builder fields(String key, JsonNode value) {
            this.fields.put(key, value);
            return this;
        }

        public CustomObjectRequest build() {
            return new CustomObjectRequest(this.fields, this.additionalProperties);
        }
    }
}

