/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.crm.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import com.merge.api.resources.crm.types.AddressRequest;
import com.merge.api.resources.crm.types.EmailAddressRequest;
import com.merge.api.resources.crm.types.LeadRequestConvertedAccount;
import com.merge.api.resources.crm.types.LeadRequestConvertedContact;
import com.merge.api.resources.crm.types.LeadRequestOwner;
import com.merge.api.resources.crm.types.PhoneNumberRequest;
import com.merge.api.resources.crm.types.RemoteFieldRequest;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class LeadRequest {
    private final Optional<LeadRequestOwner> owner;
    private final Optional<String> leadSource;
    private final Optional<String> title;
    private final Optional<String> company;
    private final Optional<String> firstName;
    private final Optional<String> lastName;
    private final Optional<List<AddressRequest>> addresses;
    private final Optional<List<EmailAddressRequest>> emailAddresses;
    private final Optional<List<PhoneNumberRequest>> phoneNumbers;
    private final Optional<OffsetDateTime> convertedDate;
    private final Optional<LeadRequestConvertedContact> convertedContact;
    private final Optional<LeadRequestConvertedAccount> convertedAccount;
    private final Optional<Map<String, JsonNode>> integrationParams;
    private final Optional<Map<String, JsonNode>> linkedAccountParams;
    private final Optional<List<RemoteFieldRequest>> remoteFields;
    private final Map<String, Object> additionalProperties;

    private LeadRequest(Optional<LeadRequestOwner> owner, Optional<String> leadSource, Optional<String> title, Optional<String> company, Optional<String> firstName, Optional<String> lastName, Optional<List<AddressRequest>> addresses, Optional<List<EmailAddressRequest>> emailAddresses, Optional<List<PhoneNumberRequest>> phoneNumbers, Optional<OffsetDateTime> convertedDate, Optional<LeadRequestConvertedContact> convertedContact, Optional<LeadRequestConvertedAccount> convertedAccount, Optional<Map<String, JsonNode>> integrationParams, Optional<Map<String, JsonNode>> linkedAccountParams, Optional<List<RemoteFieldRequest>> remoteFields, Map<String, Object> additionalProperties) {
        this.owner = owner;
        this.leadSource = leadSource;
        this.title = title;
        this.company = company;
        this.firstName = firstName;
        this.lastName = lastName;
        this.addresses = addresses;
        this.emailAddresses = emailAddresses;
        this.phoneNumbers = phoneNumbers;
        this.convertedDate = convertedDate;
        this.convertedContact = convertedContact;
        this.convertedAccount = convertedAccount;
        this.integrationParams = integrationParams;
        this.linkedAccountParams = linkedAccountParams;
        this.remoteFields = remoteFields;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="owner")
    public Optional<LeadRequestOwner> getOwner() {
        return this.owner;
    }

    @JsonProperty(value="lead_source")
    public Optional<String> getLeadSource() {
        return this.leadSource;
    }

    @JsonProperty(value="title")
    public Optional<String> getTitle() {
        return this.title;
    }

    @JsonProperty(value="company")
    public Optional<String> getCompany() {
        return this.company;
    }

    @JsonProperty(value="first_name")
    public Optional<String> getFirstName() {
        return this.firstName;
    }

    @JsonProperty(value="last_name")
    public Optional<String> getLastName() {
        return this.lastName;
    }

    @JsonProperty(value="addresses")
    public Optional<List<AddressRequest>> getAddresses() {
        return this.addresses;
    }

    @JsonProperty(value="email_addresses")
    public Optional<List<EmailAddressRequest>> getEmailAddresses() {
        return this.emailAddresses;
    }

    @JsonProperty(value="phone_numbers")
    public Optional<List<PhoneNumberRequest>> getPhoneNumbers() {
        return this.phoneNumbers;
    }

    @JsonProperty(value="converted_date")
    public Optional<OffsetDateTime> getConvertedDate() {
        return this.convertedDate;
    }

    @JsonProperty(value="converted_contact")
    public Optional<LeadRequestConvertedContact> getConvertedContact() {
        return this.convertedContact;
    }

    @JsonProperty(value="converted_account")
    public Optional<LeadRequestConvertedAccount> getConvertedAccount() {
        return this.convertedAccount;
    }

    @JsonProperty(value="integration_params")
    public Optional<Map<String, JsonNode>> getIntegrationParams() {
        return this.integrationParams;
    }

    @JsonProperty(value="linked_account_params")
    public Optional<Map<String, JsonNode>> getLinkedAccountParams() {
        return this.linkedAccountParams;
    }

    @JsonProperty(value="remote_fields")
    public Optional<List<RemoteFieldRequest>> getRemoteFields() {
        return this.remoteFields;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof LeadRequest && this.equalTo((LeadRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(LeadRequest other) {
        return this.owner.equals(other.owner) && this.leadSource.equals(other.leadSource) && this.title.equals(other.title) && this.company.equals(other.company) && this.firstName.equals(other.firstName) && this.lastName.equals(other.lastName) && this.addresses.equals(other.addresses) && this.emailAddresses.equals(other.emailAddresses) && this.phoneNumbers.equals(other.phoneNumbers) && this.convertedDate.equals(other.convertedDate) && this.convertedContact.equals(other.convertedContact) && this.convertedAccount.equals(other.convertedAccount) && this.integrationParams.equals(other.integrationParams) && this.linkedAccountParams.equals(other.linkedAccountParams) && this.remoteFields.equals(other.remoteFields);
    }

    public int hashCode() {
        return Objects.hash(this.owner, this.leadSource, this.title, this.company, this.firstName, this.lastName, this.addresses, this.emailAddresses, this.phoneNumbers, this.convertedDate, this.convertedContact, this.convertedAccount, this.integrationParams, this.linkedAccountParams, this.remoteFields);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<LeadRequestOwner> owner = Optional.empty();
        private Optional<String> leadSource = Optional.empty();
        private Optional<String> title = Optional.empty();
        private Optional<String> company = Optional.empty();
        private Optional<String> firstName = Optional.empty();
        private Optional<String> lastName = Optional.empty();
        private Optional<List<AddressRequest>> addresses = Optional.empty();
        private Optional<List<EmailAddressRequest>> emailAddresses = Optional.empty();
        private Optional<List<PhoneNumberRequest>> phoneNumbers = Optional.empty();
        private Optional<OffsetDateTime> convertedDate = Optional.empty();
        private Optional<LeadRequestConvertedContact> convertedContact = Optional.empty();
        private Optional<LeadRequestConvertedAccount> convertedAccount = Optional.empty();
        private Optional<Map<String, JsonNode>> integrationParams = Optional.empty();
        private Optional<Map<String, JsonNode>> linkedAccountParams = Optional.empty();
        private Optional<List<RemoteFieldRequest>> remoteFields = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(LeadRequest other) {
            this.owner(other.getOwner());
            this.leadSource(other.getLeadSource());
            this.title(other.getTitle());
            this.company(other.getCompany());
            this.firstName(other.getFirstName());
            this.lastName(other.getLastName());
            this.addresses(other.getAddresses());
            this.emailAddresses(other.getEmailAddresses());
            this.phoneNumbers(other.getPhoneNumbers());
            this.convertedDate(other.getConvertedDate());
            this.convertedContact(other.getConvertedContact());
            this.convertedAccount(other.getConvertedAccount());
            this.integrationParams(other.getIntegrationParams());
            this.linkedAccountParams(other.getLinkedAccountParams());
            this.remoteFields(other.getRemoteFields());
            return this;
        }

        @JsonSetter(value="owner", nulls=Nulls.SKIP)
        public Builder owner(Optional<LeadRequestOwner> owner) {
            this.owner = owner;
            return this;
        }

        public Builder owner(LeadRequestOwner owner) {
            this.owner = Optional.of(owner);
            return this;
        }

        @JsonSetter(value="lead_source", nulls=Nulls.SKIP)
        public Builder leadSource(Optional<String> leadSource) {
            this.leadSource = leadSource;
            return this;
        }

        public Builder leadSource(String leadSource) {
            this.leadSource = Optional.of(leadSource);
            return this;
        }

        @JsonSetter(value="title", nulls=Nulls.SKIP)
        public Builder title(Optional<String> title) {
            this.title = title;
            return this;
        }

        public Builder title(String title) {
            this.title = Optional.of(title);
            return this;
        }

        @JsonSetter(value="company", nulls=Nulls.SKIP)
        public Builder company(Optional<String> company) {
            this.company = company;
            return this;
        }

        public Builder company(String company) {
            this.company = Optional.of(company);
            return this;
        }

        @JsonSetter(value="first_name", nulls=Nulls.SKIP)
        public Builder firstName(Optional<String> firstName) {
            this.firstName = firstName;
            return this;
        }

        public Builder firstName(String firstName) {
            this.firstName = Optional.of(firstName);
            return this;
        }

        @JsonSetter(value="last_name", nulls=Nulls.SKIP)
        public Builder lastName(Optional<String> lastName) {
            this.lastName = lastName;
            return this;
        }

        public Builder lastName(String lastName) {
            this.lastName = Optional.of(lastName);
            return this;
        }

        @JsonSetter(value="addresses", nulls=Nulls.SKIP)
        public Builder addresses(Optional<List<AddressRequest>> addresses) {
            this.addresses = addresses;
            return this;
        }

        public Builder addresses(List<AddressRequest> addresses) {
            this.addresses = Optional.of(addresses);
            return this;
        }

        @JsonSetter(value="email_addresses", nulls=Nulls.SKIP)
        public Builder emailAddresses(Optional<List<EmailAddressRequest>> emailAddresses) {
            this.emailAddresses = emailAddresses;
            return this;
        }

        public Builder emailAddresses(List<EmailAddressRequest> emailAddresses) {
            this.emailAddresses = Optional.of(emailAddresses);
            return this;
        }

        @JsonSetter(value="phone_numbers", nulls=Nulls.SKIP)
        public Builder phoneNumbers(Optional<List<PhoneNumberRequest>> phoneNumbers) {
            this.phoneNumbers = phoneNumbers;
            return this;
        }

        public Builder phoneNumbers(List<PhoneNumberRequest> phoneNumbers) {
            this.phoneNumbers = Optional.of(phoneNumbers);
            return this;
        }

        @JsonSetter(value="converted_date", nulls=Nulls.SKIP)
        public Builder convertedDate(Optional<OffsetDateTime> convertedDate) {
            this.convertedDate = convertedDate;
            return this;
        }

        public Builder convertedDate(OffsetDateTime convertedDate) {
            this.convertedDate = Optional.of(convertedDate);
            return this;
        }

        @JsonSetter(value="converted_contact", nulls=Nulls.SKIP)
        public Builder convertedContact(Optional<LeadRequestConvertedContact> convertedContact) {
            this.convertedContact = convertedContact;
            return this;
        }

        public Builder convertedContact(LeadRequestConvertedContact convertedContact) {
            this.convertedContact = Optional.of(convertedContact);
            return this;
        }

        @JsonSetter(value="converted_account", nulls=Nulls.SKIP)
        public Builder convertedAccount(Optional<LeadRequestConvertedAccount> convertedAccount) {
            this.convertedAccount = convertedAccount;
            return this;
        }

        public Builder convertedAccount(LeadRequestConvertedAccount convertedAccount) {
            this.convertedAccount = Optional.of(convertedAccount);
            return this;
        }

        @JsonSetter(value="integration_params", nulls=Nulls.SKIP)
        public Builder integrationParams(Optional<Map<String, JsonNode>> integrationParams) {
            this.integrationParams = integrationParams;
            return this;
        }

        public Builder integrationParams(Map<String, JsonNode> integrationParams) {
            this.integrationParams = Optional.of(integrationParams);
            return this;
        }

        @JsonSetter(value="linked_account_params", nulls=Nulls.SKIP)
        public Builder linkedAccountParams(Optional<Map<String, JsonNode>> linkedAccountParams) {
            this.linkedAccountParams = linkedAccountParams;
            return this;
        }

        public Builder linkedAccountParams(Map<String, JsonNode> linkedAccountParams) {
            this.linkedAccountParams = Optional.of(linkedAccountParams);
            return this;
        }

        @JsonSetter(value="remote_fields", nulls=Nulls.SKIP)
        public Builder remoteFields(Optional<List<RemoteFieldRequest>> remoteFields) {
            this.remoteFields = remoteFields;
            return this;
        }

        public Builder remoteFields(List<RemoteFieldRequest> remoteFields) {
            this.remoteFields = Optional.of(remoteFields);
            return this;
        }

        public LeadRequest build() {
            return new LeadRequest(this.owner, this.leadSource, this.title, this.company, this.firstName, this.lastName, this.addresses, this.emailAddresses, this.phoneNumbers, this.convertedDate, this.convertedContact, this.convertedAccount, this.integrationParams, this.linkedAccountParams, this.remoteFields, this.additionalProperties);
        }
    }
}

