/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.crm.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class ModelOperation {
    private final String modelName;
    private final List<String> availableOperations;
    private final List<String> requiredPostParameters;
    private final List<String> supportedFields;
    private final Map<String, Object> additionalProperties;

    private ModelOperation(String modelName, List<String> availableOperations, List<String> requiredPostParameters, List<String> supportedFields, Map<String, Object> additionalProperties) {
        this.modelName = modelName;
        this.availableOperations = availableOperations;
        this.requiredPostParameters = requiredPostParameters;
        this.supportedFields = supportedFields;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="model_name")
    public String getModelName() {
        return this.modelName;
    }

    @JsonProperty(value="available_operations")
    public List<String> getAvailableOperations() {
        return this.availableOperations;
    }

    @JsonProperty(value="required_post_parameters")
    public List<String> getRequiredPostParameters() {
        return this.requiredPostParameters;
    }

    @JsonProperty(value="supported_fields")
    public List<String> getSupportedFields() {
        return this.supportedFields;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ModelOperation && this.equalTo((ModelOperation)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ModelOperation other) {
        return this.modelName.equals(other.modelName) && this.availableOperations.equals(other.availableOperations) && this.requiredPostParameters.equals(other.requiredPostParameters) && this.supportedFields.equals(other.supportedFields);
    }

    public int hashCode() {
        return Objects.hash(this.modelName, this.availableOperations, this.requiredPostParameters, this.supportedFields);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ModelNameStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ModelNameStage,
    _FinalStage {
        private String modelName;
        private List<String> supportedFields = new ArrayList<String>();
        private List<String> requiredPostParameters = new ArrayList<String>();
        private List<String> availableOperations = new ArrayList<String>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ModelOperation other) {
            this.modelName(other.getModelName());
            this.availableOperations(other.getAvailableOperations());
            this.requiredPostParameters(other.getRequiredPostParameters());
            this.supportedFields(other.getSupportedFields());
            return this;
        }

        @Override
        @JsonSetter(value="model_name")
        public _FinalStage modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        @Override
        public _FinalStage addAllSupportedFields(List<String> supportedFields) {
            this.supportedFields.addAll(supportedFields);
            return this;
        }

        @Override
        public _FinalStage addSupportedFields(String supportedFields) {
            this.supportedFields.add(supportedFields);
            return this;
        }

        @Override
        @JsonSetter(value="supported_fields", nulls=Nulls.SKIP)
        public _FinalStage supportedFields(List<String> supportedFields) {
            this.supportedFields.clear();
            this.supportedFields.addAll(supportedFields);
            return this;
        }

        @Override
        public _FinalStage addAllRequiredPostParameters(List<String> requiredPostParameters) {
            this.requiredPostParameters.addAll(requiredPostParameters);
            return this;
        }

        @Override
        public _FinalStage addRequiredPostParameters(String requiredPostParameters) {
            this.requiredPostParameters.add(requiredPostParameters);
            return this;
        }

        @Override
        @JsonSetter(value="required_post_parameters", nulls=Nulls.SKIP)
        public _FinalStage requiredPostParameters(List<String> requiredPostParameters) {
            this.requiredPostParameters.clear();
            this.requiredPostParameters.addAll(requiredPostParameters);
            return this;
        }

        @Override
        public _FinalStage addAllAvailableOperations(List<String> availableOperations) {
            this.availableOperations.addAll(availableOperations);
            return this;
        }

        @Override
        public _FinalStage addAvailableOperations(String availableOperations) {
            this.availableOperations.add(availableOperations);
            return this;
        }

        @Override
        @JsonSetter(value="available_operations", nulls=Nulls.SKIP)
        public _FinalStage availableOperations(List<String> availableOperations) {
            this.availableOperations.clear();
            this.availableOperations.addAll(availableOperations);
            return this;
        }

        @Override
        public ModelOperation build() {
            return new ModelOperation(this.modelName, this.availableOperations, this.requiredPostParameters, this.supportedFields, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ModelOperation build();

        public _FinalStage availableOperations(List<String> var1);

        public _FinalStage addAvailableOperations(String var1);

        public _FinalStage addAllAvailableOperations(List<String> var1);

        public _FinalStage requiredPostParameters(List<String> var1);

        public _FinalStage addRequiredPostParameters(String var1);

        public _FinalStage addAllRequiredPostParameters(List<String> var1);

        public _FinalStage supportedFields(List<String> var1);

        public _FinalStage addSupportedFields(String var1);

        public _FinalStage addAllSupportedFields(List<String> var1);
    }

    public static interface ModelNameStage {
        public _FinalStage modelName(String var1);

        public Builder from(ModelOperation var1);
    }
}

