/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.crm.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import com.merge.api.resources.crm.types.MultipartFormFieldRequestEncoding;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class MultipartFormFieldRequest {
    private final String name;
    private final String data;
    private final Optional<MultipartFormFieldRequestEncoding> encoding;
    private final Optional<String> fileName;
    private final Optional<String> contentType;
    private final Map<String, Object> additionalProperties;

    private MultipartFormFieldRequest(String name, String data, Optional<MultipartFormFieldRequestEncoding> encoding, Optional<String> fileName, Optional<String> contentType, Map<String, Object> additionalProperties) {
        this.name = name;
        this.data = data;
        this.encoding = encoding;
        this.fileName = fileName;
        this.contentType = contentType;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="data")
    public String getData() {
        return this.data;
    }

    @JsonProperty(value="encoding")
    public Optional<MultipartFormFieldRequestEncoding> getEncoding() {
        return this.encoding;
    }

    @JsonProperty(value="file_name")
    public Optional<String> getFileName() {
        return this.fileName;
    }

    @JsonProperty(value="content_type")
    public Optional<String> getContentType() {
        return this.contentType;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof MultipartFormFieldRequest && this.equalTo((MultipartFormFieldRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(MultipartFormFieldRequest other) {
        return this.name.equals(other.name) && this.data.equals(other.data) && this.encoding.equals(other.encoding) && this.fileName.equals(other.fileName) && this.contentType.equals(other.contentType);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.data, this.encoding, this.fileName, this.contentType);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static NameStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements NameStage,
    DataStage,
    _FinalStage {
        private String name;
        private String data;
        private Optional<String> contentType = Optional.empty();
        private Optional<String> fileName = Optional.empty();
        private Optional<MultipartFormFieldRequestEncoding> encoding = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(MultipartFormFieldRequest other) {
            this.name(other.getName());
            this.data(other.getData());
            this.encoding(other.getEncoding());
            this.fileName(other.getFileName());
            this.contentType(other.getContentType());
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public DataStage name(String name) {
            this.name = name;
            return this;
        }

        @Override
        @JsonSetter(value="data")
        public _FinalStage data(String data) {
            this.data = data;
            return this;
        }

        @Override
        public _FinalStage contentType(String contentType) {
            this.contentType = Optional.of(contentType);
            return this;
        }

        @Override
        @JsonSetter(value="content_type", nulls=Nulls.SKIP)
        public _FinalStage contentType(Optional<String> contentType) {
            this.contentType = contentType;
            return this;
        }

        @Override
        public _FinalStage fileName(String fileName) {
            this.fileName = Optional.of(fileName);
            return this;
        }

        @Override
        @JsonSetter(value="file_name", nulls=Nulls.SKIP)
        public _FinalStage fileName(Optional<String> fileName) {
            this.fileName = fileName;
            return this;
        }

        @Override
        public _FinalStage encoding(MultipartFormFieldRequestEncoding encoding) {
            this.encoding = Optional.of(encoding);
            return this;
        }

        @Override
        @JsonSetter(value="encoding", nulls=Nulls.SKIP)
        public _FinalStage encoding(Optional<MultipartFormFieldRequestEncoding> encoding) {
            this.encoding = encoding;
            return this;
        }

        @Override
        public MultipartFormFieldRequest build() {
            return new MultipartFormFieldRequest(this.name, this.data, this.encoding, this.fileName, this.contentType, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public MultipartFormFieldRequest build();

        public _FinalStage encoding(Optional<MultipartFormFieldRequestEncoding> var1);

        public _FinalStage encoding(MultipartFormFieldRequestEncoding var1);

        public _FinalStage fileName(Optional<String> var1);

        public _FinalStage fileName(String var1);

        public _FinalStage contentType(Optional<String> var1);

        public _FinalStage contentType(String var1);
    }

    public static interface DataStage {
        public _FinalStage data(String var1);
    }

    public static interface NameStage {
        public DataStage name(String var1);

        public Builder from(MultipartFormFieldRequest var1);
    }
}

