/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.crm.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import com.merge.api.resources.crm.types.AddressRequest;
import com.merge.api.resources.crm.types.EmailAddressRequest;
import com.merge.api.resources.crm.types.PatchedContactRequestOwner;
import com.merge.api.resources.crm.types.PhoneNumberRequest;
import com.merge.api.resources.crm.types.RemoteFieldRequest;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class PatchedContactRequest {
    private final Optional<String> firstName;
    private final Optional<String> lastName;
    private final Optional<String> account;
    private final Optional<PatchedContactRequestOwner> owner;
    private final Optional<List<AddressRequest>> addresses;
    private final Optional<List<EmailAddressRequest>> emailAddresses;
    private final Optional<List<PhoneNumberRequest>> phoneNumbers;
    private final Optional<OffsetDateTime> lastActivityAt;
    private final Optional<Map<String, JsonNode>> integrationParams;
    private final Optional<Map<String, JsonNode>> linkedAccountParams;
    private final Optional<List<RemoteFieldRequest>> remoteFields;
    private final Map<String, Object> additionalProperties;

    private PatchedContactRequest(Optional<String> firstName, Optional<String> lastName, Optional<String> account, Optional<PatchedContactRequestOwner> owner, Optional<List<AddressRequest>> addresses, Optional<List<EmailAddressRequest>> emailAddresses, Optional<List<PhoneNumberRequest>> phoneNumbers, Optional<OffsetDateTime> lastActivityAt, Optional<Map<String, JsonNode>> integrationParams, Optional<Map<String, JsonNode>> linkedAccountParams, Optional<List<RemoteFieldRequest>> remoteFields, Map<String, Object> additionalProperties) {
        this.firstName = firstName;
        this.lastName = lastName;
        this.account = account;
        this.owner = owner;
        this.addresses = addresses;
        this.emailAddresses = emailAddresses;
        this.phoneNumbers = phoneNumbers;
        this.lastActivityAt = lastActivityAt;
        this.integrationParams = integrationParams;
        this.linkedAccountParams = linkedAccountParams;
        this.remoteFields = remoteFields;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="first_name")
    public Optional<String> getFirstName() {
        return this.firstName;
    }

    @JsonProperty(value="last_name")
    public Optional<String> getLastName() {
        return this.lastName;
    }

    @JsonProperty(value="account")
    public Optional<String> getAccount() {
        return this.account;
    }

    @JsonProperty(value="owner")
    public Optional<PatchedContactRequestOwner> getOwner() {
        return this.owner;
    }

    @JsonProperty(value="addresses")
    public Optional<List<AddressRequest>> getAddresses() {
        return this.addresses;
    }

    @JsonProperty(value="email_addresses")
    public Optional<List<EmailAddressRequest>> getEmailAddresses() {
        return this.emailAddresses;
    }

    @JsonProperty(value="phone_numbers")
    public Optional<List<PhoneNumberRequest>> getPhoneNumbers() {
        return this.phoneNumbers;
    }

    @JsonProperty(value="last_activity_at")
    public Optional<OffsetDateTime> getLastActivityAt() {
        return this.lastActivityAt;
    }

    @JsonProperty(value="integration_params")
    public Optional<Map<String, JsonNode>> getIntegrationParams() {
        return this.integrationParams;
    }

    @JsonProperty(value="linked_account_params")
    public Optional<Map<String, JsonNode>> getLinkedAccountParams() {
        return this.linkedAccountParams;
    }

    @JsonProperty(value="remote_fields")
    public Optional<List<RemoteFieldRequest>> getRemoteFields() {
        return this.remoteFields;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof PatchedContactRequest && this.equalTo((PatchedContactRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(PatchedContactRequest other) {
        return this.firstName.equals(other.firstName) && this.lastName.equals(other.lastName) && this.account.equals(other.account) && this.owner.equals(other.owner) && this.addresses.equals(other.addresses) && this.emailAddresses.equals(other.emailAddresses) && this.phoneNumbers.equals(other.phoneNumbers) && this.lastActivityAt.equals(other.lastActivityAt) && this.integrationParams.equals(other.integrationParams) && this.linkedAccountParams.equals(other.linkedAccountParams) && this.remoteFields.equals(other.remoteFields);
    }

    public int hashCode() {
        return Objects.hash(this.firstName, this.lastName, this.account, this.owner, this.addresses, this.emailAddresses, this.phoneNumbers, this.lastActivityAt, this.integrationParams, this.linkedAccountParams, this.remoteFields);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> firstName = Optional.empty();
        private Optional<String> lastName = Optional.empty();
        private Optional<String> account = Optional.empty();
        private Optional<PatchedContactRequestOwner> owner = Optional.empty();
        private Optional<List<AddressRequest>> addresses = Optional.empty();
        private Optional<List<EmailAddressRequest>> emailAddresses = Optional.empty();
        private Optional<List<PhoneNumberRequest>> phoneNumbers = Optional.empty();
        private Optional<OffsetDateTime> lastActivityAt = Optional.empty();
        private Optional<Map<String, JsonNode>> integrationParams = Optional.empty();
        private Optional<Map<String, JsonNode>> linkedAccountParams = Optional.empty();
        private Optional<List<RemoteFieldRequest>> remoteFields = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(PatchedContactRequest other) {
            this.firstName(other.getFirstName());
            this.lastName(other.getLastName());
            this.account(other.getAccount());
            this.owner(other.getOwner());
            this.addresses(other.getAddresses());
            this.emailAddresses(other.getEmailAddresses());
            this.phoneNumbers(other.getPhoneNumbers());
            this.lastActivityAt(other.getLastActivityAt());
            this.integrationParams(other.getIntegrationParams());
            this.linkedAccountParams(other.getLinkedAccountParams());
            this.remoteFields(other.getRemoteFields());
            return this;
        }

        @JsonSetter(value="first_name", nulls=Nulls.SKIP)
        public Builder firstName(Optional<String> firstName) {
            this.firstName = firstName;
            return this;
        }

        public Builder firstName(String firstName) {
            this.firstName = Optional.of(firstName);
            return this;
        }

        @JsonSetter(value="last_name", nulls=Nulls.SKIP)
        public Builder lastName(Optional<String> lastName) {
            this.lastName = lastName;
            return this;
        }

        public Builder lastName(String lastName) {
            this.lastName = Optional.of(lastName);
            return this;
        }

        @JsonSetter(value="account", nulls=Nulls.SKIP)
        public Builder account(Optional<String> account) {
            this.account = account;
            return this;
        }

        public Builder account(String account) {
            this.account = Optional.of(account);
            return this;
        }

        @JsonSetter(value="owner", nulls=Nulls.SKIP)
        public Builder owner(Optional<PatchedContactRequestOwner> owner) {
            this.owner = owner;
            return this;
        }

        public Builder owner(PatchedContactRequestOwner owner) {
            this.owner = Optional.of(owner);
            return this;
        }

        @JsonSetter(value="addresses", nulls=Nulls.SKIP)
        public Builder addresses(Optional<List<AddressRequest>> addresses) {
            this.addresses = addresses;
            return this;
        }

        public Builder addresses(List<AddressRequest> addresses) {
            this.addresses = Optional.of(addresses);
            return this;
        }

        @JsonSetter(value="email_addresses", nulls=Nulls.SKIP)
        public Builder emailAddresses(Optional<List<EmailAddressRequest>> emailAddresses) {
            this.emailAddresses = emailAddresses;
            return this;
        }

        public Builder emailAddresses(List<EmailAddressRequest> emailAddresses) {
            this.emailAddresses = Optional.of(emailAddresses);
            return this;
        }

        @JsonSetter(value="phone_numbers", nulls=Nulls.SKIP)
        public Builder phoneNumbers(Optional<List<PhoneNumberRequest>> phoneNumbers) {
            this.phoneNumbers = phoneNumbers;
            return this;
        }

        public Builder phoneNumbers(List<PhoneNumberRequest> phoneNumbers) {
            this.phoneNumbers = Optional.of(phoneNumbers);
            return this;
        }

        @JsonSetter(value="last_activity_at", nulls=Nulls.SKIP)
        public Builder lastActivityAt(Optional<OffsetDateTime> lastActivityAt) {
            this.lastActivityAt = lastActivityAt;
            return this;
        }

        public Builder lastActivityAt(OffsetDateTime lastActivityAt) {
            this.lastActivityAt = Optional.of(lastActivityAt);
            return this;
        }

        @JsonSetter(value="integration_params", nulls=Nulls.SKIP)
        public Builder integrationParams(Optional<Map<String, JsonNode>> integrationParams) {
            this.integrationParams = integrationParams;
            return this;
        }

        public Builder integrationParams(Map<String, JsonNode> integrationParams) {
            this.integrationParams = Optional.of(integrationParams);
            return this;
        }

        @JsonSetter(value="linked_account_params", nulls=Nulls.SKIP)
        public Builder linkedAccountParams(Optional<Map<String, JsonNode>> linkedAccountParams) {
            this.linkedAccountParams = linkedAccountParams;
            return this;
        }

        public Builder linkedAccountParams(Map<String, JsonNode> linkedAccountParams) {
            this.linkedAccountParams = Optional.of(linkedAccountParams);
            return this;
        }

        @JsonSetter(value="remote_fields", nulls=Nulls.SKIP)
        public Builder remoteFields(Optional<List<RemoteFieldRequest>> remoteFields) {
            this.remoteFields = remoteFields;
            return this;
        }

        public Builder remoteFields(List<RemoteFieldRequest> remoteFields) {
            this.remoteFields = Optional.of(remoteFields);
            return this;
        }

        public PatchedContactRequest build() {
            return new PatchedContactRequest(this.firstName, this.lastName, this.account, this.owner, this.addresses, this.emailAddresses, this.phoneNumbers, this.lastActivityAt, this.integrationParams, this.linkedAccountParams, this.remoteFields, this.additionalProperties);
        }
    }
}

