/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.crm.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import com.merge.api.resources.crm.types.PatchedOpportunityRequestStatus;
import com.merge.api.resources.crm.types.RemoteFieldRequest;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class PatchedOpportunityRequest {
    private final Optional<String> name;
    private final Optional<String> description;
    private final Optional<Integer> amount;
    private final Optional<String> owner;
    private final Optional<String> account;
    private final Optional<String> stage;
    private final Optional<PatchedOpportunityRequestStatus> status;
    private final Optional<OffsetDateTime> lastActivityAt;
    private final Optional<OffsetDateTime> closeDate;
    private final Optional<Map<String, JsonNode>> integrationParams;
    private final Optional<Map<String, JsonNode>> linkedAccountParams;
    private final Optional<List<RemoteFieldRequest>> remoteFields;
    private final Map<String, Object> additionalProperties;

    private PatchedOpportunityRequest(Optional<String> name, Optional<String> description, Optional<Integer> amount, Optional<String> owner, Optional<String> account, Optional<String> stage, Optional<PatchedOpportunityRequestStatus> status, Optional<OffsetDateTime> lastActivityAt, Optional<OffsetDateTime> closeDate, Optional<Map<String, JsonNode>> integrationParams, Optional<Map<String, JsonNode>> linkedAccountParams, Optional<List<RemoteFieldRequest>> remoteFields, Map<String, Object> additionalProperties) {
        this.name = name;
        this.description = description;
        this.amount = amount;
        this.owner = owner;
        this.account = account;
        this.stage = stage;
        this.status = status;
        this.lastActivityAt = lastActivityAt;
        this.closeDate = closeDate;
        this.integrationParams = integrationParams;
        this.linkedAccountParams = linkedAccountParams;
        this.remoteFields = remoteFields;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="name")
    public Optional<String> getName() {
        return this.name;
    }

    @JsonProperty(value="description")
    public Optional<String> getDescription() {
        return this.description;
    }

    @JsonProperty(value="amount")
    public Optional<Integer> getAmount() {
        return this.amount;
    }

    @JsonProperty(value="owner")
    public Optional<String> getOwner() {
        return this.owner;
    }

    @JsonProperty(value="account")
    public Optional<String> getAccount() {
        return this.account;
    }

    @JsonProperty(value="stage")
    public Optional<String> getStage() {
        return this.stage;
    }

    @JsonProperty(value="status")
    public Optional<PatchedOpportunityRequestStatus> getStatus() {
        return this.status;
    }

    @JsonProperty(value="last_activity_at")
    public Optional<OffsetDateTime> getLastActivityAt() {
        return this.lastActivityAt;
    }

    @JsonProperty(value="close_date")
    public Optional<OffsetDateTime> getCloseDate() {
        return this.closeDate;
    }

    @JsonProperty(value="integration_params")
    public Optional<Map<String, JsonNode>> getIntegrationParams() {
        return this.integrationParams;
    }

    @JsonProperty(value="linked_account_params")
    public Optional<Map<String, JsonNode>> getLinkedAccountParams() {
        return this.linkedAccountParams;
    }

    @JsonProperty(value="remote_fields")
    public Optional<List<RemoteFieldRequest>> getRemoteFields() {
        return this.remoteFields;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof PatchedOpportunityRequest && this.equalTo((PatchedOpportunityRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(PatchedOpportunityRequest other) {
        return this.name.equals(other.name) && this.description.equals(other.description) && this.amount.equals(other.amount) && this.owner.equals(other.owner) && this.account.equals(other.account) && this.stage.equals(other.stage) && this.status.equals(other.status) && this.lastActivityAt.equals(other.lastActivityAt) && this.closeDate.equals(other.closeDate) && this.integrationParams.equals(other.integrationParams) && this.linkedAccountParams.equals(other.linkedAccountParams) && this.remoteFields.equals(other.remoteFields);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description, this.amount, this.owner, this.account, this.stage, this.status, this.lastActivityAt, this.closeDate, this.integrationParams, this.linkedAccountParams, this.remoteFields);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> name = Optional.empty();
        private Optional<String> description = Optional.empty();
        private Optional<Integer> amount = Optional.empty();
        private Optional<String> owner = Optional.empty();
        private Optional<String> account = Optional.empty();
        private Optional<String> stage = Optional.empty();
        private Optional<PatchedOpportunityRequestStatus> status = Optional.empty();
        private Optional<OffsetDateTime> lastActivityAt = Optional.empty();
        private Optional<OffsetDateTime> closeDate = Optional.empty();
        private Optional<Map<String, JsonNode>> integrationParams = Optional.empty();
        private Optional<Map<String, JsonNode>> linkedAccountParams = Optional.empty();
        private Optional<List<RemoteFieldRequest>> remoteFields = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(PatchedOpportunityRequest other) {
            this.name(other.getName());
            this.description(other.getDescription());
            this.amount(other.getAmount());
            this.owner(other.getOwner());
            this.account(other.getAccount());
            this.stage(other.getStage());
            this.status(other.getStatus());
            this.lastActivityAt(other.getLastActivityAt());
            this.closeDate(other.getCloseDate());
            this.integrationParams(other.getIntegrationParams());
            this.linkedAccountParams(other.getLinkedAccountParams());
            this.remoteFields(other.getRemoteFields());
            return this;
        }

        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.of(name);
            return this;
        }

        @JsonSetter(value="description", nulls=Nulls.SKIP)
        public Builder description(Optional<String> description) {
            this.description = description;
            return this;
        }

        public Builder description(String description) {
            this.description = Optional.of(description);
            return this;
        }

        @JsonSetter(value="amount", nulls=Nulls.SKIP)
        public Builder amount(Optional<Integer> amount) {
            this.amount = amount;
            return this;
        }

        public Builder amount(Integer amount) {
            this.amount = Optional.of(amount);
            return this;
        }

        @JsonSetter(value="owner", nulls=Nulls.SKIP)
        public Builder owner(Optional<String> owner) {
            this.owner = owner;
            return this;
        }

        public Builder owner(String owner) {
            this.owner = Optional.of(owner);
            return this;
        }

        @JsonSetter(value="account", nulls=Nulls.SKIP)
        public Builder account(Optional<String> account) {
            this.account = account;
            return this;
        }

        public Builder account(String account) {
            this.account = Optional.of(account);
            return this;
        }

        @JsonSetter(value="stage", nulls=Nulls.SKIP)
        public Builder stage(Optional<String> stage) {
            this.stage = stage;
            return this;
        }

        public Builder stage(String stage) {
            this.stage = Optional.of(stage);
            return this;
        }

        @JsonSetter(value="status", nulls=Nulls.SKIP)
        public Builder status(Optional<PatchedOpportunityRequestStatus> status) {
            this.status = status;
            return this;
        }

        public Builder status(PatchedOpportunityRequestStatus status) {
            this.status = Optional.of(status);
            return this;
        }

        @JsonSetter(value="last_activity_at", nulls=Nulls.SKIP)
        public Builder lastActivityAt(Optional<OffsetDateTime> lastActivityAt) {
            this.lastActivityAt = lastActivityAt;
            return this;
        }

        public Builder lastActivityAt(OffsetDateTime lastActivityAt) {
            this.lastActivityAt = Optional.of(lastActivityAt);
            return this;
        }

        @JsonSetter(value="close_date", nulls=Nulls.SKIP)
        public Builder closeDate(Optional<OffsetDateTime> closeDate) {
            this.closeDate = closeDate;
            return this;
        }

        public Builder closeDate(OffsetDateTime closeDate) {
            this.closeDate = Optional.of(closeDate);
            return this;
        }

        @JsonSetter(value="integration_params", nulls=Nulls.SKIP)
        public Builder integrationParams(Optional<Map<String, JsonNode>> integrationParams) {
            this.integrationParams = integrationParams;
            return this;
        }

        public Builder integrationParams(Map<String, JsonNode> integrationParams) {
            this.integrationParams = Optional.of(integrationParams);
            return this;
        }

        @JsonSetter(value="linked_account_params", nulls=Nulls.SKIP)
        public Builder linkedAccountParams(Optional<Map<String, JsonNode>> linkedAccountParams) {
            this.linkedAccountParams = linkedAccountParams;
            return this;
        }

        public Builder linkedAccountParams(Map<String, JsonNode> linkedAccountParams) {
            this.linkedAccountParams = Optional.of(linkedAccountParams);
            return this;
        }

        @JsonSetter(value="remote_fields", nulls=Nulls.SKIP)
        public Builder remoteFields(Optional<List<RemoteFieldRequest>> remoteFields) {
            this.remoteFields = remoteFields;
            return this;
        }

        public Builder remoteFields(List<RemoteFieldRequest> remoteFields) {
            this.remoteFields = Optional.of(remoteFields);
            return this;
        }

        public PatchedOpportunityRequest build() {
            return new PatchedOpportunityRequest(this.name, this.description, this.amount, this.owner, this.account, this.stage, this.status, this.lastActivityAt, this.closeDate, this.integrationParams, this.linkedAccountParams, this.remoteFields, this.additionalProperties);
        }
    }
}

