/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.crm.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class PhoneNumber {
    private final Optional<OffsetDateTime> createdAt;
    private final Optional<OffsetDateTime> modifiedAt;
    private final Optional<String> phoneNumber;
    private final Optional<String> phoneNumberType;
    private final Map<String, Object> additionalProperties;

    private PhoneNumber(Optional<OffsetDateTime> createdAt, Optional<OffsetDateTime> modifiedAt, Optional<String> phoneNumber, Optional<String> phoneNumberType, Map<String, Object> additionalProperties) {
        this.createdAt = createdAt;
        this.modifiedAt = modifiedAt;
        this.phoneNumber = phoneNumber;
        this.phoneNumberType = phoneNumberType;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="created_at")
    public Optional<OffsetDateTime> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="modified_at")
    public Optional<OffsetDateTime> getModifiedAt() {
        return this.modifiedAt;
    }

    @JsonProperty(value="phone_number")
    public Optional<String> getPhoneNumber() {
        return this.phoneNumber;
    }

    @JsonProperty(value="phone_number_type")
    public Optional<String> getPhoneNumberType() {
        return this.phoneNumberType;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof PhoneNumber && this.equalTo((PhoneNumber)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(PhoneNumber other) {
        return this.createdAt.equals(other.createdAt) && this.modifiedAt.equals(other.modifiedAt) && this.phoneNumber.equals(other.phoneNumber) && this.phoneNumberType.equals(other.phoneNumberType);
    }

    public int hashCode() {
        return Objects.hash(this.createdAt, this.modifiedAt, this.phoneNumber, this.phoneNumberType);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<OffsetDateTime> createdAt = Optional.empty();
        private Optional<OffsetDateTime> modifiedAt = Optional.empty();
        private Optional<String> phoneNumber = Optional.empty();
        private Optional<String> phoneNumberType = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(PhoneNumber other) {
            this.createdAt(other.getCreatedAt());
            this.modifiedAt(other.getModifiedAt());
            this.phoneNumber(other.getPhoneNumber());
            this.phoneNumberType(other.getPhoneNumberType());
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<OffsetDateTime> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(OffsetDateTime createdAt) {
            this.createdAt = Optional.of(createdAt);
            return this;
        }

        @JsonSetter(value="modified_at", nulls=Nulls.SKIP)
        public Builder modifiedAt(Optional<OffsetDateTime> modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public Builder modifiedAt(OffsetDateTime modifiedAt) {
            this.modifiedAt = Optional.of(modifiedAt);
            return this;
        }

        @JsonSetter(value="phone_number", nulls=Nulls.SKIP)
        public Builder phoneNumber(Optional<String> phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = Optional.of(phoneNumber);
            return this;
        }

        @JsonSetter(value="phone_number_type", nulls=Nulls.SKIP)
        public Builder phoneNumberType(Optional<String> phoneNumberType) {
            this.phoneNumberType = phoneNumberType;
            return this;
        }

        public Builder phoneNumberType(String phoneNumberType) {
            this.phoneNumberType = Optional.of(phoneNumberType);
            return this;
        }

        public PhoneNumber build() {
            return new PhoneNumber(this.createdAt, this.modifiedAt, this.phoneNumber, this.phoneNumberType, this.additionalProperties);
        }
    }
}

